/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm.utils;

public final class SuballocatedIntVector {
    protected final int m_blocksize;
    protected final int m_SHIFT;
    protected final int m_MASK;
    protected static final int NUMBLOCKS_DEFAULT = 32;
    protected final int m_numblocks;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected final int[] m_map0;
    protected int[] m_buildCache;
    protected int m_buildCacheStartIndex = 0;

    public SuballocatedIntVector() {
        this(2048);
    }

    public SuballocatedIntVector(int n2, int n3) {
        int n4 = 0;
        while (0 != (n2 >>>= 1)) {
            ++n4;
        }
        this.m_SHIFT = n4;
        this.m_blocksize = 1 << this.m_SHIFT;
        this.m_MASK = this.m_blocksize - 1;
        this.m_numblocks = n3;
        this.m_map = new int[n3][];
        this.m_buildCache = new int[this.m_blocksize];
        this.m_map0 = this.m_buildCache;
        this.m_map[0] = this.m_buildCache;
        this.m_buildCacheStartIndex = 0;
    }

    public SuballocatedIntVector(int n2) {
        this(n2, 32);
    }

    public int size() {
        return this.m_firstFree;
    }

    public void setSize(int n2) {
        if (this.m_firstFree > n2) {
            this.m_firstFree = n2;
        }
    }

    public void addElement(int n2) {
        int n3 = this.m_firstFree - this.m_buildCacheStartIndex;
        if (n3 >= 0 && n3 < this.m_blocksize) {
            this.m_buildCache[n3] = n2;
            ++this.m_firstFree;
        } else {
            Object object2;
            int n4 = this.m_firstFree & this.m_MASK;
            int n5 = this.m_firstFree >>> this.m_SHIFT;
            if (n5 >= this.m_map.length) {
                object2 = new int[n5 + this.m_numblocks][];
                System.arraycopy(this.m_map, 0, object2, 0, this.m_map.length);
                this.m_map = (int[][])object2;
            }
            if (null == (object2 = this.m_map[n5])) {
                this.m_map[n5] = new int[this.m_blocksize];
                object2 = this.m_map[n5];
            }
            object2[n4] = n2;
            this.m_buildCache = object2;
            this.m_buildCacheStartIndex = this.m_firstFree - n4;
            ++this.m_firstFree;
        }
    }

    public void addTwoElements(int n2, int n3) {
        int n4 = this.m_firstFree - this.m_buildCacheStartIndex;
        if (n4 >= 0 && n4 < this.m_blocksize - 1) {
            this.m_buildCache[n4] = n2;
            this.m_buildCache[n4 + 1] = n3;
            this.m_firstFree += 2;
        } else {
            this.addElement(n2);
            this.addElement(n3);
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
        this.m_buildCache = this.m_map0;
        this.m_buildCacheStartIndex = 0;
    }

    private boolean removeElement(int n2) {
        int n3 = this.indexOf(n2, 0);
        if (n3 < 0) {
            return false;
        }
        this.removeElementAt(n3);
        return true;
    }

    public void removeElementAt(int n2) {
        if (n2 < this.m_firstFree) {
            int n3 = this.m_firstFree >>> this.m_SHIFT;
            int n4 = n2 & this.m_MASK;
            for (int i = n2 >>> this.m_SHIFT; i <= n3; ++i) {
                int n5 = this.m_blocksize - n4 - 1;
                int[] nArray = this.m_map[i];
                if (null == nArray) {
                    this.m_map[i] = new int[this.m_blocksize];
                    nArray = this.m_map[i];
                } else {
                    System.arraycopy(nArray, n4 + 1, nArray, n4, n5);
                }
                if (i < n3) {
                    int[] nArray2 = this.m_map[i + 1];
                    if (nArray2 != null) {
                        nArray[this.m_blocksize - 1] = nArray2 != null ? nArray2[0] : 0;
                    }
                } else {
                    nArray[this.m_blocksize - 1] = 0;
                }
                n4 = 0;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(int n2, int n3) {
        if (n3 < this.m_blocksize) {
            this.m_map0[n3] = n2;
        } else {
            int[] nArray;
            int n4 = n3 >>> this.m_SHIFT;
            int n5 = n3 & this.m_MASK;
            if (n4 >= this.m_map.length) {
                int n6 = n4 + this.m_numblocks;
                int[][] nArrayArray = new int[n6][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                this.m_map = nArrayArray;
            }
            if (null == (nArray = this.m_map[n4])) {
                this.m_map[n4] = new int[this.m_blocksize];
                nArray = this.m_map[n4];
            }
            nArray[n5] = n2;
        }
        if (n3 >= this.m_firstFree) {
            this.m_firstFree = n3 + 1;
        }
    }

    public final int elementAt(int n2) {
        if (n2 < this.m_blocksize) {
            return this.m_map0[n2];
        }
        return this.m_map[n2 >>> this.m_SHIFT][n2 & this.m_MASK];
    }

    private boolean contains(int n2) {
        return this.indexOf(n2, 0) >= 0;
    }

    public int indexOf(int n2, int n3) {
        int n4;
        int[] nArray;
        if (n3 >= this.m_firstFree) {
            return -1;
        }
        int n5 = n3 & this.m_MASK;
        int n6 = this.m_firstFree >>> this.m_SHIFT;
        for (int i = n3 >>> this.m_SHIFT; i < n6; ++i) {
            nArray = this.m_map[i];
            if (nArray != null) {
                for (n4 = n5; n4 < this.m_blocksize; ++n4) {
                    if (nArray[n4] != n2) continue;
                    return n4 + i * this.m_blocksize;
                }
            }
            n5 = 0;
        }
        n4 = this.m_firstFree & this.m_MASK;
        nArray = this.m_map[n6];
        for (int i = n5; i < n4; ++i) {
            if (nArray[i] != n2) continue;
            return i + n6 * this.m_blocksize;
        }
        return -1;
    }

    public int indexOf(int n2) {
        return this.indexOf(n2, 0);
    }

    private int lastIndexOf(int n2) {
        int n3 = this.m_firstFree & this.m_MASK;
        for (int i = this.m_firstFree >>> this.m_SHIFT; i >= 0; --i) {
            int[] nArray = this.m_map[i];
            if (nArray != null) {
                for (int j = n3; j >= 0; --j) {
                    if (nArray[j] != n2) continue;
                    return j + i * this.m_blocksize;
                }
            }
            n3 = 0;
        }
        return -1;
    }

    public final int[] getMap0() {
        return this.m_map0;
    }

    public final int[][] getMap() {
        return this.m_map;
    }
}

