/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.CollectionType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeFactory;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;

public class AggregateType
extends CollectionType {
    private AnyAtomicType m_homogeneousAtomicType = null;
    private boolean m_allAtomicItemTypes = true;

    public AggregateType() {
    }

    public AggregateType(Type firstType) {
        this.addType(firstType);
    }

    public AggregateType(Type firstType, Type secondType) {
        this.addType(firstType);
        this.addType(secondType);
    }

    public AnyAtomicType getHomogeneousAtomicType() {
        return this.m_homogeneousAtomicType;
    }

    public boolean allAtomicItemTypes() {
        return this.m_allAtomicItemTypes;
    }

    @Override
    public void addType(Type type2) {
        this.m_types.add(type2);
        if (!this.m_hasNodeType && type2.mayContainNodeType()) {
            this.m_hasNodeType = true;
            this.m_allAtomicItemTypes = false;
        }
        if (this.m_allAtomicItemTypes) {
            OccurrenceIndicator quantifier = type2.getQuantifier();
            if (quantifier == OccurrenceIndicator.ONE || quantifier == OccurrenceIndicator.ZERO_OR_ONE) {
                Type baseType = type2.getPrimeType();
                if (baseType instanceof AnyAtomicType) {
                    if (this.m_types.size() == 1) {
                        this.m_homogeneousAtomicType = (AnyAtomicType)baseType;
                    } else if (this.m_homogeneousAtomicType != null && this.m_homogeneousAtomicType != baseType) {
                        this.m_homogeneousAtomicType = null;
                    }
                } else {
                    this.m_homogeneousAtomicType = null;
                }
            } else {
                this.m_allAtomicItemTypes = false;
            }
        }
    }

    @Override
    public OccurrenceIndicator getQuantifier() {
        int size = this.m_types.size();
        OccurrenceIndicator result2 = this.get(0).getQuantifier();
        for (int i = 1; i < size; ++i) {
            result2 = result2.sum(this.get(i).getQuantifier());
        }
        if (this.canBeEmpty()) {
            return result2.product(OccurrenceIndicator.ZERO_OR_ONE);
        }
        return result2;
    }

    @Override
    public Type getApproximateType() {
        return TypeFactory.newType(this.getPrimeType(), this.getQuantifier());
    }

    @Override
    public Type getAtomizedType() {
        if (!this.m_hasNodeType) {
            return this;
        }
        int size = this.size();
        AggregateType result2 = new AggregateType(this.get(0).getAtomizedType());
        for (int i = 1; i < size; ++i) {
            result2.addType(this.get(i).getAtomizedType());
        }
        return result2;
    }

    @Override
    public String getRuntimeType() {
        return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XSequence";
    }

    @Override
    public int castableAs(AnyAtomicType type2, boolean acceptEmpty) {
        if (this.getQuantifier() == OccurrenceIndicator.TWO_OR_MORE) {
            return 0;
        }
        return 2;
    }

    @Override
    public int typeMatches(XSequenceType expectedType, int promotionSetting) {
        OccurrenceIndicator expectedQuantifier;
        if (this.canBeEmpty()) {
            return 2;
        }
        OccurrenceIndicator thisQuantifier = this.getQuantifier();
        int matches_quantifier = thisQuantifier.matches(expectedQuantifier = expectedType.getQuantifier());
        if (matches_quantifier == 0) {
            return 0;
        }
        int size = this.size();
        boolean hasUnknown = false;
        boolean hasMatchWithPromotion = false;
        int noCount = 0;
        for (int i = 0; i < size; ++i) {
            int item_matches = this.get(i).typeMatches(expectedType, promotionSetting);
            if (item_matches == 0) {
                ++noCount;
                continue;
            }
            if (item_matches == 2) {
                hasUnknown = true;
                continue;
            }
            if (item_matches != 3) continue;
            hasMatchWithPromotion = true;
        }
        if (noCount == size) {
            return 0;
        }
        if (hasUnknown || noCount > 0) {
            return 2;
        }
        if (hasMatchWithPromotion) {
            return 3;
        }
        return 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.get(i).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object otherType) {
        if (otherType instanceof AggregateType) {
            AggregateType aggregateType = (AggregateType)otherType;
            int size = this.size();
            if (size == aggregateType.size()) {
                for (int i = 0; i < size; ++i) {
                    if (this.get(i) == aggregateType.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

