/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.CollectionType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeFactory;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;

public class ChoiceType
extends CollectionType {
    public static final ChoiceType NUMERIC = new ChoiceType();
    private boolean m_allSingleItems = true;

    public ChoiceType() {
    }

    public ChoiceType(Type firstType) {
        this.addType(firstType);
    }

    public ChoiceType(Type firstType, Type secondType) {
        this.addType(firstType);
        this.addType(secondType);
    }

    @Override
    public void addType(Type type2) {
        if (type2 instanceof ChoiceType) {
            ChoiceType choiceType = (ChoiceType)type2;
            int size = choiceType.size();
            for (int i = 0; i < size; ++i) {
                this.addSingleType(choiceType.get(i));
            }
        } else {
            this.addSingleType(type2);
        }
    }

    private void addSingleType(Type type2) {
        if (!this.m_types.contains(type2)) {
            this.m_types.add(type2);
            if (!(type2 instanceof ItemType)) {
                this.m_allSingleItems = false;
            }
            if (!this.m_hasNodeType && type2.mayContainNodeType()) {
                this.m_hasNodeType = true;
            }
        }
    }

    @Override
    public Type getPrimeType() {
        if (this.m_allSingleItems) {
            return this;
        }
        return super.getPrimeType();
    }

    @Override
    public Type getApproximateType() {
        if (this.m_allSingleItems) {
            return this;
        }
        return TypeFactory.newType(this.getPrimeType(), this.getQuantifier());
    }

    @Override
    public OccurrenceIndicator getQuantifier() {
        int size = this.m_types.size();
        OccurrenceIndicator result2 = this.get(0).getQuantifier();
        for (int i = 1; i < size; ++i) {
            result2 = result2.choice(this.get(i).getQuantifier());
        }
        if (this.canBeEmpty()) {
            return result2.product(OccurrenceIndicator.ZERO_OR_ONE);
        }
        return result2;
    }

    @Override
    public Type getAtomizedType() {
        if (!this.m_hasNodeType) {
            return this;
        }
        int size = this.size();
        ChoiceType result2 = new ChoiceType(this.get(0).getAtomizedType());
        for (int i = 1; i < size; ++i) {
            result2.addType(this.get(i).getAtomizedType());
        }
        if (result2.size() == 1) {
            return result2.get(0);
        }
        return result2;
    }

    @Override
    public String getRuntimeType() {
        int size = this.size();
        String result2 = this.get(0).getRuntimeType();
        for (int i = 1; i < size; ++i) {
            String currentType = this.get(i).getRuntimeType();
            if (currentType.equals(result2)) continue;
            if (this.mayContainNodeType()) {
                return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XSequence";
            }
            OccurrenceIndicator occur = this.getQuantifier();
            if (occur == OccurrenceIndicator.ONE || occur == OccurrenceIndicator.ZERO_OR_ONE) {
                return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XItem";
            }
            return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XSequence";
        }
        return result2;
    }

    @Override
    public int castableAs(AnyAtomicType type2, boolean acceptEmpty) {
        int size = this.m_types.size();
        boolean allYes = true;
        boolean allNo = true;
        for (int i = 0; i < size; ++i) {
            Type sourceType = (Type)this.m_types.get(i);
            int result2 = (sourceType = sourceType.getAtomizedType()).castableAs(type2, acceptEmpty);
            if (result2 == 1) {
                allNo = false;
                continue;
            }
            if (result2 == 0) {
                allYes = false;
                continue;
            }
            allYes = false;
            allNo = false;
        }
        if (allYes) {
            return 1;
        }
        if (allNo) {
            return 0;
        }
        return 2;
    }

    @Override
    public int typeMatches(XSequenceType expectedType, int promotionSetting) {
        if (this.canBeEmpty()) {
            return 2;
        }
        Type firstType = this.get(0);
        int size = this.size();
        int firstMatches = firstType.typeMatches(expectedType, promotionSetting);
        if (firstMatches == 2) {
            return 2;
        }
        for (int i = 1; i < size; ++i) {
            int otherMatches = this.get(i).typeMatches(expectedType, promotionSetting);
            if (otherMatches == 2) {
                return 2;
            }
            if (firstMatches != 0 && otherMatches == 0 || firstMatches == 0 && otherMatches != 0) {
                return 2;
            }
            if (otherMatches != 3) continue;
            firstMatches = otherMatches;
        }
        return firstMatches;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            sb.append(this.get(i).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object otherType) {
        if (otherType instanceof ChoiceType) {
            ChoiceType choiceType = (ChoiceType)otherType;
            int size = this.size();
            if (size == choiceType.size()) {
                for (int i = 0; i < size; ++i) {
                    if (choiceType.contains(this.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        NUMERIC.addSingleType(TypeConstants.INTEGER);
        NUMERIC.addSingleType(TypeConstants.DECIMAL);
        NUMERIC.addSingleType(TypeConstants.FLOAT);
        NUMERIC.addSingleType(TypeConstants.DOUBLE);
    }
}

