/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeFactory;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;

public class CompoundType
extends Type {
    private Type m_basetype;
    private OccurrenceIndicator m_occurrenceIndicator;

    public CompoundType(Type basetype, OccurrenceIndicator indicator) {
        this.m_basetype = basetype;
        this.m_occurrenceIndicator = indicator;
    }

    public Type getBaseType() {
        return this.m_basetype;
    }

    public OccurrenceIndicator getOccurrenceIndicator() {
        return this.m_occurrenceIndicator;
    }

    public String toString() {
        return this.m_basetype.toString() + this.m_occurrenceIndicator.toString();
    }

    @Override
    public OccurrenceIndicator getQuantifier() {
        return this.m_basetype.getQuantifier().product(this.m_occurrenceIndicator);
    }

    @Override
    public Type getPrimeType() {
        return this.m_basetype.getPrimeType();
    }

    @Override
    public Type getApproximateType() {
        return TypeFactory.newType(this.getPrimeType(), this.getQuantifier());
    }

    @Override
    public Type getAtomizedType() {
        return TypeFactory.newType(this.m_basetype.getAtomizedType(), this.m_occurrenceIndicator);
    }

    @Override
    public String getRuntimeType() {
        if (this.m_occurrenceIndicator == OccurrenceIndicator.ONE || this.m_occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
            return this.m_basetype.getRuntimeType();
        }
        return "com.ibm.xltxe.rnm1.xtq.xml.datamodel.XSequence";
    }

    @Override
    public boolean mayContainNodeType() {
        return this.m_basetype.mayContainNodeType();
    }

    @Override
    public int castableAs(AnyAtomicType type2, boolean acceptEmpty) {
        OccurrenceIndicator quantifier = this.getQuantifier();
        Type primeType = this.getPrimeType();
        if (quantifier == OccurrenceIndicator.TWO_OR_MORE) {
            return 0;
        }
        if (quantifier == OccurrenceIndicator.ZERO_OR_MORE || this.m_occurrenceIndicator == OccurrenceIndicator.ONE_OR_MORE) {
            int result2;
            if (primeType instanceof AnyAtomicType && (result2 = primeType.castableAs(type2, acceptEmpty)) == 0) {
                return 0;
            }
        } else if (primeType instanceof AnyAtomicType) {
            int result3 = primeType.castableAs(type2, acceptEmpty);
            if (result3 == 1) {
                return acceptEmpty ? 1 : 2;
            }
            return result3;
        }
        return 2;
    }

    @Override
    public int typeMatches(XSequenceType expectedType, int promotionSetting) {
        OccurrenceIndicator thisQuantifier = this.getQuantifier();
        OccurrenceIndicator expectedQuantifier = expectedType.getQuantifier();
        boolean canBothQuantifiersBeEmpty = thisQuantifier.canBeEmpty() && expectedQuantifier.canBeEmpty();
        int matches_quantifier = thisQuantifier.matches(expectedQuantifier);
        if (matches_quantifier == 0) {
            return 0;
        }
        Type primeType = this.getPrimeType();
        int matches_prime = primeType.typeMatches(expectedType, promotionSetting);
        if (matches_prime == 0) {
            return canBothQuantifiersBeEmpty ? 2 : 0;
        }
        if (matches_prime == 1 && matches_quantifier == 1) {
            return 1;
        }
        if (matches_prime == 3 && matches_quantifier == 1) {
            return 3;
        }
        return 2;
    }
}

