/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.IDerivableType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.NodeType;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.UntypedAny;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import javax.xml.namespace.QName;

public class ElementType
extends NodeType {
    private Type m_elementType;
    private QName m_elementName;
    private QName[] m_subGroupNames;
    private boolean m_nillable;
    private boolean m_isDeclaration;

    public ElementType() {
        this(null, null, false);
    }

    public ElementType(QName elementName, Type elementType) {
        this(elementName, elementType, false);
    }

    public ElementType(QName elementName, Type elementType, boolean nillable) {
        this.m_elementName = elementName;
        this.m_elementType = elementType;
        this.m_nillable = nillable;
    }

    public ElementType(QName elementName, QName[] subGroupNames, Type elementType, boolean nillable) {
        this.m_elementName = elementName;
        this.m_elementType = elementType;
        this.m_subGroupNames = subGroupNames;
        this.m_nillable = nillable;
        this.m_isDeclaration = true;
    }

    public boolean isNillable() {
        return this.m_nillable;
    }

    public boolean isDeclaration() {
        return this.m_isDeclaration;
    }

    public QName getElementName() {
        return this.m_elementName;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    @Override
    public Type getAtomizedType() {
        if (this.m_elementType instanceof AnyAtomicType) {
            return this.m_elementType;
        }
        if (this.m_elementType == UNTYPEDANY) {
            return UNTYPEDATOMIC;
        }
        return UNTYPEDATOMIC;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("element(");
        if (this.m_elementName != null) {
            sb.append(this.m_elementName.toString());
        } else {
            sb.append('*');
        }
        sb.append(", ");
        if (this.m_elementType != null) {
            sb.append(this.m_elementType.toString());
        } else {
            sb.append('*');
        }
        if (this.m_nillable) {
            sb.append(", nillable");
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean equals(Object otherType) {
        if (otherType instanceof ElementType) {
            ElementType otherET = (ElementType)otherType;
            return this.elementNameEquals(otherET) && this.elementTypeEquals(otherET) && this.m_nillable == otherET.isNillable();
        }
        return false;
    }

    private boolean elementNameEquals(ElementType otherType) {
        if (this.m_elementName != null) {
            return this.m_elementName.equals(otherType.getElementName());
        }
        return otherType.getElementName() == null;
    }

    private boolean elementTypeEquals(ElementType otherType) {
        if (this.m_elementType != null) {
            return this.m_elementType.equals(otherType.getElementType());
        }
        return otherType.getElementType() == null;
    }

    @Override
    public int getId() {
        return 53;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int typeMatches(XSequenceType expectedType, int promotionSetting) {
        ItemType baseType = expectedType.getBaseType();
        if (baseType == Type.NODE) return 1;
        if (baseType == Type.ITEM) {
            return 1;
        }
        if (!(baseType instanceof ElementType)) return 0;
        ElementType elementType = (ElementType)baseType;
        QName eName = elementType.getElementName();
        Type eType = elementType.getElementType();
        QName[] subGroupNames = elementType.getSubGroupNames();
        boolean match = true;
        if (eName != null && !(match = eName.equals(this.m_elementName)) && subGroupNames != null && this.m_elementName != null) {
            for (int i = 0; i < subGroupNames.length && !(match = subGroupNames[i].equals(this.m_elementName)); ++i) {
            }
        }
        if (match) {
            if (eType == null) return 1;
            if (!(this.m_elementType instanceof IDerivableType)) return 2;
            if (((IDerivableType)((Object)this.m_elementType)).isDerivedFrom((IDerivableType)((Object)eType))) {
                return 1;
            }
            if (!(this.m_elementType instanceof UntypedAny)) return 0;
            return 2;
        }
        if (this.m_elementName != null) return 0;
        return 2;
    }

    public QName[] getSubGroupNames() {
        return this.m_subGroupNames;
    }
}

