/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.BaseConstants;

public abstract class OccurrenceIndicator
implements BaseConstants {
    public static final OccurrenceIndicator ZERO_OR_MORE = new ZeroOrMore();
    public static final OccurrenceIndicator ONE_OR_MORE = new OneOrMore();
    public static final OccurrenceIndicator ZERO_OR_ONE = new ZeroOrOne();
    public static final OccurrenceIndicator TWO_OR_MORE = new TwoOrMore();
    public static final OccurrenceIndicator ONE = new One();

    protected OccurrenceIndicator() {
    }

    public abstract boolean canBeEmpty();

    public abstract int matches(OccurrenceIndicator var1);

    public abstract OccurrenceIndicator sum(OccurrenceIndicator var1);

    public abstract OccurrenceIndicator choice(OccurrenceIndicator var1);

    public abstract OccurrenceIndicator product(OccurrenceIndicator var1);

    public static class TwoOrMore
    extends OccurrenceIndicator {
        public String toString() {
            return "2+";
        }

        @Override
        public boolean canBeEmpty() {
            return false;
        }

        @Override
        public int matches(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == this || otherIndicator == ZERO_OR_MORE || otherIndicator == ONE_OR_MORE) {
                return 1;
            }
            return 0;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator otherIndicator) {
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ONE || otherIndicator == ONE_OR_MORE) {
                return ONE_OR_MORE;
            }
            if (otherIndicator == TWO_OR_MORE) {
                return TWO_OR_MORE;
            }
            return ZERO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return TWO_OR_MORE;
        }
    }

    public static class One
    extends OccurrenceIndicator {
        public String toString() {
            return "";
        }

        @Override
        public boolean canBeEmpty() {
            return false;
        }

        @Override
        public int matches(OccurrenceIndicator otherIndicator) {
            return otherIndicator != TWO_OR_MORE ? 1 : 0;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ONE_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == TWO_OR_MORE) {
                return ONE_OR_MORE;
            }
            return otherIndicator;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator otherIndicator) {
            return otherIndicator;
        }
    }

    public static class ZeroOrOne
    extends OccurrenceIndicator {
        public String toString() {
            return "?";
        }

        @Override
        public boolean canBeEmpty() {
            return true;
        }

        @Override
        public int matches(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == this || otherIndicator == ZERO_OR_MORE) {
                return 1;
            }
            if (otherIndicator == TWO_OR_MORE) {
                return 0;
            }
            return 2;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ONE || otherIndicator == ONE_OR_MORE) {
                return ONE_OR_MORE;
            }
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ONE || otherIndicator == ZERO_OR_ONE) {
                return ZERO_OR_ONE;
            }
            return ZERO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ONE || otherIndicator == ZERO_OR_ONE) {
                return ZERO_OR_ONE;
            }
            return ZERO_OR_MORE;
        }
    }

    public static class OneOrMore
    extends OccurrenceIndicator {
        public String toString() {
            return "+";
        }

        @Override
        public boolean canBeEmpty() {
            return false;
        }

        @Override
        public int matches(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == this || otherIndicator == ZERO_OR_MORE) {
                return 1;
            }
            return 2;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ONE_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return ONE_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            if (otherIndicator == TWO_OR_MORE) {
                return TWO_OR_MORE;
            }
            return ONE_OR_MORE;
        }
    }

    public static class ZeroOrMore
    extends OccurrenceIndicator {
        public String toString() {
            return "*";
        }

        @Override
        public boolean canBeEmpty() {
            return true;
        }

        @Override
        public int matches(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == this) {
                return 1;
            }
            return 2;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator otherIndicator) {
            if (otherIndicator == ONE || otherIndicator == ONE_OR_MORE) {
                return ONE_OR_MORE;
            }
            if (otherIndicator == ZERO_OR_ONE || otherIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator otherIndicator) {
            return ZERO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator otherIndicator) {
            return ZERO_OR_MORE;
        }
    }
}

