/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ChoiceType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ComplexType;
import com.ibm.xltxe.rnm1.xtq.xml.types.CompoundType;
import com.ibm.xltxe.rnm1.xtq.xml.types.IDerivableType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xml.types.UserDefinedAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.UserDefinedListType;
import com.ibm.xltxe.rnm1.xtq.xml.types.UserDefinedUnionType;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class TypeFactory {
    private final XSModel _schemaModel;
    private final HashMap _userTypes;
    private static final IDerivableType[] BUILTIN_TYPES = new IDerivableType[]{TypeConstants.UNTYPEDATOMIC, TypeConstants.STRING, TypeConstants.FLOAT, TypeConstants.DOUBLE, TypeConstants.DECIMAL, TypeConstants.INTEGER, TypeConstants.DURATION, TypeConstants.YEARMONTHDURATION, TypeConstants.DAYTIMEDURATION, TypeConstants.DATETIME, TypeConstants.TIME, TypeConstants.DATE, TypeConstants.GYEARMONTH, TypeConstants.GYEAR, TypeConstants.GMONTHDAY, TypeConstants.GDAY, TypeConstants.GMONTH, TypeConstants.BOOLEAN, TypeConstants.BASE64BINARY, TypeConstants.HEXBINARY, TypeConstants.ANYURI, TypeConstants.QNAME, TypeConstants.NOTATION, TypeConstants.LONG, TypeConstants.INT, TypeConstants.SHORT, TypeConstants.BYTE, TypeConstants.UNSIGNEDLONG, TypeConstants.UNSIGNEDINT, TypeConstants.UNSIGNEDSHORT, TypeConstants.UNSIGNEDBYTE, TypeConstants.NONPOSITIVEINTEGER, TypeConstants.NONNEGATIVEINTEGER, TypeConstants.POSITIVEINTEGER, TypeConstants.NEGATIVEINTEGER, TypeConstants.NORMALIZEDSTRING, TypeConstants.TOKEN, TypeConstants.LANGUAGE, TypeConstants.NMTOKEN, TypeConstants.NAME, TypeConstants.NCNAME, TypeConstants.ID, TypeConstants.IDREF, TypeConstants.ENTITY, TypeConstants.ANYATOMICTYPE, TypeConstants.ANYTYPE, TypeConstants.ANYSIMPLETYPE, TypeConstants.UNTYPEDANY, TypeConstants.IDREFS, TypeConstants.NMTOKENS, TypeConstants.ENTITIES};
    private static final HashMap NAME2TYPES = new HashMap();

    public TypeFactory() {
        this(null);
    }

    public TypeFactory(XSModel schema2) {
        this._schemaModel = schema2;
        this._userTypes = new HashMap();
    }

    public IDerivableType getTypeFromName(QName qname2) {
        String ns = qname2.getNamespaceURI();
        IDerivableType type2 = ns.equals("http://www.w3.org/2001/XMLSchema") ? (IDerivableType)NAME2TYPES.get(qname2) : this.getUserTypeFromName(qname2);
        return type2;
    }

    public static IDerivableType getTypeFromId(int id2) {
        return BUILTIN_TYPES[id2];
    }

    public static int getTypeSize() {
        return BUILTIN_TYPES.length;
    }

    protected IDerivableType getUserTypeFromName(QName qname2) {
        XSTypeDefinition xsType;
        String ns = qname2.getNamespaceURI();
        String localPart = qname2.getLocalPart();
        IDerivableType userType = (IDerivableType)this._userTypes.get(qname2);
        if (userType == null && this._schemaModel != null && (xsType = this._schemaModel.getTypeDefinition(localPart, ns)) != null) {
            userType = this.createUserTypeFromXSTypeDef(qname2, xsType);
        }
        return userType;
    }

    public IDerivableType getTypeFromNameOrXSTypeDef(QName qname2, XSTypeDefinition xsType) {
        IDerivableType type2;
        String ns = qname2.getNamespaceURI();
        if (ns.equals("http://www.w3.org/2001/XMLSchema")) {
            type2 = (IDerivableType)NAME2TYPES.get(qname2);
        } else {
            type2 = (IDerivableType)this._userTypes.get(qname2);
            if (type2 == null) {
                type2 = this.createUserTypeFromXSTypeDef(qname2, xsType);
            }
        }
        return type2;
    }

    public IDerivableType getTypeFromAnonymousXSTypeDef(XSTypeDefinition xsType) {
        Type userType = null;
        if (xsType.getTypeCategory() == 16) {
            XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)xsType;
            switch (simpleType.getVariety()) {
                case 1: {
                    XSTypeDefinition baseXSType = simpleType.getBaseType();
                    QName baseTypeName = new QName(baseXSType.getNamespace(), baseXSType.getName());
                    AnyAtomicType derivableBase = (AnyAtomicType)this.getTypeFromNameOrXSTypeDef(baseTypeName, baseXSType);
                    UserDefinedAtomicType udat = new UserDefinedAtomicType(derivableBase);
                    userType = udat;
                    break;
                }
                case 2: {
                    XSSimpleTypeDefinition itemXSType = simpleType.getItemType();
                    QName itemTypeName = new QName(itemXSType.getNamespace(), itemXSType.getName());
                    IDerivableType itemType = this.getTypeFromNameOrXSTypeDef(itemTypeName, itemXSType);
                    userType = new UserDefinedListType(itemType);
                    break;
                }
                case 3: {
                    XSObjectList members = simpleType.getMemberTypes();
                    int size = members.getLength();
                    Type[] memberTypes = new Type[size];
                    for (int i = 0; i < members.getLength(); ++i) {
                        XSTypeDefinition memberXSType = (XSTypeDefinition)members.item(i);
                        QName memberTypeName = new QName(memberXSType.getNamespace(), memberXSType.getName());
                        memberTypes[i] = (Type)((Object)this.getTypeFromNameOrXSTypeDef(memberTypeName, memberXSType));
                    }
                    userType = new UserDefinedUnionType(memberTypes);
                }
            }
        } else {
            ComplexType ct;
            userType = ct = new ComplexType();
        }
        return userType;
    }

    protected IDerivableType createUserTypeFromXSTypeDef(QName qname2, XSTypeDefinition xsType) {
        Type userType = null;
        if (xsType.getTypeCategory() == 16) {
            XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)xsType;
            switch (simpleType.getVariety()) {
                case 1: {
                    AnyAtomicType derivableBase;
                    XSTypeDefinition baseXSType = simpleType.getBaseType();
                    String baseLocalName = baseXSType.getName();
                    if (baseXSType.getName() != null) {
                        QName baseTypeName = new QName(baseXSType.getNamespace(), baseLocalName);
                        derivableBase = (AnyAtomicType)this.getTypeFromNameOrXSTypeDef(baseTypeName, baseXSType);
                    } else {
                        derivableBase = (AnyAtomicType)this.getTypeFromAnonymousXSTypeDef(baseXSType);
                    }
                    userType = new UserDefinedAtomicType(qname2, derivableBase);
                    break;
                }
                case 2: {
                    IDerivableType itemType;
                    XSSimpleTypeDefinition itemXSType = simpleType.getItemType();
                    String typeLocalName = itemXSType.getName();
                    if (typeLocalName != null) {
                        QName itemTypeName = new QName(itemXSType.getNamespace(), typeLocalName);
                        itemType = this.getTypeFromNameOrXSTypeDef(itemTypeName, itemXSType);
                    } else {
                        itemType = this.getTypeFromAnonymousXSTypeDef(itemXSType);
                    }
                    userType = new UserDefinedListType(qname2, itemType);
                    break;
                }
                case 3: {
                    XSObjectList members = simpleType.getMemberTypes();
                    int size = members.getLength();
                    Type[] memberTypes = new Type[size];
                    for (int i = 0; i < members.getLength(); ++i) {
                        XSTypeDefinition memberXSType = (XSTypeDefinition)members.item(i);
                        String memberLocalName = memberXSType.getName();
                        if (memberLocalName != null) {
                            QName memberTypeName = new QName(memberXSType.getNamespace(), memberLocalName);
                            memberTypes[i] = (Type)((Object)this.getTypeFromNameOrXSTypeDef(memberTypeName, memberXSType));
                            continue;
                        }
                        memberTypes[i] = (Type)((Object)this.getTypeFromAnonymousXSTypeDef(memberXSType));
                    }
                    userType = new UserDefinedUnionType(qname2, memberTypes);
                    break;
                }
            }
        } else {
            userType = new ComplexType(qname2);
        }
        this._userTypes.put(qname2, userType);
        return userType;
    }

    public static Type newType(Type basetype, OccurrenceIndicator quantifier) {
        if (quantifier == OccurrenceIndicator.ONE) {
            return basetype;
        }
        if (basetype instanceof ItemType) {
            return new XSequenceType((ItemType)basetype, quantifier);
        }
        return new CompoundType(basetype, quantifier);
    }

    public static Type newChoiceType(Type firstType, Type secondType) {
        if (firstType.equals(secondType)) {
            return firstType;
        }
        return new ChoiceType(firstType, secondType);
    }

    static {
        for (IDerivableType type2 : BUILTIN_TYPES) {
            NAME2TYPES.put(type2.getQName(), type2);
        }
    }
}

