/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.IDerivableType;
import com.ibm.xltxe.rnm1.xtq.xml.types.IUserDefined;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import javax.xml.namespace.QName;

public class UserDefinedAtomicType
extends AnyAtomicType
implements IUserDefined {
    private boolean m_isAnonymous = false;

    public UserDefinedAtomicType(AnyAtomicType superType) {
        this.m_qname = null;
        this.m_superType = superType;
        this.m_depth = superType.getDepth() + 1;
        this.m_isAnonymous = true;
    }

    public UserDefinedAtomicType(QName qname2, AnyAtomicType superType) {
        this.m_qname = qname2;
        this.m_superType = superType;
        this.m_depth = superType.getDepth() + 1;
    }

    @Override
    public IDerivableType getSuperType() {
        return this.m_superType;
    }

    @Override
    public boolean isNumericType() {
        return ((AnyAtomicType)this.m_superType).isNumericType();
    }

    @Override
    public AnyAtomicType getPrimitiveAncestor() {
        return ((AnyAtomicType)this.m_superType).getPrimitiveAncestor();
    }

    @Override
    public String getRuntimeType(boolean usePrimitive) {
        return this.getPrimitiveAncestor().getRuntimeType(false);
    }

    @Override
    public boolean isDerivedFrom(IDerivableType otherType) {
        if (otherType.getDepth() > this.m_depth) {
            return false;
        }
        if (otherType.getDepth() <= 1) {
            return true;
        }
        if (otherType == this || otherType == this.m_superType) {
            return true;
        }
        IDerivableType type2 = this.m_superType;
        while (type2.getDepth() > otherType.getDepth()) {
            type2 = type2.getSuperType();
        }
        return type2 == otherType;
    }

    @Override
    public int typeMatches(XSequenceType expectedType, int promotionSetting) {
        int match_result = super.typeMatches(expectedType, promotionSetting);
        if (UserDefinedAtomicType.hasNoPromoSetting(promotionSetting)) {
            return match_result;
        }
        boolean numericPromotion = UserDefinedAtomicType.hasPromoSetting(promotionSetting, 1);
        boolean uriPromotion = UserDefinedAtomicType.hasPromoSetting(promotionSetting, 2);
        if (match_result == 0) {
            if (numericPromotion && this.isDerivedFrom(DECIMAL) && (FLOAT.typeMatches(expectedType) == 1 || DOUBLE.typeMatches(expectedType) == 1)) {
                return 3;
            }
            if (numericPromotion && this.isDerivedFrom(FLOAT) && DOUBLE.typeMatches(expectedType) == 1) {
                return 3;
            }
            if (uriPromotion && this.isDerivedFrom(ANYURI) && STRING.typeMatches(expectedType) == 1) {
                return 3;
            }
            return 0;
        }
        return match_result;
    }

    @Override
    public boolean isAnonymous() {
        return this.m_isAnonymous;
    }

    @Override
    public void setAnonymous(boolean isAnonymous) {
        this.m_isAnonymous = isAnonymous;
    }
}

