/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.unicode.normalize;

import com.ibm.icu.text.Normalizer;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;

public final class XNormalizer {
    public static final String DEFAULT_FORM = "NFC";
    public static final String EMPTY_STRING = "";

    public static final String normalizeUnicode(String text2) {
        return text2.equals(EMPTY_STRING) ? EMPTY_STRING : XNormalizer.normalizeUnicode(text2, XNormalizer.getNormalizerMode(DEFAULT_FORM));
    }

    public static final String normalizeUnicode(String text2, String form) {
        return text2.equals(EMPTY_STRING) ? EMPTY_STRING : XNormalizer.normalizeUnicode(text2, XNormalizer.getNormalizerMode(form));
    }

    public static synchronized boolean alreadyNormalizedUnicode(String text2) {
        return Normalizer.quickCheck((String)text2, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM)).equals(Normalizer.YES);
    }

    public static synchronized int normalizeUnicode(char[] inChars, int inFirst, int inLast, char[] outChars, int outFirst, int outLastMax) {
        int outputCharCount = Normalizer.normalize((char[])inChars, (int)inFirst, (int)inLast, (char[])outChars, (int)outFirst, (int)outLastMax, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM), (int)0);
        return outputCharCount;
    }

    public static synchronized boolean alreadyNormalizedUnicode(char[] chars, int first, int count2) {
        return Normalizer.quickCheck((char[])chars, (int)first, (int)count2, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM), (int)0).equals(Normalizer.YES);
    }

    private static final synchronized String normalizeUnicode(String text2, Normalizer.Mode mode) {
        if (Normalizer.quickCheck((String)text2, (Normalizer.Mode)mode).equals(Normalizer.YES)) {
            return text2;
        }
        return Normalizer.normalize((String)text2, (Normalizer.Mode)mode);
    }

    private static final Normalizer.Mode getNormalizerMode(String form) {
        String effectiveForm = form.trim().toUpperCase();
        try {
            if (effectiveForm.equals(DEFAULT_FORM)) {
                return Normalizer.NFC;
            }
            if (effectiveForm.equals("NFD")) {
                return Normalizer.NFD;
            }
            if (effectiveForm.equals("NFKC")) {
                return Normalizer.NFKC;
            }
            if (effectiveForm.equals("NFKD")) {
                return Normalizer.NFKD;
            }
            if (effectiveForm.equals("FCD")) {
                return Normalizer.FCD;
            }
        }
        catch (NoClassDefFoundError e) {
            throw new NoClassDefFoundError(XMLMessages.createXMLMessage("ER_NEEDS_ICU", new Object[]{"normalizeUnicode"}));
        }
        throw new RuntimeException(XMLMessages.createXMLMessage("ER_UNSUPPORTED_NORMALIZATION_FORM", new Object[]{form}));
    }
}

