/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.StringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Vector;

final class CollatorBasedStringSearcher
extends StringSearcher {
    private static final boolean DEBUG = false;
    private final RuleBasedCollator m_collator;
    private final RuleBasedCollator m_secondaryStrengthCollator;
    private int m_mask;

    CollatorBasedStringSearcher(RuleBasedCollator collator2, RuleBasedCollator secondaryStrengthCollator) {
        this.m_collator = collator2;
        this.m_secondaryStrengthCollator = secondaryStrengthCollator;
        this.resetMaskStrength();
    }

    void resetMaskStrength() {
        this.m_mask = CollatorBasedStringSearcher.getMask(this.m_collator.getStrength());
    }

    final Range[] allOccurances(String text2, String pattern2) {
        Range[] positions;
        CollationElementIterator targIter = this.m_collator.getCollationElementIterator(text2);
        CollationElementIterator patIter = this.m_collator.getCollationElementIterator(pattern2);
        Vector<Range> matches2 = null;
        for (int i = 0; i < text2.length(); ++i) {
            targIter.setOffset(i);
            patIter.reset();
            Range position2 = this.match(targIter, patIter);
            if (position2 == null) continue;
            if (matches2 == null) {
                matches2 = new Vector<Range>();
            }
            matches2.add(position2);
        }
        if (matches2 == null) {
            positions = null;
        } else {
            positions = new Range[matches2.size()];
            for (int i = 0; i < matches2.size(); ++i) {
                positions[i] = (Range)matches2.elementAt(i);
            }
        }
        return positions;
    }

    private final Range match(CollationElementIterator targIter, CollationElementIterator patIter) {
        int targetElement;
        int endOffset;
        int startOffset;
        block7: {
            startOffset = targIter.getOffset();
            endOffset = -1;
            int done = this.getElement(-1);
            int patternElement = 0;
            targetElement = 0;
            boolean getPattern = true;
            boolean getTarget = true;
            while (true) {
                if (getPattern) {
                    patternElement = this.getElement(patIter.next());
                }
                if (getTarget) {
                    endOffset = targIter.getOffset();
                    targetElement = this.getElement(targIter.next());
                }
                getPattern = true;
                getTarget = true;
                if (patternElement == done) break block7;
                if (targetElement == 0) {
                    getPattern = false;
                    continue;
                }
                if (patternElement == 0) {
                    getTarget = false;
                    continue;
                }
                if (targetElement != patternElement) break;
            }
            return null;
        }
        while (targetElement == 0) {
            endOffset = targIter.getOffset();
            targetElement = this.getElement(targIter.next());
        }
        if (endOffset > startOffset) {
            return new Range(startOffset, endOffset);
        }
        return null;
    }

    final ParamCaseOrder[] getFirstCaseDiff(String text2, String pattern2, Locale locale) {
        ParamCaseOrder[] diff;
        CollationElementIterator targIter = this.m_collator.getCollationElementIterator(text2);
        CollationElementIterator patIter = this.m_collator.getCollationElementIterator(pattern2);
        int startTarg = -1;
        int endTarg = -1;
        int startPatt = -1;
        int endPatt = -1;
        int done = this.getElement(-1);
        int patternElement = 0;
        int targetElement = 0;
        boolean getPattern = true;
        boolean getTarget = true;
        while (true) {
            String subPattUp;
            if (getPattern) {
                startPatt = patIter.getOffset();
                patternElement = this.getElement(patIter.next());
                endPatt = patIter.getOffset();
            }
            if (getTarget) {
                startTarg = targIter.getOffset();
                targetElement = this.getElement(targIter.next());
                endTarg = targIter.getOffset();
            }
            getPattern = true;
            getTarget = true;
            if (patternElement == done || targetElement == done) {
                return null;
            }
            if (targetElement == 0) {
                getPattern = false;
                continue;
            }
            if (patternElement == 0) {
                getTarget = false;
                continue;
            }
            if (targetElement == patternElement || startPatt >= endPatt || startTarg >= endTarg) continue;
            String subText2 = text2.substring(startTarg, endTarg);
            String subPatt = pattern2.substring(startPatt, endPatt);
            String subTextUp = subText2.toUpperCase(locale);
            if (this.m_collator.compare(subTextUp, subPattUp = subPatt.toUpperCase(locale)) != 0) continue;
            diff = new ParamCaseOrder[]{ParamCaseOrder.UNKNOWN, ParamCaseOrder.UNKNOWN};
            if (this.m_collator.compare(subText2, subTextUp) == 0) {
                diff[0] = ParamCaseOrder.UPPER_FIRST;
            } else if (this.m_collator.compare(subText2, subText2.toLowerCase(locale)) == 0) {
                diff[0] = ParamCaseOrder.LOWER_FIRST;
            }
            if (this.m_collator.compare(subPatt, subPattUp) == 0) {
                diff[1] = ParamCaseOrder.UPPER_FIRST;
            } else if (this.m_collator.compare(subPatt, subPatt.toLowerCase(locale)) == 0) {
                diff[1] = ParamCaseOrder.LOWER_FIRST;
            }
            if (diff[0] == ParamCaseOrder.UPPER_FIRST && diff[1] == ParamCaseOrder.LOWER_FIRST || diff[0] == ParamCaseOrder.LOWER_FIRST && diff[1] == ParamCaseOrder.UPPER_FIRST) break;
        }
        return diff;
    }

    private static final int getMask(int strength) {
        switch (strength) {
            case 0: {
                return -65536;
            }
            case 1: {
                return -256;
            }
        }
        return -1;
    }

    private final int getElement(int maxStrengthElement) {
        return maxStrengthElement & this.m_mask;
    }

    @Override
    public Range firstOccurance(String text2, String pattern2) {
        Range first = null;
        CollationElementIterator targIter = this.m_collator.getCollationElementIterator(text2);
        CollationElementIterator patIter = this.m_collator.getCollationElementIterator(pattern2);
        for (int i = 0; i < text2.length(); ++i) {
            targIter.setOffset(i);
            patIter.reset();
            Range position2 = this.match(targIter, patIter);
            if (position2 == null) continue;
            first = position2;
            break;
        }
        return first;
    }

    @Override
    public Range lastOccurance(String text2, String pattern2) {
        Range last2 = null;
        CollationElementIterator targIter = this.m_collator.getCollationElementIterator(text2);
        CollationElementIterator patIter = this.m_collator.getCollationElementIterator(pattern2);
        for (int i = 0; i < text2.length(); ++i) {
            targIter.setOffset(i);
            patIter.reset();
            Range position2 = this.match(targIter, patIter);
            if (position2 == null) continue;
            last2 = position2;
        }
        return last2;
    }

    @Override
    public int filterComparisonWithCaseOrder(String str1, String str2, XCollator.CaseOrder caseOrder, int unfilteredComparison) {
        int secondaryComparison;
        if (this.m_secondaryStrengthCollator != null && (secondaryComparison = this.m_secondaryStrengthCollator.compare(str1, str2)) != 0) {
            return unfilteredComparison;
        }
        CollationElementIterator iter1 = this.m_collator.getCollationElementIterator(str1);
        CollationElementIterator iter2 = this.m_collator.getCollationElementIterator(str2);
        int startOffset1 = iter1.getOffset();
        int startOffset2 = iter2.getOffset();
        int filteredComparison = 0;
        boolean done = false;
        while (!done && filteredComparison == 0) {
            int endOffset2;
            int collationElement1 = iter1.next();
            int collationElement2 = iter2.next();
            boolean done1 = collationElement1 == -1;
            boolean done2 = collationElement2 == -1;
            boolean bl = done = done1 || done2;
            if (done) break;
            int endOffset1 = done1 ? str1.length() : iter1.getOffset();
            int n2 = endOffset2 = done2 ? str2.length() : iter2.getOffset();
            if (collationElement1 != collationElement2) {
                int codePoint;
                int i;
                boolean str1HasUpper = false;
                boolean str2HasUpper = false;
                boolean str1HasLower = false;
                boolean str2HasLower = false;
                for (i = startOffset1; i < endOffset1; ++i) {
                    if (str1HasUpper && str1HasLower) continue;
                    codePoint = str1.codePointAt(i);
                    if (!str1HasUpper && Character.isUpperCase(codePoint)) {
                        str1HasUpper = true;
                    }
                    if (str1HasLower || !Character.isLowerCase(codePoint)) continue;
                    str1HasLower = true;
                }
                for (i = startOffset2; i < endOffset2; ++i) {
                    if (str2HasUpper && str2HasLower) continue;
                    codePoint = str2.codePointAt(i);
                    if (!str2HasUpper && Character.isUpperCase(codePoint)) {
                        str2HasUpper = true;
                    }
                    if (str2HasLower || !Character.isLowerCase(codePoint)) continue;
                    str2HasLower = true;
                }
                switch (caseOrder) {
                    case LOWER_FIRST: {
                        if (str1HasUpper && !str2HasUpper && str2HasLower) {
                            filteredComparison = 1;
                            break;
                        }
                        if (str1HasUpper || !str1HasLower || !str2HasUpper) break;
                        filteredComparison = -1;
                        break;
                    }
                    case UPPER_FIRST: {
                        if (str1HasUpper && !str2HasUpper && str2HasLower) {
                            filteredComparison = -1;
                            break;
                        }
                        if (str1HasUpper || !str1HasLower || !str2HasUpper) break;
                        filteredComparison = 1;
                    }
                }
            }
            startOffset1 = endOffset1;
            startOffset2 = endOffset2;
        }
        return filteredComparison != 0 ? filteredComparison : unfilteredComparison;
    }
}

