/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamStrength;

public final class CollatorDeclarationImpl
implements CollatorDeclaration {
    private final String m_name;
    private final String m_key;
    private final String m_lang;
    private final ParamDecomposition m_decomposition;
    private final ParamStrength m_strength;
    private final String m_rules;
    private final String m_impl;
    private final ParamCaseOrder m_caseOrder;

    public CollatorDeclarationImpl(String name2, String lang2, ParamDecomposition decomposition, ParamStrength strength, String rules, ParamCaseOrder caseOrder, String impl2) {
        StringBuffer s = new StringBuffer();
        s.append("@");
        if (lang2 != null) {
            s.append("?lang=").append(lang2).append(';');
        }
        if (caseOrder != null) {
            s.append("?caseOrder=").append(caseOrder.getValue()).append(';');
        }
        if (decomposition != null) {
            s.append("?decomposition=").append(decomposition.getValue()).append(';');
        }
        if (strength != null) {
            s.append("?strength=").append(strength.getValue()).append(';');
        }
        if (rules != null) {
            s.append("?rules=").append(rules).append(';');
        }
        if (impl2 != null) {
            s.append("?impl=").append(impl2).append(';');
        }
        this.m_key = s.toString();
        this.m_name = name2;
        this.m_lang = lang2 == null ? "" : lang2;
        this.m_decomposition = decomposition == null ? ParamDecomposition.NOT_SPECIFIED : decomposition;
        this.m_strength = strength;
        this.m_rules = null == rules ? "" : rules;
        this.m_caseOrder = caseOrder;
        this.m_impl = impl2 == null ? "" : impl2;
    }

    public CollatorDeclarationImpl(String name2, String lang2, String decomposition, String strength, String rules, String caseOrder, String impl2) {
        this(name2, lang2, ParamDecomposition.getDecomposition(decomposition), ParamStrength.getComparisonStrength(strength), rules, ParamCaseOrder.getCaseOrder(caseOrder), impl2);
    }

    ParamDecomposition getDecompositionType() {
        return this.m_decomposition;
    }

    ParamStrength getStrengthType() {
        return this.m_strength;
    }

    ParamCaseOrder getCaseOrderType() {
        return this.m_caseOrder;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getLanguage() {
        return this.m_lang;
    }

    @Override
    public String getRules() {
        return this.m_rules;
    }

    @Override
    public String getImpl() {
        return this.m_impl;
    }

    @Override
    public String getDecomposition() {
        String ret = this.getDecompositionType().getValue();
        return ret;
    }

    @Override
    public String getStrength() {
        ParamStrength strength = this.getStrengthType();
        if (strength == null) {
            return null;
        }
        return strength.getValue();
    }

    @Override
    public String getCaseOrder() {
        String ret = this.getCaseOrderType().getValue();
        return ret;
    }

    @Override
    public String getKey() {
        return this.m_key;
    }
}

