/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ICUCollator;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.JavaCollator;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamStrength;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.UnicodeCodepointCollator;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Stack;

public final class CollatorFactory {
    static final String STRENGTH_PRIMARY = "primary";
    static final String STRENGTH_SECONDARY = "secondary";
    static final String STRENGTH_TERTIARY = "tertiary";
    static final String STRENGTH_QUATERNARY = "quaternary";
    static final String STRENGTH_IDENTICAL = "identical";
    static final String DECOMP_NO = "no";
    static final String DECOMP_CANONICAL = "canonical";
    static final String DECOMP_FULL = "full";
    static final String CASEORDER_UNKNOWN = "unknown";
    static final String CASEORDER_NO = "no";
    static final String CASEORDER_UPPER_FIRST = "upper-first";
    static final String CASEORDER_LOWER_FIRST = "lower-first";
    static final String CASEORDER_MIXED = "mixed";
    private static final String ICU_CLASS = "com.ibm.icu.text.RuleBasedColator";
    public static final String CODE_POINT_NAME = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    static final String INVALID_URI_PREFIX = "@";
    public static final String SYSTEM_DEFAULT_NAME = "@/SystemDefault";
    private static final String[] PREDEFINED_URIS = new String[]{"http://www.w3.org/2005/xpath-functions/collation/codepoint", "@/SystemDefault"};
    private static final UnicodeCodepointCollator CODE_POINT_COLLATOR;
    private static final CollatorDeclarationImpl CODE_POINT_DECLARATION;
    private static final XCollator SYSTEM_DEFAULT_COLLATOR;
    private static final CollatorDeclarationImpl SYSTEM_DEFAULT_DECLARATION;
    private static final boolean ICU_ON_CLASSPATH;

    public static final boolean isPredefinedURI(String name2) {
        if (PREDEFINED_URIS == null) {
            return false;
        }
        int length2 = PREDEFINED_URIS.length;
        for (int index2 = 0; index2 < length2; ++index2) {
            if (!PREDEFINED_URIS[index2].equals(name2)) continue;
            return true;
        }
        return false;
    }

    public static final XCollator createCollatorFromDeclaration(CollatorDeclaration decl) {
        XCollator collator2 = null;
        CollatorDeclarationImpl declImpl = decl instanceof CollatorDeclarationImpl ? (CollatorDeclarationImpl)decl : (decl == null ? new CollatorDeclarationImpl(decl.getName(), decl.getLanguage(), decl.getDecomposition(), decl.getStrength(), decl.getRules(), decl.getCaseOrder(), decl.getImpl()) : SYSTEM_DEFAULT_DECLARATION);
        String impl2 = decl.getImpl();
        try {
            if (impl2 == null || "".equals(impl2)) {
                collator2 = CollatorFactory.createSystemXCollator(declImpl);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (collator2 == null && impl2 != null) {
            Class clazz = null;
            try {
                clazz = ObjectFactory.findProviderClass(impl2, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz != null) {
                if (decl != null) {
                    Constructor con;
                    if (decl == declImpl) {
                        try {
                            con = clazz.getConstructor(CollatorDeclarationImpl.class);
                            collator2 = (XCollator)con.newInstance(declImpl);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (collator2 == null) {
                        try {
                            con = clazz.getConstructor(CollatorDeclaration.class);
                            collator2 = (XCollator)con.newInstance(decl);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (collator2 == null) {
                    try {
                        collator2 = (XCollator)clazz.newInstance();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        if (collator2 == null) {
            collator2 = new JavaCollator(declImpl);
        }
        return collator2;
    }

    private static final XCollator getUnicodeCodePointCollator() {
        return CODE_POINT_COLLATOR;
    }

    public static final XCollator getPredefinedCollator(String name2) {
        if (name2.equals(CODE_POINT_NAME)) {
            return CODE_POINT_COLLATOR;
        }
        if (name2.equals(SYSTEM_DEFAULT_NAME)) {
            return SYSTEM_DEFAULT_COLLATOR;
        }
        return null;
    }

    private final XCollator getCollatorFromLanguage(String IETFLang, String caseOrder, Stack messages) {
        String name2 = "@lang=" + IETFLang + ";";
        if (caseOrder != null) {
            name2 = name2 + "?case-order=" + caseOrder + ";";
        }
        ParamCaseOrder cco = ParamCaseOrder.getCaseOrder(caseOrder);
        String impl2 = "";
        CollatorDeclarationImpl decl = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(name2, IETFLang, null, null, null, cco.getValue(), impl2);
        XCollator collator2 = CollatorFactory.createCollatorFromDeclaration(decl);
        return collator2;
    }

    private static final XCollator createSystemXCollator(CollatorDeclarationImpl declaration2) {
        CollatorImplBase xcollator = ICU_ON_CLASSPATH ? new ICUCollator(declaration2) : new JavaCollator(declaration2);
        return xcollator;
    }

    public static boolean isNameValid(String name2) {
        return name2.length() != 0 && !CollatorFactory.isPredefinedURI(name2);
    }

    private static boolean isLanguageValid(String lang2) {
        return LocaleUtility.isIETFLangValid(lang2);
    }

    public static boolean isCaseOrderValid(String caseOrder) {
        boolean valid2 = ParamCaseOrder.isValid(caseOrder);
        return valid2;
    }

    public static boolean isDecompositionValid(String decomposition) {
        boolean valid2 = ParamDecomposition.isValid(decomposition);
        return valid2;
    }

    public static boolean isStrengthValid(String strength) {
        boolean valid2 = ParamStrength.isValid(strength);
        return valid2;
    }

    public static final CollatorDeclaration getCollatorDeclaration(String name2, String language, String decompostion, String strength, String rules, String caseOrder, String implClassname) {
        CollatorDeclarationImpl decl = new CollatorDeclarationImpl(name2, language, decompostion, strength, rules, caseOrder, implClassname);
        return decl;
    }

    public static String getLangSupported(String langRequested) {
        Locale loc = ICU_ON_CLASSPATH ? ICUCollator.getLocaleSupported(langRequested) : JavaCollator.getLocaleSupported(langRequested);
        String supported = loc.toString();
        String[] lcv = LocaleUtility.splitLangName(supported, '_');
        String ret = "";
        String lan = lcv[0];
        if (lan.length() > 0) {
            ret = ret + lan;
            String country = lcv[1];
            if (country.length() > 0) {
                ret = ret + "-" + country;
                String variant = lcv[2];
                if (variant.length() > 0) {
                    ret = ret + "_" + variant;
                }
            }
        }
        return ret;
    }

    public static final int compareLangCountryVariant(String langRequested, String langSupported) {
        return LocaleUtility.compareLangCountryVariant(langRequested, langSupported);
    }

    static {
        boolean icu_on_path = false;
        try {
            Class.forName(ICU_CLASS);
            icu_on_path = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ICU_ON_CLASSPATH = icu_on_path;
        CODE_POINT_DECLARATION = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(CODE_POINT_NAME, null, null, null, null, null, "java.lang.String");
        CODE_POINT_COLLATOR = UnicodeCodepointCollator.getInstance();
        String impl2 = ICU_ON_CLASSPATH ? "com.ibm.xltxe.rnm1.xtq.collator.impl.ICUCollator" : JavaCollator.class.getName();
        SYSTEM_DEFAULT_DECLARATION = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(SYSTEM_DEFAULT_NAME, null, null, null, null, ParamCaseOrder.UPPER_FIRST.getValue(), impl2);
        SYSTEM_DEFAULT_COLLATOR = ICU_ON_CLASSPATH ? new ICUCollator(SYSTEM_DEFAULT_DECLARATION) : new JavaCollator(SYSTEM_DEFAULT_DECLARATION);
    }
}

