/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

abstract class CollatorImplBase
implements XCollator {
    private static final String EMPTY_STRING = "";
    final CollatorDeclarationImpl m_declaration;
    final Locale m_locale;
    final Stack m_messages = new Stack();

    CollatorImplBase(CollatorDeclarationImpl decl, Locale loc) {
        this.m_declaration = decl;
        this.m_locale = loc;
    }

    public CollatorDeclaration getDeclaration() {
        return this.m_declaration;
    }

    private final Stack getMessages() {
        return this.m_messages;
    }

    abstract Range[] allOccurances(String var1, String var2);

    abstract Range firstOccurance(String var1, String var2);

    abstract Range lastOccurance(String var1, String var2);

    @Override
    public boolean contains(String text2, String pattern2) {
        if (pattern2.equals(EMPTY_STRING)) {
            return true;
        }
        if (text2.equals(EMPTY_STRING)) {
            return false;
        }
        return this.firstOccurance(text2, pattern2) != null;
    }

    @Override
    public boolean startsWith(String text2, String pattern2) {
        if (pattern2.equals(EMPTY_STRING)) {
            return true;
        }
        if (text2.equals(EMPTY_STRING)) {
            return false;
        }
        Range firstMatch = this.firstOccurance(text2, pattern2);
        return firstMatch != null && firstMatch.m_startOffset == 0;
    }

    @Override
    public boolean endsWith(String text2, String pattern2) {
        if (pattern2.equals(EMPTY_STRING)) {
            return true;
        }
        if (text2.equals(EMPTY_STRING)) {
            return false;
        }
        Range lastMatch = this.lastOccurance(text2, pattern2);
        return lastMatch != null && lastMatch.m_endOffset == text2.length();
    }

    @Override
    public String substringBefore(String text2, String pattern2) {
        if (pattern2.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        if (text2.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        Range firstMatch = this.firstOccurance(text2, pattern2);
        if (firstMatch == null) {
            return EMPTY_STRING;
        }
        return text2.substring(0, firstMatch.m_startOffset);
    }

    @Override
    public String substringAfter(String text2, String pattern2) {
        Range lastMatch;
        String after2 = pattern2.equals(EMPTY_STRING) ? text2 : (text2.equals(EMPTY_STRING) ? EMPTY_STRING : ((lastMatch = this.lastOccurance(text2, pattern2)) == null ? EMPTY_STRING : text2.substring(lastMatch.m_endOffset)));
        return after2;
    }

    static final int formatCompareReturn(int rnt) {
        rnt = rnt > 0 ? 1 : (rnt < 0 ? -1 : 0);
        return rnt;
    }

    static Range[] convertFromVector(Vector vectorOfRange) {
        int size = vectorOfRange.size();
        Range[] r = new Range[size];
        for (int i = 0; i < size; ++i) {
            r[i] = (Range)vectorOfRange.elementAt(i);
        }
        return r;
    }
}

