/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SearchIterator;
import com.ibm.icu.text.StringSearch;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Messages;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamStrength;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

final class ICUCollator
extends CollatorImplBase {
    private static final Locale[] s_Locales = RuleBasedCollator.getAvailableLocales();
    private static final ArrayList s_LocaleNames = new ArrayList();
    private final RuleBasedCollator m_collator;
    private final SearchIterator m_search;

    ICUCollator(CollatorDeclarationImpl declaration2) {
        super(declaration2, LocaleUtility.IETFToValidLocale(declaration2.getLanguage(), s_Locales, s_LocaleNames));
        RuleBasedCollator rbc = (RuleBasedCollator)Collator.getInstance((Locale)this.m_locale);
        ICUCollator.setDecomposition(rbc, declaration2.getDecompositionType());
        ICUCollator.setStrength(rbc, declaration2.getStrengthType());
        rbc = ICUCollator.setRules(rbc, declaration2.getRules(), this.m_messages);
        ICUCollator.setCaseOrder(rbc, declaration2.getCaseOrderType());
        this.m_collator = rbc;
        this.m_search = new StringSearch("pat", (CharacterIterator)new StringCharacterIterator("t"), this.m_collator);
    }

    @Override
    public Object getCollationKey(String str) {
        return this.m_collator.getCollationKey(str);
    }

    @Override
    public int compareCollationKeys(Object o1, Object o2) {
        int comp2 = 0;
        comp2 = o1 instanceof CollationKey && o2 instanceof CollationKey ? ((CollationKey)o1).compareTo((CollationKey)o2) : this.m_collator.compare((String)o1, (String)o2);
        return ICUCollator.formatCompareReturn(comp2);
    }

    @Override
    public int compare(String str1, String str2) {
        int comp2 = this.m_collator.compare(str1, str2);
        return comp2;
    }

    private static final RuleBasedCollator setRules(RuleBasedCollator rbc, String extraRules, Stack messages) {
        if (extraRules != null) {
            String oldRules = rbc.getRules();
            try {
                rbc = new RuleBasedCollator(oldRules + extraRules);
            }
            catch (Exception e) {
                String strMsg = Messages.createMessage("INVALID_ATTR_VALUE_IGNORED", new Object[]{"rules", extraRules});
                Messages.Message ms = new Messages.Message(strMsg, 3);
                messages.push(ms);
            }
        }
        return rbc;
    }

    private static void setDecomposition(RuleBasedCollator rbc, ParamDecomposition decomposition) {
        if (decomposition != null) {
            int dc = decomposition == ParamDecomposition.NO ? 16 : (decomposition == ParamDecomposition.CANONICAL ? 17 : (decomposition == ParamDecomposition.FULL ? 17 : 17));
            rbc.setDecomposition(dc);
        }
    }

    private static void setStrength(RuleBasedCollator rbc, ParamStrength strength) {
        if (strength != null) {
            int srtng = -1;
            if (strength == ParamStrength.PRIMARY) {
                srtng = 0;
            } else if (strength == ParamStrength.SECONDARY) {
                srtng = 1;
            } else if (strength == ParamStrength.TERTIARY) {
                srtng = 2;
            } else if (strength == ParamStrength.IDENTICAL) {
                srtng = 15;
            }
            rbc.setStrength(srtng);
        }
    }

    private static void setCaseOrder(RuleBasedCollator rbc, ParamCaseOrder caseOrder) {
        if (caseOrder == null) {
            return;
        }
        if (caseOrder == ParamCaseOrder.UPPER_FIRST) {
            rbc.setUpperCaseFirst(true);
        } else if (caseOrder == ParamCaseOrder.LOWER_FIRST) {
            rbc.setLowerCaseFirst(true);
        }
    }

    @Override
    Range[] allOccurances(String text2, String pattern2) {
        StringCharacterIterator target = new StringCharacterIterator(text2);
        ((StringSearch)this.m_search).setPattern(pattern2);
        this.m_search.setTarget((CharacterIterator)target);
        this.m_search.setOverlapping(true);
        Vector<Range> matches2 = null;
        int length2 = -1;
        int startOffset = this.m_search.first();
        while (startOffset != -1) {
            length2 = this.m_search.getMatchLength();
            if (length2 > 0) {
                if (matches2 == null) {
                    matches2 = new Vector<Range>();
                }
                matches2.add(new Range(startOffset, startOffset + length2));
            }
            startOffset = this.m_search.next();
        }
        Range[] ret = matches2 == null ? null : ICUCollator.convertFromVector(matches2);
        return ret;
    }

    @Override
    Range firstOccurance(String text2, String pattern2) {
        Range first = null;
        StringCharacterIterator target = new StringCharacterIterator(text2);
        ((StringSearch)this.m_search).setPattern(pattern2);
        this.m_search.setTarget((CharacterIterator)target);
        this.m_search.setOverlapping(true);
        int length2 = -1;
        int startOffset = this.m_search.first();
        while (startOffset != -1) {
            length2 = this.m_search.getMatchLength();
            if (length2 > 0) {
                first = new Range(startOffset, startOffset + length2);
                break;
            }
            startOffset = this.m_search.next();
        }
        return first;
    }

    @Override
    Range lastOccurance(String text2, String pattern2) {
        Range last2 = null;
        StringCharacterIterator target = new StringCharacterIterator(text2);
        ((StringSearch)this.m_search).setPattern(pattern2);
        this.m_search.setTarget((CharacterIterator)target);
        this.m_search.setOverlapping(true);
        int length2 = -1;
        int startOffset = this.m_search.first();
        while (startOffset != -1) {
            length2 = this.m_search.getMatchLength();
            if (length2 > 0) {
                last2 = new Range(startOffset, startOffset + length2);
            }
            startOffset = this.m_search.next();
        }
        return last2;
    }

    static Locale getLocaleSupported(String lang2) {
        Locale loc = LocaleUtility.stringToLocale(lang2, s_Locales, s_LocaleNames);
        return loc;
    }

    static {
        for (int i = 0; i < s_Locales.length; ++i) {
            s_LocaleNames.add(s_Locales[i].toString());
        }
    }
}

