/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorBasedStringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamStrength;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Locale;

final class JavaCollator
extends CollatorImplBase {
    private static final Locale[] s_Locales = RuleBasedCollator.getAvailableLocales();
    private static final ArrayList s_LocaleNames = new ArrayList();
    private final RuleBasedCollator m_collator;
    private final CollatorBasedStringSearcher m_search;
    private final JavaCollator m_helperTertiaryCanonical;
    private final JavaCollator m_helperSecondary;
    private static final boolean old_code = false;

    JavaCollator(CollatorDeclarationImpl decl) {
        super(decl, LocaleUtility.IETFToValidLocale(decl.getLanguage(), s_Locales, s_LocaleNames));
        RuleBasedCollator rbc = (RuleBasedCollator)Collator.getInstance(this.m_locale);
        rbc = this.setRules(rbc, decl.getRules());
        JavaCollator.setDecomposition(rbc, decl.getDecompositionType());
        this.m_collator = rbc;
        this.m_search = new CollatorBasedStringSearcher(rbc, null);
        this.setStrength(decl.getStrengthType());
        this.m_helperTertiaryCanonical = this.getHelperTertiaryCanonical(this.m_declaration, this.m_locale);
        this.m_helperSecondary = this.getHelperSecondary(this.m_declaration, this.m_locale);
    }

    private JavaCollator(CollatorDeclarationImpl decl, Locale loc) {
        super(decl, loc);
        RuleBasedCollator rbc = (RuleBasedCollator)Collator.getInstance(this.m_locale);
        rbc = this.setRules(rbc, decl.getRules());
        JavaCollator.setDecomposition(rbc, decl.getDecompositionType());
        this.m_collator = rbc;
        this.m_search = new CollatorBasedStringSearcher(rbc, null);
        this.setStrength(decl.getStrengthType());
        this.m_helperSecondary = null;
        this.m_helperTertiaryCanonical = null;
    }

    @Override
    public Object getCollationKey(String str) {
        return this.m_collator.getCollationKey(str);
    }

    private final int defaultCaseCompare(Object o1, Object o2) {
        int comp2 = 0;
        comp2 = o1 instanceof CollationKey && o2 instanceof CollationKey ? ((CollationKey)o1).compareTo((CollationKey)o2) : this.m_collator.compare((String)o1, (String)o2);
        return JavaCollator.formatCompareReturn(comp2);
    }

    @Override
    public int compareCollationKeys(Object o1, Object o2) {
        ParamCaseOrder caseOrder = this.m_declaration.getCaseOrderType();
        int savedStrength = this.m_collator.getStrength();
        if (caseOrder == ParamCaseOrder.NOT_SPECIFIED) {
            return this.defaultCaseCompare(o1, o2);
        }
        String text2 = null;
        String pattern2 = null;
        if (o1 instanceof CollationKey && o2 instanceof CollationKey) {
            text2 = ((CollationKey)o1).getSourceString();
            pattern2 = ((CollationKey)o2).getSourceString();
        } else {
            text2 = (String)o1;
            pattern2 = (String)o2;
        }
        int comp2 = 0;
        comp2 = savedStrength == 0 || savedStrength == 1 ? this.defaultCaseCompare(o1, o2) : this.m_helperSecondary.defaultCaseCompare(text2, pattern2);
        if (comp2 != 0) {
            return comp2;
        }
        comp2 = this.getCaseDiff(text2, pattern2);
        if (comp2 != 0) {
            return comp2;
        }
        return this.defaultCaseCompare(o1, o2);
    }

    @Override
    public int compare(String str1, String str2) {
        return this.compareCollationKeys(str1, str2);
    }

    private final int getCaseDiff(String text1, String text2) {
        ParamCaseOrder[] diff = this.m_helperTertiaryCanonical.m_search.getFirstCaseDiff(text1, text2, this.m_locale);
        if (diff != null) {
            if (this.m_declaration.getCaseOrderType() == ParamCaseOrder.UPPER_FIRST) {
                if (diff[0] == ParamCaseOrder.UPPER_FIRST) {
                    return -1;
                }
                return 1;
            }
            if (diff[0] == ParamCaseOrder.LOWER_FIRST) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private final RuleBasedCollator setRules(RuleBasedCollator rbc, String extraRules) {
        if (extraRules != null && 0 < extraRules.length()) {
            String oldRules = rbc.getRules();
            try {
                rbc = new RuleBasedCollator(oldRules + extraRules);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return rbc;
    }

    private static void setDecomposition(RuleBasedCollator collator2, ParamDecomposition decomposition) {
        if (decomposition != ParamDecomposition.NOT_SPECIFIED) {
            int i = decomposition == ParamDecomposition.NO ? 0 : (decomposition == ParamDecomposition.CANONICAL ? 1 : (decomposition == ParamDecomposition.FULL ? 2 : 0));
            collator2.setDecomposition(i);
        }
    }

    private void setStrength(ParamStrength strength) {
        if (strength != null) {
            int i = strength == ParamStrength.PRIMARY ? 0 : (strength == ParamStrength.SECONDARY ? 1 : (strength == ParamStrength.TERTIARY ? 2 : (strength == ParamStrength.IDENTICAL ? 3 : 2)));
            this.setStrength(i);
        }
    }

    private void setStrength(int i) {
        this.m_collator.setStrength(i);
        this.m_search.resetMaskStrength();
    }

    private JavaCollator getHelperTertiaryCanonical(CollatorDeclarationImpl decl, Locale loc) {
        JavaCollator ret;
        if (decl.getStrengthType() == ParamStrength.TERTIARY && decl.getDecompositionType() == ParamDecomposition.CANONICAL) {
            ret = this;
        } else {
            CollatorDeclarationImpl decl2 = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(decl.getName() + "/?strength=tertiary?decomposition=primary", decl.getLanguage(), ParamDecomposition.CANONICAL.getValue(), ParamStrength.TERTIARY.getValue(), decl.getRules(), decl.getCaseOrderType().getValue(), this.getClass().getName());
            ret = new JavaCollator(decl2, loc);
        }
        return ret;
    }

    private JavaCollator getHelperSecondary(CollatorDeclarationImpl decl, Locale loc) {
        JavaCollator ret;
        ParamStrength parentStrength = decl.getStrengthType();
        if (parentStrength == ParamStrength.PRIMARY || parentStrength == ParamStrength.SECONDARY) {
            ret = this;
        } else {
            CollatorDeclarationImpl decl2 = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(decl.getName() + "/?strength=primary", decl.getLanguage(), decl.getDecompositionType().getValue(), ParamStrength.SECONDARY.getValue(), decl.getRules(), decl.getCaseOrderType().getValue(), this.getClass().getName());
            ret = new JavaCollator(decl2, loc);
        }
        return ret;
    }

    @Override
    Range[] allOccurances(String text2, String sub2) {
        return this.m_search.allOccurances(text2, sub2);
    }

    @Override
    Range firstOccurance(String text2, String sub2) {
        return this.m_search.firstOccurance(text2, sub2);
    }

    @Override
    Range lastOccurance(String text2, String sub2) {
        return this.m_search.lastOccurance(text2, sub2);
    }

    static Locale getLocaleSupported(String lang2) {
        Locale loc = LocaleUtility.IETFToValidLocale(lang2, s_Locales, s_LocaleNames);
        return loc;
    }

    static {
        for (int i = 0; i < s_Locales.length; ++i) {
            s_LocaleNames.add(s_Locales[i].toString());
        }
    }
}

