/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public final class LocaleUtility {
    private static final char IETF_SEPARATOR = '-';
    private static final char LOCALE_SEPARATOR = '_';
    private static final String EMPTY_STRING = "";
    private static final Hashtable<String, Locale> sLocales = new Hashtable();

    private static final String IETFToLocaleLang(String IETFlang) {
        return IETFlang != null ? IETFlang.replace('-', '_') : null;
    }

    public static final Locale getLocaleForLang(String ietfLang) {
        String localeStyleName = LocaleUtility.IETFToLocaleLang(ietfLang);
        Locale locale = sLocales.get(localeStyleName);
        if (locale == null) {
            String[] parts = LocaleUtility.splitLangName(localeStyleName, '-');
            locale = parts[1].equals(EMPTY_STRING) ? new Locale(parts[0]) : (parts[2].equals(EMPTY_STRING) ? new Locale(parts[0], parts[1]) : new Locale(parts[0], parts[1], parts[2]));
            sLocales.put(localeStyleName, locale);
        }
        return locale;
    }

    public static final Locale IETFToValidLocale(String IETFLang, Locale[] locales, ArrayList names) {
        if (locales == null) {
            return null;
        }
        if (IETFLang == null) {
            return Locale.getDefault();
        }
        if (!LocaleUtility.isIETFLangValid(IETFLang)) {
            return Locale.getDefault();
        }
        String outLang = LocaleUtility.IETFToLocaleLang(IETFLang);
        Locale locale = LocaleUtility.stringToLocale(outLang, locales, names);
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    static final Locale stringToLocale(String localeLang, Locale[] locales, ArrayList names) {
        if (locales == null) {
            return null;
        }
        String outLang = localeLang;
        int index2 = -1;
        index2 = names.indexOf(outLang);
        if (index2 > -1) {
            return locales[index2];
        }
        String[] splitedLang = LocaleUtility.splitLangName(outLang, '_');
        String lang2 = splitedLang[0];
        String country = splitedLang[1];
        String variant = splitedLang[2];
        if (variant.length() != 0 && (index2 = names.indexOf(outLang = country.length() != 0 ? lang2 + '_' + country : lang2)) > -1) {
            return locales[index2];
        }
        if (country.length() != 0 && (index2 = names.indexOf(outLang = variant.length() != 0 ? lang2 + '_' + variant : lang2)) > -1) {
            return locales[index2];
        }
        outLang = lang2;
        index2 = names.indexOf(outLang);
        if (index2 > -1) {
            return locales[index2];
        }
        return null;
    }

    static boolean isIETFLangValid(String IETFlang) {
        int length2 = IETFlang.length();
        if (length2 == 0) {
            return false;
        }
        if (IETFlang.charAt(0) == '-') {
            return false;
        }
        for (int count2 = 0; count2 < length2; ++count2) {
            if (!Character.isWhitespace(IETFlang.charAt(count2))) continue;
            return false;
        }
        return true;
    }

    static String[] splitLangName(String name2, char separator) {
        String language = EMPTY_STRING;
        String country = EMPTY_STRING;
        String variant = EMPTY_STRING;
        int i1 = name2.indexOf(separator);
        if (i1 < 0) {
            language = name2;
        } else {
            int i2;
            language = name2.substring(0, i1);
            if ((i2 = name2.indexOf(separator, ++i1)) < 0) {
                country = name2.substring(i1);
            } else {
                country = name2.substring(i1, i2);
                variant = name2.substring(i2 + 1);
            }
        }
        language = language.length() == 2 ? language.toLowerCase() : EMPTY_STRING;
        country = country.length() == 2 ? country.toUpperCase() : EMPTY_STRING;
        variant = variant.length() > 0 && (language.length() == 2 || country.length() == 2) ? variant.toUpperCase() : EMPTY_STRING;
        String[] SVLang = new String[]{language, country, variant};
        return SVLang;
    }

    static int compareLangCountryVariant(String s1, String s2) {
        int retCode;
        if (s1 == null || s1.length() == 0 || s2 == null || s2.length() == 0) {
            retCode = 4;
        } else {
            String variant2;
            String variant1;
            String country2;
            String country1;
            String[] lcv2;
            String lang2;
            s1 = LocaleUtility.IETFToLocaleLang(s1);
            s2 = LocaleUtility.IETFToLocaleLang(s2);
            String[] lcv1 = LocaleUtility.splitLangName(s1, '_');
            String lang1 = lcv1[0];
            retCode = !lang1.equals(lang2 = (lcv2 = LocaleUtility.splitLangName(s2, '_'))[0]) ? 3 : (!(country1 = lcv1[1]).equals(country2 = lcv2[1]) ? 2 : (!(variant1 = lcv1[2]).equals(variant2 = lcv2[2]) ? 1 : 0));
        }
        return retCode;
    }

    static {
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length; ++i) {
            sLocales.put(availableLocales[i].toString(), availableLocales[i]);
        }
    }
}

