/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorBasedStringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.StringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.UnimplementedStringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.RuleBasedCollator;

public class XCollatorJavaCollatorProxy
implements XCollator {
    private Collator fWrappedCollator;
    private Collator fSecondaryStrengthCollator;
    private static final String EMPTY_STRING = "";
    private StringSearcher fSearcher;
    private XCollator.CaseOrder fCaseOrder;

    public XCollatorJavaCollatorProxy(Collator collator2, XCollator.CaseOrder caseOrder) {
        Collator secondaryStrengthCollator = null;
        if (caseOrder != XCollator.CaseOrder.DEFAULT && collator2.getStrength() == 2) {
            secondaryStrengthCollator = (Collator)collator2.clone();
            secondaryStrengthCollator.setStrength(1);
            this.fSecondaryStrengthCollator = secondaryStrengthCollator;
        }
        this.fWrappedCollator = collator2;
        this.fCaseOrder = caseOrder;
        this.fSearcher = collator2 instanceof RuleBasedCollator ? new CollatorBasedStringSearcher((RuleBasedCollator)collator2, (RuleBasedCollator)secondaryStrengthCollator) : new UnimplementedStringSearcher();
    }

    @Override
    public int compare(String str1, String str2) {
        int comparison2 = this.fWrappedCollator.compare(str1, str2);
        switch (this.fCaseOrder) {
            case UPPER_FIRST: 
            case LOWER_FIRST: {
                comparison2 = this.filterComparisonWithCaseOrder(str1, str2, comparison2);
                break;
            }
        }
        return comparison2;
    }

    private int filterComparisonWithCaseOrder(String str1, String str2, int unfilterdComparison) {
        return this.fSearcher.filterComparisonWithCaseOrder(str1, str2, this.fCaseOrder, unfilterdComparison);
    }

    @Override
    public int compareCollationKeys(Object o1, Object o2) {
        CollationKey key1 = (CollationKey)o1;
        CollationKey key2 = (CollationKey)o2;
        int comparison2 = key1.compareTo(key2);
        switch (this.fCaseOrder) {
            case UPPER_FIRST: 
            case LOWER_FIRST: {
                comparison2 = this.filterComparisonWithCaseOrder(key1.getSourceString(), key2.getSourceString(), comparison2);
                break;
            }
        }
        return comparison2;
    }

    @Override
    public boolean contains(String text2, String sub2) {
        if (sub2.equals(EMPTY_STRING)) {
            return true;
        }
        if (text2.equals(EMPTY_STRING)) {
            return false;
        }
        return this.firstOccurance(text2, sub2) != null;
    }

    @Override
    public boolean endsWith(String text2, String endPart) {
        if (endPart.equals(EMPTY_STRING)) {
            return true;
        }
        if (text2.equals(EMPTY_STRING)) {
            return true;
        }
        Range lastMatch = this.lastOccurance(text2, endPart);
        return lastMatch != null && lastMatch.m_endOffset == text2.length();
    }

    @Override
    public Object getCollationKey(String str) {
        return this.fWrappedCollator.getCollationKey(str);
    }

    @Override
    public boolean startsWith(String text2, String firstPart) {
        if (firstPart.equals(EMPTY_STRING)) {
            return true;
        }
        if (text2.equals(EMPTY_STRING)) {
            return false;
        }
        Range firstMatch = this.firstOccurance(text2, firstPart);
        return firstMatch != null && firstMatch.m_startOffset == 0;
    }

    Range firstOccurance(String text2, String sub2) {
        return this.fSearcher.firstOccurance(text2, sub2);
    }

    Range lastOccurance(String text2, String sub2) {
        return this.fSearcher.lastOccurance(text2, sub2);
    }

    @Override
    public String substringAfter(String text2, String sub2) {
        Range firstMatch;
        String after2 = sub2.equals(EMPTY_STRING) ? text2 : (text2.equals(EMPTY_STRING) ? EMPTY_STRING : ((firstMatch = this.firstOccurance(text2, sub2)) == null ? EMPTY_STRING : text2.substring(firstMatch.m_endOffset)));
        return after2;
    }

    @Override
    public String substringBefore(String text2, String sub2) {
        Range firstMatch;
        String before2 = sub2.equals(EMPTY_STRING) ? EMPTY_STRING : (text2.equals(EMPTY_STRING) ? EMPTY_STRING : ((firstMatch = this.firstOccurance(text2, sub2)) == null ? EMPTY_STRING : text2.substring(0, firstMatch.m_startOffset)));
        return before2;
    }
}

