/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandlerProvider;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarLinker;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.cmdline.utils.PrettyXylemListing;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.StandardOptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionOperatorTable;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.SimpleFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XPath2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.XPath2TypeChecker;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.QNameInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.DynamicVariableBuilder;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.File;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

public class XPathCompiler
extends XStarCompiler
implements ErrorHandlerProvider {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathCompiler.class);
    private static final String s_className = XPathCompiler.class.getName();
    public static final String XPATH_MAIN = "__xpath_main__";
    public static final String XPATH_FUNCTION = "__xpath_function__";
    public static final String XPATH_MODULE = "XPathModule";
    protected XSLTParser _parser;
    private int _nextGType = 14;
    private ArrayList<String> _namesIndex;
    private Hashtable<String, Integer> _elements;
    private Hashtable<String, Integer> _attributes;
    private Hashtable<String, Integer> _namespaceDecls;
    private int _nextNSType;
    private ArrayList<String> _namespaceIndex;
    private Hashtable<String, Integer> _namespaces;
    private int _stepPatternSerial = 1;
    private boolean _staticTyping = false;
    private String _xpathVersion = "2.0";
    private boolean _hasIdCall = false;
    private boolean _callsNodeset = false;
    private static final int SIMPLE = 0;
    private static final int POLYMORPHIC = 1;
    private static final int OPERATOR = 2;
    private static final int XTQHP = 3;
    private static final int BUILT_IN = 4;
    protected FunctionOperatorTable funcTable = FunctionOperatorTable.getInstance();
    private final String[] OPERATOR_NAMES = new String[]{"add", "subtract", "multiply", "div", "idiv", "mod", "eq", "ne", "gt", "lt", "ge", "le", "unary-minus", "unary-plus", "g_eq", "g_ne", "g_gt", "g_lt", "g_ge", "g_le", "is", "<<", ">>", "union", "intersect", "except"};
    private final Hashtable<FunctionKey, FunctionDeclaration> _functions = new Hashtable();
    private final PolymorphicFunctionDeclaration[] _operators = new PolymorphicFunctionDeclaration[26];
    protected Module _rtlibModule;
    protected ModuleSignature _rtlibSignature;
    private boolean _inGlobal = false;

    public XPathCompiler(String xpathVersion, XSLTParser parser) {
        super(xpathVersion);
        this._xpathVersion = xpathVersion;
        this._parser = parser;
        this.initCompiler(TypeRegistry.newTypeRegistry());
    }

    protected void initCompiler(TypeRegistry tr) {
        this._parser.init();
        this.initFunctionAndOperatorDeclarations();
        this._nextGType = 14;
        this._namesIndex = new ArrayList(128);
        this._elements = new Hashtable();
        this._attributes = new Hashtable();
        this._namespaceDecls = new Hashtable();
        this._namespaces = new Hashtable();
        this._namespaces.put("", new Integer(this._nextNSType));
        this._namespaceIndex = new ArrayList(32);
        this._stepPatternSerial = 1;
        this._hasIdCall = false;
        this._callsNodeset = false;
    }

    @Override
    public void reset() {
        super.reset();
        this._parser.reset();
        this._nextGType = 14;
        this._namesIndex.clear();
        this._elements.clear();
        this._attributes.clear();
        this._namespaceDecls.clear();
        this._namespaces.clear();
        this._namespaces.put("", new Integer(this._nextNSType));
        this._namespaceIndex.clear();
        this._stepPatternSerial = 1;
        this._hasIdCall = false;
        this._callsNodeset = false;
    }

    public int registerAttribute(QName name2) {
        Integer code = this._attributes.get(name2.toString());
        if (code == null) {
            code = new Integer(this._nextGType++);
            this._attributes.put(name2.toString(), code);
            String uri2 = name2.getNamespaceURI();
            String local2 = "@" + name2.getLocalPart();
            if (uri2 != null && !uri2.equals("")) {
                this._namesIndex.add(uri2 + ":" + local2);
            } else {
                this._namesIndex.add(local2);
            }
            if (name2.getLocalPart().equals("*")) {
                this.registerNamespace(name2.getNamespaceURI());
            }
        }
        return code;
    }

    public Hashtable<String, Integer> getAttributes() {
        return this._attributes;
    }

    public int registerElement(QName name2) {
        Integer code = this._elements.get(name2.toString());
        if (code == null) {
            code = new Integer(this._nextGType++);
            this._elements.put(name2.toString(), code);
            String uri2 = name2.getNamespaceURI();
            String local2 = name2.getLocalPart();
            if (uri2 != null && !uri2.equals("")) {
                this._namesIndex.add(uri2 + ":" + local2);
            } else {
                this._namesIndex.add(local2);
            }
        }
        if (name2.getLocalPart().equals("*")) {
            this.registerNamespace(name2.getNamespaceURI());
        }
        return code;
    }

    public int registerNamespaceDecl(QName name2) {
        Integer code = this._namespaceDecls.get(name2.toString());
        if (code == null) {
            code = new Integer(this._nextGType++);
            this._namespaceDecls.put(name2.toString(), code);
            String uri2 = name2.getNamespaceURI();
            String local2 = "%" + name2.getLocalPart();
            if (uri2 != null && !uri2.equals("")) {
                this._namesIndex.add(uri2 + ":" + local2);
            } else {
                this._namesIndex.add(local2);
            }
            if (name2.getLocalPart().equals("*")) {
                this.registerNamespace(name2.getNamespaceURI());
            }
        }
        return code;
    }

    public int registerNamespace(String namespaceURI) {
        Integer code = this._namespaces.get(namespaceURI);
        if (code == null) {
            code = new Integer(this._nextNSType++);
            this._namespaces.put(namespaceURI, code);
            this._namespaceIndex.add(namespaceURI);
        }
        return code;
    }

    public List<String> getNamesIndex() {
        return this._namesIndex;
    }

    public List<String> getNamespaceIndex() {
        return this._namespaceIndex;
    }

    private void initFunctionAndOperatorDeclarations() {
        boolean in_usewhen = this.getStaticContext().getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when");
        if (in_usewhen) {
            this.initSimpleFunctionDeclarations(true);
        } else {
            this.initSimpleFunctionDeclarations(false);
            this.initXtqhpFunctionDeclarations();
            this.initBuiltInExtensionFunctionDeclarations();
        }
        this.initPolymorphicFunctionDeclarations();
        this.initOperatorDeclarations();
    }

    private void initSimpleFunctionDeclarations(boolean inUseWhen) {
        int numFunctions = this.funcTable.getSimpleFunctionLength();
        if (inUseWhen) {
            numFunctions -= 22;
        }
        for (int i = 0; i < numFunctions; ++i) {
            SimpleFunctionDeclaration functionEntry = this.createFunctionDeclaration(i, 0, 0);
            int arity = this.funcTable.getSimpleFunctionDeclLength(i) - 3;
            FunctionKey functionKey = new FunctionKey(new QName("http://www.w3.org/2005/xpath-functions", this.funcTable.getSimpleFunctionName(i), "fn"), arity);
            this._functions.put(functionKey, functionEntry);
        }
    }

    private void initPolymorphicFunctionDeclarations() {
        int numFunctions = this.funcTable.getPolymorphicFunctionLength();
        for (int i = 0; i < numFunctions; ++i) {
            int arity;
            SimpleFunctionDeclaration functionEntry = this.createFunctionDeclaration(i, 0, 1);
            String functionName = this.funcTable.getPolymorphicFunctionName(i);
            FunctionKey functionKey = new FunctionKey(new QName("http://www.w3.org/2005/xpath-functions", functionName, "fn"), arity = this.funcTable.getPolymorphicFunctionDeclLength(i) - 4);
            FunctionDeclaration availableFunction = this._functions.get(functionKey);
            if (availableFunction == null) {
                PolymorphicFunctionDeclaration polyfunc = new PolymorphicFunctionDeclaration(functionName, arity, functionEntry);
                this._functions.put(functionKey, polyfunc);
                continue;
            }
            if (!(availableFunction instanceof PolymorphicFunctionDeclaration)) continue;
            ((PolymorphicFunctionDeclaration)availableFunction).addDeclarationEntry(functionEntry);
        }
    }

    private void initXtqhpFunctionDeclarations() {
        int numFunctions = this.funcTable.getXtqhpFunctionLength();
        for (int i = 0; i < numFunctions; ++i) {
            SimpleFunctionDeclaration functionEntry = this.createFunctionDeclaration(i, 0, 3);
            int arity = this.funcTable.getXtqhpFunctionDeclLength(i) - 3;
            FunctionKey functionKey = new FunctionKey(new QName("http://xtqhp", this.funcTable.getXtqhpFunctionName(i)), arity);
            this._functions.put(functionKey, functionEntry);
        }
    }

    private void initBuiltInExtensionFunctionDeclarations() {
        int numFunctions = this.funcTable.getBuiltInExtensionFunctionLength();
        for (int i = 0; i < numFunctions; ++i) {
            SimpleFunctionDeclaration functionEntry = this.createFunctionDeclaration(i, 0, 4);
            int arity = this.funcTable.getBuiltInExtensionFunctionDeclLength(i) - 4;
            FunctionKey functionKey = new FunctionKey(new QName(this.funcTable.getBuiltInExtensionFunctionNamespace(i), this.funcTable.getBuiltInExtensionFunctionName(i)), arity);
            this._functions.put(functionKey, functionEntry);
        }
    }

    private void initOperatorDeclaration(int operatorIndex) {
        int numFunctions = this.funcTable.getOperatorItemLength(operatorIndex);
        String operatorName = this.OPERATOR_NAMES[operatorIndex];
        int arity = 0;
        if (numFunctions > 0) {
            arity = this.funcTable.getOperatorDeclLength(operatorIndex, 0) - 4;
        }
        PolymorphicFunctionDeclaration polyfunc = new PolymorphicFunctionDeclaration(operatorName, arity);
        for (int i = 0; i < numFunctions; ++i) {
            SimpleFunctionDeclaration simpleEntry = this.createFunctionDeclaration(i, operatorIndex, 2);
            polyfunc.addDeclarationEntry(simpleEntry);
        }
        this._operators[operatorIndex] = polyfunc;
    }

    private void initOperatorDeclarations() {
        int numOperators = this.funcTable.getOperatorLength();
        for (int i = 0; i < numOperators; ++i) {
            this.initOperatorDeclaration(i);
        }
    }

    private SimpleFunctionDeclaration createFunctionDeclaration(int i, int item2, int category) {
        String methodName;
        XSequenceType returnType;
        int flag;
        XSequenceType[] argumentTypes;
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            argumentTypes = null;
                            if (category != 1) break block7;
                            String functionName = this.funcTable.getPolymorphicFunctionName(i);
                            int arity = this.funcTable.getPolymorphicFunctionDeclLength(i) - 4;
                            flag = this.funcTable.getPolymorphicFunctionFlag(i);
                            returnType = this.funcTable.getPolymorphicFunctionReturnType(i);
                            methodName = this.funcTable.getPolymorphicFunctionName_Real(i);
                            if (methodName == null) {
                                methodName = functionName;
                            }
                            if (arity <= 0) break block8;
                            argumentTypes = new XSequenceType[arity];
                            int start = 4;
                            for (int arg2 = 0; arg2 < arity; ++arg2) {
                                argumentTypes[arg2] = this.funcTable.getPolymorphicFunctionArgType(i, start + arg2);
                            }
                            break block8;
                        }
                        if (category != 2) break block9;
                        String functionName = this.funcTable.getOperatorName(item2, i);
                        int arity = this.funcTable.getOperatorDeclLength(item2, i) - 4;
                        flag = this.funcTable.getOperatorFlag(item2, i);
                        returnType = this.funcTable.getOperatorReturnType(item2, i);
                        methodName = functionName;
                        if (arity <= 0) break block8;
                        argumentTypes = new XSequenceType[arity];
                        int start = 4;
                        for (int arg3 = 0; arg3 < arity; ++arg3) {
                            argumentTypes[arg3] = this.funcTable.getOperatorArgType(item2, i, start + arg3);
                        }
                        break block8;
                    }
                    if (category != 0) break block10;
                    String functionName = this.funcTable.getSimpleFunctionName(i);
                    int arity = this.funcTable.getSimpleFunctionDeclLength(i) - 3;
                    flag = this.funcTable.getSimpleFunctionFlag(i);
                    returnType = this.funcTable.getSimpleFunctionReturnType(i);
                    methodName = functionName;
                    if (arity <= 0) break block8;
                    argumentTypes = new XSequenceType[arity];
                    int start = 3;
                    for (int arg4 = 0; arg4 < arity; ++arg4) {
                        argumentTypes[arg4] = this.funcTable.getSimpleFunctionArgType(i, start + arg4);
                    }
                    break block8;
                }
                if (category != 4) break block11;
                String functionName = this.funcTable.getBuiltInExtensionFunctionName(i);
                int arity = this.funcTable.getBuiltInExtensionFunctionDeclLength(i) - 4;
                flag = this.funcTable.getBuiltInExtensionFunctionFlag(i);
                returnType = this.funcTable.getBuiltInExtensionFunctionReturnType(i);
                methodName = functionName;
                if (arity <= 0) break block8;
                argumentTypes = new XSequenceType[arity];
                int start = 4;
                for (int arg5 = 0; arg5 < arity; ++arg5) {
                    argumentTypes[arg5] = this.funcTable.getBuiltInExtensionFunctionArgType(i, start + arg5);
                }
                break block8;
            }
            String functionName = this.funcTable.getXtqhpFunctionName(i);
            int arity = this.funcTable.getXtqhpFunctionDeclLength(i) - 3;
            flag = this.funcTable.getXtqhpFunctionFlag(i);
            returnType = this.funcTable.getXtqhpFunctionReturnType(i);
            methodName = functionName;
            if (arity > 0) {
                argumentTypes = new XSequenceType[arity];
                int start = 3;
                for (int arg6 = 0; arg6 < arity; ++arg6) {
                    argumentTypes[arg6] = this.funcTable.getXtqhpFunctionArgType(i, start + arg6);
                }
            }
        }
        return new SimpleFunctionDeclaration(methodName, returnType, argumentTypes, flag);
    }

    public FunctionDeclaration getFunctionDeclarationFromSignature(QName functionName, int arity) {
        return this._functions.get(new FunctionKey(functionName, arity));
    }

    public PolymorphicFunctionDeclaration getOperatorDeclaration(int operatorIndex) {
        return this._operators[operatorIndex];
    }

    public String getXPathVersion() {
        return this._xpathVersion;
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void setStaticTyping(boolean flag) {
        this._staticTyping = flag;
    }

    public boolean isStaticTyping() {
        return this._staticTyping;
    }

    public void setHasIdCall(boolean flag) {
        this._hasIdCall = flag;
    }

    public boolean hasIdCall() {
        return this._hasIdCall;
    }

    @Override
    public void setDebug(boolean debug) {
        super.setDebug(debug);
        this._parser.setDebug(debug);
    }

    public void setCallsNodeset(boolean flag) {
        this._callsNodeset = flag;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void setInGlobal(boolean flag) {
        this._inGlobal = flag;
    }

    public boolean isInGlobal() {
        return this._inGlobal;
    }

    public int nextStepPatternSerial() {
        return this._stepPatternSerial++;
    }

    @Override
    public Module getRuntimeLibrary() {
        return this._rtlibModule;
    }

    public ModuleSignature getRuntimeLibrarySignature() {
        if (this._rtlibModule != null) {
            return this._rtlibModule.m_signature;
        }
        return this._rtlibSignature;
    }

    @Override
    public void setRuntimeLibrary(Module lib) {
        this._rtlibModule = lib;
    }

    public void setRuntimeSignature(ModuleSignature sig) {
        this._rtlibSignature = sig;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        super.setErrorHandler(handler);
        this._parser.setErrorHandler(handler);
    }

    public SourceLocation createSourceLocation(Expr node2) {
        return null;
    }

    public void setSecureProcessing(boolean value2) {
        this._parser.setSecureProcessing(value2);
    }

    public XTQStaticContext getStaticContext() {
        return (XTQStaticContext)this._parser.getStaticContext();
    }

    public boolean compile(String expression2, SessionContext session) {
        try {
            this.setRuntimeLibrary(this.loadRuntimeLibrary());
            Expr expr = this.buildAST(expression2);
            this.setStarletModule(this._xpathVersion.equals("2.0") ? this.translate(expr) : this.translate10(expr));
            if (StandardOptimizationRegimen.DumpOption.LISTING.isEnabled()) {
                Module module = this.getStarletModule();
                if (!this.useMixedMode()) {
                    PrettyXylemListing.MakeListing(module.getName(), new Module[]{module, this.getRuntimeLibrary()});
                } else {
                    PrettyXylemListing.MakeListing(module.getName(), new Module[]{module});
                }
            }
            if (this.getDoPostASTProcessing()) {
                // empty if block
            }
            if (!this.isInterpreted()) {
                this.getStarletModule().reduce();
                ModuleSignature ms = new ModuleSignature("");
                Program program = new Program(ms);
                program.addModule(this.getStarletModule());
                program.addModule(this.getRuntimeLibrary());
                this.linkAndCodeGen(program, this.getRuntimeLibrary(), this.getStarletModule(), session);
            }
        }
        catch (WrappedRuntimeException wre) {
            this._parser.reportError(2, new ErrorMsg(wre), (Throwable)wre.getException());
        }
        catch (HandledRuntimeException e) {
            throw e;
        }
        catch (StaticError e) {
            ErrorMsg msg = e.getErrorMsg();
            if (msg == null) {
                msg = new ErrorMsg(e, e.getNode());
            }
            this._parser.reportError(2, msg, e.getException());
        }
        catch (Exception e) {
            this._parser.reportError(2, new ErrorMsg(e), (Throwable)e);
        }
        catch (Error e) {
            e.printStackTrace();
            this._parser.reportError(2, new ErrorMsg(e), (Throwable)e);
        }
        return !this._parser.errorsFound();
    }

    public Expr buildAST(String expression2) throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Started building AST");
        }
        Expr expr = this._parser.parseExpression(expression2);
        String baseURI = this._parser.getStaticContext().getBaseURI();
        if (baseURI != null) {
            expr.setBaseURI(SystemIDResolver.getAbsoluteURI(baseURI));
        } else {
            String uri2 = null;
            try {
                uri2 = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
                uri2 = uri2 + File.separator;
            }
            catch (SecurityException e) {
                // empty catch block
            }
            expr.setBaseURI(uri2);
        }
        if (!this._xpathVersion.equals("2.0")) {
            throw new RuntimeException("[XPathCompiler] v1 deprecated");
        }
        new XPath2TypeChecker(this).visitExpression(expr);
        if (this._parser.errorsFound()) {
            throw new XPathExpressionException(XMLMessages.createXMLMessage("ERR_FAIL_COMPILE_EXP", expression2));
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Finished building AST");
        }
        return expr;
    }

    public Module translate(Expr expression2) throws Exception {
        Instruction otherContextInfo;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Started translating AST to FIL");
        }
        Module module = new Module(Util.baseName(this.getClassName()), null, new ModuleSignature(""));
        module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt2", this.getRuntimeLibrarySignature(), "xslt2"));
        XPath2Translator translator = new XPath2Translator(this);
        translator.setStylesheetModlue(module);
        LetChainBuilder lcb = LetChainBuilder.newInstance(this.isInterpreted());
        DynamicVariableBuilder dvb = DynamicVariableBuilder.newDVB();
        if (this.getStaticContext().getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval/feature")) {
            Instruction qnameInstr = lcb.bind(new QNameInstruction("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval", "", "__currentgroupingkey__"));
            Instruction keyInstr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, lcb, "getVariable", new Instruction[]{qnameInstr});
            qnameInstr = lcb.bind(new QNameInstruction("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval", "", "__currentgroup__"));
            Instruction groupInstr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, lcb, "getVariable", new Instruction[]{qnameInstr});
            lcb.bind("__currentgroup__", new TupleInstruction(new Instruction[]{keyInstr, groupInstr}), true);
        }
        Instruction idInstruction = translator.compileNode(dvb, lcb, expression2);
        Instruction body = lcb.packageUp(idInstruction);
        Binding[] xpath20Parameters = new Binding[]{new Binding((Object)"__current__", XDMItemType.s_itemType), new Binding((Object)"__contextposition__", IntType.s_intType), new Binding((Object)"__contextlast__", IntType.s_intType), new Binding((Object)"__othercontextinfo__", new NamedType("XSLT20ContextInfo"))};
        Function function2 = new Function(XPATH_FUNCTION, xpath20Parameters, body);
        module.addFunction(function2);
        lcb = lcb.newInstance();
        ArrayList<Instruction> params = new ArrayList<Instruction>();
        params.add(new IdentifierInstruction("__rootcursor__"));
        params.add(new IdentifierInstruction("__contextposition__"));
        params.add(new IdentifierInstruction("__contextlast__"));
        if (this.getStaticContext().getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when")) {
            int[] cdt = this.getStaticContext().getCurrentDateTime();
            Instruction[] dateTimeInt = new Instruction[cdt.length];
            for (int i = 0; i < cdt.length; ++i) {
                dateTimeInt[i] = LiteralInstruction.integerLiteral(cdt[i]);
            }
            params.add(lcb.bind(new StreamInstruction((Type)IntType.s_intType, dateTimeInt)));
            otherContextInfo = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, lcb, "constructContextInfoUseWhen", params);
        } else {
            otherContextInfo = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, lcb, "constructContextInfo", params);
            if (this.getStaticContext().getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval/feature")) {
                Instruction qnameInstr = lcb.bind(new QNameInstruction("http://www.ibm.com/xmlns/prod/xltxe-j/trace-eval", "", "__regexgroup__"));
                Instruction varInstr = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, lcb, "getVariable", new Instruction[]{qnameInstr});
                otherContextInfo = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, lcb, "updateCurrentCapturedSubstrings", new Instruction[]{otherContextInfo, varInstr});
            }
        }
        Instruction[] instructions = new Instruction[]{new IdentifierInstruction("__rootcursor__"), new IdentifierInstruction("__contextposition__"), new IdentifierInstruction("__contextlast__"), otherContextInfo};
        Instruction callXPath20Function = lcb.bind(new FunctionCallInstruction(XPATH_FUNCTION, instructions));
        body = lcb.packageUp(callXPath20Function);
        Binding[] xpathParameters = new Binding[]{new Binding((Object)"__rootcursor__", XDMItemType.s_itemType), new Binding((Object)"__contextposition__", IntType.s_intType), new Binding((Object)"__contextlast__", IntType.s_intType)};
        function2 = new Function(XPATH_MAIN, xpathParameters, body);
        module.addFunction(function2);
        this.addPredefinedFunctions(module);
        this.addXDMFunctions(module);
        translator.generateTypeRegistryFunctions(module);
        module.addFunction(translator.createGetInScopeNamespaceTablesFunction());
        Function[] functions = translator.translateStaticContext();
        for (int i = 0; i < functions.length; ++i) {
            module.addFunction(functions[i]);
        }
        module.exportAllSymbols();
        module.typeCheck(false);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Finished translating AST to FIL");
        }
        if (StandardOptimizationRegimen.sDumpSome) {
            Program.dumpXylemFile(module, this.m_linkerSettings.getOutputDir(), module.getName());
        }
        return module;
    }

    private Module translate10(Expr expr) throws Exception {
        Module module = new Module(Util.baseName(this.getClassName()), null, new ModuleSignature(""));
        module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", this.getRuntimeLibrary().m_signature, "xslt1"));
        throw new RuntimeException("XPath Translator v1 deprecated");
    }

    public void addPredefinedFunctions(Module module) {
        Function emptyCursorFunction = new Function("empty-cursor", new Binding[]{new Binding((Object)"__root__", XDMItemType.s_itemType)}, new GetAxisCursorInstruction(Axis.PARENT, new IdentifierInstruction("__root__")));
        emptyCursorFunction.setMemoizeResult(true);
        module.addFunction(emptyCursorFunction);
    }

    public void addXDMFunctions(Module m) {
        Function f2 = new Function("xdm-node-counter-fields", new Binding[0], XSLTLinker.makeStringArrayBody(new String[0]));
        m.addFunction(f2);
        m.forceFunctionGeneration(f2);
        f2 = new Function("xdm-names", new Binding[0], new StreamInstruction(JavaObjectType.s_javaStringType));
        m.addFunction(f2);
        m.forceFunctionGeneration(f2);
        f2 = new Function("xdm-uris", new Binding[0], new StreamInstruction(JavaObjectType.s_javaStringType));
        m.addFunction(f2);
        m.forceFunctionGeneration(f2);
        f2 = new Function("xdm-types", new Binding[0], new StreamInstruction(IntType.s_intType));
        m.addFunction(f2);
        m.forceFunctionGeneration(f2);
        f2 = new Function("xdm-namespaces", new Binding[0], new StreamInstruction(JavaObjectType.s_javaStringType));
        m.addFunction(f2);
        m.forceFunctionGeneration(f2);
        String encoding = null;
        f2 = new Function("xdm-encoding", new Binding[]{}, encoding == null ? LiteralInstruction.nullLiteral(JavaObjectType.s_javaStringType) : new LetInstruction("x", StreamInstruction.charStreamLiteral(encoding), new CharStreamToJavaStringInstruction(new IdentifierInstruction("x"))));
        m.addFunction(f2);
        m.forceFunctionGeneration(f2);
    }

    @Override
    public XStarLinker getLinker() {
        return XPathLinker.s_linker;
    }

    public void dumpFunctionKeys(PrintStream pw) {
        Enumeration<FunctionKey> keys2 = this._functions.keys();
        while (keys2.hasMoreElements()) {
            FunctionKey key2 = keys2.nextElement();
            pw.print(key2.getFunctionName());
            pw.print("(");
            pw.print(key2.getArity());
            pw.println(" arguments)");
        }
    }

    final class FunctionKey {
        private final QName functionName;
        private final int arity;

        FunctionKey(QName functionName, int arity) {
            this.functionName = functionName;
            this.arity = arity;
        }

        public int hashCode() {
            return this.functionName.hashCode() + this.arity;
        }

        public boolean equals(Object a) {
            FunctionKey fk = (FunctionKey)a;
            return this.functionName.equals(fk.getFunctionName()) && this.arity == fk.getArity();
        }

        public QName getFunctionName() {
            return this.functionName;
        }

        public int getArity() {
            return this.arity;
        }
    }
}

