/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.drivers;

import com.ibm.xltxe.rnm1.xtq.Version;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIExecutable;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.runtime.Recyclable;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.runtime.AbstractPathlet;
import com.ibm.xltxe.rnm1.xtq.xpath.runtime.InterpretedPathlet;
import com.ibm.xltxe.rnm1.xylem.utils.RuntimeTerminateException;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.type.TypeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class XPathExecutable
extends AbstractSPIExecutable {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathExecutable.class);
    private static final String s_className = XPathExecutable.class.getName();
    Map<String, String> m_functionMap = null;
    Map<String, String> m_variableMap = null;
    private HashMap<String, Object> m_properties;
    private AbstractPathlet m_cachedPathlet;

    public XPathExecutable(SessionContext session) {
        super(session);
    }

    @Override
    public void execute(Cursor focus, Cursor.Area resultArea, Cursor result2, DynamicContext context2, Cursor.Profile requestedFeatures, Cursor[] args) {
        if (result2 == null) {
            throw new IllegalArgumentException("Cursor result must not be null!");
        }
        Cursor refResult = this.execute(focus, context2, requestedFeatures, args);
        if (refResult != null) {
            result2.addCopy(resultArea, refResult);
            refResult.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor execute(Cursor source, DynamicContext dynamicContext, Cursor.Profile requestedFeatures, Cursor[] args) {
        assert (null != dynamicContext);
        AbstractPathlet pathlet = null;
        try {
            pathlet = this.getPathlet(dynamicContext);
            this.initializeBindings(dynamicContext);
            Cursor cursor2 = this.execute(source, dynamicContext, pathlet, requestedFeatures, args);
            return cursor2;
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_EXECUTION_TERMINATED", new Object[]{e.getMessage()}), null);
        }
        catch (RuntimeTerminateException e) {
            this.reportError(dynamicContext, e);
        }
        catch (Exception e) {
            this.reportError(dynamicContext, e, false);
        }
        finally {
            if (pathlet instanceof Recyclable) {
                ((Recyclable)((Object)pathlet)).recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getProperties() {
        if (this.m_properties == null) {
            XPathExecutable xPathExecutable = this;
            synchronized (xPathExecutable) {
                Map<String, String> variableMap;
                if (this.m_properties != null) {
                    return this.m_properties;
                }
                HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
                Map<String, String> functionMap = this.getFunctionMap();
                if (functionMap != null) {
                    properties.put("http://www.ibm.com/xmlns/prod/xcij/function-map", functionMap);
                }
                if ((variableMap = this.getVariableMap()) != null) {
                    properties.put("http://www.ibm.com/xmlns/prod/xcij/variable-map", variableMap);
                }
                this.m_properties = properties;
            }
        }
        return this.m_properties;
    }

    private Cursor execute(Cursor source, DynamicContext dynamicContext, AbstractPathlet pathlet, Cursor.Profile requestedFeatures, Cursor[] args) throws Exception {
        if (s_logger.isLoggable(Level.CONFIG)) {
            boolean interpret = pathlet instanceof InterpretedPathlet;
            if (interpret) {
                s_logger.logrb(Level.CONFIG, s_className, "execute", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "EXECUTE_XPATH_INTERPRETER", new Object[]{Version.getVersion()});
            } else {
                s_logger.logrb(Level.CONFIG, s_className, "execute", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "EXECUTE_XPATH_COMPILER", new Object[]{pathlet.getClass().getName(), Version.getVersion()});
            }
        }
        if (DUMP_INPUT) {
            this.dumpInput(source);
        }
        Cursor result2 = (Cursor)pathlet.evaluate(source, (int)(source == null ? 0L : source.contextPosition()), (int)(source == null ? 0L : source.contextSize()), dynamicContext);
        return result2;
    }

    private AbstractPathlet getPathlet(DynamicContext context2) throws Exception {
        AbstractPathlet pathlet = this.createPathlet(this.m_session, this.m_session.getTypeRegistry());
        pathlet.postInitialization();
        pathlet.setErrorHandler(this.getErrorHandler(context2));
        return pathlet;
    }

    private AbstractPathlet getCachedPathlet() {
        if (this.m_cachedPathlet == null) {
            try {
                this.m_cachedPathlet = this.createPathlet(this.m_session, this.m_session.getTypeRegistry());
            }
            catch (WrappedRuntimeException e) {
                throw new XProcessException(e.getMessage(), e.getException());
            }
        }
        return this.m_cachedPathlet;
    }

    @Override
    protected AbstractStarlet getCachedStarlet() {
        return this.getCachedPathlet();
    }

    private void ensureMaps() {
        if (this.m_functionMap != null && this.m_variableMap != null) {
            return;
        }
        if (this.m_functionMap != null && this.m_variableMap != null) {
            return;
        }
        AbstractPathlet pathlet = this.createPathlet(this.m_session, this.m_session.getTypeRegistry());
        this.m_functionMap = pathlet.getFunctionMap();
        this.m_variableMap = pathlet.getVariableMap();
    }

    abstract AbstractPathlet createPathlet(SessionContext var1, TypeRegistry var2);

    private Map<String, String> getFunctionMap() {
        this.ensureMaps();
        return this.m_functionMap;
    }

    private Map<String, String> getVariableMap() {
        this.ensureMaps();
        return this.m_variableMap;
    }
}

