/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.drivers;

import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.Version;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.drivers.ParseUtils;
import com.ibm.xltxe.rnm1.xtq.drivers.StarletLoader;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIExecutable;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIPreparer;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiledExecutable;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathInterpretedExecutable;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.StackFrameAnalyzer;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.BasicCompilationParameters;
import com.ibm.xml.xci.exec.CompilationParameters;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.SourceLocation;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;

public class XPathPreparer
extends AbstractSPIPreparer {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathPreparer.class);
    private static final String s_className = XPathPreparer.class.getName();
    public static final String OPTION_JAVASOURCEDESTDIRS;
    public static final String JAVADESTDIR_OPTION = "javeDestDir";
    public static final boolean JAVASOURCEDESTDIRSPECIFIED;

    public XPathPreparer(SessionContext session) {
        super(session);
    }

    @Override
    public boolean compile(Source expression2, File directory, StaticContext context2, String key2, int preparerId) {
        String exprString = ParseUtils.getStringFromSource(expression2);
        if (exprString != null) {
            return this.compile(exprString, context2, new BasicCompilationParameters(key2, context2.getPackageName(), directory.toString()), preparerId, expression2);
        }
        return false;
    }

    @Override
    public boolean compile(Source expression2, StaticContext context2, CompilationParameters params, int preparerId) {
        String exprString = ParseUtils.getStringFromSource(expression2);
        if (exprString != null) {
            return this.compile(exprString, context2, params, preparerId, expression2);
        }
        return false;
    }

    @Override
    public boolean compile(String expression2, File directory, StaticContext context2, String key2, int preparerId) {
        return this.compile(expression2, context2, new BasicCompilationParameters(key2, context2.getPackageName(), directory.toString()), preparerId, null);
    }

    @Override
    public boolean compile(String expression2, StaticContext context2, CompilationParameters params, int preparerId) {
        return this.compile(expression2, context2, params, preparerId, null);
    }

    private boolean compile(String expression2, StaticContext context2, CompilationParameters params, int preparerId, Source source) {
        if (expression2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "compile", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "COMPILE_XPATH", new Object[]{Version.getVersion(), expression2});
        }
        ErrorHandler handler = this.getErrorHandler(context2);
        XTQStaticContext xtqContext = this.getXTQStaticContext(context2, source);
        try {
            XPathCompiler compiler = this.createParserAndCompiler(source, xtqContext, handler);
            compiler.setClassName(this.getClassName(params.getClassName()));
            compiler.setDestDirectory(params.getDirectoryName());
            compiler.setOutputType(1);
            compiler.setGenerateBCEL(!xtqContext.getJavaSourceFeature());
            compiler.setInterpreted(false);
            compiler.setSplitLimit(0);
            compiler.setEmitAutoSplitWarning(false);
            if (params.getPackageName() != null) {
                compiler.setPackageName(params.getPackageName());
            }
            return compiler.compile(expression2, this.getSessionContext());
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
        }
        catch (Exception e) {
            XPathPreparer.reportException(context2, e);
        }
        return false;
    }

    @Override
    public Executable load(String classname) throws ClassNotFoundException {
        String className = this.getClassName(classname);
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "load", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "LOAD_XPATH", new Object[]{className});
        }
        Class pathletClass = StarletLoader.loadStarlet(className, null);
        return new XPathCompiledExecutable(pathletClass, this.m_session);
    }

    @Override
    public Executable load(CompilationParameters params) throws ClassNotFoundException {
        String className = this.getQualifiedClassName(params);
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "load", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "LOAD_XPATH", new Object[]{className});
        }
        Class pathletClass = StarletLoader.loadStarlet(className, params.getClassLoader());
        return new XPathCompiledExecutable(pathletClass, this.m_session);
    }

    public static void directJavaSourceToDirectory(XPathCompiler compiler) {
        if (JAVASOURCEDESTDIRSPECIFIED) {
            File dir = new File(OPTION_JAVASOURCEDESTDIRS);
            dir.mkdir();
            compiler.setDestDirectory(OPTION_JAVASOURCEDESTDIRS);
        }
    }

    @Override
    public Executable prepare(String expression2, StaticContext context2, int preparerId) {
        return this.prepare(expression2, context2, preparerId, null);
    }

    private Executable prepare(String expression2, StaticContext context2, int preparerId, Source source) {
        if (expression2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        ErrorHandler handler = this.getErrorHandler(context2);
        XTQStaticContext xtqContext = this.getXTQStaticContext(context2, source);
        boolean compile = xtqContext.getCompileFeature();
        if (s_logger.isLoggable(Level.CONFIG)) {
            String messageCode = compile ? "PREPARE_XPATH_COMPILER" : "PREPARE_XPATH_INTERPRETER";
            s_logger.logrb(Level.CONFIG, s_className, "prepare", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", messageCode, new Object[]{Version.getVersion(), expression2});
        }
        try {
            XPathCompiler compiler = this.createParserAndCompiler(source, xtqContext, handler);
            String className = this.getClassName(null);
            compiler.setClassName(className);
            compiler.setInterpreted(false);
            if (compile) {
                Class<?> pathletClass;
                if (xtqContext.getJavaSourceFeature()) {
                    XPathPreparer.directJavaSourceToDirectory(compiler);
                    compiler.setGenerateBCEL(false);
                    compiler.setInterpreted(false);
                    compiler.compile(expression2, this.getSessionContext());
                    Class pathletClass2 = StarletLoader.loadStarlet(className, null);
                    return new XPathCompiledExecutable(pathletClass2, this.m_session);
                }
                compiler.setGenerateBCEL(true);
                compiler.setInterpreted(false);
                compiler.setSplitLimit(0);
                compiler.setEmitAutoSplitWarning(false);
                if (xtqContext.getGenClassesFeature()) {
                    compiler.setOutputType(3);
                } else if (DUMP_BYTECODE) {
                    this.enableBytecodeDump(compiler);
                } else {
                    compiler.setOutputType(2);
                }
                compiler.compile(expression2, this.getSessionContext());
                byte[][] bytecodes = compiler.getBytecodes();
                if (bytecodes == null) {
                    ErrorMsg err = new ErrorMsg("NO_TRANSLET_CLASS_ERR");
                    throw new NullPointerException(err.toString());
                }
                StarletLoader.ByteCodeArraysClassLoader loader = StarletLoader.getByteCodeArraysClassLoader(bytecodes, compiler.getNames());
                try {
                    pathletClass = loader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return new XPathCompiledExecutable(pathletClass, this.m_session);
            }
            compiler.setInterpreted(true);
            compiler.compile(expression2, this.getSessionContext());
            ModuleSignature ms = new ModuleSignature("");
            Program program = new Program(ms);
            program.addModule(compiler.getStarletModule());
            if (!compiler.useMixedMode()) {
                program.addModule(compiler.getRuntimeLibrary());
            }
            XPathPreparer.prepareForStackFrames(compiler);
            int mathMode = context2.getIntegerMathMode();
            XPathInterpretedExecutable executable = new XPathInterpretedExecutable(program, compiler.getFILLibrary(), mathMode == 2, mathMode == 3, this.m_session);
            if (AbstractSPIExecutable.SOURCE_LINE_INFO) {
                executable.setLineTable(compiler.getLineNumberHelper().getRuntimeLineTable());
                executable.setURITable(compiler.getLineNumberHelper().getRuntimeURITable());
            }
            return executable;
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
        }
        catch (Exception e) {
            XPathPreparer.reportException(context2, e);
        }
        return null;
    }

    public static void prepareForStackFrames(XPathCompiler compiler) {
        Module pathletModule = compiler.getStarletModule();
        StackFrameAnalyzer analyzer = new StackFrameAnalyzer(pathletModule);
        analyzer.analyze();
    }

    @Override
    public Executable prepare(Source expression2, StaticContext context2, int preparerId) {
        String exprString = ParseUtils.getStringFromSource(expression2);
        if (exprString != null) {
            return this.prepare(exprString, context2, preparerId, expression2);
        }
        return null;
    }

    @Override
    public Executable prepare(Axis axis, NodeTest nodeTest, StaticContext context2, int preparerId) {
        return null;
    }

    protected XPathCompiler createParserAndCompiler(Source source, XTQStaticContext context2, ErrorHandler handler) {
        XSLTParser parser = new XSLTParser(true, context2);
        if (source != null && source.getSystemId() != null && source.getSystemId().length() > 0) {
            parser.getExpressionFactory().setContainerLineOffset(new LineInfo(source.getSystemId(), null, -1, -1, -1, -1));
        } else if (context2.getProperty("http://www.ibm.com/xmlns/prod/xltxe-j/source_location_property") != null) {
            SourceLocation location = (SourceLocation)context2.getProperty("http://www.ibm.com/xmlns/prod/xltxe-j/source_location_property");
            parser.getExpressionFactory().setContainerLineOffset(new LineInfo(location.getSystemId(), location.getPublicId(), location.getStartLine(), location.getStartColumn(), location.getEndLine(), location.getEndColumn()));
        }
        XPathCompiler compiler = new XPathCompiler("2.0", parser);
        CodeGenerationSettings cgs = compiler.getLinkerSettings().getCodeGenerationSettings();
        int mathMode = context2.getIntegerMathMode();
        cgs.setArbitraryPrecision(mathMode == 2);
        cgs.setOverflowDetection(mathMode == 3);
        parser.getExpressionFactory().setLanguage("XPath2");
        compiler.setErrorHandler(handler);
        return compiler;
    }

    private String getClassName(String classname) {
        if (classname != null && classname.length() > 0) {
            return classname;
        }
        return "XPathModule";
    }

    @Override
    protected String getListenersProperty() {
        return null;
    }

    @Override
    protected int getLanguage() {
        return 4;
    }

    static {
        String javaDestDir = HiddenOptions.getStringValue(JAVADESTDIR_OPTION);
        if (javaDestDir != null) {
            OPTION_JAVASOURCEDESTDIRS = javaDestDir;
            JAVASOURCEDESTDIRSPECIFIED = true;
        } else {
            OPTION_JAVASOURCEDESTDIRS = ".";
            JAVASOURCEDESTDIRSPECIFIED = false;
        }
    }
}

