/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.runtime;

import com.ibm.xltxe.rnm1.xtq.common.utils.PerSessionHash;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;

public class ApplyTemplatesDispatchIDTable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final short NTYPES = 14;
    private ExtendedType[] m_extendedTypes;
    private static int m_initialSize = 128;
    private int m_nextType;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int CDATA_SECTION = 4;
    public static final int ENTITY_REFERENCE = 5;
    public static final int ENTITY = 6;
    public static final int PROCESSING_INSTRUCTION = 7;
    public static final int COMMENT = 8;
    public static final int DOCUMENT = 9;
    public static final int DOCUMENT_TYPE = 10;
    public static final int DOCUMENT_FRAGMENT = 11;
    public static final int NOTATION = 12;
    public static final int NAMESPACE = 13;
    ExtendedType hashET = new ExtendedType(-1, "", "");
    private static ExtendedType[] m_defaultExtendedTypes;
    private static float m_loadFactor;
    private static int m_initialCapacity;
    private int m_capacity = m_initialCapacity;
    private int m_threshold = (int)((float)this.m_capacity * m_loadFactor);
    private HashEntry[] m_table = new HashEntry[this.m_capacity];

    public ApplyTemplatesDispatchIDTable() {
        this.initExtendedTypes();
    }

    private void initExtendedTypes() {
        this.m_extendedTypes = new ExtendedType[m_initialSize];
        for (int i = 0; i < 14; ++i) {
            this.m_extendedTypes[i] = m_defaultExtendedTypes[i];
            this.m_table[i] = new HashEntry(m_defaultExtendedTypes[i], i, i, null);
        }
        this.m_nextType = 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpandedTypeID(String namespace2, String localName2, int type2, boolean searchOnly) {
        if (null == namespace2) {
            namespace2 = "";
        }
        if (null == localName2) {
            localName2 = "";
        }
        int hash = type2 + PerSessionHash.hash(namespace2) + PerSessionHash.hash(localName2);
        ApplyTemplatesDispatchIDTable applyTemplatesDispatchIDTable = this;
        synchronized (applyTemplatesDispatchIDTable) {
            HashEntry entry;
            this.hashET.redefine(type2, namespace2, localName2, hash);
            int index2 = hash % this.m_capacity;
            if (index2 < 0) {
                index2 = -index2;
            }
            HashEntry e = this.m_table[index2];
            while (e != null) {
                if (e.hash == hash && e.key.equals(this.hashET)) {
                    return e.value;
                }
                e = e.next;
            }
            if (searchOnly) {
                return -1;
            }
            if (this.m_nextType > this.m_threshold) {
                this.rehash();
                index2 = hash % this.m_capacity;
                if (index2 < 0) {
                    index2 = -index2;
                }
            }
            ExtendedType newET = new ExtendedType(type2, namespace2, localName2, hash);
            if (this.m_extendedTypes.length == this.m_nextType) {
                ExtendedType[] newArray = new ExtendedType[this.m_extendedTypes.length * 2];
                System.arraycopy(this.m_extendedTypes, 0, newArray, 0, this.m_extendedTypes.length);
                this.m_extendedTypes = newArray;
            }
            this.m_extendedTypes[this.m_nextType] = newET;
            this.m_table[index2] = entry = new HashEntry(newET, this.m_nextType, hash, this.m_table[index2]);
            return this.m_nextType++;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.m_extendedTypes.length; ++i) {
            if (this.m_extendedTypes[i] == null) continue;
            sb.append(this.m_extendedTypes[i].toString()).append(",");
        }
        return sb.append(']').toString();
    }

    private void rehash() {
        int newCapacity;
        int oldCapacity = this.m_capacity;
        HashEntry[] oldTable = this.m_table;
        this.m_capacity = newCapacity = 2 * oldCapacity + 1;
        this.m_threshold = (int)((float)newCapacity * m_loadFactor);
        this.m_table = new HashEntry[newCapacity];
        for (int i = oldCapacity - 1; i >= 0; --i) {
            HashEntry old2 = oldTable[i];
            while (old2 != null) {
                HashEntry e = old2;
                old2 = old2.next;
                int newIndex = e.hash % newCapacity;
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                e.next = this.m_table[newIndex];
                this.m_table[newIndex] = e;
            }
        }
    }

    public int getExpandedTypeID(int type2) {
        return type2;
    }

    public synchronized String getLocalName(int ExpandedNameID) {
        return this.m_extendedTypes[ExpandedNameID].getLocalName();
    }

    public final synchronized int getLocalNameID(int ExpandedNameID) {
        if (this.m_extendedTypes[ExpandedNameID].getLocalName().equals("")) {
            return 0;
        }
        return ExpandedNameID;
    }

    public synchronized String getNamespace(int ExpandedNameID) {
        String namespace2 = this.m_extendedTypes[ExpandedNameID].getNamespace();
        return namespace2.equals("") ? null : namespace2;
    }

    public synchronized String getNamespace2(int ExpandedNameID) {
        String namespace2 = this.m_extendedTypes[ExpandedNameID].getNamespace();
        return namespace2;
    }

    public final synchronized int getNamespaceID(int ExpandedNameID) {
        if (this.m_extendedTypes[ExpandedNameID].getNamespace().equals("")) {
            return 0;
        }
        return ExpandedNameID;
    }

    public final synchronized short getType(int ExpandedNameID) {
        return (short)this.m_extendedTypes[ExpandedNameID].getNodeType();
    }

    public boolean setItemPSVI(int ExpandedNameID, XSTypeDefinition td) {
        ExtendedType et = this.m_extendedTypes[ExpandedNameID];
        XSTypeDefinition st = et.getXSTypeDefinition();
        if (st == null) {
            et.setXSTypeDefinition(td);
            return true;
        }
        return st.equals(td);
    }

    public XSTypeDefinition getSchemaType(int ExpandedNameID) {
        ExtendedType et = this.m_extendedTypes[ExpandedNameID];
        XSTypeDefinition st = et.getXSTypeDefinition();
        return st;
    }

    public synchronized int getSize() {
        return this.m_nextType;
    }

    public synchronized ExtendedType[] getExtendedTypes() {
        return this.m_extendedTypes;
    }

    public boolean assertTypeMappings(String[] localnames, String[] uris, int[] extypes) {
        int extLen = localnames.length;
        if (extLen > 0) {
            for (int i = 0; i < extLen; ++i) {
                String uri2 = i < uris.length ? uris[i] : "";
                int j = this.getExpandedTypeID(uri2, localnames[i], extypes[i], false);
                if (j == i + 14) continue;
                return false;
            }
        }
        return true;
    }

    static {
        m_loadFactor = 0.75f;
        m_initialCapacity = 203;
        m_defaultExtendedTypes = new ExtendedType[14];
        for (int i = 0; i < 14; ++i) {
            ApplyTemplatesDispatchIDTable.m_defaultExtendedTypes[i] = new ExtendedType(i, "", "");
        }
    }

    private static final class ExtendedType {
        public static final Object UNKNOWN_SCHEMA_TYPE = Boolean.FALSE;
        private XSTypeDefinition _schemaType = null;
        private int nodetype;
        private String namespace;
        private String localName;
        private int hash;

        public String toString() {
            return "{" + this.namespace + '}' + this.localName + "=" + this.nodetype;
        }

        public ExtendedType(int nodetype, String namespace2, String localName2) {
            this.nodetype = nodetype;
            this.namespace = namespace2;
            this.localName = localName2;
            this.hash = nodetype + PerSessionHash.hash(namespace2) + PerSessionHash.hash(localName2);
        }

        public ExtendedType(int nodetype, String namespace2, String localName2, int hash) {
            this.nodetype = nodetype;
            this.namespace = namespace2;
            this.localName = localName2;
            this.hash = hash;
        }

        protected void redefine(int nodetype, String namespace2, String localName2) {
            this.nodetype = nodetype;
            this.namespace = namespace2;
            this.localName = localName2;
            this.hash = nodetype + PerSessionHash.hash(namespace2) + PerSessionHash.hash(localName2);
        }

        protected void redefine(int nodetype, String namespace2, String localName2, int hash) {
            this.nodetype = nodetype;
            this.namespace = namespace2;
            this.localName = localName2;
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(ExtendedType other2) {
            try {
                return other2.hash == this.hash && other2.nodetype == this.nodetype && other2.localName.equals(this.localName) && other2.namespace.equals(this.namespace);
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int getNodeType() {
            return this.nodetype;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public XSTypeDefinition getXSTypeDefinition() {
            return this._schemaType;
        }

        public void setXSTypeDefinition(XSTypeDefinition td) {
            this._schemaType = td;
        }
    }

    private static final class HashEntry {
        ExtendedType key;
        int value;
        int hash;
        HashEntry next;

        protected HashEntry(ExtendedType key2, int value2, int hash, HashEntry next) {
            this.key = key2;
            this.value = value2;
            this.hash = hash;
            this.next = next;
        }
    }
}

