/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xquery.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.Parser;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.ParseException;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.TokenMgrError;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XQueryContextWrapper;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandlerProvider;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarLinker;
import com.ibm.xltxe.rnm1.xtq.drivers.XTQModuleManager;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import com.ibm.xltxe.rnm1.xtq.utils.Reporter;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xquery.drivers.XQueryLinker;
import com.ibm.xltxe.rnm1.xtq.xquery.drivers.XQueryParseUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.cmdline.utils.PrettyXylemListing;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.StandardOptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.DefaultXTQAnnotationHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.XSLT2TypeChecker;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XQueryCompiler
extends XSLTCompiler
implements ErrorHandlerProvider {
    private static final Logger s_logger = LoggerUtil.getLogger(XQueryCompiler.class);
    private static final String s_className = XQueryCompiler.class.getName();
    protected Parser _parserWrapper;
    protected StreamSource _source;
    private static final boolean _dumpfilEnabled = HiddenOptions.wasSpecified("dumpfil") && HiddenOptions.optionValueIs("dumpfil", "on");

    public XQueryCompiler(Source querySource, XStaticContext context2) {
        super("2.0", new XQueryContextWrapper(context2));
        this.initCompiler(querySource, this.getParser());
    }

    @Override
    protected void initCompiler(TypeRegistry tr) {
    }

    protected XPath getXQueryParser() {
        return (XPath)this._parserWrapper.getRealParser();
    }

    private void initCompiler(Source querySource, ASTBuildingContext context2) {
        try {
            this._parserWrapper = XQueryParseUtils.createParser(querySource, context2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._source = (StreamSource)querySource;
        ExpressionFactoryImpl exprFactory = this.getXQueryParser().getExpressionFactory();
        if (querySource.getSystemId() != null && querySource.getSystemId().length() > 0) {
            exprFactory.setContainerLineOffset(new LineInfo(querySource.getSystemId(), null, -1, -1, -1, -1));
        }
        this._parser.setExpressionFactory(exprFactory);
        this.getParser().setExpressionFactory(exprFactory);
        super.initCompiler(TypeRegistry.newTypeRegistry());
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        super.setErrorHandler(handler);
        XPath p = this.getXQueryParser();
        Reporter reporter = p.getReporter();
        if (null == reporter) {
            reporter = new Reporter();
        }
        reporter.setErrorHandler(handler);
        p.setReporter(reporter);
    }

    @Override
    public void setSecureProcessing(boolean value2) {
    }

    @Override
    public XTQStaticContext getStaticContext() {
        XPath p = this.getXQueryParser();
        return (XTQStaticContext)p.getStaticContext();
    }

    public boolean compile(SessionContext session) {
        try {
            if (this.useMixedMode()) {
                this.setRuntimeSignature(this.loadRuntimeSignature());
            } else {
                this.setRuntimeLibrary(this.loadRuntimeLibrary());
            }
            Expr expr = this.buildAST();
            XTQModuleManager moduleManager = this.getModuleManager();
            moduleManager.computeSchemaSets(expr instanceof XTQProgram ? (XTQProgram)expr : expr.getXTQProgram());
            for (XTQProgram xTQProgram : moduleManager.getAllModules()) {
                Module xylemModule = this.translate(xTQProgram, (XTQStaticContext)xTQProgram.getStaticContext());
                this.addModule(xTQProgram, xylemModule);
            }
            this.setStarletModule(this.translate(expr, this.getStaticContext()));
            this.addModule((XTQProgram)expr, this.getStarletModule());
            this.setupModuleImports();
            if (StandardOptimizationRegimen.DumpOption.LISTING.isEnabled()) {
                Module module = this.getStarletModule();
                if (!this.useMixedMode()) {
                    PrettyXylemListing.MakeListing(module.getName(), new Module[]{module, this.getRuntimeLibrary()});
                } else {
                    PrettyXylemListing.MakeListing(module.getName(), new Module[]{module});
                }
            }
            if (_dumpfilEnabled) {
                this.dumpModule(this.getStarletModule());
            }
            if (this.getDoPostASTProcessing()) {
                this.postASTProcessing(this.getRuntimeLibrary(), this.getStarletModule(), null);
                Iterator<Module> iterator = this.getModules().iterator();
                while (iterator.hasNext()) {
                    this.postASTProcessing(this.getRuntimeLibrary(), iterator.next(), null);
                }
            }
            if (!this.isInterpreted()) {
                ModuleSignature moduleSignature = new ModuleSignature("");
                Program program = new Program(moduleSignature);
                program.addModules(this.getModules());
                program.addModule(this.getRuntimeLibrary());
                this.linkAndCodeGen(program, this.getRuntimeLibrary(), this.getStarletModule(), session);
            }
        }
        catch (WrappedRuntimeException wre) {
            this.getXQueryParser().reportError(2, new ErrorMsg(wre), wre.getException());
        }
        catch (HandledRuntimeException e) {
            throw e;
        }
        catch (ParseException e) {
            this.getXQueryParser().reportError(2, new ErrorMsg("XQUERY_PARSER_ERR", (Object)e, e.getSourceLocation()));
        }
        catch (TokenMgrError e) {
            this.getXQueryParser().reportError(2, new ErrorMsg("XQUERY_PARSER_ERR"));
        }
        catch (StaticError e) {
            ErrorMsg msg = e.getErrorMsg();
            if (msg == null) {
                msg = new ErrorMsg(e, e.getNode());
            }
            this.getXQueryParser().reportError(2, msg, e.getException());
        }
        catch (Exception e) {
            this.getXQueryParser().reportError(2, new ErrorMsg(e), e);
        }
        catch (Error e) {
            this.getXQueryParser().reportError(2, new ErrorMsg(e), e);
        }
        return !this.getXQueryParser().getReporter().errorsFound();
    }

    private Expr buildAST() throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Started building AST");
        }
        Expr expr = this._parserWrapper.parse();
        String baseURI = this._parser.getStaticContext().getBaseURI();
        if (baseURI != null) {
            expr.setBaseURI(SystemIDResolver.getAbsoluteURI(baseURI));
        }
        XTQProgram main = expr instanceof XTQProgram ? (XTQProgram)expr : expr.getXTQProgram();
        main.setParser(this._parser);
        this.getModuleManager().parseModules((XTQProgram)expr, this._parser.getReporter());
        XSLT2TypeChecker typeChecker = new XSLT2TypeChecker(this);
        typeChecker.visitExpression(expr);
        ((XQueryContextWrapper)this._parser).reportFunctionRedefnErrors();
        Collection<XTQProgram> modules = this.getModuleManager().getAllModules();
        for (XTQProgram module : modules) {
            typeChecker.startContext(module);
            typeChecker.visitExpression(module);
            ((XQueryContextWrapper)module.getParser()).reportFunctionRedefnErrors();
            typeChecker.endContext();
        }
        if (((XTQProgram)expr).isLibraryModule()) {
            this.getXQueryParser().reportError(2, new ErrorMsg("ERR_XQ_NO_MAIN_MODULE", null, (SimpleNode)expr));
        }
        if (this.getXQueryParser().getReporter().errorsFound()) {
            String systemID = this._source.getSystemId();
            if (null == systemID) {
                systemID = "Unknown Resource ID";
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ERR_FAIL_COMPILE_EXP", systemID));
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Finished building AST");
        }
        return expr;
    }

    public Module translate(Expr expression2, XTQStaticContext context2) throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Started translating AST to FIL");
        }
        XSLT2Translator xsltTrans = new XSLT2Translator(this, DefaultXTQAnnotationHelper.createAnnotationHelper(this.getParser().getStaticContext().getLanguage(), this.getCompilerSettings()));
        xsltTrans.setStaticContext(context2);
        xsltTrans.visitTree(expression2);
        Module module = xsltTrans.getStylesheetModule();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Finished translating AST to FIL");
        }
        if (StandardOptimizationRegimen.sDumpSome) {
            Program.dumpXylemFile(module, this.m_linkerSettings.getOutputDir(), module.getName());
        }
        return module;
    }

    @Override
    public XStarLinker getLinker() {
        return XQueryLinker.s_linker;
    }

    @Override
    public FunctionDeclaration getFunctionDeclarationFromSignature(QName functionName, int arity) {
        for (int i = 0; i < this.funcTable.getNoneXQueryFunctionLength(); ++i) {
            String simpFuncName = this.funcTable.getNoneXQueryFunctionName(i);
            if (!simpFuncName.equals(functionName.getLocalPart())) continue;
            return null;
        }
        return super.getFunctionDeclarationFromSignature(functionName, arity);
    }
}

