/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xquery.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.Parser;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceCache;
import com.ibm.xltxe.rnm1.xtq.drivers.ParseUtils;
import com.ibm.xltxe.rnm1.xtq.drivers.XTQModuleManager;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XQueryParseUtils
extends ParseUtils {
    private static final Logger s_logger = LoggerUtil.getLogger(XQueryParseUtils.class);
    private static final String s_className = XQueryParseUtils.class.getName();
    public static final boolean DUMP_EXPRESSION = HiddenOptions.wasSpecified("dumpexpr");

    public static Parser createParser(Source querySource, ASTBuildingContext context2) throws IOException {
        if (querySource instanceof StreamSource) {
            Parser parser;
            StreamSource ssource = (StreamSource)querySource;
            String systemId = ssource.getSystemId();
            if (ssource.getReader() != null) {
                parser = new Parser(context2, "XQuery1", ssource.getReader(), systemId);
            } else if (ssource.getInputStream() != null) {
                parser = new Parser(context2, "XQuery1", ssource.getInputStream(), systemId);
            } else {
                try {
                    URL url = new URL(systemId);
                    parser = new Parser(context2, "XQuery1", url.openStream(), systemId);
                }
                catch (MalformedURLException e) {
                    FileInputStream inputStream = new FileInputStream(systemId);
                    parser = new Parser(context2, "XQuery1", inputStream, systemId);
                }
            }
            return parser;
        }
        throw new RuntimeException("Source Type Not Found!");
    }

    public static Source normalizeLineBreaks(Source s, XTQModuleManager mm) {
        String stringExpr = XQueryParseUtils.getStringFromSource(s);
        stringExpr = stringExpr.replaceAll("\r\n", "\n");
        stringExpr = stringExpr.replaceAll("\r", "\n");
        if (DUMP_EXPRESSION) {
            XQueryParseUtils.dumpExpression(stringExpr, s.getSystemId());
        }
        String systemId = s.getSystemId();
        SourceCache sourceCache = mm.getSourceCache();
        if (sourceCache != null) {
            if (systemId == null || systemId.length() == 0) {
                systemId = mm.getGeneratedSystemId();
            }
            sourceCache.addDocument(systemId, stringExpr, "UTF-8");
        }
        StreamSource source = new StreamSource(new StringReader(stringExpr));
        source.setSystemId(systemId);
        return source;
    }

    protected static void dumpExpression(String expr, String systemId) {
        String filename = "xquery-dump";
        if (Program.TIMESTAMPED_DUMPS) {
            filename = filename + "." + System.currentTimeMillis();
        }
        filename = filename + ".xq";
        File f2 = new File(filename);
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(f2));
            ps.println("(: systemId: " + systemId + " :)");
            ps.println();
            ps.print(expr);
            ps.close();
            s_logger.logrb(Level.INFO, s_className, "dumpExpression", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{f2.getCanonicalPath()});
        }
        catch (IOException io) {
            s_logger.logrb(Level.WARNING, s_className, "dumpExpression", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)io);
        }
    }
}

