/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.TypeSpecializationDerivative;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ZeroArgPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoFunctorizingXSLTLinker {
    private static final Logger s_logger = LoggerUtil.getLogger(AutoFunctorizingXSLTLinker.class);
    private static final String s_className = AutoFunctorizingXSLTLinker.class.getName();
    private static final Instruction s_blankInstruction = LiteralInstruction.unitLiteral();

    public static final String compileStylesheetDetectOverlap(URL[] files, List classNames, XSLTCompilerSettings compilerSettings, XSLTLinkerSettings linkerSettings, SourceLoader sl, boolean topResolve, SessionContext session) {
        try {
            Module rtlib = XSLTCompiler.loadRuntimeLibrary(false);
            Module[] modules = new Module[files.length];
            Module[] modules0 = new Module[files.length - 1];
            Module master = null;
            HashMap<FunctionSignature, ArrayList[]> unifiedFunctionMap = new HashMap<FunctionSignature, ArrayList[]>();
            HashMap masterFunctionTable = new HashMap();
            CodeCompressor rcr = new CodeCompressor();
            for (int i = 0; i < modules.length; ++i) {
                try {
                    modules[i] = XSLTCompiler.compileStylesheetToModule(files[i], rtlib, null, false, compilerSettings, sl, topResolve);
                    modules[i].typeCheck(false);
                    if (i > 0) {
                        AutoFunctorizingXSLTLinker.renameTypeSpecializedFunctions(modules[i], modules, masterFunctionTable);
                        modules[i].removeFunctionDerivativeInformation(false);
                        modules[i].removeDeadFunctions();
                    } else {
                        AutoFunctorizingXSLTLinker.renameTypeSpecializedFunctions(modules[i], modules, masterFunctionTable);
                        master = modules[i];
                    }
                    modules[i].optimize(rcr);
                    if (linkerSettings.isDumpXylem()) {
                        String name2 = i < classNames.size() ? (String)classNames.get(i) : modules[i].getName();
                        Program.dumpXylemFile(modules[i], linkerSettings.getOutputDir(), name2, "autofunc" + i);
                    }
                }
                catch (Exception e) {
                    s_logger.logp(Level.SEVERE, s_className, "compileStylesheetDetectOverlap", "", e);
                }
                if (modules[i] == null) {
                    return null;
                }
                if (i <= 0) continue;
                modules0[i - 1] = modules[i];
            }
            rcr = null;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "compileStylesheetDetectOverlap", "Performing overlap detection");
            }
            XSLTLinker.consolidateXDMTables(modules0, master, session);
            master.removeDeadFunctions();
            HashMap signatures = new HashMap();
            HashMap reverse2 = new HashMap();
            for (int i = 0; i < modules.length; ++i) {
                for (Function f2 : modules[i].getFunctions()) {
                    ArrayList list2;
                    ArrayList list;
                    if (f2.getName().equals("main")) {
                        f2.setName("main-functor");
                    } else if (!f2.getName().equals("setupOutput")) {
                        if (!f2.getName().equals("whitespaceRules")) {
                            if (!f2.getName().equals("setupCharacterMaps") && !f2.getName().equals("get-ns-prefix-counter") && modules[i].getFunctionSignature(f2.getName()) != null) continue;
                        }
                    }
                    FunctionSignature fs = AutoFunctorizingXSLTLinker.makeFunctionSignature(f2);
                    ArrayList[] lists = (ArrayList[])unifiedFunctionMap.get(fs);
                    if (lists == null) {
                        list = new ArrayList();
                        list2 = new ArrayList();
                        lists = new ArrayList[]{list, list2};
                        unifiedFunctionMap.put(fs, lists);
                    } else {
                        list = lists[0];
                        list2 = lists[1];
                    }
                    list.add(f2);
                    list2.add(new Integer(i));
                    AutoFunctorizingXSLTLinker.scanForFunctionCalls(f2, signatures, reverse2, modules[i]);
                    AutoFunctorizingXSLTLinker.augmentFunction(f2);
                }
            }
            reverse2 = null;
            Statistics stats = new Statistics(modules);
            int moduleCount = modules.length;
            modules = null;
            modules0 = null;
            Iterator i = unifiedFunctionMap.keySet().iterator();
            HashSet<String> names = new HashSet<String>();
            HashMap<FunctionSignature, String> newNames = new HashMap<FunctionSignature, String>();
            while (i.hasNext()) {
                FunctionSignature fs = (FunctionSignature)i.next();
                ArrayList[] lists = (ArrayList[])unifiedFunctionMap.get(fs);
                ArrayList list = lists[0];
                ArrayList list2 = lists[1];
                Function masterFunction = (Function)list.get(0);
                boolean forceTopLevel = false;
                if (masterFunction.getName().equals("build_key")) {
                    forceTopLevel = true;
                }
                if (list.size() > 1) {
                    int[] xToRealTable = new int[list.size()];
                    Iterator j = list2.iterator();
                    int k2 = 0;
                    while (j.hasNext()) {
                        Integer k3 = (Integer)j.next();
                        xToRealTable[k2++] = k3;
                    }
                    Instruction[] buf = new Instruction[list.size()];
                    TypeEnvironment[] tenvs = new TypeEnvironment[list.size()];
                    int k = 0;
                    StringBuffer comment2 = new StringBuffer();
                    if (masterFunction.getComment() != null) {
                        comment2.append(masterFunction.getComment());
                    }
                    comment2.append('\n');
                    for (Function f3 : list) {
                        comment2.append("// ");
                        comment2.append(";; merged from ");
                        comment2.append(f3.getName());
                        comment2.append(" in ");
                        comment2.append(f3.getTypeEnvironment().getModule().getName());
                        comment2.append('\n');
                        tenvs[k] = f3.getTypeEnvironment();
                        buf[k++] = f3.getBody();
                    }
                    int[] score = new int[1];
                    Instruction combined = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(buf, true, master, masterFunction, xToRealTable, moduleCount, forceTopLevel, score);
                    stats.add(fs, xToRealTable, score[0]);
                    masterFunction.setBody(combined);
                    masterFunction.setComment(comment2.toString());
                    j = list.iterator();
                    j.next();
                    while (j.hasNext()) {
                        Function f4 = (Function)j.next();
                        f4.setBody(null);
                        f4.m_bindingEnvironment = null;
                        f4.removeDerivativeInformation(false);
                    }
                    tenvs = null;
                    buf = null;
                } else {
                    stats.addUnique(fs, (Integer)list2.get(0));
                }
                String name3 = masterFunction.getName();
                while (names.contains(name3)) {
                    name3 = name3 + "_$_";
                }
                names.add(name3);
                if (!name3.equals(masterFunction.getName())) {
                    newNames.put(fs, name3);
                    masterFunction.setName(name3);
                }
                master.addFunction(masterFunction, false);
                i.remove();
            }
            stats.summarize();
            names = null;
            unifiedFunctionMap = null;
            i = null;
            AutoFunctorizingXSLTLinker.handleStandardExports(master);
            AutoFunctorizingXSLTLinker.replaceFunctionCalls(master, newNames, signatures);
            newNames = null;
            signatures = null;
            master.clearTypeInformation(true);
            master.removeFunctionDerivativeInformation(false);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "compileStylesheetDetectOverlap", "Autofunctorization complete");
            }
            master.optimize(new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction n2) {
                    if (n2 instanceof IdentifierReferenceInstruction) {
                        return ((IdentifierReferenceInstruction)n2).makeIdentifierInstruction();
                    }
                    return n2;
                }
            });
            XSLTCompiler.postASTProcessing(master, null, compilerSettings.getPrereductionSplitLimit(), compilerSettings.isStreamResultOnly());
            XSLTLinker.s_linker.compileProgram(master, rtlib, files.length, classNames, master.getName(), linkerSettings, session);
            return master.getName();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "compileStylesheetDetectOverlap", "", e);
            return null;
        }
    }

    public static String compileStylesheetDetectOverlap(URL[] files, List classNames, XSLTCompilerSettings compilerSettings, XSLTLinkerSettings linkerSettings, SessionContext session) {
        return AutoFunctorizingXSLTLinker.compileStylesheetDetectOverlap(files, classNames, compilerSettings, linkerSettings, null, false, session);
    }

    public static void handleStandardExports(Module master) {
        Function prefixCount;
        Function f2 = master.getFunction("main-functor");
        Instruction[] params = new Instruction[f2.m_parameters.length];
        Binding[] paramBindings = new Binding[f2.m_parameters.length];
        for (int k = 0; k < f2.m_parameters.length; ++k) {
            params[k] = new IdentifierInstruction(f2.m_parameters[k].getName());
            paramBindings[k] = (Binding)f2.m_parameters[k].clone();
        }
        Function main = new Function("main", paramBindings, new FunctionCallInstruction("main-functor", params));
        master.addFunction(main, false);
        master.forceFunctionGeneration(master.getFunction("main"));
        master.forceFunctionGeneration(master.getFunction("setupOutput"));
        master.forceFunctionGeneration(master.getFunction("whitespaceRules"));
        Function charMaps = master.getFunction("setupCharacterMaps");
        if (charMaps != null) {
            master.forceFunctionGeneration(master.getFunction("setupCharacterMaps"));
        }
        if ((prefixCount = master.getFunction("get-ns-prefix-counter")) != null) {
            master.forceFunctionGeneration(prefixCount);
        }
    }

    public static void replaceFunctionCalls(Module master, final HashMap newNames, final HashMap signatures) {
        master.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                FunctionCallInstruction fci;
                FunctionSignature fs;
                if (n2 instanceof FunctionCallInstruction && (fs = (FunctionSignature)signatures.get((fci = (FunctionCallInstruction)n2).getFunction())) != null) {
                    String newName = (String)newNames.get(fs);
                    if (newName != null) {
                        fci.setFunction(newName);
                    } else {
                        fci.setFunction(fs.getFunctionName());
                    }
                }
                return super.optimizeStep(n2);
            }
        });
    }

    public static final void compileFunctorAppliedStylesheets(URL functorURL, URL[] targets, URL moduleSignature, XSLTCompilerSettings compilerSettings, SourceLoader sl, boolean topResolve, SessionContext session) {
        try {
            XSLTCompiler compiler = new XSLTCompiler(compilerSettings);
            if (null != sl) {
                compiler.setSourceLoader(sl);
            }
            Module rtlib = compiler.loadRuntimeLibrary();
            ModuleSignature ms = AutoFunctorizingXSLTCompiler.parseSignatureFile(moduleSignature);
            Module[] modules = new Module[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                modules[i] = XSLTCompiler.compileStylesheetToModule(targets[i], rtlib, ms, true, compilerSettings, sl, topResolve);
                if (modules[i] != null) continue;
                return;
            }
            Functor functor = AutoFunctorizingXSLTCompiler.compileToFunctor("functor", functorURL, rtlib, ms, session);
            XSLTLinker.s_linker.compileProgram(functor, modules, rtlib, compiler.getLinkerSettings());
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "compileFunctorAppliedStylesheets", "", e);
        }
    }

    public static void compileFunctorAppliedStylesheets(URL functorURL, URL[] targets, URL moduleSignature, XSLTCompilerSettings compilerSettings, SessionContext session) {
        AutoFunctorizingXSLTLinker.compileFunctorAppliedStylesheets(functorURL, targets, moduleSignature, compilerSettings, null, false, session);
    }

    protected static final FunctionSignature makeFunctionSignature(Function f2) {
        String functionName = f2.getName();
        Type returnType = f2.getReturnType();
        Binding[] params = f2.m_parameters;
        int index2 = 0;
        if (params.length > 0 && params[0].getName().equals("__functorindex__")) {
            index2 = 1;
        }
        Type[] parameterTypes = new Type[params.length - index2];
        Object[] parameterNames = new Object[parameterTypes.length];
        for (int i = index2; i < params.length; ++i) {
            parameterTypes[i - index2] = params[i].getBindingType();
            parameterNames[i - index2] = "x" + (i - index2);
        }
        return new FunctionSignature(functionName, parameterNames, parameterTypes, returnType);
    }

    protected static final void scanForFunctionCalls(Function f2, final HashMap signatures, final HashMap reverse2, final Module m) {
        new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                if (n2 instanceof FunctionCallInstruction) {
                    FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                    FunctionSignature fs = AutoFunctorizingXSLTLinker.makeFunctionSignature(m.getFunction(fci.getFunction()));
                    String id2 = (String)reverse2.get(fs);
                    if (id2 == null) {
                        id2 = Integer.toString(signatures.size());
                        signatures.put(id2, fs);
                        reverse2.put(fs, id2);
                    }
                    fci.setFunction(id2);
                }
                return n2;
            }
        }.optimizeFunction(f2);
    }

    protected static final Instruction foldTogetherStreams(Instruction[] x, int[] xToRealTable, int totalReal, boolean forceTopLevel) {
        int minlength = -1;
        int maxlength = -1;
        boolean allStrings = true;
        boolean allSameString = true;
        String sameValue = null;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] instanceof StreamInstruction)) {
                return null;
            }
            StreamInstruction si = (StreamInstruction)x[i];
            if (minlength == -1 || si.getChildInstructionCount() < minlength) {
                minlength = x[i].getChildInstructionCount();
            }
            if (maxlength == -1 || si.getChildInstructionCount() > maxlength) {
                maxlength = x[i].getChildInstructionCount();
            }
            if (!si.isString()) {
                allStrings = false;
                continue;
            }
            if (!allStrings) continue;
            if (sameValue == null) {
                sameValue = si.getStringContent();
                continue;
            }
            if (sameValue.equals(si.getStringContent())) continue;
            allSameString = false;
        }
        if (allStrings) {
            if (allSameString) {
                return x[0];
            }
            return null;
        }
        ArrayList<Instruction> items2 = new ArrayList<Instruction>();
        block1: for (int i = 0; i < minlength; ++i) {
            boolean allStreams = true;
            boolean allElements = true;
            Instruction[] y = new Instruction[x.length];
            for (int j = 0; j < x.length; ++j) {
                y[j] = x[j].getChildInstruction(i);
                if (y[j].getCachedType() instanceof StreamType) {
                    allElements = false;
                } else {
                    allStreams = false;
                }
                if (!allStreams && !allElements) break block1;
            }
            Instruction fold = AutoFunctorizingXSLTLinker.foldTogether(y, xToRealTable, totalReal, forceTopLevel);
            if (fold == null) break;
            items2.add(fold);
        }
        Type elementType = ((StreamType)((StreamInstruction)x[0]).getCachedType()).getElementType();
        if (items2.size() < maxlength) {
            ArrayList[] lists = new ArrayList[x.length];
            for (int j = 0; j < x.length; ++j) {
                lists[j] = new ArrayList();
            }
            for (int i = items2.size(); i < maxlength; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    if (i >= x[j].getChildInstructionCount()) continue;
                    lists[j].add(x[j].getChildInstruction(i));
                }
            }
            Instruction[] cases = new Instruction[x.length];
            for (int i = 0; i < x.length; ++i) {
                StreamInstruction si = new StreamInstruction(elementType, lists[i]);
                cases[i] = si;
            }
            Instruction fold = AutoFunctorizingXSLTLinker.foldTogether(cases, false, xToRealTable, totalReal, forceTopLevel);
            items2.add(fold == null ? AutoFunctorizingXSLTLinker.makeChoice(cases, xToRealTable, totalReal) : fold);
        }
        StreamInstruction si = new StreamInstruction(elementType, items2);
        return si;
    }

    protected static final Instruction areCompatible(Instruction[] x) {
        int c = -1;
        Instruction master = null;
        for (int i = 0; i < x.length; ++i) {
            if (c == -1) {
                c = x[i].getChildInstructionCount();
            } else if (c != x[i].getChildInstructionCount()) {
                return null;
            }
            if (i > 0) {
                for (int k = 0; k < c; ++k) {
                    Instruction n2;
                    Type t2;
                    Type t = x[0].getChildInstruction(k).getCachedType();
                    if (t == null) {
                        t = IntType.s_intType;
                    }
                    if ((t2 = (n2 = x[i].getChildInstruction(k)).getCachedType()) == null) {
                        t2 = IntType.s_intType;
                    }
                    if (t.equals(t2)) continue;
                    return null;
                }
            }
            Instruction blank = x[i].cloneShallow();
            for (int j = 0; j < c; ++j) {
                blank.setChildInstruction(j, s_blankInstruction);
            }
            blank.clearTypeInformation();
            if (master == null) {
                master = blank;
                continue;
            }
            if (!master.getClass().equals(blank.getClass())) {
                return null;
            }
            if (!(master instanceof LetInstruction ? !((LetInstruction)blank).getVariable().equals(((LetInstruction)master).getVariable()) : !master.equals(blank))) continue;
            return null;
        }
        return master;
    }

    public static final Instruction foldTogetherOrMakeChoice(Instruction[] x, boolean topLevel, Module m, Function f2, int[] xToRealTable, int totalReal, boolean forceTopLevel, int[] score) {
        Instruction y;
        Instruction instruction2 = y = forceTopLevel ? null : AutoFunctorizingXSLTLinker.foldTogether(x, xToRealTable, totalReal, forceTopLevel);
        if (y == null) {
            if (score != null) {
                score[0] = 0;
            }
            y = AutoFunctorizingXSLTLinker.makeChoice(x, xToRealTable, totalReal);
            if (forceTopLevel || topLevel) {
                MatchInstruction mi = (MatchInstruction)y;
                MatchInstruction.Match[] mim = mi.getMatches();
                for (int i = 0; i < mim.length; ++i) {
                    Function f22 = new Function(f2.generateNewFixupName(), (Binding[])f2.m_parameters.clone(), mim[i].getHandler());
                    m.addFunction(f22);
                    Instruction[] params = new Instruction[f2.m_parameters.length];
                    for (int j = 0; j < params.length; ++j) {
                        params[j] = new IdentifierInstruction(f2.m_parameters[j].getName());
                    }
                    mim[i].setHandler(new FunctionCallInstruction(f22.getName(), params));
                }
            }
        } else if (score != null) {
            score[0] = 1;
        }
        return y;
    }

    protected static final Instruction foldTogether(Instruction[] x, int[] xToRealTable, int totalReal, boolean forceTopLevel) {
        return AutoFunctorizingXSLTLinker.foldTogether(x, true, xToRealTable, totalReal, forceTopLevel);
    }

    protected static final Instruction foldTogether(Instruction[] x, boolean allowStreamFolding, int[] xToRealTable, int totalReal, boolean forceTopLevel) {
        if (allowStreamFolding && x[0] instanceof StreamInstruction) {
            return AutoFunctorizingXSLTLinker.foldTogetherStreams(x, xToRealTable, totalReal, forceTopLevel);
        }
        Instruction master = AutoFunctorizingXSLTLinker.areCompatible(x);
        if (master != null) {
            for (int i = 0; i < master.getChildInstructionCount(); ++i) {
                Instruction[] y = new Instruction[x.length];
                for (int j = 0; j < x.length; ++j) {
                    y[j] = x[j].getChildInstruction(i);
                }
                master.setChildInstruction(i, AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(y, false, null, null, xToRealTable, totalReal, forceTopLevel, null));
            }
            return master;
        }
        return null;
    }

    protected static final boolean areEquivalent(Instruction[] x) {
        Instruction master = AutoFunctorizingXSLTLinker.areCompatible(x);
        if (master != null) {
            for (int i = 0; i < master.getChildInstructionCount(); ++i) {
                Instruction[] y = new Instruction[x.length];
                for (int j = 0; j < x.length; ++j) {
                    y[j] = x[j].getChildInstruction(i);
                }
                if (AutoFunctorizingXSLTLinker.areEquivalent(y)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static final Instruction makeChoice(Instruction[] x, int[] xToRealTable, int totalReal) {
        Iterator l;
        Iterator j;
        ArrayList<Instruction> choices = new ArrayList<Instruction>();
        ArrayList conditions = new ArrayList();
        block0: for (int i = 0; i < x.length; ++i) {
            Integer pei = new Integer(i);
            j = choices.iterator();
            l = conditions.iterator();
            while (j.hasNext()) {
                Instruction y = (Instruction)j.next();
                ArrayList list = (ArrayList)l.next();
                if (!AutoFunctorizingXSLTLinker.areEquivalent(new Instruction[]{x[i], y})) continue;
                list.add(pei);
                continue block0;
            }
            choices.add(x[i]);
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(pei);
            conditions.add(list);
        }
        MatchInstruction.Match[] cases = new MatchInstruction.Match[choices.size()];
        Object[] cases2 = new Instruction[totalReal];
        Arrays.fill(cases2, LiteralInstruction.integerLiteral(-1));
        j = choices.iterator();
        l = conditions.iterator();
        int i = 0;
        while (j.hasNext()) {
            Instruction y = (Instruction)j.next();
            ArrayList list = (ArrayList)l.next();
            Iterator k = list.iterator();
            while (k.hasNext()) {
                cases2[xToRealTable[((Integer)k.next()).intValue()]] = LiteralInstruction.integerLiteral(i);
            }
            cases[i] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(i), y);
            ++i;
        }
        return new MatchInstruction((Instruction)new StreamElementInstruction(new StreamInstruction((Type)IntType.s_intType, (Instruction[])cases2), new IdentifierInstruction("__functorindex__")), cases, null);
    }

    protected static final void augmentFunction(Function f2) {
        new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                if (n2 instanceof FunctionCallInstruction) {
                    FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                    Instruction[] newParams = new Instruction[n2.getChildInstructionCount() + 1];
                    System.arraycopy(fci.m_parameters, 0, newParams, 1, fci.m_parameters.length);
                    newParams[0] = new IdentifierInstruction("__functorindex__");
                    fci.m_parameters = newParams;
                }
                return super.optimizeStep(n2);
            }
        }.optimizeFunction(f2);
        Binding[] newParams = new Binding[f2.m_parameters.length + 1];
        System.arraycopy(f2.m_parameters, 0, newParams, 1, f2.m_parameters.length);
        newParams[0] = new Binding((Object)"__functorindex__", IntType.s_intType);
        f2.m_parameters = newParams;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "augmentFunction", f2.getName() + " has " + f2.m_parameters.length + " parameters");
        }
    }

    protected static final void renameTypeSpecializedFunctions(Module m, Module[] modules, HashMap masterFunctionTable) {
        final HashMap<String, String> map2 = new HashMap<String, String>();
        m.removeDeadFunctions();
        for (Function f2 : new ArrayList<Function>(m.getFunctions())) {
            Function masterDerivativeF;
            Object key2 = f2.getDerivationKey();
            if (key2 == null || !(key2 instanceof TypeSpecializationDerivative)) continue;
            Function originalF = f2.getOriginalFunction();
            Object masterF = null;
            HashMap<Object, Function> masterDerivatives = (HashMap<Object, Function>)masterFunctionTable.get(originalF.getName());
            if (masterDerivatives == null) {
                masterDerivatives = new HashMap<Object, Function>();
                masterFunctionTable.put(originalF.getName(), masterDerivatives);
            }
            if ((masterDerivativeF = (Function)masterDerivatives.get(key2)) == null) {
                masterDerivativeF = f2;
                masterDerivatives.put(key2, masterDerivativeF);
            }
            map2.put(f2.getName(), masterDerivativeF.getName());
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "renameTypeSpecializedFunctions", "renamed " + f2.getName() + " to " + masterDerivativeF.getName());
            }
            m.renameFunction(f2, masterDerivativeF.getName());
            if (f2 == masterDerivativeF) continue;
            AutoFunctorizingXSLTLinker.renameMismatchedParams(f2, masterDerivativeF.m_parameters);
        }
        m.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                FunctionCallInstruction fci;
                String newName;
                if (n2 instanceof FunctionCallInstruction && (newName = (String)map2.get((fci = (FunctionCallInstruction)n2).getFunction())) != null) {
                    fci.setFunction(newName);
                }
                return super.optimizeStep(n2);
            }
        });
    }

    public static void renameMismatchedParams(Function f2, Binding[] masterDerivativeParams) {
        final HashMap<Object, Binding> renamedBindings = new HashMap<Object, Binding>();
        for (int j = 0; j < f2.m_parameters.length; ++j) {
            if (f2.m_parameters[j].getName().equals(masterDerivativeParams[j].getName())) continue;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "renameMismatchedParams", "renaming " + f2.m_parameters[j] + " to " + masterDerivativeParams[j].getName());
            }
            renamedBindings.put(f2.m_parameters[j].getName(), f2.m_parameters[j]);
            f2.m_parameters[j].setName(masterDerivativeParams[j].getName());
        }
        if (renamedBindings.size() > 0) {
            new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction n2) {
                    Object v;
                    Binding b;
                    if (n2 instanceof IdentifierInstruction && (b = (Binding)renamedBindings.get(v = ((IdentifierInstruction)n2).getVariable())) != null && n2.getBindingEnvironment().getVariableBinding(v) == b) {
                        IdentifierInstruction n22 = new IdentifierInstruction(b.getName());
                        n22.setCachedType(b.getBindingType());
                        n22.setBindingEnvironment(n2.getBindingEnvironment());
                        return n22;
                    }
                    return n2;
                }
            }.optimizeFunction(f2);
        }
    }

    public static class Statistics {
        String[] m_modules;
        int m_total = 0;
        final HashMap m_counts = new HashMap();
        final HashMap m_goodCounts = new HashMap();
        final List[] m_uniqueFunctions;

        public Statistics(Module[] modules) {
            this.m_modules = new String[modules.length];
            this.m_uniqueFunctions = new List[modules.length];
            for (int i = 0; i < modules.length; ++i) {
                this.m_modules[i] = modules[i].getName();
                this.m_uniqueFunctions[i] = new LinkedList();
            }
        }

        public Statistics(String[] modules) {
            this.m_modules = new String[modules.length];
            this.m_uniqueFunctions = new List[modules.length];
            for (int i = 0; i < modules.length; ++i) {
                this.m_modules[i] = modules[i];
                this.m_uniqueFunctions[i] = new LinkedList();
            }
        }

        private void incr(Object key2, HashMap map2) {
            Integer c = (Integer)map2.get(key2);
            c = c == null ? new Integer(1) : new Integer(c + 1);
            map2.put(key2, c);
        }

        public void addUnique(FunctionSignature fs, int moduleIndex) {
            this.incr(this.m_modules[moduleIndex], this.m_counts);
            ++this.m_total;
        }

        public void add(FunctionSignature fs, int[] moduleIndecies, int score) {
            ++this.m_total;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < moduleIndecies.length; ++i) {
                sb.append(this.m_modules[moduleIndecies[i]]);
                if (i >= moduleIndecies.length - 1) continue;
                sb.append(',');
            }
            String key2 = sb.toString();
            this.incr(key2, this.m_counts);
            if (score > 0) {
                this.incr(key2, this.m_goodCounts);
            }
        }

        public void summarize() {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "summarize", "=== Overlap Detection SUMMARY ===");
            }
            ArrayList keys2 = new ArrayList(this.m_counts.keySet());
            Collections.sort(keys2, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    arg0 = Statistics.this.m_counts.get(arg0);
                    arg1 = Statistics.this.m_counts.get(arg1);
                    if (arg0 == null && arg1 == null) {
                        return 0;
                    }
                    if (arg0 == null) {
                        return -1;
                    }
                    if (arg1 == null) {
                        return 1;
                    }
                    return ((Integer)arg0).compareTo((Integer)arg1);
                }
            });
            Collections.reverse(keys2);
            Iterator i = keys2.iterator();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "summarize", "" + this.m_total + " total signatures");
            }
            while (i.hasNext()) {
                Object k = i.next();
                Integer c = (Integer)this.m_counts.get(k);
                Integer gc = (Integer)this.m_goodCounts.get(k);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "summarize", c + " functions common to " + k);
                }
                if (gc == null || !LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
                s_logger.logp(Level.FINER, s_className, "summarize", " of which " + gc + " could be merged");
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "summarize", "=================================");
            }
        }
    }

    public static class CodeCompressor
    extends PostOrderOptimizer {
        protected HashMap m_identifierMap = new HashMap();

        @Override
        public void optimizeFunction(Function f2) {
            if (f2.hasBeenTypeChecked() && !f2.getTypeEnvironment().getModule().m_signature.containsFunction(f2.getName())) {
                super.optimizeFunction(f2);
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            StreamInstruction si;
            TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
            if (n2 instanceof CoerceInstruction) {
                Type t2;
                CoerceInstruction ci = (CoerceInstruction)n2;
                Instruction x = ci.getOperand();
                Type t1 = ci.getType().resolveType(tenv);
                if (t1.equals(t2 = x.getCachedType().resolveType(tenv))) {
                    return x;
                }
            } else if (n2 instanceof AssertTypeInstruction) {
                AssertTypeInstruction ati = (AssertTypeInstruction)n2;
                Instruction x = ati.getOperand();
                if (ati.getType().equals(x.getCachedType().resolveType(tenv))) {
                    return x;
                }
            } else if (n2 instanceof IdentifierInstruction) {
                IdentifierInstruction ii = (IdentifierInstruction)n2;
                Type iiType = ii.getCachedType();
                Type t = iiType.resolveType(tenv);
                if (t != null) {
                    NameTypePair ntp = new NameTypePair(ii.getVariable(), t);
                    IdentifierReferenceInstruction iri2 = (IdentifierReferenceInstruction)this.m_identifierMap.get(ntp);
                    if (iri2 == null) {
                        iri2 = new IdentifierReferenceInstruction(ntp.m_name, ntp.m_type);
                        this.m_identifierMap.put(ntp, iri2);
                    }
                    return iri2;
                }
            } else if (n2 instanceof StreamInstruction && !(si = (StreamInstruction)n2).isStoredAsString() && si.getChildInstructionCount() == 1 && si.getChildInstruction(0).getCachedType().resolveType(tenv).equals(si.getCachedType().resolveType(tenv))) {
                return si.getChildInstruction(0);
            }
            return super.optimizeStep(n2);
        }

        public static final class NameTypePair {
            public Object m_name;
            public Type m_type;

            public NameTypePair(Object name2, Type type2) {
                this.m_name = name2;
                this.m_type = type2;
                if (this.m_type == null) {
                    throw new IllegalArgumentException();
                }
            }

            public int hashCode() {
                return this.m_name.hashCode() + this.m_type.hashCode();
            }

            public boolean equals(Object arg0) {
                if (!(arg0 instanceof NameTypePair)) {
                    return false;
                }
                NameTypePair ntp = (NameTypePair)arg0;
                return ntp.m_name.equals(this.m_name) && ntp.m_type.equals(this.m_type);
            }
        }
    }

    public static final class IdentifierReferenceInstruction
    extends ZeroArgPrimopInstruction {
        protected Type m_type;
        protected Object m_name;

        protected IdentifierReferenceInstruction(Object ident, Type type2) {
            this.setCachedType(type2);
            this.m_name = ident;
            this.m_type = type2;
        }

        @Override
        public String innerToString() {
            return "identifier-ref";
        }

        @Override
        protected Type getTypeForTypeAnnotationPrettyPrint() {
            Type t = this.getCachedType();
            if (t == null) {
                t = this.m_type;
            }
            return t;
        }

        @Override
        protected String toStringInnerNonChildParam() {
            return this.m_name.toString();
        }

        public IdentifierInstruction makeIdentifierInstruction() {
            return new IdentifierInstruction(this.m_name);
        }

        @Override
        public Instruction cloneWithoutTypeInformation() {
            return this;
        }

        @Override
        public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object arg0) {
            return arg0 != null && arg0 instanceof IdentifierReferenceInstruction && ((IdentifierReferenceInstruction)arg0).m_name.equals(this.m_name);
        }
    }
}

