/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Compiler
implements IXylemDriver {
    private static final Logger s_logger = LoggerUtil.getLogger(Compiler.class);
    private static final String s_className = Compiler.class.getName();
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();

    public static void main(String[] args) {
        CLP clp = new CLP();
        Compiler compiler = clp.m_compiler = new Compiler();
        if (!clp.parseCommandLine(args)) {
            System.exit(-1);
        }
        try {
            clp.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        compiler.m_mss = new ModuleSignatureStore(clp.m_signatureSearchPath);
        try {
            List modules = compiler.compileFiles(clp, null, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List compileFiles(CLP clp, Collection functionsToExport, boolean writeCX, boolean returnModules) {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (URL url : clp.m_files) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "compileFiles", "compiling " + url.getPath());
            }
            try {
                Module m = this.handleFile(url, clp, writeCX);
                if (!returnModules) continue;
                modules.add(m);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "compileFiles", "", e);
                throw new Error();
            }
        }
        return returnModules ? modules : null;
    }

    protected Module handleFile(URL url, CLP clp, boolean writeCX) {
        String s = url.toString();
        ModuleSignature ms = null;
        Module m = null;
        try {
            m = this.compile(url, clp, ms, clp.m_signatureSearchPath, this.m_mss);
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of " + url, e);
            System.exit(-1);
        }
        if (m.getName().equals("")) {
            String name2 = url.getPath();
            name2 = name2.substring(name2.lastIndexOf("/") + 1);
            name2 = name2.substring(0, name2.lastIndexOf(".xylem"));
            m.setName(name2);
        }
        if (writeCX) {
            String cxo = m.getName() + ".cxo";
            try {
                File cxoFile = new File(cxo);
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxoFile));
                Module.writeModule(oos, m);
                oos.flush();
                oos.close();
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred writing of compiled module to " + cxo, e);
                System.exit(-1);
            }
            String cxi = ModuleSignatureStore.makeFilename(m.getName()) + ".cxi";
            Compiler.writeOutSignature(m.m_signature, cxi);
        }
        return m;
    }

    public Module compile(URL sourceFile, CLP clp, ModuleSignature ms, List signatureSearchPath, ModuleSignatureStore mss) throws Exception {
        try {
            boolean v1 = clp.m_version.equals("1.0");
            Module rtlib = XSLTCompiler.loadRuntimeLibrary(false);
            XSLTCompilerSettings compilerSettings = new XSLTCompilerSettings();
            compilerSettings.setVersion(clp.m_version);
            Module module = XSLTCompiler.compileStylesheetToModule(sourceFile, rtlib, null, v1, compilerSettings);
            return module;
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "compile", "Error occurred compiling stylesheet " + sourceFile, e);
            return null;
        }
    }

    public static final void writeOutSignature(ModuleSignature ms, String cxi) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxi));
            ms.write(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + cxi, e);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature ms, String cxi, File outputDir) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(outputDir, cxi)));
            ms.write(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + cxi, e);
            System.exit(-1);
        }
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Compiler m_compiler;
        public String m_version = "1.0";

        @Override
        protected int parseOption(String[] args, int i) {
            if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
                System.out.println("Usage: Compiler\n\t[-[show]version]\n\t[-xslt-version 1.0|2.0]");
                super.parseOption(args, i);
                System.out.println("Input files should be be *.xylem or *.xylemi");
                System.out.println("\nRelease: Gustav-Mon-Jan-22-06:03:25-EST-2007");
                return -1;
            }
            if ("-version".equals(args[i]) || "-showversion".equals(args[i])) {
                System.out.println("Release: Gustav-Mon-Jan-22-06:03:25-EST-2007");
                return -1;
            }
            if (args[i].equals("-xslt-version")) {
                int j = i + 1;
                if (j >= args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                if (args[j].equals("1.0") || args[j].equals("2.0")) {
                    this.m_version = args[j];
                    return j;
                }
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version bad parameter: " + args[j]);
                return -1;
            }
            return super.parseOption(args, i);
        }
    }
}

