/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DumpXylemO {
    private static final Logger s_logger = LoggerUtil.getLogger(DumpXylemO.class);
    private static final String s_className = DumpXylemO.class.getName();

    public static void main(String[] args) {
        CommandLineParserSingleInputFile clp = new CommandLineParserSingleInputFile();
        if (!clp.parseCommandLine(args)) {
            return;
        }
        try {
            ArrayList<URL> list = new ArrayList<URL>();
            list.add(clp.m_inputFile);
            list.add(new File(".").toURL());
            ModuleSignatureStore mss = new ModuleSignatureStore(list);
            try {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Compiling, and obtaining signature for, runtime library");
                }
                boolean v1 = true;
                Module rtlib = XSLTCompiler.loadRuntimeLibrary(false);
                Program p = new Program();
                p.addModule(rtlib);
                String libname = rtlib.getName();
                mss.registerModuleSignature(libname, p.getModuleSignature(libname));
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "", e);
                throw new Error();
            }
            Module module = Module.readModule(new ObjectInputStream(clp.m_inputFile.openStream()), mss);
            module.dump(new PrintWriter(System.out));
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", e);
        }
    }
}

