/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XLTXEDesugarer;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaC;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Linker
implements IXylemDriver {
    static final boolean SHOW_CPP_RESULT = false;
    private static final Logger s_logger = LoggerUtil.getLogger(Linker.class);
    private static final String s_className = Linker.class.getName();
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();
    public boolean m_isPerf;
    public boolean m_dumpXylem;
    public CodeGenerationSettings m_codeGenerationSettings = new CodeGenerationSettings();

    public static int parseOptions(XSLTLinkerSettings settings, String[] args, int i) {
        if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
            System.out.println("\t[-outputdir dir]\n\t[-enabletracing]\n\t[-dumpxylem]\n\t[-dumpintermediatexylem]\n\t[-detectoverlap]\n\t[-classloaderproxy]");
            settings.getCodeGenerationSettings().parseOption(args, i);
            return -1;
        }
        if ("-classLoaderProxy".equals(args[i])) {
            settings.setGenerateClassLoadingProxy(true);
            return i;
        }
        if ("-detectoverlap".equals(args[i])) {
            settings.setOverlapDetection(true);
            return i;
        }
        if ("-dumpintermediatexylem".equals(args[i])) {
            settings.setDumpIntermediateXylem(true);
            return i;
        }
        if ("-dumpxylem".equals(args[i])) {
            settings.setDumpXylem(true);
            return i;
        }
        if ("-enabletracing".equals(args[i])) {
            settings.getCodeGenerationSettings().setFunctionCallTracing(true);
            return i;
        }
        if ("-outputdir".equals(args[i])) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOptions", "-outputdir missing parameter");
                return -1;
            }
            File file = new File(args[i]);
            settings.setOutputDir(file);
            if (!file.exists() || !file.isDirectory()) {
                s_logger.logp(Level.SEVERE, s_className, "parseOptions", "specified output directory does not exist or is not a directory: " + file);
                return -1;
            }
            return i;
        }
        return settings.getCodeGenerationSettings().parseOption(args, i);
    }

    public static void main(String[] args) {
        Linker linker;
        CLP clp = new CLP();
        clp.m_linker = linker = new Linker();
        SessionContext session = new SessionContext();
        if (!clp.parseCommandLine(args)) {
            System.exit(-1);
        }
        try {
            clp.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        linker.m_mss = new ModuleSignatureStore(clp.m_signatureSearchPath);
        linker.m_dumpXylem = linker.m_codeGenerationSettings.m_dumpxylem;
        try {
            File file;
            if (clp.m_files.size() > 1 || clp.m_linkerSettings.isOverlapDetection()) {
                s_logger.logp(Level.SEVERE, s_className, "main", "multiple XSLT input files/-functor/-overlapdetection not yet supported");
                System.exit(-1);
            }
            if ((file = linker.linkFiles(clp.m_files, clp.m_classNames, null, 0, clp, session)) != null && !linker.m_codeGenerationSettings.getJavaCSettings().isJavaCDisabled()) {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, linker.m_outputDir, null, null, linker.m_codeGenerationSettings.getJavaCSettings());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File linkFiles(List filesToLink, List classNames, Collection functionsToExport, int optimizationLevel, CLP clp, SessionContext session) {
        LinkedList<Module> modules = new LinkedList<Module>();
        Iterator i = filesToLink.iterator();
        try {
            boolean v1;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "linkFiles", "Compiling, and obtaining signature for, runtime library");
            }
            Module rtlib = (v1 = clp.m_version.equals("1.0")) ? XSLTCompiler.loadRuntimeLibrary(false) : XSLTCompiler.loadRuntimeLibrary(false);
            Program p = new Program();
            p.addModule(rtlib);
            String libname = rtlib.getName();
            this.m_mss.registerModuleSignature(libname, p.getModuleSignature(libname));
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "linkFiles", "", e);
            throw new Error();
        }
        while (i.hasNext()) {
            URL url = (URL)i.next();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "linkFiles", "linking " + url.getPath());
            }
            try {
                Module module = Module.loadCompiled(url, this.m_mss);
                modules.add(module);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "linkFiles", "", e);
                throw new Error();
            }
        }
        return this.linkModules(modules, classNames, functionsToExport, optimizationLevel, clp, session);
    }

    public File linkModules(List modules, List classNames, Collection functionsToExport, int optimizationLevel, CLP clp, SessionContext session) {
        try {
            boolean v1 = clp.m_version.equals("1.0");
            Module rtlib = v1 ? XSLTCompiler.loadRuntimeLibrary(false) : XSLTCompiler.loadRuntimeLibrary(false);
            Module module = (Module)modules.get(0);
            String moduleName = module.getName();
            XSLTLinker.s_linker.compileProgram(module, rtlib, 1, moduleName == null ? Collections.EMPTY_LIST : Collections.singletonList(moduleName), moduleName, clp.m_linkerSettings, session);
            File linkresult = new File(module.getName());
            if (linkresult == null || !linkresult.exists()) {
                System.exit(-1);
            }
            return linkresult;
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "linkModules", "linkModules failure\n", e);
            System.exit(-1);
            return null;
        }
    }

    protected void desugar(Program prog) {
        new XLTXEDesugarer(prog).desugar();
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Linker m_linker;
        public String m_version = "1.0";
        public ArrayList m_classNames = new ArrayList();
        public XSLTLinkerSettings m_linkerSettings = new XSLTLinkerSettings(new XSLTCompilerSettings());

        @Override
        protected int parseOption(String[] args, int i) {
            if (i == 0) {
                this.m_linkerSettings.setCodeGenSettings(this.m_linker.m_codeGenerationSettings);
            }
            if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
                System.out.println("Usage: Linker\n\t[-classname name]");
                Linker.parseOptions(this.m_linkerSettings, args, i);
                System.out.println("\t[-version (1.0 | 2.0)\n");
                System.out.println("\t[-classname name-of-compiled-class]");
                super.parseOption(args, i);
                System.out.println("Input file should be *.cxo");
                return -1;
            }
            if (args[i].equals("-classname")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-classname missing parameter");
                    return -1;
                }
                this.m_classNames.add(args[i]);
                return i;
            }
            if (args[i].equals("-version")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-version missing parameter");
                    return -1;
                }
                this.m_version = args[i];
                return i;
            }
            if (args[i].equals("-javac")) {
                s_logger.logp(Level.INFO, s_className, "parseOption", "-javac is now default; use -disablejavac to suppress");
                return i;
            }
            int j = this.m_linker.m_codeGenerationSettings.parseOption(args, i);
            if (j == -1) {
                return -1;
            }
            if (j != -2) {
                return j;
            }
            return super.parseOption(args, i);
        }
    }
}

