/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xml.ras.LoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

public class OverlapDetectionXSLTCompiler {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTCompiler.class);
    private static final String s_className = OverlapDetectionXSLTCompiler.class.getName();

    public static void main(String[] args) {
        CLP clp = new CLP();
        if (!clp.parseCommandLine(args)) {
            return;
        }
        try {
            Module rtlib = XSLTCompiler.loadRuntimeLibrary(false);
            for (int i = 0; i < clp.m_inputFiles.size(); ++i) {
                URL url = (URL)clp.m_inputFiles.get(i);
                Module m = OverlapDetectionXSLTCompiler.compileIndividualModule(url, rtlib, clp.m_settings);
                m.removeDeadFunctions();
                File out = (File)clp.m_outputFiles.get(i);
                if (clp.m_dumpXylem) {
                    File xylemDump = new File(out.getAbsolutePath() + ".xylem");
                    s_logger.logp(Level.INFO, s_className, "main", "Xylem dump being written to file " + xylemDump);
                    PrintWriter pw = new PrintWriter(new FileWriter(xylemDump));
                    m.dump(pw);
                    pw.close();
                }
                ParamReferenceIdentifier.createParamReferences(m);
                s_logger.logp(Level.INFO, s_className, "main", "Writing file " + out.getAbsolutePath());
                OverlapDetectionXSLTCompiler.writeIndividualModule(m, out);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", e);
        }
    }

    public static Module compileIndividualModule(URL url, Module rtlib, XSLTCompilerSettings settings) throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "compileIndividualModule", "Compiling stylesheet: " + url);
        }
        XSLTCompiler xsltCompiler = new XSLTCompiler(settings);
        xsltCompiler.setRuntimeLibrary(rtlib);
        InputStream stream2 = url.openStream();
        InputSource input = new InputSource(stream2);
        input.setSystemId(url.toString());
        XTQProgram stylesheet = xsltCompiler.buildAST(input, url.toString());
        Module compiledStSheet = xsltCompiler.translate(stylesheet);
        compiledStSheet.typeCheck(false);
        return compiledStSheet;
    }

    public static void writeIndividualModule(Module m, File file) throws Exception {
        WriteObjectFileHelper wofh;
        ObjectOutputStream oos;
        ArrayList<Function> functions = new ArrayList<Function>(m.getFunctions());
        Module.sortFunctionList(functions);
        Iterator<Object> i = functions.iterator();
        ByteArrayOutputStream bodyOS = new ByteArrayOutputStream();
        final HashMap instructionNames = new HashMap();
        ArrayList<Record> records = new ArrayList<Record>();
        while (i.hasNext()) {
            int start = bodyOS.size();
            oos = new ObjectOutputStream(bodyOS);
            wofh = new WriteObjectFileHelper(m, oos){

                @Override
                public void writeInstructionTag(Instruction x) throws IOException {
                    Integer key2 = (Integer)instructionNames.get(x.getClass());
                    if (key2 == null) {
                        key2 = new Integer(instructionNames.size());
                        instructionNames.put(x.getClass(), key2);
                    }
                    this.writeInt(key2);
                    this.writeType(x.getCachedType());
                }
            };
            Function function2 = i.next();
            FunctionSignature fs = new FunctionSignature(function2);
            boolean exported = m.m_signature.containsFunction(function2.getName());
            if (function2.isDerivative()) {
                fs.setFunctionName(function2.getOriginalFunction().getName());
            }
            function2.write(wofh);
            oos.close();
            int end = bodyOS.size();
            Record r = new Record(fs, start, end - start, function2.getName(), exported);
            records.add(r);
        }
        bodyOS.close();
        ByteArrayOutputStream headerOS = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(headerOS);
        wofh = new WriteObjectFileHelper(m, oos);
        wofh.writeInt(records.size());
        for (Record record : records) {
            wofh.writeInt(record.m_offset);
            wofh.writeInt(record.m_size);
            wofh.writeString(record.m_originalName);
            wofh.writeBoolean(record.m_exported);
            record.m_signature.write(wofh);
        }
        oos.writeInt(instructionNames.size());
        for (Map.Entry entry : instructionNames.entrySet()) {
            oos.writeObject(entry.getValue());
            oos.writeObject(entry.getKey());
        }
        oos.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataOutputStream dos = new DataOutputStream(fileOutputStream);
        byte[] header = headerOS.toByteArray();
        dos.writeInt(header.length);
        dos.flush();
        fileOutputStream.write(header);
        fileOutputStream.write(bodyOS.toByteArray());
        dos.close();
    }

    static class Record {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        boolean m_exported;

        Record(FunctionSignature fs, int offset, int size, String originalName, boolean exported) {
            this.m_signature = fs;
            this.m_offset = offset;
            this.m_size = size;
            this.m_originalName = originalName;
            this.m_exported = exported;
        }
    }

    private static class CLP
    extends CommandLineParserSingleInputFile {
        ArrayList m_inputFiles = new ArrayList();
        ArrayList m_outputFiles = new ArrayList();
        XSLTCompilerSettings m_settings = new XSLTCompilerSettings();
        boolean m_dumpXylem = false;

        private CLP() {
        }

        @Override
        protected int parseOption(String[] args, int i) {
            if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
                System.out.println("Usage: OverlapDetectionXSLTCompiler\n  [-help | -h | -?]          Prints this message\n  [-command commandfile]     Specifies a newline-delimited file with command line args\n  [-version | -showversion]  Prints the Xylem compiler version\n  [-xslt-version 1.0|2.0]    Specifies the version of XSLT to use\n  [-traceserialization]      Makes the translet insert diagnostic PIs into its output\n  [-dumpxylem]               Dumps out generated Xylem IL\n  [-traceimportsandincludes] Prints out the names/sizes of imported/included stylesheets\n  (input.xsl output.o)+      Compiles input.xsl into output.o\n");
                return -1;
            }
            if ("-command".equals(args[i])) {
                if (i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(args[++i])) {
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-xslt-version")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                this.m_settings.setVersion(args[i]);
                if (!args[i].equals("1.0") && !args[i].equals("2.0")) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid version: " + args[i]);
                    return -1;
                }
                return i;
            }
            if (args[i].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (args[i].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return i;
            }
            if (args[i].equals("-dumpxylem")) {
                this.m_dumpXylem = true;
                return i;
            }
            if (args[i].equals("-traceserialization")) {
                this.m_settings.setSerializationTraceEnabled(true);
                return i;
            }
            if (args[i].equals("-traceimportsandincludes")) {
                this.m_settings.setTraceImportsAndIncludes(true);
                return i;
            }
            if (i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "input filename " + args[i] + " missing corrsponding output filename");
                return -1;
            }
            this.m_inputFile = this.validateInputFilename(args[i], false);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_inputFiles.add(this.m_inputFile);
            this.m_outputFiles.add(new File(args[++i]));
            return i;
        }
    }
}

