/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XDMTypeUpdater;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverlapDetectionXSLTLinker {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTLinker.class);
    private static final String s_className = OverlapDetectionXSLTLinker.class.getName();

    public static void main(String[] args) {
        XSLTCompilerSettings compilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings linkerSettings = new XSLTLinkerSettings(compilerSettings);
        SessionContext session = new SessionContext();
        linkerSettings.setOverlapDetection(true);
        if (args.length == 0) {
            s_logger.logp(Level.INFO, s_className, "main", "Usage: OverlapDetectionXSLTLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int base2 = 0;
        while (base2 < args.length) {
            ArrayList<String> list;
            String opt = args[base2];
            if (opt.equals("-split")) {
                if (++base2 == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                    return;
                }
                compilerSettings.setPrereductionSplitLimit(Integer.parseInt(args[base2++]));
                continue;
            }
            if (opt.equals("-dumpxylem")) {
                linkerSettings.setDumpXylem(true);
                ++base2;
                continue;
            }
            if (opt.equals("-disablejavac")) {
                linkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++base2;
                continue;
            }
            if (opt.equals("-generateBCEL")) {
                linkerSettings.getCodeGenerationSettings().setTargetLanguage(4);
                ++base2;
                continue;
            }
            if (opt.equals("-suppressComments")) {
                linkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++base2;
                continue;
            }
            if (!opt.equals("-command")) break;
            if (++base2 == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                return;
            }
            try {
                String s;
                list = new ArrayList<String>();
                FileReader fr = new FileReader(args[base2]);
                BufferedReader br = new BufferedReader(fr);
                while ((s = br.readLine()) != null) {
                    if ((s = s.trim()).length() <= 0) continue;
                    list.add(s);
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not read command file " + args[base2], e);
                return;
            }
            args = list.toArray(args);
            base2 = 0;
            break;
        }
        try {
            HashMap functionMap = new HashMap();
            HashMap moduleMap = new HashMap();
            ArrayList xdmNames = new ArrayList();
            ArrayList xdmURIs = new ArrayList();
            ArrayList xdmTypes = new ArrayList();
            ArrayList<String> classNames = new ArrayList<String>();
            for (int i = 0; i < args.length - base2; i += 2) {
                File file = new File(args[i + base2]);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Reading catalog for module " + file);
                }
                String className = args[i + base2 + 1];
                OverlapDetectionXSLTLinker.readIndividualModule(i / 2, className, file, functionMap, moduleMap, xdmNames, xdmURIs, xdmTypes);
                classNames.add(className);
            }
            Module master = new Module((String)classNames.get(0), null, new ModuleSignature(""));
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Detecting overlap");
            }
            OverlapDetectionXSLTLinker.detectOverlap(master, functionMap, moduleMap, xdmNames, xdmURIs, xdmTypes, session);
            Module rtlib = XSLTCompiler.loadRuntimeLibrary(false);
            master.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", rtlib.m_signature, "xslt1"));
            AutoFunctorizingXSLTLinker.handleStandardExports(master);
            Iterator i = moduleMap.values().iterator();
            while (i.hasNext()) {
                ((ModuleRecord)i.next()).m_raf.close();
            }
            moduleMap = null;
            functionMap = null;
            ParamReferenceIdentifier.fixParamReferences(master);
            master.clearTypeInformation(true);
            master.removeFunctionDerivativeInformation(false);
            Program.dumpXylemFile(master, null, "master");
            XSLTCompiler.postASTProcessing(master, null, compilerSettings.getPrereductionSplitLimit(), compilerSettings.isStreamResultOnly());
            XSLTLinker.s_linker.compileProgram(master, rtlib, classNames.size(), classNames, master.getName(), linkerSettings, session);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", e);
        }
    }

    public static void detectOverlap(Module master, HashMap functionMap, HashMap moduleMap, ArrayList xdmNames, ArrayList xdmURIs, ArrayList xdmTypes, SessionContext session) throws Exception {
        byte[] buffer = new byte[0x100000];
        final HashMap<FunctionSignature, String> unifiedFunctionNameMap = new HashMap<FunctionSignature, String>();
        HashSet<String> usedNames = new HashSet<String>();
        for (FunctionSignature fs : functionMap.keySet()) {
            String name2 = fs.getFunctionName();
            int j = 0;
            while (usedNames.contains(name2)) {
                name2 = name2 + "$" + ++j;
            }
            unifiedFunctionNameMap.put(fs, name2);
            usedNames.add(name2);
        }
        ArrayList functionMapRecords = new ArrayList(functionMap.values());
        Collections.sort(functionMapRecords, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ArrayList al0 = (ArrayList)arg0;
                ArrayList al1 = (ArrayList)arg1;
                int diff = al1.size() - al0.size();
                if (diff != 0) {
                    return diff;
                }
                FunctionRecord fr0 = (FunctionRecord)al0.get(0);
                FunctionRecord fr1 = (FunctionRecord)al1.get(0);
                return fr0.m_signature.getFunctionName().compareTo(fr1.m_signature.getFunctionName());
            }
        });
        ArrayList<String> masterNames = new ArrayList<String>();
        ArrayList<String> masterURIs = new ArrayList<String>();
        ArrayList<Integer> masterTypes = new ArrayList<Integer>();
        Iterator namesIterator = xdmNames.iterator();
        Iterator urisIterator = xdmURIs.iterator();
        Iterator typesIterator = xdmTypes.iterator();
        Function namesFunc = null;
        Function urisFunc = null;
        Function typesFunc = null;
        Module junkModule = new Module("", null);
        int[][] masterIndices = new int[xdmNames.size()][];
        int modIndex = 0;
        while (namesIterator.hasNext()) {
            FunctionRecord namesFR = (FunctionRecord)namesIterator.next();
            FunctionRecord urisFR = (FunctionRecord)urisIterator.next();
            FunctionRecord typesFR = (FunctionRecord)typesIterator.next();
            namesFunc = OverlapDetectionXSLTLinker.readFunction(namesFR, moduleMap, buffer);
            urisFunc = OverlapDetectionXSLTLinker.readFunction(urisFR, moduleMap, buffer);
            typesFunc = OverlapDetectionXSLTLinker.readFunction(typesFR, moduleMap, buffer);
            namesFunc.typeCheckReduced(junkModule, new LinkedList());
            urisFunc.typeCheckReduced(junkModule, new LinkedList());
            typesFunc.typeCheckReduced(junkModule, new LinkedList());
            String[] names = XSLTLinker.retrieveXDMStringArray(namesFunc, session);
            String[] uris = XSLTLinker.retrieveXDMStringArray(urisFunc, session);
            int[] types2 = XSLTLinker.retrieveXDMIntArray(typesFunc, session);
            masterIndices[modIndex] = new int[names.length];
            int[] newIndices = masterIndices[modIndex];
            for (int j = 0; j < names.length; ++j) {
                newIndices[j] = -1;
                for (int k = 0; k < masterNames.size(); ++k) {
                    if (!XSLTLinker.areStringRefsEqual(masterNames.get(k), names[j]) || !XSLTLinker.areStringRefsEqual(masterURIs.get(k), uris[j]) || !masterTypes.get(k).equals(new Integer(types2[j]))) continue;
                    newIndices[j] = k;
                    break;
                }
                if (newIndices[j] != -1) continue;
                newIndices[j] = masterNames.size();
                masterNames.add(names[j]);
                masterURIs.add(uris[j]);
                masterTypes.add(new Integer(types2[j]));
            }
            ++modIndex;
        }
        String[] masterNamesArray = new String[masterNames.size()];
        masterNames.toArray(masterNamesArray);
        String[] masterURIsArray = new String[masterURIs.size()];
        masterURIs.toArray(masterURIsArray);
        namesFunc.setBody(XSLTLinker.makeStringArrayBody(masterNamesArray));
        urisFunc.setBody(XSLTLinker.makeStringArrayBody(masterURIsArray));
        typesFunc.setBody(XSLTLinker.makeIntArrayBody(masterTypes));
        master.addFunction(namesFunc);
        master.addFunction(urisFunc);
        master.addFunction(typesFunc);
        master.forceFunctionGeneration(namesFunc);
        master.forceFunctionGeneration(urisFunc);
        master.forceFunctionGeneration(typesFunc);
        block5: for (ArrayList list : functionMapRecords) {
            Iterator j = list.iterator();
            Instruction[] bodies = new Instruction[list.size()];
            Function[] functions = new Function[list.size()];
            int[] xToRealTable = new int[list.size()];
            int k = 0;
            while (j.hasNext()) {
                FunctionRecord fr = (FunctionRecord)j.next();
                Function f2 = null;
                f2 = OverlapDetectionXSLTLinker.readFunction(fr, moduleMap, buffer);
                if (f2.getName().equals("main")) {
                    f2.setName("main-functor");
                } else if (!(f2.getName().equals("setupOutput") || f2.getName().equals("whitespaceRules") || f2.getName().equals("setupCharacterMaps") || f2.getName().equals("get-ns-prefix-counter"))) {
                    if (fr.m_exported) {
                        if (master.getFunction(f2.getName()) != null) continue block5;
                        master.addFunction(f2);
                        master.forceFunctionGeneration(f2);
                        continue block5;
                    }
                    f2.setName((String)unifiedFunctionNameMap.get(fr.m_signature));
                }
                final ModuleRecord mr = (ModuleRecord)moduleMap.get(fr.m_moduleName);
                xToRealTable[k] = mr.m_index;
                XDMTypeUpdater xdmtu = new XDMTypeUpdater(){

                    @Override
                    protected Instruction optimizeStep2(Instruction n2) {
                        if (n2 instanceof FunctionCallInstruction) {
                            FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                            FunctionSignature fs = (FunctionSignature)mr.m_functionNames.get(fci.getFunction());
                            String newName = (String)unifiedFunctionNameMap.get(fs);
                            Instruction[] newParams = new Instruction[n2.getChildInstructionCount() + 1];
                            System.arraycopy(fci.m_parameters, 0, newParams, 1, fci.m_parameters.length);
                            newParams[0] = new IdentifierInstruction("__functorindex__");
                            fci.m_parameters = newParams;
                            fci.setFunction(newName);
                        }
                        return super.optimizeStep2(n2);
                    }
                };
                xdmtu.m_newIndices = masterIndices[mr.m_index];
                xdmtu.optimizeFunction(f2);
                functions[k] = f2;
                bodies[k++] = f2.getBody();
            }
            Function masterFunction = functions[0];
            boolean forceTopLevel = false;
            if (masterFunction.getName().equals("build_key")) {
                forceTopLevel = true;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "detectOverlap", "Merging function " + masterFunction.getName() + " from " + list.size() + " modules");
            }
            Binding[] newParams = new Binding[masterFunction.m_parameters.length + 1];
            System.arraycopy(masterFunction.m_parameters, 0, newParams, 1, masterFunction.m_parameters.length);
            newParams[0] = new Binding((Object)"__functorindex__", IntType.s_intType);
            masterFunction.m_parameters = newParams;
            Instruction combined = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(bodies, true, master, masterFunction, xToRealTable, moduleMap.size(), forceTopLevel, null);
            masterFunction.setBody(combined);
            master.addFunction(masterFunction);
        }
    }

    public static void readIndividualModule(int index2, String moduleName, File file, HashMap functionMap, HashMap moduleMap, ArrayList xdmNames, ArrayList xdmURIs, ArrayList xdmTypes) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(fis);
        ModuleRecord mr = new ModuleRecord();
        mr.m_baseOffset = dis.readInt() + 4;
        ObjectInputStream ois = new ObjectInputStream(dis);
        ReadObjectFileHelper rofh = new ReadObjectFileHelper(new ModuleSignature(), ois, new ModuleSignatureStore(Collections.EMPTY_LIST));
        mr.m_functionNames = new HashMap();
        int records = rofh.readInt();
        for (int i = 0; i < records; ++i) {
            FunctionRecord r = new FunctionRecord();
            r.m_offset = rofh.readInt();
            r.m_size = rofh.readInt();
            r.m_originalName = rofh.readString();
            r.m_exported = rofh.readBoolean();
            r.m_signature = new FunctionSignature();
            r.m_signature.read(rofh);
            r.m_moduleName = moduleName;
            ArrayList<FunctionRecord> list = (ArrayList<FunctionRecord>)functionMap.get(r.m_signature);
            if (list == null) {
                list = new ArrayList<FunctionRecord>();
                functionMap.put(r.m_signature, list);
            }
            list.add(r);
            mr.m_functionNames.put(r.m_originalName, r.m_signature);
            if (r.m_originalName.equals("xdm-names")) {
                xdmNames.add(r);
                continue;
            }
            if (r.m_originalName.equals("xdm-types")) {
                xdmTypes.add(r);
                continue;
            }
            if (!r.m_originalName.equals("xdm-uris")) continue;
            xdmURIs.add(r);
        }
        int c = ois.readInt();
        mr.m_instructionNames = new HashMap();
        for (int i = 0; i < c; ++i) {
            mr.m_instructionNames.put(ois.readObject(), ois.readObject());
        }
        fis.close();
        mr.m_raf = new RandomAccessFile(file, "r");
        mr.m_index = index2;
        moduleMap.put(moduleName, mr);
    }

    public static Function readFunction(FunctionRecord fr, HashMap moduleMap, byte[] buffer) throws Exception {
        final ModuleRecord mr = (ModuleRecord)moduleMap.get(fr.m_moduleName);
        if (buffer.length < fr.m_size) {
            buffer = new byte[fr.m_size];
        }
        mr.m_raf.seek(mr.m_baseOffset + fr.m_offset);
        mr.m_raf.read(buffer, 0, fr.m_size);
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bais);
        ReadObjectFileHelper rofh = new ReadObjectFileHelper(new ModuleSignature(), ois, new ModuleSignatureStore(Collections.EMPTY_LIST)){

            @Override
            public Instruction readInstruction(BindingEnvironment benv) throws Exception {
                int key2 = this.readInt();
                Class k = (Class)mr.m_instructionNames.get(new Integer(key2));
                Instruction n2 = (Instruction)k.newInstance();
                n2.setCachedType(this.readType());
                n2.read(this, benv);
                return n2;
            }
        };
        Function f2 = new Function();
        f2.read(rofh);
        return f2;
    }

    static class ModuleRecord {
        HashMap m_instructionNames;
        HashMap m_functionNames;
        RandomAccessFile m_raf;
        int m_baseOffset;
        int m_index;

        ModuleRecord() {
        }
    }

    static class FunctionRecord {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        String m_moduleName;
        boolean m_exported;

        FunctionRecord() {
        }
    }
}

