/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ZeroArgPrimopInstruction;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class ParamReferenceIdentifier
extends ZeroArgPrimopInstruction {
    private int m_paramIndex;

    public static void fixParamReferences(Module m) {
        m.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                if (n2 instanceof ParamReferenceIdentifier) {
                    ParamReferenceIdentifier pri = (ParamReferenceIdentifier)n2;
                    if (pri.m_paramIndex >= this.getCurrentFunction().m_parameters.length) {
                        throw new StaticError("ERR_SYSTEM", "oob " + pri.m_paramIndex + "/" + this.getCurrentFunction().m_parameters.length + " in " + this.getCurrentFunction());
                    }
                    Object v = this.getCurrentFunction().m_parameters[pri.m_paramIndex].getName();
                    n2 = new IdentifierInstruction(v);
                    n2.setCachedType(pri.getCachedType());
                    n2.setBindingEnvironment(pri.getBindingEnvironment());
                }
                return n2;
            }
        });
    }

    public static void createParamReferences(Module m) {
        m.optimize(new Optimizer(){
            HashMap m_paramIndecies = new HashMap();

            @Override
            public void optimizeFunction(Function f2) {
                this.m_paramIndecies.clear();
                for (int i = 0; i < f2.m_parameters.length; ++i) {
                    this.m_paramIndecies.put(f2.m_parameters[i].getName(), new Integer(i));
                }
                super.optimizeFunction(f2);
            }

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                Object v;
                Integer bi;
                if (n2 instanceof IdentifierInstruction && (bi = (Integer)this.m_paramIndecies.get(v = ((IdentifierInstruction)n2).getVariable())) != null && n2.getBindingEnvironment().getVariableBinding(v) == this.getCurrentFunction().m_parameters[bi]) {
                    ParamReferenceIdentifier n22 = new ParamReferenceIdentifier(bi, n2.getCachedType());
                    return n22;
                }
                return n2;
            }
        });
    }

    ParamReferenceIdentifier(int paramIndex, Type t) {
        this.setCachedType(t);
        this.m_paramIndex = paramIndex;
    }

    public ParamReferenceIdentifier() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return this;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        return this.getCachedType();
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.getCachedType();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInt(this.m_paramIndex);
        wofh.writeType(this.getCachedType());
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_paramIndex = rofh.readInt();
        this.setCachedType(rofh.readType());
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof ParamReferenceIdentifier)) {
            return false;
        }
        ParamReferenceIdentifier pri = (ParamReferenceIdentifier)arg0;
        return pri.m_paramIndex == this.m_paramIndex;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("PARAM", indent);
        pw.print("" + this.m_paramIndex);
        pw.printFormClose(indent);
    }
}

