/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SoftReferenceCache {
    private HashMap m_map = new HashMap();

    public synchronized void clear() {
        this.m_map.clear();
    }

    public synchronized void evict(String className) {
        this.m_map.remove(className);
    }

    public synchronized Object get(String className) {
        SoftListNode n2 = (SoftListNode)this.m_map.get(className);
        if (n2 == null) {
            return null;
        }
        this.m_map.put(className, n2.unlink());
        return n2.get();
    }

    public synchronized int count(String className) {
        int count2 = 0;
        SoftListNode n2 = (SoftListNode)this.m_map.get(className);
        while (n2 != null) {
            n2 = n2.m_next;
            ++count2;
        }
        return count2;
    }

    public synchronized Set getKeys() {
        return new HashSet(this.m_map.keySet());
    }

    public synchronized void cache(String className, Object v) {
        SoftListNode n2 = new SoftListNode(v);
        n2.link(this.m_map.put(className, n2));
    }

    private class SoftListNode
    extends SoftReference {
        private SoftListNode m_prev;
        private SoftListNode m_next;

        SoftListNode(Object referent) {
            super(referent);
        }

        private void link(SoftListNode next) {
            this.m_next = next;
            if (next != null) {
                this.m_next.m_prev = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            SoftReferenceCache softReferenceCache = SoftReferenceCache.this;
            synchronized (softReferenceCache) {
                this.unlink();
            }
            super.clear();
        }

        private SoftListNode unlink() {
            SoftListNode n2;
            if (this.m_prev != null) {
                this.m_prev.m_next = this.m_next;
            }
            if ((n2 = this.m_next) != null) {
                this.m_next.m_prev = this.m_prev;
            }
            return n2;
        }
    }
}

