/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.Linker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandaloneXSLTCompilerLinker {
    private static final Logger s_logger = LoggerUtil.getLogger(StandaloneXSLTCompilerLinker.class);
    private static final String s_className = StandaloneXSLTCompilerLinker.class.getName();

    public static void main(String[] args) {
        if (args.length == 0) {
            s_logger.logp(Level.INFO, s_className, "main", "Usage: StandaloneXSLTCompilerLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-classloaderproxy]\n        [-standardserializer]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        SessionContext session = new SessionContext();
        int base2 = 0;
        XSLTCompilerSettings compilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings linkerSettings = new XSLTLinkerSettings(compilerSettings);
        while (base2 < args.length) {
            ArrayList<String> list;
            String opt = args[base2];
            int i = Linker.parseOptions(linkerSettings, args, base2);
            if (i > 0) {
                base2 = i + 1;
                continue;
            }
            if (opt.equals("-split")) {
                if (++base2 == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                    return;
                }
                compilerSettings.setPrereductionSplitLimit(Integer.parseInt(args[base2++]));
                continue;
            }
            if (opt.equals("-newsplit")) {
                if (++base2 == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-newsplit missing parameter");
                    return;
                }
                try {
                    linkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(Integer.parseInt(args[base2]));
                }
                catch (NumberFormatException nfe) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "invalid split limit: " + args[base2]);
                    return;
                }
                ++base2;
                continue;
            }
            if (opt.equals("-dumpxylem")) {
                linkerSettings.setDumpXylem(true);
                ++base2;
                continue;
            }
            if (opt.equals("-disablejavac")) {
                linkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++base2;
                continue;
            }
            if (opt.equals("-classloaderproxy")) {
                linkerSettings.setGenerateClassLoadingProxy(true);
                ++base2;
                continue;
            }
            if (opt.equals("-standardserializer")) {
                compilerSettings.setStreamResultOnly(false);
                ++base2;
                continue;
            }
            if (opt.equals("-generateBCEL")) {
                linkerSettings.getCodeGenerationSettings().setTargetLanguage(4);
                ++base2;
                continue;
            }
            if (opt.equals("-generateFCGJava")) {
                linkerSettings.getCodeGenerationSettings().setTargetLanguage(3);
                ++base2;
                continue;
            }
            if (opt.equals("-suppressComments")) {
                linkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++base2;
                continue;
            }
            if (opt.equals("-xhtmlCompatability")) {
                compilerSettings.setXHTMLCompatability(true);
                ++base2;
                continue;
            }
            if (!opt.equals("-command")) break;
            if (++base2 == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-command requires parameter");
                return;
            }
            try {
                String s;
                list = new ArrayList<String>();
                FileReader fr = new FileReader(args[base2]);
                BufferedReader br = new BufferedReader(fr);
                while ((s = br.readLine()) != null) {
                    if ((s = s.trim()).length() <= 0) continue;
                    list.add(s);
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not read command file " + args[base2], e);
                return;
            }
            args = list.toArray(new String[0]);
            base2 = 0;
            break;
        }
        try {
            for (int i = 0; i < args.length - base2; ++i) {
                String classname = null;
                try {
                    File file = new File(args[i + base2]);
                    if (args[(i += 2) + base2 - 1].equals("-classname")) {
                        classname = args[base2 + i];
                        if (i == args.length) {
                            s_logger.logp(Level.SEVERE, s_className, "main", "-classname missing parameter");
                            throw new RuntimeException();
                        }
                    }
                    XSLTLinker.s_linker.compileStylesheet(file.toURL(), classname, compilerSettings, linkerSettings, session);
                    continue;
                }
                catch (Throwable e) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "", e);
                }
            }
            s_logger.info("Done");
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", e);
        }
    }
}

