/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.OptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.AutomatonFunctionCallExtractionOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.DataFlowAnalyzer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.GeneralCompareOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.GetLastOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.SimpleUnflattenStreamOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.SimpleUnflattenXDMSequenceOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.StringEqualityOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XDMSequenceOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XLTXEDesugarer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XPathStepOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTMinimalPartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XTypeStore;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadParameterEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.FlattenLetOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.InliningOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.LetLetOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.RepeatedExpressionOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.StaticStringTableOptimizer;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardOptimizationRegimen
extends OptimizationRegimen {
    private static final Logger s_logger = LoggerUtil.getLogger(StandardOptimizationRegimen.class);
    private static final String s_className = StandardOptimizationRegimen.class.getName();
    protected Program m_program;
    protected Module m_primaryModule;
    protected XSLTLinkerSettings m_linkerSettings;
    protected File m_dir;
    protected String m_className;
    protected Set m_entryPoints;
    private final boolean m_v2Regimen;
    private static boolean FORCEROUNDTRIP = false;
    private static final boolean ROUNDTRIPPRETTYPRINTANDPARSE = false;
    private static final boolean JUSTTURNALLDUMPON = false;
    public static final String DUMP_OPTION = "dumpfil";
    public static final boolean sDumpSome = HiddenOptions.wasSpecified("dumpfil") && !HiddenOptions.optionValueIs("dumpfil", "off");
    public static final String OPTIMIZATION_REPORT_OPTION = "optReport";
    public static final boolean sOptReport = HiddenOptions.wasSpecified("optReport") && !HiddenOptions.optionValueIs("optReport", "off");
    public static final boolean sDumpAll = sDumpSome && HiddenOptions.wasSpecified("dumpfil.all");
    private XTypeStore m_typeStore = null;
    protected IdentifierConsolidator m_ic;
    public static int optCounter = 0;

    public StandardOptimizationRegimen(String version) {
        this.m_v2Regimen = "2.0".equals(version);
    }

    protected void desugar() throws Exception {
        new XLTXEDesugarer(this.m_program).desugar();
    }

    protected void doPartialEvaluation() throws Exception {
        if (this.m_linkerSettings.isMinOptimizations()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Beginning minimal version of partial evaluation");
            }
            this.m_ic = new IdentifierConsolidator();
            XSLTPartialEvaluationSettings pes = new XSLTPartialEvaluationSettings(this.m_linkerSettings.getCodeGenerationSettings());
            XSLTMinimalPartialEvaluationOptimizer peo = new XSLTMinimalPartialEvaluationOptimizer(this.m_entryPoints, pes);
            peo.m_ic = this.m_ic;
            this.m_program.optimize(peo);
            peo = null;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Completed minimal version of partial evaluation");
            }
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Beginning partial evaluation");
            }
            this.m_ic = new IdentifierConsolidator();
            XSLTPartialEvaluationSettings pes = new XSLTPartialEvaluationSettings(this.m_linkerSettings.getCodeGenerationSettings());
            XSLTPartialEvaluationOptimizer peo = new XSLTPartialEvaluationOptimizer(this.m_entryPoints, pes);
            peo.m_ic = this.m_ic;
            this.m_program.optimize(peo);
            peo = null;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Completed partial evaluation");
            }
        }
    }

    @Override
    public void doOptimizations(XSLTLinkerSettings linkerSettings, final Program program, final Set entryPoints, File dir, String className, Module primaryModule, SessionContext session) throws Exception {
        boolean doWholeProgram = true;
        String debugFunctionSubname = "Search.Leftmodule.Listitem";
        File tempdir = dir;
        this.m_className = className;
        StuffNeededForDumpHelper dhArgs = new StuffNeededForDumpHelper(program, true, "Search.Leftmodule.Listitem", tempdir, className);
        this.m_linkerSettings = linkerSettings;
        this.m_program = program;
        this.m_entryPoints = entryPoints;
        this.m_dir = dir;
        this.m_primaryModule = primaryModule;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "doOptimizations", "Beginning optimizations");
        }
        if (DumpOption.INITIAL.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", tempdir, DumpOption.INITIAL.getOption());
        }
        if (DumpOption.POLYMORPHIC_ADT.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", tempdir, "pre-" + DumpOption.POLYMORPHIC_ADT.getOption());
        }
        new CallOpt(DumpOption.POLYMORPHIC_ADT, dhArgs){

            @Override
            public void opt() throws Exception {
                StandardOptimizationRegimen.this.desugar();
            }
        }.run();
        new CallOpt(DumpOption.REMOVEFUNCTIONDERIVATIVEINFORMATION, dhArgs){

            @Override
            public void opt() throws Exception {
                program.removeFunctionDerivativeInformation(false);
            }
        }.run();
        if (this.m_v2Regimen) {
            new CallOpt(DumpOption.POLYMORPHICADTDESUGARER, dhArgs){

                @Override
                public void opt() throws Exception {
                    new PolymorphicADTDesugarer(program).desugar();
                }
            }.run();
            new CallOpt(DumpOption.STATICSTRINGTABLE, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new StaticStringTableOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.PARTIAL_EVAL, dhArgs){

                @Override
                public void opt() throws Exception {
                    StandardOptimizationRegimen.this.m_ic = null;
                    StandardOptimizationRegimen.this.doPartialEvaluation();
                }
            }.run();
            new CallOpt(DumpOption.AUTOMATON_FUNCTION, dhArgs){

                @Override
                public void opt() throws Exception {
                    AutomatonFunctionCallExtractionOptimizer.doOptimization(program, entryPoints, StandardOptimizationRegimen.this.m_linkerSettings.getCodeGenerationSettings());
                }
            }.run();
            new CallOpt(DumpOption.REMOVEDEADFUNCTIONS, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.removeDeadFunctions();
                }
            }.run();
            new CallOpt(DumpOption.ELIMINATEDEADLETS, dhArgs){

                @Override
                public void opt() throws Exception {
                    DeadLetEliminatorOptimizer.eliminateDeadLets(program);
                }
            }.run();
            new CallOpt(DumpOption.DEAD_PARAMS, dhArgs){

                @Override
                public void opt() throws Exception {
                    DeadParameterEliminatorOptimizer.eliminateDeadParameters(program);
                }
            }.run();
            new CallOpt(DumpOption.DEAD_CODE, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.removeDeadFunctions();
                }
            }.run();
            new CallOpt(DumpOption.REMOVEFUNCTIONDERIVATIVEINFORMATION, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.removeFunctionDerivativeInformation(false);
                }
            }.run();
            new CallOpt(DumpOption.ELIMINATEDEADLETS, dhArgs){

                @Override
                public void opt() throws Exception {
                    DeadLetEliminatorOptimizer.eliminateDeadLets(program);
                }
            }.run();
            new CallOpt(DumpOption.STRING_EQUALITY, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new StringEqualityOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.INLINE, dhArgs, true){

                @Override
                public void opt() throws Exception {
                    if (InliningOptimizer.doInline) {
                        program.reTypeReduceRoundTrip("pre-inline", true);
                        program.optimize(new InliningOptimizer(false, new HashSet<String>(), 0, -1L));
                    }
                }
            }.run();
            new CallOpt(DumpOption.XPATHSTEP, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new XPathStepOptimizer());
                    assert (program.ensureGoodTypes());
                }
            }.run();
            new CallOpt(DumpOption.XDMSEQUENCE_OPT, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new XDMSequenceOptimizer());
                    assert (program.ensureGoodTypes());
                }
            }.run();
            new CallOpt(DumpOption.ELIMINATEDEADLETS, dhArgs){

                @Override
                public void opt() throws Exception {
                    DeadLetEliminatorOptimizer.eliminateDeadLets(program);
                }
            }.run();
            new CallOpt(DumpOption.REMOVEDEADFUNCTIONS, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.removeDeadFunctions();
                }
            }.run();
            new CallOpt(DumpOption.REMOVEFUNCTIONDERIVATIVEINFORMATION, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.removeFunctionDerivativeInformation(false);
                }
            }.run();
            new CallOpt(DumpOption.SIMPLEUNFLATTENXDMSEQUENCEOPTIMIZER, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new SimpleUnflattenXDMSequenceOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.SIMPLEUNFLATTENSTREAMOPTIMIZER, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new SimpleUnflattenStreamOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.GETLASTOPTIMIZER, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new GetLastOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.REPEATED_EXPRESSION, dhArgs){

                @Override
                public void opt() throws Exception {
                    RepeatedExpressionOptimizer ree = new RepeatedExpressionOptimizer();
                    ree.prescan(program);
                    program.optimize(ree);
                    program.typeCheckReduced();
                }
            }.run();
            new CallOpt(DumpOption.GETLASTOPTIMIZER, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new GetLastOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.FLATTENLETOPTIMIZER, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new FlattenLetOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.LETLET, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new LetLetOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.GENERALCOMPAREOPTIMIZER, dhArgs){

                @Override
                public void opt() throws Exception {
                    program.optimize(new GeneralCompareOptimizer());
                }
            }.run();
            new CallOpt(DumpOption.DATAFLOW, dhArgs){

                @Override
                public void opt() throws Exception {
                    DataFlowAnalyzer analyzerForCodeGen = new DataFlowAnalyzer(program);
                    analyzerForCodeGen.analyze();
                }
            }.run();
        }
        program.reTypeReduceRoundTrip("pre-code generation", true);
        if (DumpOption.FINAL.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", tempdir, DumpOption.FINAL.getOption());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "doOptimizations", "Finished optimizations");
        }
        this.m_linkerSettings = null;
        this.m_program = null;
        this.m_entryPoints = null;
        this.m_dir = null;
        this.m_className = null;
        this.m_primaryModule = null;
    }

    public static void optimizeForSequences(final Program program, boolean doWholeProgram, File tempdir, String className) throws TypeCheckException {
        StuffNeededForDumpHelper dhArgs = new StuffNeededForDumpHelper(program, doWholeProgram, "Search.Leftmodule.Listitem", tempdir, className);
        try {
            new CallOpt(DumpOption.XDMSEQUENCE_OPT, dhArgs){

                @Override
                public void opt() throws Exception {
                    new XDMSequenceOptimizer().optimizeModule(program);
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void dumpHelper2(boolean doWholeProgram, String debugFunctionName, File tempdir, String explanation, Program program) {
        if (doWholeProgram) {
            Program.dumpXylemFile(program, tempdir, "XSLTModule", explanation, false);
        } else {
            Program.dumpXylemFunctions(program.getSimilarFunctions(debugFunctionName), tempdir, "XSLTModule", explanation);
        }
    }

    protected void dumpHelper(boolean doWholeProgram, String debugFunctionName, File tempdir, String explanation) {
        if (doWholeProgram) {
            Program.dumpXylemFile(this.m_program, tempdir, this.m_className, explanation, false);
        } else {
            Program.dumpXylemFunctions(this.m_program.getSimilarFunctions(debugFunctionName), tempdir, this.m_className, explanation);
        }
    }

    public static abstract class CallOpt {
        protected final DumpOption dumpOption;
        protected final StuffNeededForDumpHelper dhArgs;
        protected final boolean doTypeCheck;

        public CallOpt(DumpOption dumpOption, StuffNeededForDumpHelper dhArgs) {
            this.dumpOption = dumpOption;
            this.dhArgs = dhArgs;
            this.doTypeCheck = FORCEROUNDTRIP;
        }

        public CallOpt(DumpOption dumpOption, StuffNeededForDumpHelper dhArgs, boolean doTypeCheck) {
            this.dumpOption = dumpOption;
            this.dhArgs = dhArgs;
            this.doTypeCheck = doTypeCheck;
        }

        public void run() throws Exception {
            this.dumpPreMaybe();
            long start = 0L;
            String reportString = null;
            int preInstrCount = 0;
            if (sOptReport) {
                InstructionCountAnalyzer ica = new InstructionCountAnalyzer();
                this.dhArgs.program.optimize(ica);
                reportString = "PRE: " + ica.count + " before, ";
                preInstrCount = ica.count;
                start = System.currentTimeMillis();
            }
            this.opt();
            if (sOptReport) {
                long end = System.currentTimeMillis();
                InstructionCountAnalyzer ica = new InstructionCountAnalyzer();
                this.dhArgs.program.optimize(ica);
                int diffInstructions = preInstrCount - ica.count;
                reportString = reportString + "POST: " + ica.count + " after, ";
                System.out.println(this.dumpOption.name() + ": " + diffInstructions + " instructions diff, " + reportString + "TIMEING: " + (end - start) + " milliseconds");
            }
            this.dumpPostMaybe();
            this.dhArgs.program.reTypeReduceRoundTrip(this.dumpOption.name(), this.doTypeCheck);
        }

        public abstract void opt() throws Exception;

        void dumpPreMaybe() {
            if (this.dumpOption.isEnabled()) {
                this.dumpHelper(this.dhArgs.doWholeProgram, this.dhArgs.debugFunctionName, this.dhArgs.tempdir, optCounter + "-pre-" + this.dumpOption.getOption());
            }
        }

        void dumpPostMaybe() {
            if (this.dumpOption.isEnabled()) {
                this.dumpHelper(this.dhArgs.doWholeProgram, this.dhArgs.debugFunctionName, this.dhArgs.tempdir, optCounter + "-post-" + this.dumpOption.getOption());
            }
            ++this.dhArgs.count;
            ++optCounter;
        }

        protected void dumpHelper(boolean doWholeProgram, String debugFunctionName, File tempdir, String explanation) {
            if (doWholeProgram) {
                Program.dumpXylemFile(this.dhArgs.program, tempdir, this.dhArgs.className, explanation, false);
            } else {
                Program.dumpXylemFunctions(this.dhArgs.program.getSimilarFunctions(debugFunctionName), tempdir, this.dhArgs.className, explanation);
            }
        }
    }

    public static class InstructionCountAnalyzer
    extends Optimizer {
        public int count = 0;

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            ++this.count;
            return super.optimizeStep(n2);
        }
    }

    public static class StuffNeededForDumpHelper {
        final Program program;
        final boolean doWholeProgram;
        final String debugFunctionName;
        final File tempdir;
        final String className;
        int count;

        public StuffNeededForDumpHelper(Program program, boolean doWholeProgram, String debugFunctionName, File tempdir, String className) {
            this.doWholeProgram = doWholeProgram;
            this.debugFunctionName = debugFunctionName;
            this.tempdir = tempdir;
            this.program = program;
            this.className = className;
            this.count = 0;
        }
    }

    public static enum DumpOption {
        LISTING("listing", HiddenOptions.wasSpecified("dumpfil.listing")),
        INITIAL("initial"),
        PARTIAL_EVAL("partial-eval"),
        POLYMORPHICADTDESUGARER("PolymorphicADTDesugarer"),
        REMOVEFUNCTIONDERIVATIVEINFORMATION("removeFunctionDerivativeInformation"),
        REMOVEDEADFUNCTIONS("removeDeadFunctions"),
        ELIMINATEDEADLETS("eliminateDeadLets"),
        DEADDECONSTRUCTIONELIMINATOROPTIMIZER("DeadDeconstructionEliminatorOptimizer"),
        XDMSEQUENCE_OPT("xdmsequenceopt"),
        DEAD_CODE("deadcode"),
        AUTOMATON_FUNCTION("automatonfunction"),
        REPEATED_EXPRESSION("repeatedexpression"),
        LOOP_INVARIANT("loopinvariant"),
        STRING_EQUALITY("stringequality"),
        DEAD_PARAMS("deadparams"),
        INLINE("inline"),
        POLYMORPHIC_ADT("polymorphicadtdesugarer"),
        GET_LAST("getlast"),
        DATAFLOW("dataflow"),
        FINAL("final"),
        LETLET("letlet"),
        XPATHSTEP("xpathstep"),
        STATICSTRINGTABLE("staticstringtable"),
        SIMPLEUNFLATTENXDMSEQUENCEOPTIMIZER("SimpleUnflattenXDMSequenceOptimizer"),
        FLATTENLETOPTIMIZER("FlattenLetOptimizer"),
        SIMPLEUNFLATTENSTREAMOPTIMIZER("SimpleUnflattenStreamOptimizer"),
        GETLASTOPTIMIZER("GetLastOptimizer"),
        GENERALCOMPAREOPTIMIZER("GeneralCompareOptmizer");

        private final String m_option;
        private final boolean m_enabled;

        private DumpOption(String option) {
            this.m_option = option;
            this.m_enabled = sDumpAll || sDumpSome && HiddenOptions.wasSpecified("dumpfil." + option);
        }

        private DumpOption(String option, boolean customEnablement) {
            this.m_option = option;
            this.m_enabled = customEnablement;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public String getOption() {
            return this.m_option;
        }
    }
}

