/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathInterpretedExecutable;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.SimpleErrorHandlerImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XPath2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.XPath2TypeChecker;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.builders.DynamicVariableBuilder;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;

public class XPathTranslatorDriver {
    static final boolean s_abe = false;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: XPathTranslatorDriver\n        [-notypecheck (of rt module)(default: true)]\n        [-notranslatortypecheck (default: true)]\n        [-removedeadfunctions (default: false)]\n        [-runover filename]\n        xpathExpression\n");
            return;
        }
        int base2 = 0;
        XSLTCompilerSettings compilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings linkerSettings = new XSLTLinkerSettings(compilerSettings);
        PrintStream out = System.out;
        boolean doRuntimeLibTypeCheck = true;
        boolean dotranslatortypecheck = true;
        boolean removeDeadFunctions = false;
        String filename = null;
        while (base2 < args.length) {
            String opt = args[base2];
            if (opt.equals("-dump")) {
                linkerSettings.setDumpXylem(true);
                ++base2;
                continue;
            }
            if (opt.equals("-notypecheck")) {
                doRuntimeLibTypeCheck = false;
                ++base2;
                continue;
            }
            if (opt.equals("-notranslatortypecheck")) {
                dotranslatortypecheck = false;
                ++base2;
                continue;
            }
            if (opt.equals("-removedeadfunctions")) {
                removeDeadFunctions = true;
                ++base2;
                continue;
            }
            if (!opt.equals("-runover")) break;
            filename = args[++base2];
            ++base2;
        }
        try {
            if (args.length - base2 != 1) {
                System.out.println("Expected xpath parameter");
                return;
            }
            String expression2 = args[base2];
            linkerSettings.setVersion("2.0");
            BasicStaticContext sc = new BasicStaticContext();
            sc.setLanguageTypeAndVersion(4);
            String uri2 = null;
            try {
                uri2 = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
            }
            catch (SecurityException e) {
                // empty catch block
            }
            sc.setBaseURI(uri2);
            SimpleErrorHandlerImpl eh = new SimpleErrorHandlerImpl();
            sc.setErrorHandler(null);
            XSLTParser parser = new XSLTParser(true, new XTQStaticContext(sc));
            XPathCompiler compiler = new XPathCompiler(compilerSettings.getVersion(), parser);
            compiler.setClassName("XPathModule");
            compiler.getCompilerSettings().setInterpreted(true);
            ModuleSignature xpathModuleSig = new ModuleSignature("XPathModule");
            ModuleSignature parentModuleSig = new ModuleSignature("");
            Module rtlib = compiler.loadRuntimeLibrary();
            if (!doRuntimeLibTypeCheck) {
                ModuleFunctionCallInstruction.LAZYMODULETYPECHECK = true;
            }
            compiler.setRuntimeLibrary(rtlib);
            Module module = new Module("XPathModule", null, parentModuleSig);
            module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt2", rtlib.m_signature, "xslt2"));
            Expr expr = XPathTranslatorDriver.buildAST(expression2, parser, compiler);
            XPath2Translator translator = new XPath2Translator(compiler);
            LetChainBuilder lcb = LetChainBuilder.newInstance(true);
            DynamicVariableBuilder dvb = DynamicVariableBuilder.newDVB();
            Instruction idInstruction = translator.compileNode(dvb, lcb, expr);
            Instruction body = lcb.packageUp(idInstruction);
            XDMItemType currentAndRootInputType = XDMItemType.s_itemType;
            Binding[] xpath20Parameters = new Binding[]{new Binding((Object)"__current__", currentAndRootInputType), new Binding((Object)"__contextposition__", IntType.s_intType), new Binding((Object)"__contextlast__", IntType.s_intType), new Binding((Object)"__othercontextinfo__", new NamedType("XSLT20ContextInfo"))};
            Function function2 = new Function("__xpath_function__", xpath20Parameters, body);
            module.addFunction(function2);
            lcb = lcb.newInstance();
            ArrayList<IdentifierInstruction> params = new ArrayList<IdentifierInstruction>();
            params.add(new IdentifierInstruction("__rootcursor__"));
            params.add(new IdentifierInstruction("__contextposition__"));
            params.add(new IdentifierInstruction("__contextlast__"));
            Instruction otherContextInfo = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)compiler, lcb, "constructContextInfo", params);
            Instruction[] instructions = new Instruction[]{new IdentifierInstruction("__rootcursor__"), new IdentifierInstruction("__contextposition__"), new IdentifierInstruction("__contextlast__"), otherContextInfo};
            Instruction callXPath20Function = lcb.bind(new FunctionCallInstruction("__xpath_function__", instructions));
            body = lcb.packageUp(callXPath20Function);
            Binding[] xpathParameters = new Binding[]{new Binding((Object)"__rootcursor__", currentAndRootInputType), new Binding((Object)"__contextposition__", IntType.s_intType), new Binding((Object)"__contextlast__", IntType.s_intType), new Binding((Object)"dynamicContext", FcgCodeGenHelper.DYNAMICCONTEXTFILTYPE)};
            function2 = new Function("__xpath_main__", xpathParameters, body);
            module.addFunction(function2);
            compiler.addPredefinedFunctions(module);
            compiler.addXDMFunctions(module);
            translator.generateTypeRegistryFunctions(module);
            module.addFunction(translator.createGetStaticNamespaceTablesFunction());
            module.exportAllSymbols();
            compiler.setStarletModule(module);
            ModuleSignature ms = new ModuleSignature("");
            Program program = new Program(ms);
            program.addModule(compiler.getStarletModule());
            program.addModule(compiler.getRuntimeLibrary());
            if (dotranslatortypecheck) {
                module.typeCheck(removeDeadFunctions);
            }
            PrintWriter outw = new PrintWriter(out);
            module.dump(outw);
            outw.close();
            SessionContext session = new SessionContext();
            if (filename != null) {
                System.out.println("Preparing the input stream: " + filename);
                RequestInfo request = new RequestInfo(Cursor.RANDOM_ACCESS, sc);
                FileInputStream is2 = new FileInputStream(filename);
                Cursor contextDoc = session.document(new StreamSource(is2), request);
                System.out.println("Executing the expression");
                BasicMutableDynamicContext dc = new BasicMutableDynamicContext(session, sc);
                int mathMode = sc.getIntegerMathMode();
                XPathInterpretedExecutable xie = new XPathInterpretedExecutable(program, null, mathMode == 2, mathMode == 3, new SessionContext());
                Cursor result2 = xie.execute(contextDoc, dc, Cursor.RANDOM_ACCESS, null);
                System.out.println(result2.getClass().getCanonicalName());
                System.out.println("<output>");
                if (null != result2) {
                    VolatileCData output = result2.serialize(null);
                    output.writeEncodedBytesTo(System.out, "UTF-8", (short)0, true);
                }
                System.out.println("</output>");
            }
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Expr buildAST(String expression2, XSLTParser parser, XPathCompiler compiler) throws Exception {
        Expr expr = parser.parseExpression(expression2);
        new XPath2TypeChecker(compiler).visitExpression(expr);
        if (parser.errorsFound()) {
            throw new XPathExpressionException(XMLMessages.createXMLMessage("ERR_FAIL_COMPILE_EXP", expression2));
        }
        return expr;
    }
}

