/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarLinker;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.VisitorBase;
import com.ibm.xltxe.rnm1.xtq.xslt.cmdline.utils.PrettyXylemListing;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.StandardOptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.DefaultXTQAnnotationHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.XSLT2TypeChecker;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTReverseInliningOptimizer;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.SimpleUnflattenStreamOptimizer;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XSLTCompiler
extends XPathCompiler {
    public static final boolean ENABLE_EXPERIMENT_OPTIMIZATIONS = false;
    private SourceLoader m_loader = null;
    private XTQProgram m_stylesheet = null;
    private int m_stylesheetSerial = 1;
    private int m_attributeSetSerial = 0;
    private Vector m_characterData;
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTCompiler.class);
    private static final String s_className = XSLTCompiler.class.getName();
    private boolean m_templateInlining = false;

    public XSLTCompiler() {
        this("1.0");
    }

    public XSLTCompiler(String xsltVersion) {
        this(xsltVersion, new XSLTParser(xsltVersion.equals("2.0"), new XStaticContext()));
    }

    public XSLTCompiler(String xsltVersion, XSLTParser parser) {
        super(xsltVersion, parser);
    }

    public XSLTCompiler(XSLTCompilerSettings settings) {
        super(settings.getVersion(), new XSLTParser(settings.getVersion().equals("2.0"), new XStaticContext()));
        this.m_compiSettings = settings;
        this.m_linkerSettings = new XSLTLinkerSettings(settings);
    }

    public XSLTCompiler(XSLTLinkerSettings settings) {
        super(settings.getVersion(), new XSLTParser(settings.getVersion().equals("2.0"), new XStaticContext()));
        this.m_compiSettings = settings.getCompilerSettings();
        this.m_linkerSettings = settings;
    }

    public void setXML10Only(boolean flag) {
        this.m_compiSettings.setXML10Only(flag);
        CodeGenerationSettings cgs = this.m_linkerSettings.getCodeGenerationSettings();
        this._parser.setXML10Only(flag);
    }

    public String getXSLTVersion() {
        return this.m_compiSettings.getVersion();
    }

    public Properties getOutputProperties() {
        Properties p = this._parser.getOutputProperties();
        return p;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_stylesheet = null;
        this.m_stylesheetSerial = 1;
        this.m_attributeSetSerial = 0;
    }

    public void setSourceLoader(SourceLoader loader) {
        this.m_loader = loader;
    }

    public SourceLoader getSourceLoader() {
        return this.m_loader;
    }

    public void setTemplateInlining(boolean templateInlining) {
        this.m_templateInlining = templateInlining;
    }

    public boolean getTemplateInlining() {
        return this.m_templateInlining;
    }

    public void setPIParameters(String media, String title, String charset) {
        this._parser.setPIParameters(media, title, charset);
    }

    public void handleXSLTCErrors(String source) {
        Vector v = this.getErrors();
        if (v != null) {
            for (ErrorMsg em : v) {
                s_logger.logrb(Level.SEVERE, s_className, "handleXSLTCErrors", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM", (Object)(source + ": " + em.toString()));
            }
        }
    }

    public boolean compile(URL url, SessionContext session) {
        try {
            InputStream stream2 = url.openStream();
            InputSource input = new InputSource(stream2);
            input.setSystemId(url.toString());
            return this.compile(input, this.m_className, session);
        }
        catch (IOException e) {
            this._parser.reportError(2, new ErrorMsg(e));
            return false;
        }
    }

    public boolean compile(URL url, String name2, SessionContext session) {
        try {
            InputStream stream2 = url.openStream();
            InputSource input = new InputSource(stream2);
            input.setSystemId(url.toString());
            return this.compile(input, name2, session);
        }
        catch (IOException e) {
            this._parser.reportError(2, new ErrorMsg(e));
            return false;
        }
    }

    public boolean compile(InputStream stream2, String name2, SessionContext session) {
        InputSource input = new InputSource(stream2);
        input.setSystemId(name2);
        return this.compile(input, name2, session);
    }

    public boolean compile(InputSource input, String name2, SessionContext session) {
        try {
            if (this.useMixedMode()) {
                this.setRuntimeSignature(this.loadRuntimeSignature());
            } else {
                this.setRuntimeLibrary(this.loadRuntimeLibrary());
            }
            XTQProgram stylesheet = this.buildAST(input, name2);
            Module compiledStSheet = this.translate(stylesheet);
            if (StandardOptimizationRegimen.DumpOption.LISTING.isEnabled()) {
                Module module = this.getStarletModule();
                PrettyXylemListing.MakeListing(module.getName(), new Module[]{module, this.getRuntimeLibrary()});
            }
            if (this.getDoPostASTProcessing()) {
                this.postASTProcessing(this.getRuntimeLibrary(), compiledStSheet, null);
            }
            ModuleSignature ms = new ModuleSignature("");
            Program program = new Program(ms);
            program.addModule(compiledStSheet);
            program.addModule(this.getRuntimeLibrary());
            this.linkAndCodeGen(program, this.getRuntimeLibrary(), compiledStSheet, session);
        }
        catch (WrappedRuntimeException wre) {
            this._parser.reportError(2, new ErrorMsg(wre), (Throwable)wre.getException());
        }
        catch (HandledRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this._parser.reportError(2, new ErrorMsg(e), (Throwable)e);
        }
        catch (Error e2) {
            this._parser.reportError(2, new ErrorMsg(e2), (Throwable)e2);
        }
        return !this.errorsFound();
    }

    public String getTransletSuperclassName() {
        return "com.ibm.xltxe.rnm1.xtq.ast.runtime.AbstractTranslet";
    }

    public Expr makeAST(InputSource input, String name2) {
        this.reset();
        String systemId = null;
        String publicId = null;
        if (input != null) {
            systemId = input.getSystemId();
            publicId = input.getPublicId();
        }
        if (this.m_className == null) {
            if (name2 != null) {
                this.setClassName(name2);
            } else if (systemId != null && !systemId.equals("")) {
                this.setClassName(Util.baseName(systemId));
            } else {
                this.setClassName("GregorSamsa");
            }
        }
        Expr element2 = null;
        XMLReader reader = this._parser.getXMLReader();
        element2 = reader == null ? this._parser.parse(input, null) : this._parser.parse(reader, input, null);
        if (!this.errorsFound() && element2 != null) {
            this.makeASTCompletion(systemId, publicId, element2);
        }
        return this.m_stylesheet;
    }

    public XTQProgram makeASTCompletion(String systemId, String publicId, Expr element2) {
        this.m_stylesheet = this._parser.makeStylesheet(element2);
        this.m_stylesheet.giveHighestImportPrecedence();
        this._parser.setTopLevelXTQProgram(this.m_stylesheet);
        this.m_stylesheet.setSourceLoader(this.m_loader);
        this.m_stylesheet.setSystemId(systemId, this._parser.getStaticContext().getBaseURI());
        this.m_stylesheet.setURI(systemId);
        this.m_stylesheet.setParentXTQProgram(null);
        this.m_stylesheet.setTemplateInlining(this.m_templateInlining);
        this._parser.setCurrentXTQProgram(this.m_stylesheet);
        this._parser.setCurrentImportPrecedence(this.m_stylesheet.getImportPrecedence());
        this._parser.createAST(this.m_stylesheet);
        if (!this.errorsFound()) {
            try {
                if (!this.m_compiSettings.getVersion().equals("2.0")) {
                    throw new RuntimeException("[XSLTCompiler] v1 deprecated");
                }
                XSLT2TypeChecker typechecker = new XSLT2TypeChecker(this);
                ((VisitorBase)typechecker).visitTree(this.m_stylesheet);
            }
            catch (WrappedRuntimeException wrte) {
                Exception e = wrte.getException();
                e = e instanceof TypeCheckError ? e : wrte;
                this._parser.reportError(3, new ErrorMsg(e));
            }
            catch (StaticError se) {
                ErrorMsg msg = se.getErrorMsg();
                if (msg == null) {
                    msg = new ErrorMsg(se, se.getNode());
                }
                this._parser.reportError(3, msg, se.getException());
            }
        }
        this.m_stylesheet.getImportPrecedence().computePrecedenceOnImportTree();
        return this.m_stylesheet;
    }

    public boolean compile(Vector stylesheets, SessionContext session) {
        int count2 = stylesheets.size();
        if (count2 == 0) {
            return true;
        }
        if (count2 == 1) {
            Object url = stylesheets.firstElement();
            if (url instanceof URL) {
                return this.compile((URL)url, session);
            }
            return false;
        }
        Enumeration urls = stylesheets.elements();
        while (urls.hasMoreElements()) {
            this.m_className = null;
            Object url = urls.nextElement();
            if (!(url instanceof URL) || this.compile((URL)url, session)) continue;
            return false;
        }
        return true;
    }

    public Vector getErrors() {
        return this._parser.getErrors();
    }

    public Vector getWarnings() {
        return this._parser.getWarnings();
    }

    public void printErrors() {
        this._parser.printErrors();
    }

    public void printWarnings() {
        this._parser.printWarnings();
    }

    public void setStylesheet(XTQProgram stylesheet) {
        if (this.m_stylesheet == null) {
            this.m_stylesheet = stylesheet;
        }
    }

    public XTQProgram getStylesheet() {
        return this.m_stylesheet;
    }

    public int nextStylesheetSerial() {
        return this.m_stylesheetSerial++;
    }

    public int nextAttributeSetSerial() {
        return this.m_attributeSetSerial++;
    }

    public void setDisableSetParameter(boolean diableSetParameter) {
        this.m_compiSettings.setDisableSetParameter(diableSetParameter);
    }

    public boolean disableSetParameter() {
        return this.m_compiSettings.getDisableSetParameter();
    }

    public String getCharacterData(int index2) {
        return ((StringBuffer)this.m_characterData.elementAt(index2)).toString();
    }

    public int getCharacterDataCount() {
        return this.m_characterData != null ? this.m_characterData.size() : 0;
    }

    public int addCharacterData(String newData) {
        StringBuffer currData;
        if (this.m_characterData == null) {
            this.m_characterData = new Vector();
            currData = new StringBuffer();
            this.m_characterData.addElement(currData);
        } else {
            currData = (StringBuffer)this.m_characterData.elementAt(this.m_characterData.size() - 1);
        }
        if (newData.length() + currData.length() > 21845) {
            currData = new StringBuffer();
            this.m_characterData.addElement(currData);
        }
        int newDataOffset = currData.length();
        currData.append(newData);
        return newDataOffset;
    }

    @Override
    public SourceLocation createSourceLocation(Expr node2) {
        return new SourceLocation(node2.getSystemId(), node2.getPublicId(), node2.getStartLineNumber(), node2.getStartColumnNumber(), node2.getEndLineNumber(), node2.getEndColumnNumber());
    }

    public XTQProgram buildAST(InputSource input, String name2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Started building AST");
        }
        XTQProgram result2 = (XTQProgram)this.makeAST(input, name2);
        if (this.errorsFound()) {
            Vector errors = this._parser.getErrors();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < errors.size(); ++i) {
                buffer.append(errors.elementAt(i));
            }
            if (buffer.length() > 0) {
                throw new RuntimeException(buffer.toString());
            }
            ErrorMsg msg = new ErrorMsg("STYLESHEET_ERRORS");
            throw new RuntimeException(msg.getFormattedMessage());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Finished building AST");
        }
        return result2;
    }

    public Module translate(XTQProgram stylesheet) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Started translating AST to FIL");
        }
        stylesheet.setCallsNodeset(this.callsNodeset());
        stylesheet.setHasIdCall(this.hasIdCall());
        Module result2 = null;
        if (!this.m_compiSettings.getVersion().equals("2.0")) {
            throw new RuntimeException("[XSLTCompiler] XSLT Translator v1 deprecated");
        }
        XSLT2Translator translator = new XSLT2Translator(this, DefaultXTQAnnotationHelper.createAnnotationHelper(this.getParser().getStaticContext().getLanguage(), this.getCompilerSettings()));
        ((VisitorBase)translator).visitTree(stylesheet);
        result2 = translator.getStylesheetModule();
        this.typeCheck(result2);
        if (this.errorsFound()) {
            ErrorMsg msg = new ErrorMsg("STYLESHEET_ERRORS");
            throw new RuntimeException(msg.getFormattedMessage());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Finished translating AST to FIL");
        }
        if (StandardOptimizationRegimen.sDumpSome) {
            Program.dumpXylemFile(result2, this.m_linkerSettings.getOutputDir(), result2.getName());
        }
        return result2;
    }

    public boolean errorsFound() {
        return this.getParser().errorsFound();
    }

    public void postASTProcessing(Module runtime, Module stylesheet, String functorName) throws Exception {
        try {
            if (functorName != null) {
                AutoFunctorizingXSLTCompiler.postASTProcessingForFunctor(this);
            } else {
                XSLTCompiler.postASTProcessing(stylesheet, runtime, this.getSplitLimit(), this.getCompilerSettings().isStreamResultOnly());
            }
        }
        catch (Exception e) {
            s_logger.logrb(Level.SEVERE, s_className, "postASTProcessing", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)e);
        }
    }

    public boolean isXHTMLCompatability() {
        return this.m_compiSettings.isXHTMLCompatability();
    }

    public void setXHTMLCompatability(boolean b) {
        this.m_compiSettings.setXHTMLCompatability(b);
    }

    public void typeCheck(Module module) {
        try {
            if (this.isInterpreted()) {
                module.typeCheck();
            } else {
                module.typeCheckReduced();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static final void postASTProcessing(Module m, Module runtimeLibrary, int prereductionSplitLimit, boolean xylemSerializer) throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "postASTProcessing", "Post-processing AST");
        }
        m.typeCheck();
        m.optimize(new PostOrderOptimizer(){

            @Override
            protected void optimizeChildren(Instruction n2) {
                StreamInstruction si;
                if (n2 instanceof StreamInstruction && (si = (StreamInstruction)n2).isString()) {
                    return;
                }
                super.optimizeChildren(n2);
            }

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                LetInstruction leti;
                if (n2 instanceof CoerceInstruction) {
                    CoerceInstruction ci = (CoerceInstruction)n2;
                    TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
                    if (ci.getType().equals(ci.getOperand().getCachedType().resolveType(tenv))) {
                        return ci.getOperand();
                    }
                } else if (n2 instanceof AssertTypeInstruction) {
                    AssertTypeInstruction ci = (AssertTypeInstruction)n2;
                    TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
                    if (ci.getType().equals(ci.getOperand().getCachedType().resolveType(tenv))) {
                        return ci.getOperand();
                    }
                } else if (n2 instanceof LetInstruction && (leti = (LetInstruction)n2).getBody() instanceof LiteralInstruction) {
                    return leti.getBody();
                }
                return n2;
            }
        });
        if (0 != prereductionSplitLimit) {
            m.optimize(new SimpleUnflattenStreamOptimizer(prereductionSplitLimit));
            m.optimize(new XSLTReverseInliningOptimizer(prereductionSplitLimit));
            m.clearTypeInformation(true);
        }
        m.typeCheck();
        m.reduce();
        m.formalizeSignature("");
    }

    public static Module compileStylesheetToModule(URL source, Module rtlibModule, ModuleSignature ms, boolean doPostASTProcessing, XSLTCompilerSettings settings, SourceLoader sl, boolean topResolve) throws Exception {
        InputSource input;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "compileStylesheetToModule", "Compiling stylesheet: " + source);
        }
        XSLTCompiler xsltCompiler = new XSLTCompiler(settings);
        if (null != sl) {
            xsltCompiler.setSourceLoader(sl);
        }
        xsltCompiler.setModuleSignature(ms);
        xsltCompiler.setRuntimeLibrary(rtlibModule);
        if (null != sl && topResolve) {
            input = sl.loadSource("", source.toString(), null);
        } else {
            InputStream stream2 = source.openStream();
            input = new InputSource(stream2);
            input.setSystemId(source.toString());
        }
        XTQProgram stylesheet = xsltCompiler.buildAST(input, source.toString());
        Module compiledStSheet = xsltCompiler.translate(stylesheet);
        if (doPostASTProcessing) {
            xsltCompiler.postASTProcessing(rtlibModule, compiledStSheet, null);
        }
        return compiledStSheet;
    }

    public static Module compileStylesheetToModule(URL source, Module rtlibModule, ModuleSignature ms, boolean doPostASTProcessing, XSLTCompilerSettings settings) throws Exception {
        return XSLTCompiler.compileStylesheetToModule(source, rtlibModule, ms, doPostASTProcessing, settings, null, false);
    }

    public String getFunctorName() {
        return this.m_linkerSettings.getFunctorName();
    }

    public void setFunctorName(String name2) {
        this.m_linkerSettings.setFunctorName(name2);
    }

    public String getFunctorParamLocalName() {
        return this.m_linkerSettings.getFunctorParamLocalName();
    }

    public void setFunctorParamLocalName(String paramLocalName) {
        this.m_linkerSettings.setFunctorParamLocalName(paramLocalName);
    }

    public ModuleSignature getFunctorParamSignature() {
        return this.m_linkerSettings.getFunctorParamSignature();
    }

    public void setFunctorParamSignature(ModuleSignature paramSignature) {
        this.m_linkerSettings.setFunctorParamSignature(paramSignature);
    }

    public Functor getXylemFunctorOutput() {
        return this.m_linkerSettings.getXylemFunctorOutput();
    }

    public void setXylemFunctorOutput(Functor functorOutput) {
        this.m_linkerSettings.setXylemFunctorOutput(functorOutput);
    }

    @Override
    public XStarLinker getLinker() {
        return XSLTLinker.s_linker;
    }
}

