/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.XFactoryUtils;
import com.ibm.xml.xci.serializer.SAX2DOM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSLTDumpingParser
extends XSLTParser {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTDumpingParser.class);
    private static final String s_className = XSLTDumpingParser.class.getName();
    private SessionContext m_session;
    private int stylesheetCount;
    private SAX2DOM m_s2d;

    public XSLTDumpingParser(boolean isXSLT20, XStaticContext context2, SessionContext session) {
        super(isXSLT20, context2);
        this.m_session = session;
    }

    @Override
    public Expr parse(XMLReader reader, InputSource input, Expr astExpr) {
        String filename = "xslt-dump-" + ++this.stylesheetCount;
        if (Program.TIMESTAMPED_DUMPS) {
            filename = filename + "." + System.currentTimeMillis();
        }
        filename = filename + ".xsl";
        SAX2DOM prev_s2d = this.m_s2d;
        SAX2DOM s2d = null;
        try {
            this.m_s2d = s2d = new SAX2DOM();
        }
        catch (ParserConfigurationException pce) {
            s_logger.logrb(Level.WARNING, s_className, "parse", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)pce);
        }
        Expr result2 = super.parse(reader, input, astExpr);
        if (s2d != null) {
            this.m_s2d = prev_s2d;
            Cursor cursor2 = XFactoryUtils.getDocument(new DOMSource(s2d.getDOM()), this.m_session, false);
            File f2 = new File(filename);
            try {
                PrintStream ps = new PrintStream(f2);
                ps.println("<!-- systemId: " + input.getSystemId() + " -->");
                ps.println();
                cursor2.copyToResult(new StreamResult(ps), null, false, true);
                ps.close();
                s_logger.logrb(Level.INFO, s_className, "parse", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{f2.getCanonicalPath()});
                return result2;
            }
            catch (IOException io) {
                s_logger.logrb(Level.WARNING, s_className, "parse", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)io);
            }
        }
        return result2;
    }

    @Override
    public void characters(char[] ch, int start, int length2) {
        this.m_s2d.characters(ch, start, length2);
        super.characters(ch, start, length2);
    }

    @Override
    public void endDocument() {
        this.m_s2d.endDocument();
        super.endDocument();
    }

    @Override
    public void endElement(String uri2, String localname2, String qname2) {
        this.m_s2d.endElement(uri2, localname2, qname2);
        super.endElement(uri2, localname2, qname2);
    }

    @Override
    public void endPrefixMapping(String prefix2) {
        this.m_s2d.endPrefixMapping(prefix2);
        super.endPrefixMapping(prefix2);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length2) {
        this.m_s2d.ignorableWhitespace(ch, start, length2);
        super.ignorableWhitespace(ch, start, length2);
    }

    @Override
    public void processingInstruction(String name2, String value2) {
        this.m_s2d.processingInstruction(name2, value2);
        super.processingInstruction(name2, value2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_s2d.setDocumentLocator(locator);
        super.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name2) {
        this.m_s2d.skippedEntity(name2);
        super.skippedEntity(name2);
    }

    @Override
    public void startDocument() {
        this.m_s2d.startDocument();
        super.startDocument();
    }

    @Override
    public void startElement(String uri2, String localname2, String qname2, Attributes attributes2) throws SAXException {
        this.m_s2d.startElement(uri2, localname2, qname2, attributes2);
        super.startElement(uri2, localname2, qname2, attributes2);
    }

    @Override
    public void startPrefixMapping(String prefix2, String uri2) {
        this.m_s2d.startPrefixMapping(prefix2, uri2);
        super.startPrefixMapping(prefix2, uri2);
    }

    @Override
    public void comment(char[] ch, int start, int length2) throws SAXException {
        this.m_s2d.comment(ch, start, length2);
        super.comment(ch, start, length2);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_s2d.endCDATA();
        super.endCDATA();
    }

    @Override
    public void endDTD() throws SAXException {
        this.m_s2d.endDTD();
        super.endDTD();
    }

    @Override
    public void endEntity(String name2) throws SAXException {
        this.m_s2d.endEntity(name2);
        super.endEntity(name2);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_s2d.startCDATA();
        super.startCDATA();
    }

    @Override
    public void startDTD(String name2, String publicId, String systemId) throws SAXException {
        this.m_s2d.startDTD(name2, publicId, systemId);
        super.startDTD(name2, publicId, systemId);
    }

    @Override
    public void startEntity(String name2) throws SAXException {
        this.m_s2d.startEntity(name2);
        super.startEntity(name2);
    }
}

