/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.Version;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIExecutable;
import com.ibm.xltxe.rnm1.xtq.exec.XDynamicContextImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XOutputParametersImpl;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.runtime.Recyclable;
import com.ibm.xltxe.rnm1.xtq.scontext.MergedCharacterMapsManager;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.AbstractTranslet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.InterpretedTranslet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.OutputProperties;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.WhitespaceHelper;
import com.ibm.xltxe.rnm1.xylem.utils.OverflowException;
import com.ibm.xltxe.rnm1.xylem.utils.RuntimeTerminateException;
import com.ibm.xltxe.rnm1.xylem.utils.XSLTArgumentNodeMissingTypedValueException;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XOutputParameters;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.XFactoryUtils;
import com.ibm.xml.xci.type.SchemaResolver;
import com.ibm.xml.xci.type.SequenceType;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.wrappers.StripWhitespaceFilter;
import java.io.CharArrayReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class XSLTExecutable
extends AbstractSPIExecutable {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTExecutable.class);
    private static final String s_className = XSLTExecutable.class.getName();
    private CursorFactory m_resultTreeCursorFactory;
    private OutputProperties m_outputProperties;
    private MergedCharacterMapsManager m_charMapManager;
    private HashMap<String, Object> m_properties;
    private AbstractTranslet m_cachedTranslet;
    private TypeRegistry m_clonedTypeRegistry;
    private HashMap<String, SequenceType> m_stylesheetFunctions;
    private HashMap<String, SequenceType[]> m_stylesheetFunctionParams;
    private HashMap<String, SequenceType> m_extensionFunctions;
    private HashMap<String, SequenceType[]> m_extensionFunctionParams;
    public static final String CACHE_TEMP_TREES = "CacheTrees";

    public XSLTExecutable(SessionContext session) {
        super(session);
        int id2 = AbstractStarlet.USE_CACHE_TREES ? session.getDataProviderID("com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory") : session.getDataProviderID("com.ibm.xml.xci.adapters.dom.DOMCursorFactory");
        this.m_resultTreeCursorFactory = session.getCursorFactory(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor execute(Cursor source, DynamicContext dynamicContext, Cursor.Profile requestedFeatures, Cursor[] args) {
        assert (null != dynamicContext);
        assert (source == null || source.factory().getSessionContext() == dynamicContext.getSessionContext());
        AbstractTranslet translet = null;
        try {
            translet = this.getTranslet(dynamicContext);
            Cursor cursor2 = this.execute(source, dynamicContext, translet, requestedFeatures, args, null);
            return cursor2;
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
            if (translet.isXSLMessageTerminate()) {
                throw new XProcessException(XMLMessages.createXMLMessage("ER_API_XSLT_EXECUTION_TERMINATED", new Object[]{e.getMessage()}), null);
            }
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_EXECUTION_TERMINATED", new Object[]{e.getMessage()}), null);
        }
        catch (RuntimeTerminateException e) {
            this.reportError(dynamicContext, e, translet.isXSLMessageTerminate());
        }
        catch (Exception e) {
            this.reportError(dynamicContext, e, translet.isXSLMessageTerminate());
        }
        finally {
            if (translet instanceof Recyclable) {
                ((Recyclable)((Object)translet)).recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Cursor source, DynamicContext dynamicContext, Cursor.Profile requestedFeatures, Cursor[] args, Result result2) {
        assert (null != dynamicContext);
        assert (source == null || source.factory().getSessionContext() == dynamicContext.getSessionContext());
        AbstractTranslet translet = null;
        try {
            translet = this.getTranslet(dynamicContext);
            this.execute(source, dynamicContext, translet, requestedFeatures, args, result2);
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
            if (translet.isXSLMessageTerminate()) {
                throw new XProcessException(XMLMessages.createXMLMessage("ER_API_XSLT_EXECUTION_TERMINATED", new Object[]{e.getMessage()}), null);
            }
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_EXECUTION_TERMINATED", new Object[]{e.getMessage()}), null);
        }
        catch (RuntimeTerminateException e) {
            this.reportError(dynamicContext, e, translet.isXSLMessageTerminate());
        }
        catch (Exception e) {
            this.reportError(dynamicContext, e, translet.isXSLMessageTerminate());
        }
        finally {
            if (translet instanceof Recyclable) {
                ((Recyclable)((Object)translet)).recycle();
            }
        }
    }

    private Cursor execute(Cursor source, DynamicContext dynamicContext, AbstractTranslet translet, Cursor.Profile requestedFeatures, Cursor[] args, Result result2) throws Exception {
        this.initializeBindings(dynamicContext);
        if (s_logger.isLoggable(Level.CONFIG)) {
            boolean interpret = translet instanceof InterpretedTranslet;
            String messageCode = interpret ? "EXECUTE_XSLT_INTERPRETER" : "EXECUTE_XSLT_COMPILER";
            String transletDescription = interpret ? translet.getStylesheetURI() : translet.getClass().getName() + "; " + translet.getStylesheetURI();
            s_logger.logrb(Level.CONFIG, s_className, "execute", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", messageCode, new Object[]{transletDescription, Version.getVersion()});
        }
        if (DUMP_INPUT) {
            this.dumpInput(source);
        }
        Cursor resultCursor = null;
        Object sourceStripList = null;
        Object sourcePreserveList = null;
        if (this.m_properties == null) {
            this.getProperties();
        }
        source = XFactoryUtils.applyInputFiltersXSLT(source, this.m_properties);
        try {
            resultCursor = translet.evaluate(source, dynamicContext, result2);
        }
        catch (ArithmeticException ae) {
            if (SOURCE_LINE_INFO) {
                throw new RuntimeTerminateException(ae);
            }
            BasisLibrary2.runTimeError("ERR_DIVISION_BY_ZERO");
        }
        catch (OverflowException oe) {
            if (SOURCE_LINE_INFO) {
                throw new RuntimeTerminateException(oe);
            }
            BasisLibrary2.runTimeError("ERR_OVERFLOW");
        }
        catch (XSLTArgumentNodeMissingTypedValueException xanmtve) {
            if (SOURCE_LINE_INFO) {
                throw new RuntimeTerminateException(xanmtve);
            }
            BasisLibrary2.runTimeError("ERR_NO_TYPE_VALUE");
        }
        return resultCursor;
    }

    @Override
    public void execute(Cursor focus, Cursor.Area resultArea, Cursor result2, DynamicContext context2, Cursor.Profile requestedFeatures, Cursor[] args) {
        if (result2 == null) {
            throw new IllegalArgumentException("Cursor result must not be null!");
        }
        Cursor refResult = this.execute(focus, context2, requestedFeatures, args);
        if (refResult != null) {
            result2.addCopy(resultArea, refResult);
            refResult.release();
        }
    }

    public XOutputParameters getSerializerParameters() {
        return this.getSerializerParameters(null);
    }

    public XOutputParameters getSerializerParameters(QName qname2) {
        String version;
        Properties properties;
        String name2 = qname2 == null ? "" : qname2.toString();
        XOutputParameters params = null;
        OutputProperties outputProperties = this.getOutputProperties();
        if (outputProperties != null && (properties = outputProperties.getOutputProperties(name2)) != null) {
            params = AbstractTranslet.outputPropertiesToMap(properties, this.getCharMapManager());
        }
        if (params == null) {
            if (qname2 == null) {
                params = new XOutputParametersImpl();
            } else {
                return null;
            }
        }
        if ((version = this.getStylesheetVersion()) != null && version.equals("1.0")) {
            params.setBackwardsCompatible(true);
        }
        return params;
    }

    private AbstractTranslet getTranslet(DynamicContext context2) throws Exception {
        AbstractTranslet translet = this.createTranslet(this.m_session, this.getTypeRegistry());
        translet.postInitialization();
        translet.setErrorHandler(this.getErrorHandler(context2));
        this.initializeApplyTemplatesDispatchIDTable(translet);
        translet.setResultResolver(context2.getResultResolver());
        translet.setResultTreeCursorFactory(this.m_resultTreeCursorFactory);
        translet.setExecutionTraceEnabled(this.getExecutionTraceEnabled());
        return translet;
    }

    protected abstract AbstractTranslet createTranslet(SessionContext var1, TypeRegistry var2);

    private OutputProperties getOutputProperties() {
        if (this.m_outputProperties == null) {
            AbstractTranslet translet = this.getCachedTranslet();
            this.m_outputProperties = translet != null ? translet.getOutputProperties() : new OutputProperties();
        }
        return this.m_outputProperties;
    }

    private MergedCharacterMapsManager getCharMapManager() {
        if (this.m_charMapManager == null) {
            AbstractTranslet translet = this.getCachedTranslet();
            this.m_charMapManager = translet != null ? translet.getMergedCharacterMapsManager() : new MergedCharacterMapsManager();
        }
        return this.m_charMapManager;
    }

    private String getStylesheetVersion() {
        AbstractTranslet translet = this.getCachedTranslet();
        if (translet != null) {
            return translet.getStylesheetVersion();
        }
        return null;
    }

    public void registerImportedSchemas(SessionContext session) {
        List<Source> schemaSources = null;
        try {
            Object transletKey;
            WeakHashMap<Object, Boolean> registeredSchemas = (WeakHashMap<Object, Boolean>)session.getUserData(AbstractTranslet.REGISTERED_SCHEMAS_SESSION_DATA_KEY);
            if (registeredSchemas == null) {
                registeredSchemas = new WeakHashMap<Object, Boolean>();
                session.setUserData(AbstractTranslet.REGISTERED_SCHEMAS_SESSION_DATA_KEY, registeredSchemas);
            }
            if (!registeredSchemas.containsKey(transletKey = this.transletKey())) {
                schemaSources = this.getImportedSchemas(session);
                registeredSchemas.put(transletKey, Boolean.TRUE);
            }
        }
        catch (ClassCastException cce) {
            schemaSources = this.getImportedSchemas(session);
        }
        if (schemaSources != null) {
            session.getTypeRegistry().load(schemaSources);
        }
    }

    protected abstract Object transletKey();

    @Override
    public void loadSchema(XDynamicContextImpl dc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getProperties() {
        if (this.m_properties == null) {
            XSLTExecutable xSLTExecutable = this;
            synchronized (xSLTExecutable) {
                Map<String, String> variableMap;
                Map<String, String> functionMap;
                if (this.m_properties != null) {
                    return this.m_properties;
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                WhitespaceHelper.WhitespaceRule[] whitespaceRules = this.getWhitespaceRules();
                if (whitespaceRules.length > 0) {
                    StripWhitespaceFilter.PrioritizedNameTestList stripList = new StripWhitespaceFilter.PrioritizedNameTestList();
                    StripWhitespaceFilter.PrioritizedNameTestList preserveList = new StripWhitespaceFilter.PrioritizedNameTestList();
                    for (int i = whitespaceRules.length - 1; i >= 0; --i) {
                        WhitespaceHelper.WhitespaceRule rule2 = whitespaceRules[i];
                        if (rule2.getAction() == 1) {
                            stripList.insertTest(rule2.getNamespace(), rule2.getElement(), rule2.getStrength(), i);
                            continue;
                        }
                        if (rule2.getAction() != 2) continue;
                        preserveList.insertTest(rule2.getNamespace(), rule2.getElement(), rule2.getStrength(), i);
                    }
                    properties.put("http://www.ibm.com/xmlns/prod/xcij/strip-space", stripList);
                    properties.put("http://www.ibm.com/xmlns/prod/xcij/preserve-space", preserveList);
                }
                if ((functionMap = this.getFunctionMap()) != null) {
                    properties.put("http://www.ibm.com/xmlns/prod/xcij/function-map", functionMap);
                }
                if ((variableMap = this.getVariableMap()) != null) {
                    properties.put("http://www.ibm.com/xmlns/prod/xcij/variable-map", variableMap);
                }
                properties.put("http://www.ibm.com/xmlns/prod/xcij/strip-type-annotations", this.getStripTypeAnnotations());
                if (this.m_stylesheetFunctions != null) {
                    properties.put("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-ud-functions", this.m_stylesheetFunctions);
                    properties.put("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-ud-function-params", this.m_stylesheetFunctionParams);
                }
                if (this.m_extensionFunctions != null) {
                    properties.put("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-extension-functions", this.m_extensionFunctions);
                    properties.put("http://www.ibm.com/xmlns/prod/xltxe/execution-trace-extension-function-params", this.m_extensionFunctionParams);
                }
                this.initCommonProperties(properties);
                this.m_properties = properties;
            }
        }
        return this.m_properties;
    }

    private AbstractTranslet getCachedTranslet() {
        if (this.m_cachedTranslet == null) {
            try {
                this.m_cachedTranslet = this.createTranslet(this.m_session, this.m_session.getTypeRegistry());
            }
            catch (WrappedRuntimeException e) {
                throw new XProcessException(e.getMessage(), e.getException());
            }
        }
        return this.m_cachedTranslet;
    }

    @Override
    protected AbstractStarlet getCachedStarlet() {
        return this.getCachedTranslet();
    }

    private WhitespaceHelper.WhitespaceRule[] getWhitespaceRules() {
        AbstractTranslet translet = this.getCachedTranslet();
        if (translet != null) {
            return translet.getWhitespaceRules();
        }
        return null;
    }

    private List<Source> getImportedSchemas(SessionContext session) {
        AbstractTranslet translet = this.getCachedTranslet();
        if (translet != null) {
            return translet.getImportedSchemas(session);
        }
        return null;
    }

    private Map<String, String> getFunctionMap() {
        AbstractTranslet translet = this.getCachedTranslet();
        if (translet != null) {
            return translet.getFunctionMap();
        }
        return null;
    }

    private Map<String, String> getVariableMap() {
        AbstractTranslet translet = this.getCachedTranslet();
        if (translet != null) {
            return translet.getVariableMap();
        }
        return null;
    }

    private boolean getStripTypeAnnotations() {
        AbstractTranslet translet = this.getCachedTranslet();
        if (translet != null) {
            return translet.getStripTypeAnnotateTree();
        }
        return false;
    }

    private TypeRegistry getTypeRegistry() {
        if (this.m_clonedTypeRegistry == null) {
            TypeRegistry registry = this.m_session.getTypeRegistry();
            AbstractTranslet translet = this.getCachedTranslet();
            if (translet.hasSchemas() && !translet.wereSchemasPreregistered(this.m_session) && translet.getTransletVersion() < 20009) {
                this.m_clonedTypeRegistry = registry.cloneTypeRegistry();
                this.m_clonedTypeRegistry.setErrorHandler(registry.getErrorHandler());
                this.m_clonedTypeRegistry.setSchemaResolver(registry.getSchemaResolver());
            } else {
                this.m_clonedTypeRegistry = registry;
            }
        }
        return this.m_clonedTypeRegistry;
    }

    public void setStylesheetFunctions(HashMap<String, SequenceType> functions) {
        this.m_stylesheetFunctions = functions;
    }

    public HashMap<String, SequenceType> getStylesheetFunctions() {
        return this.m_stylesheetFunctions;
    }

    public void setStylesheetFunctionParams(HashMap<String, SequenceType[]> functions) {
        this.m_stylesheetFunctionParams = functions;
    }

    public HashMap<String, SequenceType[]> getStylesheetFunctionParams() {
        return this.m_stylesheetFunctionParams;
    }

    public void setExtensionFunctions(HashMap<String, SequenceType> functions) {
        this.m_extensionFunctions = functions;
    }

    public HashMap<String, SequenceType> getExtensionFunctions() {
        return this.m_extensionFunctions;
    }

    public void setExtensionFunctionParams(HashMap<String, SequenceType[]> functions) {
        this.m_extensionFunctionParams = functions;
    }

    public HashMap<String, SequenceType[]> getExtensionFunctionParams() {
        return this.m_extensionFunctionParams;
    }

    private static class InlineSchemaResolver
    implements SchemaResolver {
        String[] _inlineSchemas;

        public InlineSchemaResolver(String[] inlineSchemas) {
            this._inlineSchemas = inlineSchemas;
        }

        @Override
        public List<? extends Source> resolve(SchemaResolver.SchemaIdentifier si) {
            List<String> locations = si.getLocations();
            for (int i = 0; i < this._inlineSchemas.length; i += 3) {
                String inlineSchema = this._inlineSchemas[i];
                for (String loc : locations) {
                    if (!inlineSchema.equals(loc)) continue;
                    String realBase = this._inlineSchemas[i + 1];
                    String schema2 = this._inlineSchemas[i + 2];
                    char[] schemaChars = schema2.toCharArray();
                    CharArrayReader car = new CharArrayReader(schemaChars);
                    StreamSource ss = new StreamSource(car);
                    ss.setSystemId(realBase);
                    ArrayList<StreamSource> list = new ArrayList<StreamSource>();
                    list.add(ss);
                    return list;
                }
            }
            return null;
        }
    }
}

