/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.Version;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceCache;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.TraceXSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.drivers.StarletLoader;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIExecutable;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIPreparer;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathPreparer;
import com.ibm.xltxe.rnm1.xtq.xslt.cmdline.utils.PrettyXylemListing;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.StandardOptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiledExecutable;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTDumpingParser;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTExecutable;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTInterpretedExecutable;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.SourceConverter;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.SourceProviderImpl;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.debug.TraceUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.input.Util;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.StackFrameAnalyzer;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XItemSource;
import com.ibm.xml.xapi.XItemView;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.BasicCompilationParameters;
import com.ibm.xml.xci.exec.CompilationParameters;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public final class XSLTPreparer
extends AbstractSPIPreparer {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTPreparer.class);
    private static final String s_className = XSLTPreparer.class.getName();
    public static final String XSLT_MODULE = "XSLTModule";

    public XSLTPreparer(SessionContext session) {
        super(session);
    }

    @Override
    public boolean compile(String stylesheet, File directory, StaticContext context2, String key2, int preparerId) {
        return this.compile(stylesheet, context2, (CompilationParameters)new BasicCompilationParameters(key2, context2.getPackageName(), directory.toString()), preparerId);
    }

    @Override
    public boolean compile(String stylesheet, StaticContext context2, CompilationParameters params, int preparerId) {
        Source source = this.getSourceFromString(stylesheet);
        return this.compile(source, context2, params, preparerId);
    }

    @Override
    public boolean compile(Source stylesheet, File directory, StaticContext context2, String classname, int preparerId) {
        return this.compile(stylesheet, context2, (CompilationParameters)new BasicCompilationParameters(classname, context2.getPackageName(), directory.toString()), preparerId);
    }

    @Override
    public boolean compile(Source stylesheet, StaticContext context2, CompilationParameters params, int preparerId) {
        if (stylesheet == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        if (context2.getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/ignore-xpath-namespace-differences")) {
            throw new StaticError("ERR_SYSTEM", "Feature http://www.ibm.com/xmlns/prod/xltxe-j/ignore-xpath-namespace-differences is not applicable for evaluating XSLT stylesheets.");
        }
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "compile", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "COMPILE_XSLT", new Object[]{this.getSourceDescription(stylesheet), Version.getVersion()});
        }
        ErrorHandler handler = this.getErrorHandler(context2);
        XTQStaticContext xtqContext = this.getXTQStaticContext(context2, stylesheet, true, handler);
        try {
            XSLTCompiler compiler = this.createParserAndCompiler(stylesheet, xtqContext, handler, false, null, null);
            InputSource input = Util.getInputSource(compiler.getParser(), stylesheet);
            compiler.setClassName(this.getClassName(params.getClassName()));
            compiler.setDestDirectory(params.getDirectoryName());
            compiler.setOutputType(1);
            compiler.setGenerateBCEL(!xtqContext.getJavaSourceFeature());
            compiler.setInterpreted(false);
            compiler.setSplitLimit(0);
            compiler.setEmitAutoSplitWarning(false);
            if (params.getPackageName() != null) {
                compiler.setPackageName(params.getPackageName());
            }
            return compiler.compile(input, null, this.getSessionContext());
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
        }
        catch (Exception e) {
            XSLTPreparer.reportException(context2, e);
        }
        return false;
    }

    @Override
    public Executable load(String classname) throws ClassNotFoundException {
        String className = this.getClassName(classname);
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "load", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "LOAD_XSLT", new Object[]{className});
        }
        Class transletClass = StarletLoader.loadStarlet(className, null);
        return new XSLTCompiledExecutable(transletClass, this.m_session);
    }

    @Override
    public Executable load(CompilationParameters params) throws ClassNotFoundException {
        String className = this.getQualifiedClassName(params);
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "load", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "LOAD_XSLT", new Object[]{className});
        }
        Class transletClass = StarletLoader.loadStarlet(className, params.getClassLoader());
        return new XSLTCompiledExecutable(transletClass, this.m_session);
    }

    @Override
    public Executable prepare(Source stylesheet, StaticContext context2, int preparerId) {
        if (stylesheet == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        if (context2.getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/ignore-xpath-namespace-differences")) {
            throw new StaticError("ERR_SYSTEM", "Feature http://www.ibm.com/xmlns/prod/xltxe-j/ignore-xpath-namespace-differences is not applicable for evaluating XSLT stylesheets.");
        }
        ErrorHandler handler = this.getErrorHandler(context2);
        XTQStaticContext xtqContext = this.getXTQStaticContext(context2, stylesheet, true, handler);
        boolean compile = xtqContext.getCompileFeature();
        if (s_logger.isLoggable(Level.CONFIG)) {
            String messageCode = compile ? "PREPARE_XSLT_COMPILER" : "PREPARE_XSLT_INTERPRETER";
            s_logger.logrb(Level.CONFIG, s_className, "prepare", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", messageCode, new Object[]{this.getSourceDescription(stylesheet), Version.getVersion()});
        }
        try {
            boolean trace2;
            boolean bl = trace2 = this.isExecutionTraceEnabled() && !compile;
            if (s_logger.isLoggable(Level.CONFIG) && trace2) {
                s_logger.logrb(Level.CONFIG, s_className, "prepare", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "EXECUTION_TRACE_ENABLED", new Object[]{this.getSourceDescription(stylesheet)});
            }
            SourceCache sourceCache = null;
            SourceConverter sourceConverter = null;
            if (trace2) {
                sourceCache = new SourceCache();
                sourceConverter = new SourceConverter();
                stylesheet = sourceConverter.convertIfNecessary(stylesheet, this.getSessionContext());
            }
            XSLTCompiler compiler = this.createParserAndCompiler(stylesheet, xtqContext, handler, trace2, sourceCache, sourceConverter);
            InputSource input = Util.getInputSource(compiler.getParser(), stylesheet);
            XSLTExecutable executable = null;
            if (compile) {
                String className = this.getClassName(null);
                compiler.setClassName(className);
                compiler.setInterpreted(false);
                XPathPreparer.directJavaSourceToDirectory(compiler);
                if (xtqContext.getJavaSourceFeature()) {
                    compiler.setGenerateBCEL(false);
                    compiler.setInterpreted(false);
                    compiler.compile(input, className, this.getSessionContext());
                    Class transletClass = StarletLoader.loadStarlet(className, null);
                    executable = new XSLTCompiledExecutable(transletClass, this.m_session);
                } else {
                    Class<?> transletClass;
                    compiler.setGenerateBCEL(true);
                    compiler.setInterpreted(false);
                    compiler.setSplitLimit(0);
                    compiler.setEmitAutoSplitWarning(false);
                    if (xtqContext.getGenClassesFeature()) {
                        compiler.setOutputType(3);
                    } else if (DUMP_BYTECODE) {
                        this.enableBytecodeDump(compiler);
                    } else {
                        compiler.setOutputType(2);
                    }
                    compiler.compile(input, className, this.getSessionContext());
                    byte[][] bytecodes = compiler.getBytecodes();
                    if (bytecodes == null) {
                        ErrorMsg err = new ErrorMsg("NO_TRANSLET_CLASS_ERR");
                        throw new NullPointerException(err.toString());
                    }
                    StarletLoader.ByteCodeArraysClassLoader loader = StarletLoader.getByteCodeArraysClassLoader(bytecodes, compiler.getNames());
                    try {
                        transletClass = loader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        FFDCUtil.log(e, this);
                        s_logger.logrb(Level.SEVERE, s_className, "prepare", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)e);
                        return null;
                    }
                    executable = new XSLTCompiledExecutable(transletClass, this.m_session);
                }
            } else {
                compiler.setInterpreted(true);
                if (compiler.useMixedMode()) {
                    compiler.setRuntimeSignature(compiler.loadRuntimeSignature());
                } else {
                    compiler.setRuntimeLibrary(compiler.loadRuntimeLibrary());
                }
                XTQProgram ast = compiler.buildAST(input, null);
                Module module = compiler.translate(ast);
                module.typeCheck(false);
                ModuleSignature ms = new ModuleSignature("");
                Program program = new Program(ms);
                program.addModule(module);
                if (!compiler.useMixedMode()) {
                    program.addModule(compiler.getRuntimeLibrary());
                }
                int mathMode = context2.getIntegerMathMode();
                XSLTPreparer.prepareForStackFrames(compiler);
                if (StandardOptimizationRegimen.DumpOption.LISTING.isEnabled()) {
                    if (!compiler.useMixedMode()) {
                        PrettyXylemListing.MakeListing(module.getName(), new Module[]{module, compiler.getRuntimeLibrary()});
                    } else {
                        PrettyXylemListing.MakeListing(module.getName(), new Module[]{module});
                    }
                }
                executable = new XSLTInterpretedExecutable(program, compiler.getFILLibrary(), module.getName(), mathMode == 2, mathMode == 3, this.m_session);
                if (AbstractSPIExecutable.SOURCE_LINE_INFO) {
                    executable.setLineTable(compiler.getLineNumberHelper().getRuntimeLineTable());
                    executable.setURITable(compiler.getLineNumberHelper().getRuntimeURITable());
                }
                if (trace2) {
                    TraceUtils.setupExtensionFunctions(context2, executable);
                    TypeRegistry tr = xtqContext.getTypeRegistry();
                    xtqContext.getInScopeSchemaModel();
                    TraceUtils.setupStylesheetFunctions(xtqContext.getStylesheetFunctions(), tr, executable);
                }
            }
            executable.setExecutionTraceEnabled(trace2);
            if (trace2) {
                sourceCache.addDocument("generated:built-in-rules.xsl", "<xsl:template match=\"/\">\n   <xsl:apply-templates/>\n</xsl:template>\n\n<xsl:template match=\"*\">\n   <xsl:apply-templates/>\n</xsl:template>\n\n<xsl:template match=\"text()|@*\">\n   <xsl:value-of select=\".\"/>\n</xsl:template>\n\n<xsl:template match=\"processing-instruction()|comment()\"/>\n", "UTF-8");
                executable.setExecutionTraceSourceProvider(new SourceProviderImpl(sourceCache.getDocuments(), sourceCache.getEncodings()));
            }
            return executable;
        }
        catch (HandledRuntimeException e) {
            if (e.getRuntimeException() != null) {
                throw e.getRuntimeException();
            }
        }
        catch (Exception e) {
            XSLTPreparer.reportException(context2, e);
        }
        return null;
    }

    public static void prepareForStackFrames(XSLTCompiler compiler) {
        Module transletModule = compiler.getStarletModule();
        StackFrameAnalyzer analyzer = new StackFrameAnalyzer(transletModule);
        analyzer.analyze();
    }

    @Override
    public Executable prepare(String stylesheet, StaticContext context2, int preparerId) {
        Source source = this.getSourceFromString(stylesheet);
        return this.prepare(source, context2, preparerId);
    }

    @Override
    public Executable prepare(Axis axis, NodeTest nodeTest, StaticContext context2, int preparerId) {
        return null;
    }

    protected XSLTCompiler createParserAndCompiler(Source source, XTQStaticContext context2, ErrorHandler handler, boolean trace2, SourceCache sourceCache, SourceConverter sourceConverter) {
        XSLTParser parser = trace2 ? new TraceXSLTParser(true, (XStaticContext)context2, sourceCache) : (DUMP_EXPRESSION ? new XSLTDumpingParser(true, (XStaticContext)context2, this.m_session) : new XSLTParser(true, context2));
        XSLTCompiler compiler = new XSLTCompiler("2.0", parser);
        compiler.getCompilerSettings().setExecutionTracing(trace2);
        CodeGenerationSettings cgs = compiler.getLinkerSettings().getCodeGenerationSettings();
        int mathMode = context2.getIntegerMathMode();
        cgs.setArbitraryPrecision(mathMode == 2);
        cgs.setOverflowDetection(mathMode == 3);
        parser.getExpressionFactory().setLanguage("XSLT2");
        compiler.setErrorHandler(handler);
        URIResolver sourceResolver = context2.getSourceURIResolver();
        if (sourceResolver != null) {
            SourceLoader loader = XSLTPreparer.createSourceLoader(sourceResolver, trace2, sourceConverter, this.getSessionContext());
            compiler.setSourceLoader(loader);
        }
        return compiler;
    }

    private String getClassName(String classname) {
        if (classname != null && classname.length() > 0) {
            return classname;
        }
        return XSLT_MODULE;
    }

    private Source getSourceFromString(String stylesheet) {
        if (stylesheet == null) {
            return null;
        }
        StringReader reader = new StringReader(stylesheet);
        return new StreamSource(reader);
    }

    private static SourceLoader createSourceLoader(final URIResolver uriResolver, boolean trace2, final SourceConverter sourceConverter, final SessionContext session) {
        if (trace2) {
            return new SourceLoader(){

                @Override
                public InputSource loadSource(String href, String context2, XSLTParser parser) {
                    try {
                        Source source = uriResolver.resolve(href, context2);
                        if (source != null) {
                            source = sourceConverter.convertIfNecessary(source, session);
                            return Util.getInputSource(parser, source);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }
        return new SourceLoader(){

            @Override
            public InputSource loadSource(String href, String context2, XSLTParser parser) {
                try {
                    Source source = uriResolver.resolve(href, context2);
                    if (source != null) {
                        if (source instanceof XItemSource) {
                            XItemView item2 = ((XItemSource)source).getItem();
                            if (item2 == null) {
                                return null;
                            }
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            item2.exportItem(new StreamResult(output));
                            ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
                            source = new StreamSource(input, source.getSystemId());
                        }
                        return Util.getInputSource(parser, source);
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    @Override
    protected String getListenersProperty() {
        return "com.ibm.xml.xci.exec.trace.XSLT2TraceListeners";
    }

    @Override
    protected int getLanguage() {
        return 6;
    }
}

