/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XSLTTranslatorDriver {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTTranslatorDriver.class);
    private static final String s_className = XSLTTranslatorDriver.class.getName();
    static final boolean s_abe = false;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: XSLTTranslatorDriver\n        [-out filename]\n        xslfile");
            return;
        }
        int base2 = 0;
        XSLTCompilerSettings compilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings linkerSettings = new XSLTLinkerSettings(compilerSettings);
        OutputStream out = System.out;
        while (base2 < args.length) {
            String opt = args[base2];
            if (opt.equals("-dump")) {
                linkerSettings.setDumpXylem(true);
                ++base2;
                continue;
            }
            if (!opt.equals("-out")) break;
            if (++base2 == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-out requires parameter");
                return;
            }
            try {
                out = new FileOutputStream(args[base2]);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not open output file " + args[base2], e);
                return;
            }
            ++base2;
        }
        try {
            if (args.length - base2 != 1) {
                System.out.println("Expected xslfile parameter");
                return;
            }
            linkerSettings.setVersion("2.0");
            File xslFile = new File(args[base2]);
            URL url = xslFile.toURL();
            XSLTCompiler compiler = new XSLTCompiler(compilerSettings.getVersion());
            Module rtlib = compiler.loadRuntimeLibrary();
            Module module = XSLTCompiler.compileStylesheetToModule(url, rtlib, null, false, compilerSettings);
            if (module == null) {
                return;
            }
            PrintWriter outw = new PrintWriter(out);
            module.dump(outw);
            outw.close();
            module.typeCheck();
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

