/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.SecuritySupport;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;

public class XylemRuntimePreCompiler {
    static final List<String> excludedFunctionNames = Collections.emptyList();

    public static void main(String[] args) throws Exception {
        String version = args[0];
        if (!version.equals("2.0")) {
            throw new IllegalArgumentException(new ErrorMsg("ERR_SYSTEM", "Unrecognized version: " + version).toString());
        }
        Module module = XSLTCompiler.parseRuntimeLibrary();
        SessionContext session = new SessionContext();
        String path2 = args[1] + "/" + XylemRuntimePreCompiler.getPath("xltxe_rt.xylemo");
        File file = new File(path2);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        Module.writeModule(oos, module);
        oos.flush();
        fos.close();
        path2 = args[1] + "/" + XylemRuntimePreCompiler.getPath("xltxe_rts.xylemo");
        file = new File(path2);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        fos = new FileOutputStream(file);
        oos = new ObjectOutputStream(fos);
        module.m_signature.write(oos);
        oos.flush();
        fos.close();
        if (args.length >= 3 && "compile".equals(args[2])) {
            int i = 3;
            while (i < args.length) {
                XylemRuntimePreCompiler.compileRuntime(args[1], args[i++], session);
            }
        }
    }

    public static InputStream getPrecompiledRuntime() {
        String path2 = XylemRuntimePreCompiler.getPath("xltxe_rt.xylemo");
        return XylemRuntimePreCompiler.getResource(path2);
    }

    public static InputStream getPrecompiledRuntimeSignature() {
        String path2 = XylemRuntimePreCompiler.getPath("xltxe_rts.xylemo");
        return XylemRuntimePreCompiler.getResource(path2);
    }

    private static String getPath(String fileName) {
        return "com/ibm/xltxe/rnm1/xtq/xslt/runtime/v2/" + fileName;
    }

    private static InputStream getResource(String path2) {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = this.getClass().getClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
        InputStream inputStream = SecuritySupport.getResourceAsStream(cl, path2);
        return inputStream;
    }

    private static void compileRuntime(String outputDir, String integerMode, SessionContext session) throws Exception {
        String runtimeClassName;
        XStarCompiler compiler = new XStarCompiler("2.0");
        compiler.setPackageName("com.ibm.xltxe.rnm1.xtq.runtime");
        CodeGenerationSettings cgs = compiler.getLinkerSettings().getCodeGenerationSettings();
        if ("ap".equals(integerMode)) {
            cgs.setArbitraryPrecision(true);
            runtimeClassName = "FILLibrary_AP";
        } else if ("od".equals(integerMode)) {
            cgs.setOverflowDetection(true);
            runtimeClassName = "FILLibrary_OD";
        } else {
            runtimeClassName = "FILLibrary";
        }
        compiler.setClassName(runtimeClassName);
        compiler.setDestDirectory(new File(outputDir).getAbsolutePath());
        compiler.setOutputType(1);
        compiler.setGenerateBCEL(true);
        compiler.setInterpreted(false);
        compiler.setSplitLimit(0);
        compiler.setEmitAutoSplitWarning(false);
        cgs.setMixedModeModuleCompilation(true);
        cgs.setMixedModeFunctionExcludeList(excludedFunctionNames);
        Module filLibrary = new Module(runtimeClassName, null, new ModuleSignature(""));
        ModuleSignature ms = new ModuleSignature("");
        Program program = new Program(ms);
        program.addModule(filLibrary);
        program.addModule(compiler.loadRuntimeLibrary());
        compiler.linkAndCodeGen(program, compiler.loadRuntimeLibrary(), filLibrary, session);
    }
}

