/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.common.utils.XMLString;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.Constants;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.Operators;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BasisLibrary
extends Operators
implements Constants {
    public static final int NUM_OF_TYPES = 50;
    private static final String EMPTYSTRING = "";
    private static final double lowerBounds = 0.001;
    private static final double upperBounds = 1.0E7;
    private static final DecimalFormat defaultFormatter;
    private static final String defaultPattern = "";
    private static FieldPosition _fieldPosition;
    private static int prefixIndex;
    private static ResourceBundle m_bundle;
    public static final String ERROR_MESSAGES_KEY = "error-messages";

    public static int countF(Cursor iterator) {
        if (iterator == null) {
            return 0;
        }
        return (int)iterator.contextSize();
    }

    public static int positionF(Cursor iterator) {
        if (iterator == null) {
            return 0;
        }
        return (int)iterator.contextPosition();
    }

    public static double sumF(Cursor iterator) {
        try {
            double result2 = 0.0;
            if (iterator != null) {
                do {
                    result2 += Double.parseDouble(iterator.itemTypedValue().getString(1));
                } while (iterator.toNext());
            }
            return result2;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static String stringF(Object obj) {
        if (obj instanceof Cursor) {
            return ((Cursor)obj).itemTypedValue().getString(1);
        }
        if (obj == null) {
            return "";
        }
        if (obj instanceof Double) {
            return RuntimeLibrary.doubleToString10((Double)obj);
        }
        if (obj instanceof Float) {
            return RuntimeLibrary.floatToString10(((Float)obj).floatValue());
        }
        return obj.toString();
    }

    public static String stringF(Object obj, int node2) {
        if (obj instanceof Cursor) {
            return ((Cursor)obj).itemTypedValue().getString(1);
        }
        if (obj == null) {
            return "";
        }
        if (obj instanceof Double) {
            int length2;
            Double d = (Double)obj;
            String result2 = d.toString();
            if (result2.charAt((length2 = result2.length()) - 2) == '.' && result2.charAt(length2 - 1) == '0') {
                return result2.substring(0, length2 - 2);
            }
            return result2;
        }
        return obj.toString();
    }

    public static String stringF(Object obj, Object cursor2) {
        if (obj instanceof Cursor) {
            return ((Cursor)obj).itemTypedValue().getString(1);
        }
        if (obj instanceof Double) {
            int length2;
            Double d = (Double)obj;
            String result2 = d.toString();
            if (result2.charAt((length2 = result2.length()) - 2) == '.' && result2.charAt(length2 - 1) == '0') {
                return result2.substring(0, length2 - 2);
            }
            return result2;
        }
        if (obj != null) {
            return obj.toString();
        }
        return BasisLibrary.stringF(cursor2);
    }

    public static double numberF(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        if (obj instanceof String) {
            return BasisLibrary.stringToReal((String)obj);
        }
        if (obj instanceof Cursor) {
            Cursor iter = (Cursor)obj;
            return BasisLibrary.stringToReal(iter.itemTypedValue().getString(1));
        }
        if (obj == null) {
            return BasisLibrary.stringToReal("");
        }
        String className = obj.getClass().getName();
        BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", className, "number()");
        return 0.0;
    }

    public static String substringF(String value2, double start) {
        int strlen = value2.length();
        return BasisLibrary.substringF(value2, start, (double)strlen - start + 1.0);
    }

    public static String substringF(String value2, int start) {
        try {
            int strlen = value2.length();
            int istart = start - 1;
            if (istart > strlen) {
                return "";
            }
            if (istart < 1) {
                istart = 0;
            }
            return value2.substring(istart);
        }
        catch (IndexOutOfBoundsException e) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "substring()");
            return null;
        }
    }

    public static String substringF(String value2, double start, double length2) {
        try {
            int strlen = value2.length();
            int istart = (int)Math.round(start) - 1;
            int isum = istart + (int)Math.round(length2);
            if (Double.isInfinite(length2)) {
                isum = Integer.MAX_VALUE;
            }
            if (Double.isNaN(start) || Double.isNaN(length2)) {
                return "";
            }
            if (Double.isInfinite(start)) {
                return "";
            }
            if (istart > strlen) {
                return "";
            }
            if (isum < 0) {
                return "";
            }
            if (istart < 0) {
                istart = 0;
            }
            if (isum > strlen) {
                return value2.substring(istart);
            }
            return value2.substring(istart, isum);
        }
        catch (IndexOutOfBoundsException e) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "substring()");
            return null;
        }
    }

    public static String substringF(String value2, int start, int length2) {
        try {
            int istart = start - 1;
            int isum = istart + length2;
            int strlen = value2.length();
            if (istart > strlen) {
                return "";
            }
            if (isum < 0) {
                return "";
            }
            if (istart < 0) {
                istart = 0;
            }
            if (isum > strlen) {
                return value2.substring(istart);
            }
            return value2.substring(istart, isum);
        }
        catch (IndexOutOfBoundsException e) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "substring()");
            return null;
        }
    }

    public static String substring_afterF(String value2, String substring2) {
        int index2 = value2.indexOf(substring2);
        if (index2 >= 0) {
            return value2.substring(index2 + substring2.length());
        }
        return "";
    }

    public static String substring_beforeF(String value2, String substring2) {
        int index2 = value2.indexOf(substring2);
        if (index2 >= 0) {
            return value2.substring(0, index2);
        }
        return "";
    }

    public static String translateF(String value2, String from2, String to2) {
        if (null == value2) {
            return "";
        }
        int tol = to2.length();
        int froml = from2.length();
        int valuel = value2.length();
        StringBuffer result2 = new StringBuffer();
        for (int i = 0; i < valuel; ++i) {
            int j;
            char ch = value2.charAt(i);
            for (j = 0; j < froml; ++j) {
                if (ch != from2.charAt(j)) continue;
                if (j >= tol) break;
                result2.append(to2.charAt(j));
                break;
            }
            if (j != froml) continue;
            result2.append(ch);
        }
        return result2.toString();
    }

    public static String normalize_spaceF(Cursor node2) {
        if (node2 == null) {
            return "";
        }
        return BasisLibrary.normalize_spaceF(node2.itemTypedValue().getString(1));
    }

    public static String normalize_spaceF(String value2) {
        int i;
        if (null == value2) {
            return "";
        }
        int n2 = value2.length();
        StringBuffer result2 = new StringBuffer();
        for (i = 0; i < n2 && BasisLibrary.isWhiteSpace(value2.charAt(i)); ++i) {
        }
        while (true) {
            if (i < n2 && !BasisLibrary.isWhiteSpace(value2.charAt(i))) {
                result2.append(value2.charAt(i++));
                continue;
            }
            if (i == n2) break;
            while (i < n2 && BasisLibrary.isWhiteSpace(value2.charAt(i))) {
                ++i;
            }
            if (i >= n2) continue;
            result2.append(' ');
        }
        return result2.toString();
    }

    public static String generate_idF(Cursor node2, AbstractStarlet starlet) {
        if (node2 == null) {
            return "";
        }
        return starlet.generate_id_support(node2);
    }

    public static char[] unparsed_entity_uriF(Object context2, char[] arg2) {
        if (context2 == null) {
            BasisLibrary.runTimeError("ERR_SYSTEM", "unparsed-entity-uri called with a bad cursor.");
        }
        String name2 = new String(arg2);
        String uri2 = null;
        uri2 = ((Cursor)context2).itemDocumentInfo().getUnparsedEntitySystemId(name2).toString();
        if (uri2 == null) {
            return new String("").toCharArray();
        }
        return uri2.toCharArray();
    }

    public static char[] unparsed_entity_uriF(Cursor context2, char[] arg2) {
        return BasisLibrary.unparsed_entity_uriF((Object)context2, arg2);
    }

    public static String getLocalName(String value2) {
        int idx = value2.lastIndexOf(58);
        if (idx >= 0) {
            value2 = value2.substring(idx + 1);
        }
        if ((idx = value2.lastIndexOf(64)) >= 0) {
            value2 = value2.substring(idx + 1);
        }
        return value2;
    }

    public static void unresolved_externalF(String name2) {
        BasisLibrary.runTimeError("EXTERNAL_FUNC_ERR", name2);
    }

    public static void unsupported_ElementF(String qname2, boolean isExtension) {
        if (isExtension) {
            BasisLibrary.runTimeError("UNSUPPORTED_EXT_ERR", qname2);
        } else {
            BasisLibrary.runTimeError("UNSUPPORTED_XSL_ERR", qname2);
        }
    }

    public static void unsupported_functionF(String qname2) {
        BasisLibrary.runTimeError("UNSUPPORTED_FUNC_ERR", qname2);
    }

    public static String system_propertyF(String name2) {
        if (name2.equals("xsl:version")) {
            return "1.0";
        }
        if (name2.equals("xsl:vendor")) {
            return "IBM Corporation";
        }
        if (name2.equals("xsl:vendor-url")) {
            return "http://www.ibm.com/";
        }
        BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", name2, "system-property()");
        return "";
    }

    private static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private static boolean compareStrings(String lstring, String rstring, int op2) {
        switch (op2) {
            case 0: {
                return lstring.equals(rstring);
            }
            case 1: {
                return !lstring.equals(rstring);
            }
            case 2: {
                return BasisLibrary.stringToReal(lstring) > BasisLibrary.stringToReal(rstring);
            }
            case 3: {
                return BasisLibrary.stringToReal(lstring) < BasisLibrary.stringToReal(rstring);
            }
            case 4: {
                return BasisLibrary.stringToReal(lstring) >= BasisLibrary.stringToReal(rstring);
            }
            case 5: {
                return BasisLibrary.stringToReal(lstring) <= BasisLibrary.stringToReal(rstring);
            }
        }
        BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
        return false;
    }

    public static boolean nodesetContainsNode(Cursor iterator, Cursor xciNode) {
        if (iterator == null || xciNode == null) {
            return false;
        }
        if (iterator.contextIsNodesOnly()) {
            return true;
        }
        if (iterator.contextIsAtomsOnly()) {
            return false;
        }
        Cursor xciIterator = iterator.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
        do {
            if (!xciNode.itemIsSameNode(xciIterator)) continue;
            xciIterator.release();
            return true;
        } while (xciIterator.toNext());
        xciIterator.release();
        return false;
    }

    public static boolean compare(Cursor left, double rnumber, int op2) {
        switch (op2) {
            case 0: {
                if (left == null) break;
                do {
                    if (BasisLibrary.numberF(left.itemTypedValue().getString(1)) != rnumber) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 1: {
                if (left == null) break;
                do {
                    if (BasisLibrary.numberF(left.itemTypedValue().getString(1)) == rnumber) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 2: {
                if (left == null) break;
                do {
                    if (!(BasisLibrary.numberF(left.itemTypedValue().getString(1)) > rnumber)) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 3: {
                if (left == null) break;
                do {
                    if (!(BasisLibrary.numberF(left.itemTypedValue().getString(1)) < rnumber)) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 4: {
                if (left == null) break;
                do {
                    if (!(BasisLibrary.numberF(left.itemTypedValue().getString(1)) >= rnumber)) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 5: {
                if (left == null) break;
                do {
                    if (!(BasisLibrary.numberF(left.itemTypedValue().getString(1)) <= rnumber)) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            default: {
                BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
            }
        }
        return false;
    }

    public static boolean compare(Cursor left, String rstring, int op2) {
        switch (op2) {
            case 0: {
                if (left == null) break;
                do {
                    String lstring;
                    if (!(lstring = left.itemTypedValue().getString(1)).equals(rstring)) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 1: {
                if (left == null) break;
                do {
                    String lstring;
                    if ((lstring = left.itemTypedValue().getString(1)).equals(rstring)) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 2: {
                if (left == null) break;
                do {
                    String lstring;
                    if (!(BasisLibrary.numberF(lstring = left.itemTypedValue().getString(1)) > BasisLibrary.numberF(rstring))) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 3: {
                if (left == null) break;
                do {
                    String lstring;
                    if (!(BasisLibrary.numberF(lstring = left.itemTypedValue().getString(1)) < BasisLibrary.numberF(rstring))) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 4: {
                if (left == null) break;
                do {
                    String lstring;
                    if (!(BasisLibrary.numberF(lstring = left.itemTypedValue().getString(1)) >= BasisLibrary.numberF(rstring))) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            case 5: {
                if (left == null) break;
                do {
                    String lstring;
                    if (!(BasisLibrary.numberF(lstring = left.itemTypedValue().getString(1)) <= BasisLibrary.numberF(rstring))) continue;
                    return true;
                } while (left.toNext());
                break;
            }
            default: {
                BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
            }
        }
        return false;
    }

    public static boolean compare(Object left, Object right, int op2) {
        boolean hasSimpleArgs;
        boolean result2 = false;
        boolean bl = hasSimpleArgs = BasisLibrary.hasSimpleType(left) && BasisLibrary.hasSimpleType(right);
        if (op2 != 0 && op2 != 1 && hasSimpleArgs) {
            switch (op2) {
                case 2: {
                    return BasisLibrary.numberF(left) > BasisLibrary.numberF(right);
                }
                case 3: {
                    return BasisLibrary.numberF(left) < BasisLibrary.numberF(right);
                }
                case 4: {
                    return BasisLibrary.numberF(left) >= BasisLibrary.numberF(right);
                }
                case 5: {
                    return BasisLibrary.numberF(left) <= BasisLibrary.numberF(right);
                }
            }
            BasisLibrary.runTimeError("ERR_SYSTEM", "compare()");
        }
        if (hasSimpleArgs) {
            result2 = left instanceof Boolean || right instanceof Boolean ? BasisLibrary.booleanF(left) == BasisLibrary.booleanF(right) : (left instanceof Double || right instanceof Double || left instanceof Integer || right instanceof Integer ? BasisLibrary.numberF(left) == BasisLibrary.numberF(right) : BasisLibrary.stringF(left).equals(BasisLibrary.stringF(right)));
            if (op2 == 1) {
                result2 = !result2;
            }
        } else {
            Cursor iter;
            if (BasisLibrary.hasSimpleType(left) && right instanceof Cursor) {
                Object temp = right;
                right = left;
                left = temp;
                op2 = BasisLibrary.getReverseOp(op2);
            }
            if ((iter = (Cursor)left) != null) {
                iter = iter.fork(iter.profile(), true);
            }
            if (right instanceof Cursor) {
                result2 = BasisLibrary.compare(iter, (Cursor)right, op2);
            } else if (right instanceof String) {
                result2 = BasisLibrary.compare(iter, (String)right, op2);
            } else if (right instanceof Number) {
                double temp = ((Number)right).doubleValue();
                result2 = BasisLibrary.compare(iter, temp, op2);
            } else if (right instanceof Boolean) {
                boolean temp = (Boolean)right;
                result2 = iter != null == temp;
            } else {
                if (right == null) {
                    return false;
                }
                String className = right.getClass().getName();
                BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", className, "compare()");
            }
        }
        return result2;
    }

    public static boolean compare(Cursor left, Cursor right, int op2) {
        if (left == null || right == null) {
            return false;
        }
        ArrayList<String> rights = new ArrayList<String>();
        do {
            String rvalue = right.itemTypedValue().getString(1);
            rights.add(rvalue);
        } while (right.toNext());
        int rl = rights.size();
        do {
            String lvalue = left.itemTypedValue().getString(1);
            for (int i = rl - 1; i >= 0; --i) {
                if (!BasisLibrary.compareStrings(lvalue, (String)rights.get(i), op2)) continue;
                return true;
            }
        } while (left.toNext());
        return false;
    }

    public static boolean testLanguage(String testLang, Cursor node2) {
        return BasisLibrary.testLanguage(testLang, BasisLibrary.getLanguage(node2));
    }

    private static boolean testLanguage(String testLang, String inScopeLang) {
        if (inScopeLang == null) {
            return false;
        }
        inScopeLang = inScopeLang.toLowerCase();
        if ((testLang = testLang.toLowerCase()).length() == 2) {
            return inScopeLang.startsWith(testLang);
        }
        return inScopeLang.equals(testLang);
    }

    public static String getLanguage(Cursor node2) {
        throw new UnsupportedOperationException("BasisLibrary.getLanguage() not yet implemented for Cursor");
    }

    private static boolean hasSimpleType(Object obj) {
        return obj instanceof Boolean || obj instanceof Double || obj instanceof Integer || obj instanceof String;
    }

    public static double stringToReal(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int stringToInt(XMLString s) {
        try {
            return Integer.parseInt(((Object)s).toString());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String realToString(double d) {
        double m = Math.abs(d);
        if (m >= 0.001 && m < 1.0E7) {
            int length2;
            String result2 = Double.toString(d);
            if (result2.charAt((length2 = result2.length()) - 2) == '.' && result2.charAt(length2 - 1) == '0') {
                return result2.substring(0, length2 - 2);
            }
            if (result2.indexOf(46) != 0 && result2.indexOf(69) < 0 && result2.charAt(length2 - 1) == '0') {
                return result2.substring(0, length2 - 1);
            }
            return result2;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        if (d == 0.0) {
            return "0";
        }
        return BasisLibrary.formatNumber(d, "", defaultFormatter);
    }

    public static int realToInt(double d) {
        return (int)d;
    }

    public static String formatNumber(double number2, String pattern2, DecimalFormat formatter) {
        if (formatter == null) {
            formatter = defaultFormatter;
        }
        try {
            StringBuffer result2 = new StringBuffer();
            String localizedPattern = formatter.toPattern();
            int index2 = localizedPattern.indexOf(46);
            if (index2 >= 1 && localizedPattern.charAt(index2 - 1) == '#') {
                StringBuffer newpattern = new StringBuffer();
                newpattern.append(localizedPattern.substring(0, index2 - 1));
                newpattern.append("0");
                newpattern.append(localizedPattern.substring(index2));
                formatter.applyLocalizedPattern(newpattern.toString());
            } else if (index2 == 0) {
                StringBuffer newpattern = new StringBuffer();
                newpattern.append("0");
                newpattern.append(localizedPattern);
                formatter.applyLocalizedPattern(newpattern.toString());
            }
            formatter.format(number2, result2, _fieldPosition);
            return result2.toString();
        }
        catch (IllegalArgumentException e) {
            BasisLibrary.runTimeError("FORMAT_NUMBER_ERR", Double.toString(number2), pattern2);
            return "";
        }
    }

    private static void copyNodes(NodeList nodeList, Document doc2, Node parent2) {
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node curr = nodeList.item(i);
            short nodeType = curr.getNodeType();
            String value2 = null;
            try {
                value2 = curr.getNodeValue();
            }
            catch (DOMException ex) {
                BasisLibrary.runTimeError("ERR_SYSTEM", ex.getMessage());
                return;
            }
            String nodeName = curr.getNodeName();
            Node newNode = null;
            switch (nodeType) {
                case 2: {
                    newNode = doc2.createAttributeNS(curr.getNamespaceURI(), nodeName);
                    break;
                }
                case 4: {
                    newNode = doc2.createCDATASection(value2);
                    break;
                }
                case 8: {
                    newNode = doc2.createComment(value2);
                    break;
                }
                case 11: {
                    newNode = doc2.createDocumentFragment();
                    break;
                }
                case 9: {
                    newNode = doc2.createElementNS(null, "__document__");
                    BasisLibrary.copyNodes(curr.getChildNodes(), doc2, newNode);
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    Element element2 = doc2.createElementNS(curr.getNamespaceURI(), nodeName);
                    if (curr.hasAttributes()) {
                        NamedNodeMap attributes2 = curr.getAttributes();
                        for (int k = 0; k < attributes2.getLength(); ++k) {
                            Node attr2 = attributes2.item(k);
                            element2.setAttributeNS(attr2.getNamespaceURI(), attr2.getNodeName(), attr2.getNodeValue());
                        }
                    }
                    BasisLibrary.copyNodes(curr.getChildNodes(), doc2, element2);
                    newNode = element2;
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    newNode = doc2.createEntityReference(nodeName);
                    break;
                }
                case 12: {
                    break;
                }
                case 7: {
                    newNode = doc2.createProcessingInstruction(nodeName, value2);
                    break;
                }
                case 3: {
                    newNode = doc2.createTextNode(value2);
                }
            }
            try {
                parent2.appendChild(newNode);
                continue;
            }
            catch (DOMException e) {
                BasisLibrary.runTimeError("ERR_SYSTEM", e.getMessage());
                return;
            }
        }
    }

    public static void checkAttribQName(String name2) {
        int firstOccur = name2.indexOf(":");
        int lastOccur = name2.lastIndexOf(":");
        String localName2 = name2.substring(lastOccur + 1);
        if (firstOccur > 0) {
            String oriPrefix;
            String newPrefix = name2.substring(0, firstOccur);
            if (firstOccur != lastOccur && !XML11Char.isXML11ValidNCName(oriPrefix = name2.substring(firstOccur + 1, lastOccur))) {
                BasisLibrary.runTimeError("INVALID_QNAME_ERR", oriPrefix + ":" + localName2);
            }
            if (!XML11Char.isXML11ValidNCName(newPrefix)) {
                BasisLibrary.runTimeError("INVALID_QNAME_ERR", newPrefix + ":" + localName2);
            }
        }
        if (!XML11Char.isXML11ValidNCName(localName2) || localName2.equals("xmlns")) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", localName2);
        }
    }

    public static void checkNCName(String name2) {
        if (!XML11Char.isXML11ValidNCName(name2)) {
            BasisLibrary.runTimeError("INVALID_NCNAME_ERR", name2);
        }
    }

    public static void checkQName(String name2) {
        if (!XML11Char.isXML11ValidQName(name2)) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", name2);
        }
    }

    public static String getPrefix(String qname2) {
        int index2 = qname2.indexOf(58);
        return index2 > 0 ? qname2.substring(0, index2) : null;
    }

    public static String generatePrefix() {
        return "ns" + prefixIndex++;
    }

    public static void runTimeError(String code) {
        throw new RuntimeException(m_bundle.getString(code));
    }

    public static void runTimeError(String code, Object[] args) {
        String message = MessageFormat.format(m_bundle.getString(code), args);
        throw new RuntimeException(message);
    }

    public static void runTimeError(String code, Object arg0) {
        BasisLibrary.runTimeError(code, new Object[]{arg0});
    }

    public static void runTimeError(String code, Object arg0, Object arg1) {
        BasisLibrary.runTimeError(code, new Object[]{arg0, arg1});
    }

    public static void runTimeOldTransletWarning(String code, Object arg0) {
        String message = MessageFormat.format(m_bundle.getString(code), arg0);
        System.err.println(message);
    }

    public static String replace(String base2, char ch, String str) {
        return base2.indexOf(ch) < 0 ? base2 : BasisLibrary.replace(base2, String.valueOf(ch), new String[]{str});
    }

    public static String replace(String base2, String delim, String[] str) {
        int len = base2.length();
        StringBuffer result2 = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = base2.charAt(i);
            int k = delim.indexOf(ch);
            if (k >= 0) {
                result2.append(str[k]);
                continue;
            }
            result2.append(ch);
        }
        return result2.toString();
    }

    public static String qnameToString(QName value2) {
        return Util.getStringRep(value2);
    }

    private static String getBaseFromURI(String uri2) {
        int backwardSep = uri2.lastIndexOf(92) + 1;
        int forwardSep = uri2.lastIndexOf(47) + 1;
        return uri2.substring(0, Math.max(backwardSep, forwardSep));
    }

    public static double roundF(double d) {
        return d < -0.5 || d > 0.0 ? Math.floor(d + 0.5) : (d == 0.0 ? d : (Double.isNaN(d) ? Double.NaN : -0.0));
    }

    public static boolean booleanF(Object obj) {
        if (obj instanceof Double) {
            double temp = (Double)obj;
            return temp != 0.0 && !Double.isNaN(temp);
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue() != 0.0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return !((String)obj).equals("");
        }
        String className = obj.getClass().getName();
        BasisLibrary.runTimeError("INVALID_ARGUMENT_ERR", className, "number()");
        return false;
    }

    public static QName validateQNameF(char[] name2, boolean prefixRequired, boolean lookupDefault, Hashtable inScopeNamespaces) {
        String localPart;
        int colonIdx = -1;
        for (int i = 0; i < name2.length; ++i) {
            if (name2[i] != ':') continue;
            colonIdx = i;
            break;
        }
        String prefix2 = colonIdx < 0 ? "" : String.valueOf(name2, 0, colonIdx);
        String string2 = localPart = colonIdx == name2.length ? "" : String.valueOf(name2, colonIdx + 1, name2.length - (colonIdx + 1));
        if (prefixRequired) {
            if (colonIdx == -1 || !XML11Char.isXML11ValidNCName(prefix2) || !XML11Char.isXML11ValidNCName(localPart)) {
                BasisLibrary.runTimeError("INVALID_QNAME_BUT_NOT_NCNAME_ERR", new String(name2));
            }
        } else if (colonIdx >= 0 && !XML11Char.isXML11ValidNCName(prefix2) || !XML11Char.isXML11ValidNCName(localPart)) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", new String(name2));
        }
        String uri2 = "";
        if (prefix2.length() == 0) {
            if (lookupDefault && (uri2 = (String)inScopeNamespaces.get(prefix2)) == null) {
                uri2 = "";
            }
        } else {
            uri2 = (String)inScopeNamespaces.get(prefix2);
            if (uri2 == null) {
                BasisLibrary.runTimeError("UNRESOLVED_PREFIX_ERR", prefix2);
            }
        }
        return new QName(uri2, localPart, prefix2);
    }

    public static QName validateXML11QNameF(char[] name2, boolean prefixRequired, boolean lookupDefault, Hashtable inScopeNamespaces) {
        String localPart;
        int colonIdx = -1;
        for (int i = 0; i < name2.length; ++i) {
            if (name2[i] != ':') continue;
            colonIdx = i;
            break;
        }
        String prefix2 = colonIdx < 0 ? "" : String.valueOf(name2, 0, colonIdx);
        String string2 = localPart = colonIdx == name2.length ? "" : String.valueOf(name2, colonIdx + 1, name2.length - (colonIdx + 1));
        if (prefixRequired) {
            if (colonIdx == -1 || !XML11Char.isXML11ValidNCName(prefix2) || !XML11Char.isXML11ValidNCName(localPart)) {
                BasisLibrary.runTimeError("INVALID_QNAME_BUT_NOT_NCNAME_ERR", new String(name2));
            }
        } else if (colonIdx >= 0 && !XML11Char.isXML11ValidNCName(prefix2) || !XML11Char.isXML11ValidNCName(localPart)) {
            BasisLibrary.runTimeError("INVALID_QNAME_ERR", new String(name2));
        }
        String uri2 = "";
        if (prefix2.length() == 0) {
            if (lookupDefault && (uri2 = (String)inScopeNamespaces.get(prefix2)) == null) {
                uri2 = "";
            }
        } else {
            uri2 = (String)inScopeNamespaces.get(prefix2);
            if (uri2 == null) {
                BasisLibrary.runTimeError("UNRESOLVED_PREFIX_ERR", prefix2);
            }
        }
        return new QName(uri2, localPart, prefix2);
    }

    public static final QName construct_QNameF(char[] arg1, char[] arg2) {
        String namespaceURI = String.valueOf(arg1);
        String tmp = String.valueOf(arg2);
        String prefix2 = "";
        int index2 = tmp.indexOf(":");
        if (index2 != -1) {
            prefix2 = tmp.substring(0, index2);
        }
        String localname2 = tmp.substring(index2 + 1);
        return new QName(namespaceURI, localname2, prefix2);
    }

    public static final char[] getLocalCurrency() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        String curr = dfs.getCurrencySymbol();
        char[] ret = curr.toCharArray();
        return ret;
    }

    public static final boolean prefixResolveF(char[] name2, Hashtable inScopeNamespaces) {
        String uri2;
        String prefix2;
        int colonIdx = -1;
        for (int i = 0; i < name2.length; ++i) {
            if (name2[i] != ':') continue;
            colonIdx = i;
            break;
        }
        String string2 = prefix2 = colonIdx < 0 ? "" : String.valueOf(name2, 0, colonIdx);
        return prefix2.length() == 0 || (uri2 = (String)inScopeNamespaces.get(prefix2)) != null;
    }

    public static final boolean elementAvailableF(char[] arg1, char[] arg2, HashMap instrTable) {
        String namespace2 = String.valueOf(arg1);
        String localName2 = String.valueOf(arg2);
        String key2 = "{" + namespace2 + "}" + localName2;
        Object val = instrTable.get(key2);
        return val != null;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setDigit('#');
        symbols.setGroupingSeparator(',');
        symbols.setMinusSign('-');
        symbols.setPatternSeparator(';');
        symbols.setPercent('%');
        symbols.setZeroDigit('0');
        defaultFormatter = new DecimalFormat("#,##0.###", symbols);
        defaultFormatter.setMaximumFractionDigits(1000);
        defaultFormatter.setGroupingUsed(false);
        _fieldPosition = new FieldPosition(0);
        prefixIndex = 0;
        m_bundle = ResourceBundle.getBundle("com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages");
    }
}

