/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatInt;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateFormatFunctionsLibrary {
    private static final String EMPTYSTRING = "";
    private static final String COMMA = ",";
    private static final String STAR = "*";
    private static final String DASH = "-";
    private static final String ZERO = "0";
    private boolean isTimeZoneSpecified = false;
    private boolean defaultCalendarFallBack = false;
    private boolean defaultLanguageFallBack = false;
    private static Map<Locale, GenericDateFormatSymbols> cachedSymbols = new ConcurrentHashMap<Locale, GenericDateFormatSymbols>();
    private final NumberFormatFactoryRuleBased s_ICUNumberFormatFactory = NumberFormatFactoryRuleBased.getInstance();
    private NumberFormatInt numberFormatInt = new NumberFormatInt(this.s_ICUNumberFormatFactory);
    private String cspecificer = "YMDdFWwHhPmsfZzCE";

    public char[] formatDateTime(String[] date2, char[] picture, char[] language, char[] calendar, char[] country) {
        Locale locale;
        int year2 = Integer.parseInt(date2[0]);
        int month2 = Integer.parseInt(date2[1]) - 1;
        int day2 = Integer.parseInt(date2[2]);
        int hours2 = Integer.parseInt(date2[3]);
        int minutes2 = Integer.parseInt(date2[4]);
        int seconds2 = this.getSeconds(date2[5]);
        int milliseconds = this.getMillieconds(date2[5]);
        String timeZone = date2[6];
        if (language.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(language))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(language), String.valueOf(country));
        }
        GenericCalendar cal = this.getCalendar(String.valueOf(calendar), timeZone, locale);
        GenericDateFormatSymbols dfs = this.getDateFormatSymbols(locale);
        cal.set(1, year2);
        cal.set(2, month2);
        cal.set(5, day2);
        cal.set(11, hours2);
        cal.set(12, minutes2);
        cal.set(13, seconds2);
        cal.set(14, milliseconds);
        StringBuffer buff = new StringBuffer();
        int pictureSize = picture.length;
        block4: for (int i = 0; i < pictureSize; ++i) {
            switch (picture[i]) {
                case '[': {
                    StringBuffer pictureBuffer = new StringBuffer();
                    char ch = picture[++i];
                    if (ch == '[') {
                        buff.append(ch);
                        continue block4;
                    }
                    while (i < pictureSize && (ch = picture[i]) != ']') {
                        if (!Character.isWhitespace(ch)) {
                            pictureBuffer.append(picture[i]);
                        }
                        ++i;
                    }
                    String token = pictureBuffer.toString();
                    if (token.length() <= 0) continue block4;
                    if (this.isPictureValid(token)) {
                        buff.append(this.formatDateTimeVariableMarker(token, cal, dfs, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", token);
                    continue block4;
                }
                case ']': {
                    char ch;
                    if (++i == pictureSize) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((ch = picture[i]) == ']') {
                        buff.append(ch);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    buff.append(picture[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            buff.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            buff.insert(0, "[Calendar: AD]");
        }
        return buff.toString().toCharArray();
    }

    private int getRawOffSetFromTimeZone(String timeZone) {
        int ptIndex = timeZone.indexOf("PT");
        int hourIndex = timeZone.indexOf("H");
        int minuteIndex = timeZone.indexOf("M");
        int hours2 = 0;
        int minutes2 = 0;
        int retValue = 0;
        if (hourIndex != -1 || minuteIndex != -1) {
            if (hourIndex == -1) {
                minutes2 = Integer.parseInt(timeZone.substring(ptIndex + 2, minuteIndex));
            } else if (minuteIndex == -1) {
                hours2 = Integer.parseInt(timeZone.substring(ptIndex + 2, hourIndex));
            } else {
                hours2 = Integer.parseInt(timeZone.substring(ptIndex + 2, hourIndex));
                minutes2 = Integer.parseInt(timeZone.substring(hourIndex + 1, minuteIndex));
            }
        }
        retValue = (hours2 * 60 + minutes2) * 60 * 1000;
        if (timeZone.startsWith(DASH)) {
            retValue *= -1;
        }
        return retValue;
    }

    private String getTimeFromOffset(int rawOffset) {
        StringBuffer buffer = new StringBuffer();
        if (rawOffset == 0) {
            return EMPTYSTRING;
        }
        if (rawOffset < 0) {
            buffer.append(DASH);
            rawOffset *= -1;
        } else {
            buffer.append("+");
        }
        int totalMinutes = rawOffset / 60 / 1000;
        int hours2 = totalMinutes / 60;
        int minutes2 = totalMinutes % 60;
        if (hours2 < 10) {
            buffer.append(ZERO + String.valueOf(hours2));
        } else {
            buffer.append(String.valueOf(hours2));
        }
        if (minutes2 < 10) {
            buffer.append(":0" + String.valueOf(minutes2));
        } else {
            buffer.append(":" + String.valueOf(minutes2));
        }
        return buffer.toString();
    }

    private String applyPresentationModifier(String modifier, String value2, NumberFormatInt numberFormatInt, Locale locale) {
        return numberFormatInt.applyPresentationModifier(modifier, value2, locale);
    }

    private String formatYear(int year2, String token, boolean widthSpecified, Locale locale) {
        String modifier = this.getModifier(token, widthSpecified);
        String retValue = this.formatValueHelper(year2, modifier, locale);
        if (widthSpecified) {
            retValue = this.adjustWidthForYear(retValue, token);
        }
        return retValue;
    }

    private String formatMonth(int month2, String token, boolean widthSpecified, GenericDateFormatSymbols dfs, Locale locale) {
        String modifier = this.getModifier(token, widthSpecified);
        int minWidth = -1;
        int maxWidth = -1;
        if (widthSpecified && (minWidth = this.getMinimumWidth(token)) > (maxWidth = this.getMaximumWidth(token))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if (modifier.startsWith("N") || modifier.startsWith("n")) {
            String monthName = dfs.getMonths()[month2];
            int length2 = monthName.length();
            if (widthSpecified && maxWidth != -1 && length2 > maxWidth) {
                monthName = dfs.getShortMonths()[month2];
            }
            String retValue = this.applyPresentationModifier(modifier, monthName, this.numberFormatInt, locale);
            return retValue;
        }
        String retValue = this.formatValueHelper(month2 + 1, modifier, locale);
        if (widthSpecified) {
            retValue = this.adjustWidthForValue(retValue, minWidth, maxWidth);
        }
        return retValue;
    }

    private String formatDateTimeVariableMarker(String token, GenericCalendar cal, GenericDateFormatSymbols dfs, Locale locale) {
        boolean widthSpecified = this.isWidthSpecified(token);
        char specifier = token.charAt(0);
        StringBuffer buffer = new StringBuffer();
        switch (specifier) {
            case 'Y': {
                buffer.append(this.formatYear(cal.get(1), token, widthSpecified, locale));
                break;
            }
            case 'M': {
                buffer.append(this.formatMonth(cal.get(2), token, widthSpecified, dfs, locale));
                break;
            }
            case 'D': {
                buffer.append(this.formatValue(cal.get(5), token, locale));
                break;
            }
            case 'd': {
                buffer.append(this.formatValue(cal.get(6), token, locale));
                break;
            }
            case 'F': {
                buffer.append(this.formatDayOfWeek(cal.get(7), token, widthSpecified, dfs, locale));
                break;
            }
            case 'W': {
                buffer.append(this.formatValue(cal.get(3), token, locale));
                break;
            }
            case 'w': {
                buffer.append(this.formatValue(cal.get(4), token, locale));
                break;
            }
            case 'H': {
                buffer.append(this.formatValue(cal.get(11), token, locale));
                break;
            }
            case 'h': {
                int hour = cal.get(10);
                if (hour == 0) {
                    hour = 12;
                }
                buffer.append(this.formatValue(hour, token, locale));
                break;
            }
            case 'P': {
                buffer.append(this.formatAMPM(cal.get(9), token, widthSpecified, dfs, locale));
                break;
            }
            case 'm': {
                buffer.append(this.formatTimeValue(cal.get(12), token, locale));
                break;
            }
            case 's': {
                buffer.append(this.formatTimeValue(cal.get(13), token, locale));
                break;
            }
            case 'f': {
                buffer.append(this.formatMillisecondValue(cal.get(14), token, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                String retValue = this.getTimeFromOffset(cal.get(15));
                String modifier = this.getModifier(token, widthSpecified);
                if (modifier.equals(EMPTYSTRING)) {
                    if (retValue.equals(EMPTYSTRING)) {
                        retValue = "Z";
                    }
                } else if (retValue.equals(EMPTYSTRING)) {
                    retValue = "GMT";
                }
                buffer.append(retValue);
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                buffer.append("GMT" + this.getTimeFromOffset(cal.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                buffer.append(this.formatEras(cal.get(0), token, widthSpecified, dfs, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_SPECIFIER", String.valueOf(specifier));
            }
        }
        return buffer.toString();
    }

    private String formatDateVariableMarker(String token, GenericCalendar cal, GenericDateFormatSymbols dfs, Locale locale) {
        boolean widthSpecified = this.isWidthSpecified(token);
        char specifier = token.charAt(0);
        StringBuffer buffer = new StringBuffer();
        switch (specifier) {
            case 'Y': {
                buffer.append(this.formatYear(cal.get(1), token, widthSpecified, locale));
                break;
            }
            case 'M': {
                buffer.append(this.formatMonth(cal.get(2), token, widthSpecified, dfs, locale));
                break;
            }
            case 'D': {
                buffer.append(this.formatValue(cal.get(5), token, locale));
                break;
            }
            case 'd': {
                buffer.append(this.formatValue(cal.get(6), token, locale));
                break;
            }
            case 'F': {
                buffer.append(this.formatDayOfWeek(cal.get(7), token, widthSpecified, dfs, locale));
                break;
            }
            case 'W': {
                buffer.append(this.formatValue(cal.get(3), token, locale));
                break;
            }
            case 'w': {
                buffer.append(this.formatValue(cal.get(4), token, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                buffer.append(this.getTimeFromOffset(cal.get(15)));
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                buffer.append("GMT" + this.getTimeFromOffset(cal.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                buffer.append(this.formatEras(cal.get(0), token, widthSpecified, dfs, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_SPECIFIER", String.valueOf(specifier));
            }
        }
        return buffer.toString();
    }

    private String formatDayOfWeek(int day2, String token, boolean widthSpecified, GenericDateFormatSymbols dfs, Locale locale) {
        String modifier = this.getModifier(token, widthSpecified);
        int minWidth = -1;
        int maxWidth = -1;
        if (widthSpecified && (minWidth = this.getMinimumWidth(token)) > (maxWidth = this.getMaximumWidth(token))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if (modifier.startsWith("N") || modifier.startsWith("n")) {
            String dayName = dfs.getWeekdays()[day2];
            int length2 = dayName.length();
            if (widthSpecified && maxWidth != -1 && length2 > maxWidth) {
                dayName = dfs.getShortWeekdays()[day2];
            }
            String retValue = this.applyPresentationModifier(modifier, dayName, this.numberFormatInt, locale);
            return retValue;
        }
        String retValue = this.formatValueHelper(day2, modifier, locale);
        if (widthSpecified) {
            retValue = this.adjustWidthForValue(retValue, minWidth, maxWidth);
        }
        return retValue;
    }

    private String formatAMPM(int AMPM, String token, boolean widthSpecified, GenericDateFormatSymbols dfs, Locale locale) {
        String modifier = this.getModifier(token, widthSpecified);
        if (modifier.equals(EMPTYSTRING) && !widthSpecified) {
            modifier = "n";
        }
        String retValue = this.numberFormatInt.applyPresentationModifier(modifier, dfs.getAmPmStrings()[AMPM], locale);
        return retValue;
    }

    private String formatTimeValue(int value2, String token, Locale locale) {
        boolean widthSpecified = this.isWidthSpecified(token);
        String modifier = this.getModifier(token, widthSpecified);
        if (modifier.equals(EMPTYSTRING)) {
            modifier = "01";
        }
        String retValue = this.formatValueHelper(value2, modifier, locale);
        if (widthSpecified) {
            retValue = this.adjustWidth(retValue, token);
        }
        return retValue;
    }

    private String formatMillisecondValue(int value2, String token, Locale locale) {
        String retValue;
        boolean widthSpecified = this.isWidthSpecified(token);
        String modifier = this.getModifier(token, widthSpecified);
        if (widthSpecified) {
            int length2;
            int minValue = this.getMinimumWidth(token);
            int maxValue = this.getMaximumWidth(token);
            if (modifier.equals(EMPTYSTRING) || !this.containsLetter(modifier)) {
                modifier = "001";
            }
            if ((length2 = (retValue = this.formatValueHelper(value2, modifier, locale)).length()) > maxValue) {
                retValue = retValue.substring(0, maxValue);
            } else if (length2 < minValue && !this.containsLetter(retValue)) {
                StringBuffer sb = new StringBuffer();
                int numberOfZerosRequiered = minValue - length2;
                for (int i = 0; i < numberOfZerosRequiered; ++i) {
                    sb.append('0');
                }
                retValue = retValue + sb.toString();
            }
        } else if (modifier.equals(EMPTYSTRING)) {
            retValue = this.formatValueHelper(value2, "001", locale);
        } else if (!this.containsLetter(modifier)) {
            retValue = this.formatValueHelper(value2, "001", locale);
            int length3 = modifier.length();
            if (length3 > 3) {
                StringBuffer sb = new StringBuffer();
                int numberOfZerosRequiered = length3 - 3;
                for (int i = 0; i < numberOfZerosRequiered; ++i) {
                    sb.append('0');
                }
                retValue = retValue + sb.toString();
            } else if (length3 < 3) {
                retValue = retValue.substring(0, length3);
            }
        } else {
            retValue = this.formatValueHelper(value2, modifier, locale);
        }
        return retValue;
    }

    private String formatValue(int value2, String token, Locale locale) {
        boolean widthSpecified = this.isWidthSpecified(token);
        String modifier = this.getModifier(token, widthSpecified);
        String retValue = this.formatValueHelper(value2, modifier, locale);
        if (widthSpecified) {
            retValue = this.adjustWidth(retValue, token);
        }
        return retValue;
    }

    private String formatValueHelper(int value2, String modifier, Locale locale) {
        String retValue = modifier.equals(EMPTYSTRING) ? String.valueOf(value2) : (modifier.endsWith("o") ? this.numberFormatInt.formatValue(value2, modifier, 1, EMPTYSTRING, EMPTYSTRING, locale.getLanguage(), "yes") : this.numberFormatInt.formatValue(value2, modifier, 1, EMPTYSTRING, EMPTYSTRING, locale.getLanguage(), EMPTYSTRING));
        return retValue;
    }

    private String formatEras(int eras, String modifier, boolean widthSpecified, GenericDateFormatSymbols dfs, Locale locale) {
        return dfs.getEras()[eras];
    }

    public char[] formatDate(String[] date2, char[] picture, char[] language, char[] calendar, char[] country) {
        Locale locale;
        int year2 = Integer.parseInt(date2[0]);
        int month2 = Integer.parseInt(date2[1]) - 1;
        int day2 = Integer.parseInt(date2[2]);
        String timeZone = date2[3];
        if (language.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(language))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(language), String.valueOf(country));
        }
        GenericCalendar cal = this.getCalendar(String.valueOf(calendar), timeZone, locale);
        GenericDateFormatSymbols dfs = this.getDateFormatSymbols(locale);
        cal.set(1, year2);
        cal.set(2, month2);
        cal.set(5, day2);
        StringBuffer buff = new StringBuffer();
        int pictureSize = picture.length;
        block4: for (int i = 0; i < pictureSize; ++i) {
            switch (picture[i]) {
                case '[': {
                    char ch;
                    StringBuffer pictureBuffer = new StringBuffer();
                    if (++i == pictureSize) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", "[");
                    }
                    if ((ch = picture[i]) == '[') {
                        buff.append(ch);
                        continue block4;
                    }
                    while (i < pictureSize && (ch = picture[i]) != ']') {
                        if (!Character.isWhitespace(ch)) {
                            pictureBuffer.append(picture[i]);
                        }
                        ++i;
                    }
                    String token = pictureBuffer.toString();
                    if (token.length() <= 0) continue block4;
                    if (this.isPictureValid(token)) {
                        buff.append(this.formatDateVariableMarker(token, cal, dfs, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", token);
                    continue block4;
                }
                case ']': {
                    char ch;
                    if (++i == pictureSize) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((ch = picture[i]) == ']') {
                        buff.append(ch);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    buff.append(picture[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            buff.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            buff.insert(0, "[Calendar: AD]");
        }
        return buff.toString().toCharArray();
    }

    public char[] formatTime(String[] date2, char[] picture, char[] language, char[] calendar, char[] country) {
        Locale locale;
        int hours2 = Integer.parseInt(date2[0]);
        int minutes2 = Integer.parseInt(date2[1]);
        int seconds2 = this.getSeconds(date2[2]);
        int milliseconds = this.getMillieconds(date2[2]);
        String timeZone = date2[3];
        if (language.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(language))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(language), String.valueOf(country));
        }
        GenericCalendar cal = this.getCalendar(String.valueOf(calendar), timeZone, locale);
        GenericDateFormatSymbols dfs = this.getDateFormatSymbols(locale);
        cal.set(11, hours2);
        cal.set(12, minutes2);
        cal.set(13, seconds2);
        cal.set(14, milliseconds);
        StringBuffer buff = new StringBuffer();
        int pictureSize = picture.length;
        block4: for (int i = 0; i < pictureSize; ++i) {
            switch (picture[i]) {
                case '[': {
                    StringBuffer pictureBuffer = new StringBuffer();
                    char ch = picture[++i];
                    if (ch == '[') {
                        buff.append(ch);
                        continue block4;
                    }
                    while (i < pictureSize && (ch = picture[i]) != ']') {
                        if (!Character.isWhitespace(ch)) {
                            pictureBuffer.append(picture[i]);
                        }
                        ++i;
                    }
                    String token = pictureBuffer.toString();
                    if (token.length() <= 0) continue block4;
                    if (this.isPictureValid(token)) {
                        buff.append(this.formatTimeVariableMarker(token, cal, dfs, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", token);
                    continue block4;
                }
                case ']': {
                    char ch;
                    if (++i == pictureSize) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((ch = picture[i]) == ']') {
                        buff.append(ch);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    buff.append(picture[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            buff.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            buff.insert(0, "[Calendar: AD]");
        }
        return buff.toString().toCharArray();
    }

    private String formatTimeVariableMarker(String token, GenericCalendar cal, GenericDateFormatSymbols dfs, Locale locale) {
        boolean widthSpecified = this.isWidthSpecified(token);
        char specifier = token.charAt(0);
        StringBuffer buffer = new StringBuffer();
        switch (specifier) {
            case 'H': {
                buffer.append(this.formatValue(cal.get(11), token, locale));
                break;
            }
            case 'h': {
                int hour = cal.get(10);
                if (hour == 0) {
                    hour = 12;
                }
                buffer.append(this.formatValue(hour, token, locale));
                break;
            }
            case 'P': {
                buffer.append(this.formatAMPM(cal.get(9), token, widthSpecified, dfs, locale));
                break;
            }
            case 'm': {
                buffer.append(this.formatTimeValue(cal.get(12), token, locale));
                break;
            }
            case 's': {
                buffer.append(this.formatTimeValue(cal.get(13), token, locale));
                break;
            }
            case 'f': {
                buffer.append(this.formatMillisecondValue(cal.get(14), token, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                String retValue = this.getTimeFromOffset(cal.get(15));
                String modifier = this.getModifier(token, widthSpecified);
                if (modifier.equals(EMPTYSTRING)) {
                    if (retValue.equals(EMPTYSTRING)) {
                        retValue = "Z";
                    }
                } else if (retValue.equals(EMPTYSTRING)) {
                    retValue = "GMT";
                }
                buffer.append(retValue);
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                buffer.append("GMT" + this.getTimeFromOffset(cal.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_TIME_SPECIFIER", String.valueOf(specifier));
            }
        }
        return buffer.toString();
    }

    private boolean isWidthSpecified(String modifier) {
        return modifier.indexOf(COMMA) != -1;
    }

    private boolean isLanguageSupported(String language) {
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!language.equals(locales[i].getLanguage())) continue;
            return true;
        }
        return false;
    }

    private String adjustWidth(String value2, String token) {
        String retValue;
        int length2;
        int maxWidth;
        int minWidth = this.getMinimumWidth(token);
        if (minWidth > (maxWidth = this.getMaximumWidth(token))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if ((length2 = (retValue = String.valueOf(value2)).length()) < minWidth) {
            int numberOfZeroToPrepend = minWidth - length2;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < numberOfZeroToPrepend; ++i) {
                sb.append('0');
            }
            sb.append(retValue);
            retValue = sb.toString();
        } else if (length2 > maxWidth) {
            retValue = retValue.substring(0, maxWidth);
        }
        return retValue;
    }

    private String adjustWidthForYear(String value2, String token) {
        int maxWidth;
        int minWidth = this.getMinimumWidth(token);
        if (minWidth > (maxWidth = this.getMaximumWidth(token))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        return this.adjustWidthForValue(value2, minWidth, maxWidth);
    }

    private String adjustWidthForValue(String value2, int minWidth, int maxWidth) {
        String retValue;
        int length2 = value2.length();
        if (length2 < minWidth) {
            if (Character.isDigit(value2.charAt(0))) {
                int numberOfZeroToPrepend = minWidth - length2;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < numberOfZeroToPrepend; ++i) {
                    sb.append('0');
                }
                sb.append(value2);
                retValue = sb.toString();
            } else {
                int numberOfSpacesToPrepend = minWidth - length2;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < numberOfSpacesToPrepend; ++i) {
                    sb.append(' ');
                }
                sb.append(value2);
                retValue = sb.toString();
            }
        } else {
            retValue = length2 > maxWidth ? value2.substring(length2 - maxWidth) : value2;
        }
        return retValue;
    }

    private int getSeconds(String time2) {
        int msIndex = time2.indexOf(".");
        if (msIndex < 0) {
            return Integer.parseInt(time2);
        }
        return Integer.parseInt(time2.substring(0, msIndex));
    }

    private boolean hasOridnal(String modifier) {
        if (modifier.indexOf("o") == -1) {
            return false;
        }
        if (modifier.endsWith("o")) {
            for (int i = 0; i < modifier.length(); ++i) {
                char ch = modifier.charAt(i);
                switch (ch) {
                    case 'N': 
                    case 'W': 
                    case 'n': 
                    case 'w': {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean containsLetter(String modifier) {
        int length2 = modifier.length();
        for (int i = 0; i < length2; ++i) {
            if (Character.isDigit(modifier.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isPictureValid(String modifier) {
        int length2 = modifier.length();
        char ch = modifier.charAt(0);
        if (this.cspecificer.indexOf(ch) < 0) {
            return false;
        }
        for (int i = 1; i < length2; ++i) {
            ch = modifier.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == ',' || ch == '-' || ch == '*') continue;
            return false;
        }
        return true;
    }

    private int getMillieconds(String time2) {
        int msIndex = time2.indexOf(".");
        if (msIndex < 0) {
            return 0;
        }
        return Integer.parseInt(time2.substring(msIndex + 1));
    }

    private int getMinimumWidth(String token) {
        String width;
        int retValue = -1;
        int commaIndex = token.indexOf(COMMA);
        int dashIndex = token.indexOf(DASH);
        if (commaIndex != -1 && !(width = dashIndex == -1 ? token.substring(commaIndex + 1) : token.substring(commaIndex + 1, dashIndex)).equals(EMPTYSTRING) && !width.equals(STAR)) {
            try {
                retValue = Integer.parseInt(width);
            }
            catch (NumberFormatException e) {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_WIDTH_SPECIFIER", width);
            }
        }
        return retValue;
    }

    private int getMaximumWidth(String token) {
        String width = EMPTYSTRING;
        int retValue = -1;
        int commaIndex = token.indexOf(COMMA);
        int dashIndex = token.indexOf(DASH);
        if (commaIndex != -1) {
            if (dashIndex != -1) {
                width = token.substring(dashIndex + 1);
            }
            if (!width.equals(EMPTYSTRING)) {
                try {
                    retValue = Integer.parseInt(width);
                }
                catch (NumberFormatException e) {
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_WIDTH_SPECIFIER", width);
                }
            }
        }
        return retValue;
    }

    private GenericCalendar getCalendar(String calendarEra, String timeZone, Locale locale) {
        GenericCalendar cal = this.s_ICUNumberFormatFactory != null ? new GenericCalendarICUImpl(calendarEra, timeZone, locale) : new GenericCalendarJavaImpl(calendarEra, timeZone, locale);
        return cal;
    }

    private GenericDateFormatSymbols getDateFormatSymbols(Locale locale) {
        GenericDateFormatSymbols dfs = cachedSymbols.get(locale);
        if (dfs != null) {
            return dfs;
        }
        dfs = this.s_ICUNumberFormatFactory != null ? new DateFormatSymbolsICUImpl(locale) : new DateFormatSymbolsJavaImpl(locale);
        cachedSymbols.put(locale, dfs);
        return dfs;
    }

    private String getModifier(String token, boolean widthSpecified) {
        String retValue = widthSpecified ? token.substring(1, token.indexOf(COMMA)) : (token.length() > 1 ? token.substring(1) : EMPTYSTRING);
        return retValue;
    }

    private class GenericCalendarJavaImpl
    implements GenericCalendar {
        final GregorianCalendar m_cal;

        public GenericCalendarJavaImpl(String calendarEra, String timeZone, Locale locale) {
            if (calendarEra.equals(DateFormatFunctionsLibrary.EMPTYSTRING) || calendarEra.equals("AD")) {
                GregorianCalendar adCalendar = new GregorianCalendar(locale);
                adCalendar.setMinimalDaysInFirstWeek(4);
                adCalendar.setFirstDayOfWeek(2);
                this.m_cal = adCalendar;
            } else if (calendarEra.equals("ISO")) {
                GregorianCalendar isoCalendar = new GregorianCalendar(locale);
                isoCalendar.setMinimalDaysInFirstWeek(4);
                isoCalendar.setFirstDayOfWeek(2);
                this.m_cal = isoCalendar;
            } else {
                DateFormatFunctionsLibrary.this.defaultCalendarFallBack = true;
                GregorianCalendar adCalendar = new GregorianCalendar(locale);
                adCalendar.setMinimalDaysInFirstWeek(4);
                adCalendar.setFirstDayOfWeek(2);
                this.m_cal = adCalendar;
            }
            if (!timeZone.equals(DateFormatFunctionsLibrary.EMPTYSTRING)) {
                DateFormatFunctionsLibrary.this.isTimeZoneSpecified = true;
                this.m_cal.getTimeZone().setRawOffset(DateFormatFunctionsLibrary.this.getRawOffSetFromTimeZone(timeZone));
            }
        }

        @Override
        public int get(int value2) {
            return this.m_cal.get(value2);
        }

        public Object getDisplayName(Locale locale) {
            return "hello";
        }

        @Override
        public void set(int field, int value2) {
            this.m_cal.set(field, value2);
        }

        @Override
        public Object getTimeZone() {
            return this.m_cal.getTimeZone();
        }
    }

    private class GenericCalendarICUImpl
    implements GenericCalendar {
        final Calendar m_cal;

        public GenericCalendarICUImpl(String calendarEra, String timeZone, Locale locale) {
            if (calendarEra.equals(DateFormatFunctionsLibrary.EMPTYSTRING) || calendarEra.equals("AD")) {
                com.ibm.icu.util.GregorianCalendar adCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                adCalendar.setMinimalDaysInFirstWeek(4);
                adCalendar.setFirstDayOfWeek(2);
                this.m_cal = adCalendar;
            } else if (calendarEra.equals("BE")) {
                this.m_cal = new BuddhistCalendar(locale);
            } else if (calendarEra.equals("ISO")) {
                com.ibm.icu.util.GregorianCalendar isoCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                isoCalendar.setMinimalDaysInFirstWeek(4);
                isoCalendar.setFirstDayOfWeek(2);
                this.m_cal = isoCalendar;
            } else {
                DateFormatFunctionsLibrary.this.defaultCalendarFallBack = true;
                com.ibm.icu.util.GregorianCalendar adCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                adCalendar.setMinimalDaysInFirstWeek(4);
                adCalendar.setFirstDayOfWeek(2);
                this.m_cal = adCalendar;
            }
            if (!timeZone.equals(DateFormatFunctionsLibrary.EMPTYSTRING)) {
                DateFormatFunctionsLibrary.this.isTimeZoneSpecified = true;
                this.m_cal.setTimeZone(TimeZone.getTimeZone((String)("GMT" + DateFormatFunctionsLibrary.this.getTimeFromOffset(DateFormatFunctionsLibrary.this.getRawOffSetFromTimeZone(timeZone)))));
            }
        }

        @Override
        public int get(int value2) {
            return this.m_cal.get(value2);
        }

        public Object getDisplayName(Locale locale) {
            return this.m_cal.getDisplayName(locale);
        }

        @Override
        public void set(int field, int value2) {
            this.m_cal.set(field, value2);
        }

        @Override
        public Object getTimeZone() {
            return this.m_cal.getTimeZone();
        }
    }

    private class DateFormatSymbolsJavaImpl
    implements GenericDateFormatSymbols {
        final DateFormatSymbols m_dfs;

        public DateFormatSymbolsJavaImpl(Locale locale) {
            this.m_dfs = new DateFormatSymbols(locale);
        }

        @Override
        public String[] getAmPmStrings() {
            return this.m_dfs.getAmPmStrings();
        }

        @Override
        public String[] getMonths() {
            return this.m_dfs.getMonths();
        }

        @Override
        public String[] getShortMonths() {
            return this.m_dfs.getShortMonths();
        }

        @Override
        public String[] getWeekdays() {
            return this.m_dfs.getWeekdays();
        }

        @Override
        public String[] getShortWeekdays() {
            return this.m_dfs.getShortWeekdays();
        }

        @Override
        public String[] getEras() {
            return this.m_dfs.getEras();
        }
    }

    private class DateFormatSymbolsICUImpl
    implements GenericDateFormatSymbols {
        final com.ibm.icu.text.DateFormatSymbols m_dfs;

        public DateFormatSymbolsICUImpl(Locale locale) {
            this.m_dfs = new com.ibm.icu.text.DateFormatSymbols(locale);
        }

        @Override
        public String[] getAmPmStrings() {
            return this.m_dfs.getAmPmStrings();
        }

        @Override
        public String[] getMonths() {
            return this.m_dfs.getMonths();
        }

        @Override
        public String[] getShortMonths() {
            return this.m_dfs.getShortMonths();
        }

        @Override
        public String[] getWeekdays() {
            return this.m_dfs.getWeekdays();
        }

        @Override
        public String[] getShortWeekdays() {
            return this.m_dfs.getShortWeekdays();
        }

        @Override
        public String[] getEras() {
            return this.m_dfs.getEras();
        }
    }

    private static interface GenericDateFormatSymbols {
        public String[] getMonths();

        public String[] getEras();

        public String[] getAmPmStrings();

        public String[] getShortMonths();

        public String[] getWeekdays();

        public String[] getShortWeekdays();
    }

    private static interface GenericCalendar {
        public int get(int var1);

        public void set(int var1, int var2);

        public Object getTimeZone();
    }
}

