/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDate;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XValidationContext;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;
import com.ibm.xml.jaxp.datatype.Duration2;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.ByteList;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDateTime;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDecimal;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDouble;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSFloat;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSQName;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidatedInfo;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidationContext;
import com.ibm.xml.xml4j.internal.s1.impl.dv.XSSimpleType;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.HexBin;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.AnyURIDV;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;

public class LibraryUtilities {
    public static final int DECIMAL_SCALE = 18;
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final Class[] CLASS_ARRAY = new Class[]{Boolean.class, Double.class, String.class};

    public static char[] dateTimeToCharArray(int year2, int month2, int day2, int hour, int min2, int sec, int millisec, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer();
        sb.append(LibraryUtilities.dateToString(year2, month2, day2));
        sb.append('T');
        sb.append(LibraryUtilities.timeToString(hour, min2, sec, millisec));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static char[] dateToCharArray(int year2, int month2, int day2, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer();
        sb.append(LibraryUtilities.dateToString(year2, month2, day2));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static char[] timeToCharArray(int hour, int min2, int sec, int millisec, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer();
        sb.append(LibraryUtilities.timeToString(hour, min2, sec, millisec));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static String timeToString(int hour, int min2, int sec, int millisec) {
        StringBuffer sb = new StringBuffer();
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(2);
        sb.append(nb.format(Math.abs(hour)));
        sb.append(':');
        sb.append(nb.format(Math.abs(min2)));
        sb.append(':');
        sb.append(nb.format(Math.abs(sec)));
        if (millisec != 0) {
            millisec = Math.abs(millisec);
            int k = 3;
            while (millisec % 10 == 0) {
                --k;
                millisec /= 10;
            }
            nb.setMinimumIntegerDigits(k);
            sb.append('.');
            sb.append(nb.format(millisec));
        }
        return sb.toString();
    }

    public static char[] gDayToCharArray(int day2, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer("---");
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(2);
        sb.append(nb.format(day2));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static char[] gMonthToCharArray(int month2, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer("--");
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(2);
        sb.append(nb.format(month2));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static char[] gMonthDayToCharArray(int month2, int day2, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer("--");
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(2);
        sb.append(nb.format(month2));
        sb.append("-");
        sb.append(nb.format(day2));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static char[] gYearToCharArray(int year2, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer();
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(4);
        sb.append(nb.format(year2));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static char[] gYearMonthToCharArray(int year2, int month2, boolean hasTZ, int hrTZ, int minTZ) {
        StringBuffer sb = new StringBuffer();
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(4);
        sb.append(nb.format(year2));
        sb.append("-");
        month2 = Math.abs(month2);
        nb.setMinimumIntegerDigits(2);
        sb.append(nb.format(month2));
        sb.append(LibraryUtilities.tzToString(hasTZ, hrTZ, minTZ));
        return sb.toString().toCharArray();
    }

    public static String dateToString(int year2, int month2, int day2) {
        StringBuffer sb = new StringBuffer();
        NumberFormat nb = NumberFormat.getInstance();
        nb.isParseIntegerOnly();
        nb.setGroupingUsed(false);
        nb.setMinimumIntegerDigits(4);
        sb.append(nb.format(year2));
        sb.append('-');
        nb.setMinimumIntegerDigits(2);
        sb.append(nb.format(Math.abs(month2)));
        sb.append('-');
        sb.append(nb.format(Math.abs(day2)));
        return sb.toString();
    }

    public static String tzToString(boolean hasTZ, int hrTZ, int minTZ) {
        if (hasTZ) {
            StringBuffer sb = new StringBuffer();
            if (hrTZ == 0 && minTZ == 0) {
                sb.append('Z');
            } else {
                if (hrTZ >= 0) {
                    sb.append('+');
                }
                NumberFormat nb = NumberFormat.getInstance();
                nb.isParseIntegerOnly();
                nb.setGroupingUsed(false);
                nb.setMinimumIntegerDigits(2);
                sb.append(nb.format(hrTZ));
                sb.append(':');
                sb.append(nb.format(Math.abs(minTZ)));
            }
            return sb.toString();
        }
        return "";
    }

    public static char[] nodeToCharArray(Cursor seq) {
        try {
            Duration dur;
            QName qname2 = seq.itemTypeName();
            if (qname2 != null && qname2.getLocalPart().equals("duration") && (dur = seq.itemTypedValue().getDuration(1)) instanceof Duration2) {
                return ((Duration2)dur).toFOFormat().toCharArray();
            }
            return seq.itemStringValueAsChars().toCharArray();
        }
        catch (ParseException pe) {
            throw new WrappedRuntimeException(pe);
        }
    }

    public static char[] durationToCharArray(int year2, int month2, int day2, int hour, int min2, int sec, int millisec) {
        StringBuffer sb = new StringBuffer();
        if (year2 < 0 || month2 < 0 || day2 < 0 || hour < 0 || min2 < 0 || sec < 0 || millisec < 0) {
            sb.append('-');
            year2 = Math.abs(year2);
            month2 = Math.abs(month2);
            day2 = Math.abs(day2);
            hour = Math.abs(hour);
            min2 = Math.abs(min2);
            sec = Math.abs(sec);
            millisec = Math.abs(millisec);
        }
        sb.append('P');
        if (year2 > 0) {
            sb.append(year2);
            sb.append('Y');
        }
        if (month2 > 0) {
            sb.append(month2);
            sb.append('M');
        }
        if (day2 > 0) {
            sb.append(day2);
            sb.append('D');
        }
        if (hour > 0 || min2 > 0 || sec > 0 || millisec > 0) {
            sb.append('T');
        }
        if (hour > 0) {
            sb.append(hour);
            sb.append('H');
        }
        if (min2 > 0) {
            sb.append(min2);
            sb.append('M');
        }
        if (sec > 0 || millisec > 0) {
            sb.append(sec);
            if (millisec > 0) {
                sb.append('.');
                if (millisec < 10) {
                    sb.append('0');
                }
                if (millisec < 100) {
                    sb.append('0');
                }
                while (millisec % 10 == 0) {
                    millisec /= 10;
                }
                sb.append(millisec);
            }
            sb.append('S');
        }
        if (sb.length() == 1) {
            sb.append("T0S");
        }
        try {
            DatatypeFactory dtf = DatatypeFactory.newInstance();
            Duration dur = dtf.newDuration(sb.toString());
            if (dur instanceof Duration2) {
                sb.replace(0, sb.length(), ((Duration2)dur).toFOFormat());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return sb.toString().toCharArray();
    }

    public static char[] dayTimeDurationToCharArray(int day2, int hour, int min2, int sec, int millisec) {
        StringBuffer sb = new StringBuffer();
        if (day2 < 0 || hour < 0 || min2 < 0 || sec < 0 || millisec < 0) {
            sb.append('-');
            day2 = Math.abs(day2);
            hour = Math.abs(hour);
            min2 = Math.abs(min2);
            sec = Math.abs(sec);
            millisec = Math.abs(millisec);
        }
        sb.append('P');
        if (day2 > 0) {
            sb.append(day2);
            sb.append('D');
        }
        if (hour > 0 || min2 > 0 || sec > 0 || millisec > 0) {
            sb.append('T');
        }
        if (hour > 0) {
            sb.append(hour);
            sb.append('H');
        }
        if (min2 > 0) {
            sb.append(min2);
            sb.append('M');
        }
        if (sec > 0 || millisec > 0) {
            sb.append(sec);
            if (millisec > 0) {
                sb.append('.');
                if (millisec < 10) {
                    sb.append('0');
                }
                if (millisec < 100) {
                    sb.append('0');
                }
                while (millisec % 10 == 0) {
                    millisec /= 10;
                }
                sb.append(millisec);
            }
            sb.append('S');
        }
        if (sb.length() == 1) {
            sb.append("T0S");
        }
        return sb.toString().toCharArray();
    }

    public static char[] yearMonthDurationToCharArray(int year2, int month2) {
        StringBuffer sb = new StringBuffer();
        if (year2 < 0 || month2 < 0) {
            sb.append('-');
            year2 = Math.abs(year2);
            month2 = Math.abs(month2);
        }
        sb.append('P');
        if (year2 > 0) {
            sb.append(year2);
            sb.append('Y');
        }
        if (month2 > 0) {
            sb.append(month2);
            sb.append('M');
        }
        if (sb.length() == 1) {
            sb.append("0M");
        }
        return sb.toString().toCharArray();
    }

    public static char[] hexBinaryToCharArray(byte[] bytes2) {
        String str = HexBin.encode(bytes2).trim();
        return str.toCharArray();
    }

    public static char[] base64BinaryToCharArray(byte[] bytes2) {
        String str = Base64.encode(bytes2).trim();
        return str.toCharArray();
    }

    public static long[] parseLongFromStr(char[] string2) {
        boolean isNegative = false;
        StringBuffer str = new StringBuffer();
        long[] results = new long[2];
        results[0] = 0L;
        for (int i = 0; i < string2.length; ++i) {
            if (string2[i] == '-' && i == 0) {
                isNegative = true;
                continue;
            }
            if (string2[i] == '+' && i == 0) continue;
            if (string2[i] >= '0' && string2[i] <= '9') {
                str.append(string2[i]);
                continue;
            }
            results[0] = 1L;
            results[1] = 0L;
        }
        if (str.length() == 0) {
            results[0] = 1L;
            results[1] = 0L;
        }
        if (results[0] == 1L) {
            return results;
        }
        try {
            results[1] = Long.parseLong((isNegative ? "-" : "") + str.toString());
        }
        catch (NumberFormatException e) {
            results[0] = 2L;
            results[1] = 0L;
        }
        return results;
    }

    public static BigInteger[] parseBigIntegerFromStr(char[] string2) {
        boolean isNegative = false;
        StringBuffer str = new StringBuffer();
        BigInteger[] results = new BigInteger[2];
        results[0] = BigInteger.ZERO;
        for (int i = 0; i < string2.length; ++i) {
            if (string2[i] == '-' && i == 0) {
                isNegative = true;
                continue;
            }
            if (string2[i] == '+' && i == 0) continue;
            if (string2[i] >= '0' && string2[i] <= '9') {
                str.append(string2[i]);
                continue;
            }
            results[0] = BigInteger.ONE;
            results[1] = BigInteger.ZERO;
        }
        if (str.length() == 0) {
            results[0] = BigInteger.ONE;
            results[1] = BigInteger.ZERO;
        }
        if (results[0] == BigInteger.ONE) {
            return results;
        }
        try {
            results[1] = new BigInteger((isNegative ? "-" : "") + str.toString());
        }
        catch (NumberFormatException e) {
            results[0] = BigInteger.ONE;
            results[1] = BigInteger.ZERO;
        }
        return results;
    }

    public static long[] parseLongFromFloat(float f2) {
        long[] result2 = new long[2];
        result2[0] = 0L;
        if ((double)f2 >= 9.223372036854776E18 || (double)f2 <= -9.223372036854776E18) {
            result2[0] = 2L;
            result2[1] = 0L;
        } else {
            result2[1] = (long)f2;
        }
        return result2;
    }

    public static BigInteger[] parseBigIntegerFromFloat(float f2) {
        BigInteger[] result2 = new BigInteger[]{BigInteger.ZERO, new BigDecimal(f2).toBigInteger()};
        return result2;
    }

    public static long[] parseLongFromDouble(double d) {
        long[] result2 = new long[2];
        result2[0] = 0L;
        if (d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
            result2[0] = 2L;
            result2[1] = 0L;
        } else {
            result2[1] = (long)d;
        }
        return result2;
    }

    public static BigInteger[] parseBigIntegerFromDouble(double d) {
        BigInteger[] result2 = new BigInteger[]{BigInteger.ZERO, new BigDecimal(d).toBigInteger()};
        return result2;
    }

    public static long[] parseLongFromDecimal(BigDecimal d) {
        long[] result2 = new long[2];
        result2[0] = 0L;
        BigInteger i = d.toBigInteger();
        if (i.compareTo(MAX_LONG) > 0 || i.compareTo(MIN_LONG) < 0) {
            result2[0] = 2L;
            result2[1] = 0L;
        } else {
            result2[1] = i.longValue();
        }
        return result2;
    }

    public static BigInteger[] parseBigIntegerFromDecimal(BigDecimal d) {
        BigInteger[] result2 = new BigInteger[]{BigInteger.ZERO, d.toBigInteger()};
        return result2;
    }

    public static BigDecimal[] parseDecimalfromStr(char[] string2) {
        BigDecimal zero2;
        boolean isNegative = false;
        StringBuffer str = new StringBuffer();
        BigDecimal[] result2 = new BigDecimal[2];
        result2[0] = zero2 = new BigDecimal(0);
        for (int i = 0; i < string2.length; ++i) {
            if (string2[i] == '-' && i == 0) {
                isNegative = true;
                continue;
            }
            if (string2[i] == '+' && i == 0) continue;
            if (string2[i] >= '0' && string2[i] <= '9' || string2[i] == '.') {
                str.append(string2[i]);
                continue;
            }
            result2[0] = new BigDecimal(1);
            result2[1] = zero2;
        }
        if (str.length() == 0) {
            result2[0] = new BigDecimal(1);
            result2[1] = zero2;
        }
        try {
            result2[1] = new BigDecimal((isNegative ? "-" : "") + str.toString());
        }
        catch (Exception e) {
            result2[0] = new BigDecimal(1);
            result2[1] = zero2;
        }
        return result2;
    }

    public static BigDecimal[] parseDecimalfromFloat(float f2) {
        BigDecimal zero2;
        BigDecimal[] result2 = new BigDecimal[2];
        result2[0] = zero2 = new BigDecimal(0);
        try {
            result2[1] = new BigDecimal(f2);
        }
        catch (Exception e) {
            result2[0] = new BigDecimal(1);
            result2[1] = zero2;
        }
        return result2;
    }

    public static BigDecimal[] parseDecimalfromDouble(double d) {
        BigDecimal zero2;
        BigDecimal[] result2 = new BigDecimal[2];
        result2[0] = zero2 = new BigDecimal(0);
        try {
            result2[1] = new BigDecimal(d);
        }
        catch (Exception e) {
            result2[0] = new BigDecimal(1);
            result2[1] = zero2;
        }
        return result2;
    }

    public static float[] parseFloatfromStr(char[] s) {
        float[] result2 = new float[2];
        result2[0] = 0.0f;
        try {
            result2[1] = Float.parseFloat(String.valueOf(s));
        }
        catch (Exception e) {
            result2[0] = 1.0f;
            result2[1] = 0.0f;
        }
        return result2;
    }

    public static double[] parseDoublefromStr(char[] s) {
        double[] result2 = new double[2];
        result2[0] = 0.0;
        try {
            result2[1] = Double.parseDouble(String.valueOf(s));
        }
        catch (Exception e) {
            result2[0] = 1.0;
            result2[1] = 0.0;
        }
        return result2;
    }

    public static int[] parseDateTime(char[] string2) {
        int[] date2;
        int[] time2;
        boolean isNegative;
        String str = String.valueOf(string2);
        int[] isError = new int[]{};
        if (string2.length == 0) {
            return isError;
        }
        boolean bl = isNegative = string2[0] == '-';
        if (isNegative) {
            str = str.substring(1);
        }
        try {
            String d;
            int posT = str.indexOf(84);
            String t = str.substring(posT + 1);
            time2 = LibraryUtilities.parseTime(t.toCharArray(), false);
            if (time2.length == 0) {
                return isError;
            }
            boolean addOneDay = false;
            if (time2[0] == 24 || time2[0] == -24) {
                addOneDay = true;
                time2[0] = 0;
            }
            if ((date2 = LibraryUtilities.parseDate((d = str.substring(0, posT)).toCharArray(), isNegative, addOneDay)).length == 0) {
                return isError;
            }
        }
        catch (Exception e) {
            return isError;
        }
        return new int[]{date2[0], date2[1], date2[2], time2[0], time2[1], time2[2], time2[3], time2[4], time2[5], time2[6]};
    }

    public static int[] parseDate(char[] string2) {
        int[] result2;
        boolean isNegative;
        int[] isError = new int[]{};
        if (string2.length == 0) {
            return isError;
        }
        String temp = String.valueOf(string2);
        boolean bl = isNegative = string2[0] == '-';
        if (isNegative) {
            temp = temp.substring(1);
        }
        if ((result2 = LibraryUtilities.parseDate(temp.toCharArray(), isNegative, false)).length == 0) {
            return isError;
        }
        return result2;
    }

    private static int[] getDigits(char[] string2, int start, int minLength, int maxLength) {
        StringBuffer temp = new StringBuffer();
        if (string2.length - start < minLength) {
            return new int[]{-1};
        }
        int l = 0;
        for (int i = start; i < string2.length && i < maxLength + start; ++i) {
            if (string2[i] >= '0' && string2[i] <= '9') {
                temp.append(string2[i]);
                ++l;
                continue;
            }
            if (i >= start + minLength) {
                return new int[]{l, Integer.parseInt(temp.toString())};
            }
            return new int[]{-1};
        }
        return new int[]{l, Integer.parseInt(temp.toString())};
    }

    private static int[] parseMilliSeconds(char[] string2, int start) {
        StringBuffer temp = new StringBuffer();
        int pos = start;
        while (string2[pos] >= '0' && string2[pos] <= '9') {
            temp.append(string2[pos]);
            if (++pos != string2.length) continue;
        }
        if (temp.length() == 0) {
            return new int[]{0, Integer.parseInt(temp.toString())};
        }
        if (temp.length() > 3) {
            temp.delete(3, temp.length());
        }
        if (temp.length() == 1) {
            temp.append("00");
        } else if (temp.length() == 2) {
            temp.append("0");
        }
        return new int[]{pos - start, Integer.parseInt(temp.toString())};
    }

    private static boolean checkChars(char[] string2, int pos, char[] chars) {
        if (pos >= string2.length) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (string2[pos] != chars[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean checkChars(char[] string2, int pos, char c) {
        if (pos >= string2.length) {
            return false;
        }
        return string2[pos] == c;
    }

    private static int[] parseDate(char[] string2, boolean isNegative, boolean plusOneDay) {
        int[] result2 = new int[6];
        int[] isError = new int[]{};
        Arrays.fill(result2, 0);
        int pos = 0;
        try {
            int[] day2;
            int[] month2;
            int[] year2 = LibraryUtilities.getDigits(string2, pos, 4, 100);
            if (year2[0] == -1) {
                return isError;
            }
            result2[0] = year2[1];
            if (!LibraryUtilities.checkChars(string2, pos += year2[0], '-')) {
                return isError;
            }
            if ((month2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[1] = month2[1];
            if (!LibraryUtilities.checkChars(string2, pos += month2[0], '-')) {
                return isError;
            }
            if ((day2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[2] = day2[1];
            int[] tzvalue = LibraryUtilities.parseTimeZone(string2, pos += day2[0]);
            if (tzvalue.length == 0) {
                return isError;
            }
            result2[3] = tzvalue[0];
            result2[4] = tzvalue[1];
            result2[5] = tzvalue[2];
        }
        catch (Exception e) {
            return isError;
        }
        if (!LibraryUtilities.validYear(result2[0])) {
            return isError;
        }
        if (!LibraryUtilities.validMonth(result2[1])) {
            return isError;
        }
        if (!LibraryUtilities.validDayOfMonth(result2[0], result2[1], result2[2])) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[4], result2[5])) {
            return isError;
        }
        if (plusOneDay) {
            result2[2] = result2[2] + 1;
            if (!LibraryUtilities.validDayOfMonth(result2[0], result2[1], result2[2])) {
                result2[2] = 1;
                result2[1] = result2[1] + 1;
                if (!LibraryUtilities.validMonth(result2[1])) {
                    result2[1] = 1;
                    result2[0] = result2[0] + 1;
                }
            }
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
        }
        return result2;
    }

    public static int[] parseTime(char[] string2) {
        int[] isError = new int[]{};
        if (string2.length == 0) {
            return isError;
        }
        int[] result2 = LibraryUtilities.parseTime(string2, false);
        if (result2.length == 0) {
            return isError;
        }
        if (result2[0] == 24) {
            result2[0] = 0;
        }
        return result2;
    }

    private static int[] parseTimeZone(char[] string2, int pos) {
        int[] result2 = new int[3];
        int[] isError = new int[]{};
        Arrays.fill(result2, 0);
        if (string2.length > pos) {
            if (!LibraryUtilities.checkChars(string2, pos, new char[]{'-', '+', 'Z'})) {
                return isError;
            }
            result2[0] = 1;
            if (LibraryUtilities.checkChars(string2, pos, 'Z')) {
                if (string2.length != ++pos) {
                    return isError;
                }
            } else {
                int[] tzm;
                int[] tzh;
                boolean tzIsNegative = false;
                if (LibraryUtilities.checkChars(string2, pos, '-')) {
                    tzIsNegative = true;
                }
                if ((tzh = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                    return isError;
                }
                int n2 = result2[1] = tzIsNegative ? tzh[1] * -1 : tzh[1];
                if (!LibraryUtilities.checkChars(string2, pos += tzh[0], ':')) {
                    return isError;
                }
                if ((tzm = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                    return isError;
                }
                int n3 = result2[2] = tzIsNegative ? tzm[1] * -1 : tzm[1];
                if (string2.length != (pos += tzm[0])) {
                    return isError;
                }
            }
        }
        return result2;
    }

    private static int[] parseTime(char[] string2, boolean isNegative) {
        int[] result2 = new int[7];
        int[] isError = new int[]{};
        int pos = 0;
        Arrays.fill(result2, 0);
        try {
            int[] sec;
            int[] min2;
            int[] hour = LibraryUtilities.getDigits(string2, pos, 2, 2);
            if (hour[0] == -1) {
                return isError;
            }
            result2[0] = hour[1];
            if (!LibraryUtilities.checkChars(string2, pos += hour[0], ':')) {
                return isError;
            }
            if ((min2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[1] = min2[1];
            if (!LibraryUtilities.checkChars(string2, pos += min2[0], ':')) {
                return isError;
            }
            if ((sec = LibraryUtilities.getDigits(string2, ++pos, 2, 100))[0] == -1) {
                return isError;
            }
            result2[2] = sec[1];
            if (string2.length > (pos += sec[0])) {
                int[] tzvalue;
                if (LibraryUtilities.checkChars(string2, pos, '.')) {
                    int[] msec;
                    if ((msec = LibraryUtilities.parseMilliSeconds(string2, ++pos))[0] == -1) {
                        return isError;
                    }
                    pos += msec[0];
                    result2[3] = msec[1];
                }
                if ((tzvalue = LibraryUtilities.parseTimeZone(string2, pos)).length == 0) {
                    return isError;
                }
                result2[4] = tzvalue[0];
                result2[5] = tzvalue[1];
                result2[6] = tzvalue[2];
            }
        }
        catch (Exception e) {
            return isError;
        }
        if (!LibraryUtilities.validHour(result2[0], result2[1], result2[2], result2[3])) {
            return isError;
        }
        if (!LibraryUtilities.validMinOrSec(result2[1])) {
            return isError;
        }
        if (!LibraryUtilities.validMinOrSec(result2[2])) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[5], result2[6])) {
            return isError;
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
            result2[1] = result2[1] * -1;
            result2[2] = result2[2] * -1;
            result2[3] = result2[3] * -1;
        }
        return result2;
    }

    public static int[] parseGDay(char[] string2) {
        int[] result2 = new int[4];
        int[] isError = new int[]{};
        int pos = 0;
        Arrays.fill(result2, 0);
        try {
            int[] day2;
            if (!LibraryUtilities.checkChars(string2, pos, '-')) {
                return isError;
            }
            if (!LibraryUtilities.checkChars(string2, ++pos, '-')) {
                return isError;
            }
            if (!LibraryUtilities.checkChars(string2, ++pos, '-')) {
                return isError;
            }
            if ((day2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[0] = day2[1];
            int[] tzvalue = LibraryUtilities.parseTimeZone(string2, pos += day2[0]);
            if (tzvalue.length == 0) {
                return isError;
            }
            result2[1] = tzvalue[0];
            result2[2] = tzvalue[1];
            result2[3] = tzvalue[2];
        }
        catch (Exception e) {
            return isError;
        }
        if (result2[0] < 1 || result2[0] > 31) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[2], result2[3])) {
            return isError;
        }
        return result2;
    }

    public static int[] parseGYear(char[] string2) {
        int[] result2 = new int[4];
        int[] isError = new int[]{};
        int pos = 0;
        boolean isNegative = false;
        Arrays.fill(result2, 0);
        try {
            int[] year2;
            if (LibraryUtilities.checkChars(string2, pos, '-')) {
                isNegative = true;
                ++pos;
            }
            if ((year2 = LibraryUtilities.getDigits(string2, pos, 4, 100))[0] == -1) {
                return isError;
            }
            result2[0] = year2[1];
            int[] tzvalue = LibraryUtilities.parseTimeZone(string2, pos += year2[0]);
            if (tzvalue.length == 0) {
                return isError;
            }
            result2[1] = tzvalue[0];
            result2[2] = tzvalue[1];
            result2[3] = tzvalue[2];
        }
        catch (Exception e) {
            return isError;
        }
        if (!LibraryUtilities.validYear(result2[0])) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[2], result2[3])) {
            return isError;
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
        }
        return result2;
    }

    public static int[] parseGYearMonth(char[] string2) {
        int[] result2 = new int[5];
        int[] isError = new int[]{};
        int pos = 0;
        Arrays.fill(result2, 0);
        boolean isNegative = false;
        try {
            int[] month2;
            int[] year2;
            if (LibraryUtilities.checkChars(string2, pos, '-')) {
                isNegative = true;
                ++pos;
            }
            if ((year2 = LibraryUtilities.getDigits(string2, pos, 4, 100))[0] == -1) {
                return isError;
            }
            result2[0] = year2[1];
            if (!LibraryUtilities.checkChars(string2, pos += year2[0], '-')) {
                return isError;
            }
            if ((month2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[1] = month2[1];
            int[] tzvalue = LibraryUtilities.parseTimeZone(string2, pos += month2[0]);
            if (tzvalue.length == 0) {
                return isError;
            }
            result2[2] = tzvalue[0];
            result2[3] = tzvalue[1];
            result2[4] = tzvalue[2];
        }
        catch (Exception e) {
            return isError;
        }
        if (!LibraryUtilities.validYear(result2[0])) {
            return isError;
        }
        if (!LibraryUtilities.validMonth(result2[1])) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[3], result2[4])) {
            return isError;
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
            result2[1] = result2[1] * -1;
        }
        return result2;
    }

    public static int[] parseGMonth(char[] string2) {
        int[] result2 = new int[4];
        int[] isError = new int[]{};
        int pos = 0;
        Arrays.fill(result2, 0);
        try {
            int[] month2;
            if (!LibraryUtilities.checkChars(string2, pos, '-')) {
                return isError;
            }
            if (!LibraryUtilities.checkChars(string2, ++pos, '-')) {
                return isError;
            }
            if ((month2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[0] = month2[1];
            int[] tzvalue = LibraryUtilities.parseTimeZone(string2, pos += month2[0]);
            if (tzvalue.length == 0) {
                return isError;
            }
            result2[1] = tzvalue[0];
            result2[2] = tzvalue[1];
            result2[3] = tzvalue[2];
        }
        catch (Exception e) {
            return isError;
        }
        if (!LibraryUtilities.validMonth(result2[0])) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[2], result2[3])) {
            return isError;
        }
        return result2;
    }

    public static int[] parseGMonthDay(char[] string2) {
        int[] result2 = new int[5];
        int[] isError = new int[]{};
        int pos = 0;
        Arrays.fill(result2, 0);
        try {
            int[] day2;
            int[] month2;
            if (!LibraryUtilities.checkChars(string2, pos, '-')) {
                return isError;
            }
            if (!LibraryUtilities.checkChars(string2, ++pos, '-')) {
                return isError;
            }
            if ((month2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[0] = month2[1];
            if (!LibraryUtilities.checkChars(string2, pos += month2[0], '-')) {
                return isError;
            }
            if ((day2 = LibraryUtilities.getDigits(string2, ++pos, 2, 2))[0] == -1) {
                return isError;
            }
            result2[1] = day2[1];
            int[] tzvalue = LibraryUtilities.parseTimeZone(string2, pos += day2[0]);
            if (tzvalue.length == 0) {
                return isError;
            }
            result2[2] = tzvalue[0];
            result2[3] = tzvalue[1];
            result2[4] = tzvalue[2];
        }
        catch (Exception e) {
            return isError;
        }
        if (!LibraryUtilities.validMonth(result2[0])) {
            return isError;
        }
        if (!LibraryUtilities.validDayOfMonth(result2[0], result2[1])) {
            return isError;
        }
        if (!LibraryUtilities.validTZ(result2[3], result2[4])) {
            return isError;
        }
        return result2;
    }

    public static int[] parseDuration(char[] string2) {
        int[] result2 = new int[7];
        int[] isError = new int[]{};
        Arrays.fill(result2, 0);
        StringBuffer temp = new StringBuffer();
        int order2 = 0;
        boolean afterT = false;
        boolean hasP = false;
        boolean isNegative = false;
        try {
            block13: for (int i = 0; i < string2.length; ++i) {
                if (string2[i] >= '0' && string2[i] <= '9') {
                    temp.append(string2[i]);
                    continue;
                }
                switch (string2[i]) {
                    case '-': {
                        if (i == 0) {
                            isNegative = true;
                            continue block13;
                        }
                        return isError;
                    }
                    case 'P': {
                        if (i == 0 || i == 1 && string2[0] == '-') {
                            if (i + 1 == string2.length) {
                                return isError;
                            }
                        } else {
                            return isError;
                        }
                        hasP = true;
                        continue block13;
                    }
                    case 'Y': {
                        if (order2 != 0) {
                            return isError;
                        }
                        result2[0] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        if (!afterT) continue block13;
                        return isError;
                    }
                    case 'M': {
                        if (!afterT) {
                            if (order2 != 0) {
                                return isError;
                            }
                            order2 = 1;
                            result2[1] = Integer.parseInt(temp.toString());
                        } else {
                            if (order2 >= 4) {
                                return isError;
                            }
                            order2 = 4;
                            result2[4] = Integer.parseInt(temp.toString());
                        }
                        temp = new StringBuffer();
                        continue block13;
                    }
                    case 'D': {
                        if (order2 >= 2) {
                            return isError;
                        }
                        order2 = 2;
                        result2[2] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        if (!afterT) continue block13;
                        return isError;
                    }
                    case 'T': {
                        if (afterT || i == string2.length - 1) {
                            return isError;
                        }
                        afterT = true;
                        continue block13;
                    }
                    case 'H': {
                        if (order2 >= 3) {
                            return isError;
                        }
                        order2 = 3;
                        result2[3] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        if (afterT) continue block13;
                        return isError;
                    }
                    case 'S': {
                        if (order2 == 5) {
                            if (temp.length() > 3) {
                                temp.delete(3, temp.length());
                            } else {
                                while (temp.length() < 3) {
                                    temp.append('0');
                                }
                            }
                            result2[6] = Integer.parseInt(temp.toString());
                        } else if (order2 < 5) {
                            result2[5] = Integer.parseInt(temp.toString());
                        } else {
                            return isError;
                        }
                        order2 = 6;
                        temp = new StringBuffer();
                        if (afterT) continue block13;
                        return isError;
                    }
                    case '.': {
                        if (order2 >= 5) {
                            return isError;
                        }
                        order2 = 5;
                        if (temp.length() > 0 && !temp.toString().equals("-")) {
                            result2[5] = Integer.parseInt(temp.toString());
                            temp = new StringBuffer();
                        }
                        if (afterT) continue block13;
                        return isError;
                    }
                    default: {
                        return isError;
                    }
                }
            }
        }
        catch (Exception e) {
            return isError;
        }
        if (!hasP) {
            return isError;
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
            result2[1] = result2[1] * -1;
            result2[2] = result2[2] * -1;
            result2[3] = result2[3] * -1;
            result2[4] = result2[4] * -1;
            result2[5] = result2[5] * -1;
            result2[6] = result2[6] * -1;
        }
        if (Math.abs(result2[5]) >= 60) {
            result2[4] = result2[4] + result2[5] / 60;
            result2[5] = result2[5] % 60;
        }
        if (Math.abs(result2[4]) >= 60) {
            result2[3] = result2[3] + result2[4] / 60;
            result2[4] = result2[4] % 60;
        }
        if (Math.abs(result2[3]) >= 24) {
            result2[2] = result2[2] + result2[3] / 24;
            result2[3] = result2[3] % 24;
        }
        if (Math.abs(result2[1]) >= 12) {
            result2[0] = result2[0] + result2[1] / 12;
            result2[1] = result2[1] % 12;
        }
        return result2;
    }

    public static int[] parseDayTimeDuration(char[] string2) {
        int[] result2 = new int[5];
        int[] isError = new int[]{};
        Arrays.fill(result2, 0);
        StringBuffer temp = new StringBuffer();
        int order2 = 0;
        boolean afterT = false;
        boolean hasP = false;
        boolean isNegative = false;
        boolean parseTime = false;
        try {
            block12: for (int i = 0; i < string2.length; ++i) {
                if (string2[i] >= '0' && string2[i] <= '9') {
                    if (i == string2.length - 1) {
                        return isError;
                    }
                    temp.append(string2[i]);
                    continue;
                }
                switch (string2[i]) {
                    case '-': {
                        if (i == 0) {
                            isNegative = true;
                            continue block12;
                        }
                        return isError;
                    }
                    case 'P': {
                        if (i == 0 || i == 1 && string2[0] == '-') {
                            if (i + 1 == string2.length) {
                                return isError;
                            }
                        } else {
                            return isError;
                        }
                        hasP = true;
                        continue block12;
                    }
                    case 'M': {
                        if (order2 >= 2) {
                            return isError;
                        }
                        order2 = 2;
                        result2[2] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        parseTime = true;
                        continue block12;
                    }
                    case 'D': {
                        if (order2 > 0) {
                            return isError;
                        }
                        order2 = 0;
                        result2[0] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        if (!afterT) continue block12;
                        return isError;
                    }
                    case 'T': {
                        if (afterT || i == string2.length - 1) {
                            return isError;
                        }
                        if (temp.length() > 0) {
                            return isError;
                        }
                        if (parseTime) {
                            return isError;
                        }
                        afterT = true;
                        continue block12;
                    }
                    case 'H': {
                        if (order2 >= 1) {
                            return isError;
                        }
                        order2 = 1;
                        result2[1] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        parseTime = true;
                        continue block12;
                    }
                    case 'S': {
                        if (order2 == 3) {
                            if (temp.length() > 3) {
                                temp.delete(3, temp.length());
                            } else {
                                while (temp.length() < 3) {
                                    temp.append('0');
                                }
                            }
                            result2[4] = Integer.parseInt(temp.toString());
                        } else if (order2 < 3) {
                            result2[3] = Integer.parseInt(temp.toString());
                        } else {
                            return isError;
                        }
                        order2 = 4;
                        temp = new StringBuffer();
                        parseTime = true;
                        continue block12;
                    }
                    case '.': {
                        if (order2 >= 3) {
                            return isError;
                        }
                        order2 = 3;
                        if (temp.length() <= 0 || temp.toString().equals("-")) continue block12;
                        result2[3] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        continue block12;
                    }
                    default: {
                        return isError;
                    }
                }
            }
        }
        catch (Exception e) {
            return isError;
        }
        if (!hasP) {
            return isError;
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
            result2[1] = result2[1] * -1;
            result2[2] = result2[2] * -1;
            result2[3] = result2[3] * -1;
            result2[4] = result2[4] * -1;
        }
        if (Math.abs(result2[3]) >= 60) {
            result2[2] = result2[2] + result2[3] / 60;
            result2[3] = result2[3] % 60;
        }
        if (Math.abs(result2[2]) >= 60) {
            result2[1] = result2[1] + result2[2] / 60;
            result2[2] = result2[2] % 60;
        }
        if (Math.abs(result2[1]) >= 24) {
            result2[0] = result2[0] + result2[1] / 24;
            result2[1] = result2[1] % 24;
        }
        return result2;
    }

    public static int[] parseYearMonthDuration(char[] string2) {
        int[] result2 = new int[2];
        int[] isError = new int[]{};
        Arrays.fill(result2, 0);
        StringBuffer temp = new StringBuffer();
        boolean order2 = false;
        boolean hasP = false;
        boolean isNegative = false;
        try {
            block8: for (int i = 0; i < string2.length; ++i) {
                if (string2[i] >= '0' && string2[i] <= '9') {
                    if (i == string2.length - 1) {
                        return isError;
                    }
                    temp.append(string2[i]);
                    continue;
                }
                switch (string2[i]) {
                    case '-': {
                        if (i == 0) {
                            isNegative = true;
                            continue block8;
                        }
                        return isError;
                    }
                    case 'P': {
                        if (i == 0 || i == 1 && string2[0] == '-') {
                            if (i + 1 == string2.length) {
                                return isError;
                            }
                        } else {
                            return isError;
                        }
                        hasP = true;
                        continue block8;
                    }
                    case 'Y': {
                        if (order2) {
                            return isError;
                        }
                        result2[0] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        continue block8;
                    }
                    case 'M': {
                        if (order2) {
                            return isError;
                        }
                        result2[1] = Integer.parseInt(temp.toString());
                        temp = new StringBuffer();
                        continue block8;
                    }
                    default: {
                        return isError;
                    }
                }
            }
        }
        catch (Exception e) {
            return isError;
        }
        if (!hasP) {
            return isError;
        }
        if (isNegative) {
            result2[0] = result2[0] * -1;
            result2[1] = result2[1] * -1;
        }
        if (Math.abs(result2[1]) >= 12) {
            result2[0] = result2[0] + result2[1] / 12;
            result2[1] = result2[1] % 12;
        }
        return result2;
    }

    public static byte[] parseHexBinary(char[] string2) {
        byte[] isError = new byte[]{};
        try {
            byte[] bytes2 = HexBin.decode(String.valueOf(string2));
            if (bytes2 == null) {
                return isError;
            }
            return bytes2;
        }
        catch (Exception e) {
            return isError;
        }
    }

    public static byte[] parseBase64Binary(char[] string2) {
        byte[] isError = new byte[]{};
        try {
            byte[] bytes2 = Base64.decode(String.valueOf(string2));
            if (bytes2 == null) {
                return isError;
            }
            return bytes2;
        }
        catch (Exception e) {
            return isError;
        }
    }

    public static int[] getImplicitTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getRawOffset();
        int[] result2 = new int[2];
        if (offset == 0) {
            result2[0] = 0;
            result2[1] = 0;
        } else {
            result2[0] = (int)Math.floor((offset /= 60000) / 60);
            result2[1] = offset % 60;
        }
        return result2;
    }

    private static boolean validMonth(int month2) {
        return month2 > 0 && month2 <= 12;
    }

    private static boolean validYear(int year2) {
        return year2 != 0;
    }

    private static boolean validDayOfMonth(int year2, int month2, int day2) {
        if (day2 <= 0) {
            return false;
        }
        if (month2 == 2 && (year2 % 100 != 0 && year2 % 4 == 0 || year2 % 400 == 0)) {
            return day2 <= 29;
        }
        return day2 <= daysInMonth[month2 - 1];
    }

    private static boolean validDayOfMonth(int month2, int day2) {
        if (day2 <= 0) {
            return false;
        }
        if (month2 == 2) {
            return day2 <= 29;
        }
        return day2 <= daysInMonth[month2 - 1];
    }

    private static boolean validHour(int hr, int min2, int sec, int millisec) {
        if (hr < 24 && hr >= 0) {
            return true;
        }
        return hr == 24 && min2 == 0 && sec == 0 && millisec == 0;
    }

    private static boolean validMinOrSec(int min2) {
        return min2 < 60 && min2 >= 0;
    }

    private static boolean validTZ(int hr, int min2) {
        if (hr < -14 || hr > 14) {
            return false;
        }
        if (min2 < -59 || min2 > 59) {
            return false;
        }
        return hr != 14 && hr != -14 || min2 == 0;
    }

    public static boolean validURI(char[] str) {
        try {
            AnyURIDV uri2 = new AnyURIDV();
            uri2.getActualValue(String.valueOf(str), null);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int[] addYearMonthDurationToDate(int year1, int month1, int day1, int tz_hour1, int tz_minute1, int year2, int month2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDate xdate = noTimezone ? new XDate(year1, month1, day1) : new XDate(year1, month1, day1, tz_hour1, tz_minute1);
        XYearMonthDuration xymd = new XYearMonthDuration(year2, month2);
        XDate result2 = xdate.add(xymd);
        if (noTimezone) {
            int[] nArray2 = new int[3];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray = nArray2;
            nArray2[2] = result2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addDayTimeDurationToDate(int year1, int month1, int day1, int tz_hour1, int tz_minute1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDate xdate = noTimezone ? new XDate(year1, month1, day1) : new XDate(year1, month1, day1, tz_hour1, tz_minute1);
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XDate result2 = xdate.add(xdtd);
        if (noTimezone) {
            int[] nArray2 = new int[3];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray = nArray2;
            nArray2[2] = result2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addDayTimeDurationToTime(int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        double sec1 = (double)(second1 * 1000 + millisecond1) / 1000.0;
        XTime xtime = noTimezone ? new XTime(hour1, minute1, sec1) : new XTime(hour1, minute1, sec1, tz_hour1, tz_minute1);
        double sec2 = (double)(second2 * 1000 + millisecond2) / 1000.0;
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour2, minute2, sec2);
        XTime result2 = xtime.add(xdtd);
        double resultSeconds = result2.getSecond();
        double msD = (resultSeconds - (double)((int)resultSeconds)) * 1000.0;
        long msL = Math.round(msD);
        if (noTimezone) {
            int[] nArray2 = new int[4];
            nArray2[0] = result2.getHour();
            nArray2[1] = result2.getMinute();
            nArray2[2] = (int)resultSeconds;
            nArray = nArray2;
            nArray2[3] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = result2.getHour();
            nArray3[1] = result2.getMinute();
            nArray3[2] = (int)resultSeconds;
            nArray3[3] = (int)msL;
            nArray3[4] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[5] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addYearMonthDurationToDateTime(int year1, int month1, int day1, int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int year2, int month2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDateTime xdatetime = noTimezone ? new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0) : new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XYearMonthDuration xymd = new XYearMonthDuration(year2, month2);
        XDateTime result2 = xdatetime.add(xymd);
        double resultSeconds = result2.getSecond();
        if (noTimezone) {
            int[] nArray2 = new int[7];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray2[2] = result2.getDay();
            nArray2[3] = result2.getHour();
            nArray2[4] = result2.getMinute();
            nArray2[5] = (int)resultSeconds;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getHour();
            nArray3[4] = result2.getMinute();
            nArray3[5] = (int)resultSeconds;
            nArray3[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
            nArray3[7] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addDayTimeDurationToDateTime(int year1, int month1, int day1, int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDateTime xdatetime = noTimezone ? new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0) : new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XDateTime result2 = xdatetime.add(xdtd);
        double resultSeconds = result2.getSecond();
        if (noTimezone) {
            int[] nArray2 = new int[7];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray2[2] = result2.getDay();
            nArray2[3] = result2.getHour();
            nArray2[4] = result2.getMinute();
            nArray2[5] = (int)resultSeconds;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getHour();
            nArray3[4] = result2.getMinute();
            nArray3[5] = (int)resultSeconds;
            nArray3[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
            nArray3[7] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addYearMonthDurations(int year1, int month1, int year2, int month2) {
        XYearMonthDuration xymd1 = new XYearMonthDuration(year1, month1);
        XYearMonthDuration xymd2 = new XYearMonthDuration(year2, month2);
        XYearMonthDuration result2 = xymd1.add(xymd2);
        return new int[]{result2.getYears(), result2.getMonths()};
    }

    public static int[] addDayTimeDurations(int day1, int hour1, int minute1, int second1, int millisecond1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        XDayTimeDuration xymd1 = new XDayTimeDuration(day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0);
        XDayTimeDuration xymd2 = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XDayTimeDuration result2 = xymd1.add(xymd2);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static int[] subtractYearMonthDurationFromDate(int year1, int month1, int day1, int tz_hour1, int tz_minute1, int year2, int month2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDate xdate = noTimezone ? new XDate(year1, month1, day1) : new XDate(year1, month1, day1, tz_hour1, tz_minute1);
        XYearMonthDuration xymd = new XYearMonthDuration(year2, month2);
        XDate result2 = xdate.subtract(xymd);
        if (noTimezone) {
            int[] nArray2 = new int[3];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray = nArray2;
            nArray2[2] = result2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractDayTimeDurationFromDate(int year1, int month1, int day1, int tz_hour1, int tz_minute1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDate xdate = noTimezone ? new XDate(year1, month1, day1) : new XDate(year1, month1, day1, tz_hour1, tz_minute1);
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XDate result2 = xdate.subtract(xdtd);
        if (noTimezone) {
            int[] nArray2 = new int[3];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray = nArray2;
            nArray2[2] = result2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractTimes(int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int hour2, int minute2, int second2, int millisecond2, int tz_hour2, int tz_minute2) {
        XTime xtime1 = new XTime(hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XTime xtime2 = new XTime(hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0, tz_hour2, tz_minute2);
        XDayTimeDuration result2 = xtime1.subtract(xtime2);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static int[] subtractDayTimeDurationFromTime(int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XTime xtime = noTimezone ? new XTime(hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0) : new XTime(hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XTime result2 = xtime.subtract(xdtd);
        double resultSeconds = result2.getSecond();
        if (noTimezone) {
            int[] nArray2 = new int[4];
            nArray2[0] = result2.getHour();
            nArray2[1] = result2.getMinute();
            nArray2[2] = (int)resultSeconds;
            nArray = nArray2;
            nArray2[3] = (int)(resultSeconds * 1000.0) - (int)resultSeconds * 1000;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = result2.getHour();
            nArray3[1] = result2.getMinute();
            nArray3[2] = (int)resultSeconds;
            nArray3[3] = (int)(resultSeconds * 1000.0) - (int)resultSeconds * 1000;
            nArray3[4] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[5] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractYearMonthDurationFromDateTime(int year1, int month1, int day1, int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int year2, int month2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDateTime xdatetime = noTimezone ? new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0) : new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XYearMonthDuration xymd = new XYearMonthDuration(year2, month2);
        XDateTime result2 = xdatetime.subtract(xymd);
        double resultSeconds = result2.getSecond();
        if (noTimezone) {
            int[] nArray2 = new int[7];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray2[2] = result2.getDay();
            nArray2[3] = result2.getHour();
            nArray2[4] = result2.getMinute();
            nArray2[5] = (int)resultSeconds;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getHour();
            nArray3[4] = result2.getMinute();
            nArray3[5] = (int)resultSeconds;
            nArray3[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
            nArray3[7] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractDayTimeDurationFromDateTime(int year1, int month1, int day1, int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        int[] nArray;
        boolean noTimezone = tz_hour1 > 24;
        XDateTime xdatetime = noTimezone ? new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0) : new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XDateTime result2 = xdatetime.subtract(xdtd);
        double resultSeconds = result2.getSecond();
        if (noTimezone) {
            int[] nArray2 = new int[7];
            nArray2[0] = result2.getYear();
            nArray2[1] = result2.getMonth();
            nArray2[2] = result2.getDay();
            nArray2[3] = result2.getHour();
            nArray2[4] = result2.getMinute();
            nArray2[5] = (int)resultSeconds;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = result2.getYear();
            nArray3[1] = result2.getMonth();
            nArray3[2] = result2.getDay();
            nArray3[3] = result2.getHour();
            nArray3[4] = result2.getMinute();
            nArray3[5] = (int)resultSeconds;
            nArray3[6] = (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0);
            nArray3[7] = result2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = result2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractDatesYieldingDayTimeDuration(int year1, int month1, int day1, int tz_hour1, int tz_minute1, int year2, int month2, int day2, int tz_hour2, int tz_minute2) {
        XDate xdate1 = new XDate(year1, month1, day1, tz_hour1, tz_minute1);
        XDate xdate2 = new XDate(year2, month2, day2, tz_hour2, tz_minute2);
        XDayTimeDuration result2 = xdate1.subtract(xdate2);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static int[] subtractDateTimesYieldingDayTimeDuration(int year1, int month1, int day1, int hour1, int minute1, int second1, int millisecond1, int tz_hour1, int tz_minute1, int year2, int month2, int day2, int hour2, int minute2, int second2, int millisecond2, int tz_hour2, int tz_minute2) {
        XDateTime xdatetime1 = new XDateTime(year1, month1, day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0, tz_hour1, tz_minute1);
        XDateTime xdatetime2 = new XDateTime(year2, month2, day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0, tz_hour2, tz_minute2);
        XDayTimeDuration result2 = xdatetime1.subtract(xdatetime2);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static int[] subtractYearMonthDurations(int year1, int month1, int year2, int month2) {
        XYearMonthDuration xymd1 = new XYearMonthDuration(year1, month1);
        XYearMonthDuration xymd2 = new XYearMonthDuration(year2, month2);
        XYearMonthDuration result2 = xymd1.subtract(xymd2);
        return new int[]{result2.getYears(), result2.getMonths()};
    }

    public static int[] subtractDayTimeDurations(int day1, int hour1, int minute1, int second1, int millisecond1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        XDayTimeDuration xdtd1 = new XDayTimeDuration(day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0);
        XDayTimeDuration xdtd2 = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        XDayTimeDuration result2 = xdtd1.subtract(xdtd2);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static int[] multiplyYearMonthDuration(int year2, int month2, double val) {
        XYearMonthDuration xymd = new XYearMonthDuration(year2, month2);
        XYearMonthDuration result2 = xymd.multiply(val);
        return new int[]{result2.getYears(), result2.getMonths()};
    }

    public static int[] multiplyDayTimeDuration(int day2, int hour, int minute, int second, int millisecond, double val) {
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour, minute, (double)second + (double)millisecond / 1000.0);
        XDayTimeDuration result2 = xdtd.multiply(val);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static int[] DivideYearMonthDuration(int year2, int month2, double val) {
        XYearMonthDuration xymd = new XYearMonthDuration(year2, month2);
        XYearMonthDuration result2 = xymd.divide(val);
        return new int[]{result2.getYears(), result2.getMonths()};
    }

    public static int[] DivideDayTimeDuration(int day2, int hour, int minute, int second, int millisecond, double val) {
        XDayTimeDuration xdtd = new XDayTimeDuration(day2, hour, minute, (double)second + (double)millisecond / 1000.0);
        XDayTimeDuration result2 = xdtd.divide(val);
        double resultSeconds = result2.getSeconds();
        return new int[]{result2.getDays(), result2.getHours(), result2.getMinutes(), (int)resultSeconds, (int)Math.round((resultSeconds - (double)((int)resultSeconds)) * 1000.0)};
    }

    public static BigDecimal divideYearMonthDurationByYearMonthDuration(int year1, int month1, int year2, int month2) {
        XYearMonthDuration xymd1 = new XYearMonthDuration(year1, month1);
        XYearMonthDuration xymd2 = new XYearMonthDuration(year2, month2);
        return xymd1.divide(xymd2);
    }

    public static BigDecimal divideDayTimeDurationByDayTimeDuration(int day1, int hour1, int minute1, int second1, int millisecond1, int day2, int hour2, int minute2, int second2, int millisecond2) {
        XDayTimeDuration xdtd1 = new XDayTimeDuration(day1, hour1, minute1, (double)second1 + (double)millisecond1 / 1000.0);
        XDayTimeDuration xdtd2 = new XDayTimeDuration(day2, hour2, minute2, (double)second2 + (double)millisecond2 / 1000.0);
        return xdtd1.divide(xdtd2);
    }

    public static int[] currentDateTime() {
        Calendar cal = GregorianCalendar.getInstance();
        int[] result2 = new int[]{cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 0};
        return result2;
    }

    public static int getJavaType(Object object2) {
        if (object2 == null) {
            return 1024;
        }
        Class<?> clazz = object2.getClass();
        if (clazz.isArray()) {
            return 512;
        }
        for (int i = 0; i < CLASS_ARRAY.length; ++i) {
            if (clazz != CLASS_ARRAY[i]) continue;
            return i;
        }
        return -1;
    }

    public static char[] validateSchemaString(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        char[] isEmpty = new char[]{};
        String str = String.valueOf(value2);
        try {
            XSSimpleType typeValidator = (XSSimpleType)type2;
            XValidationContext ctx = new XValidationContext(inScopeNamespaces);
            ValidatedInfo info = new ValidatedInfo();
            typeValidator.validate(str, (ValidationContext)ctx, info);
            Object val = info.actualValue;
            return ((String)val).toCharArray();
        }
        catch (Exception e) {
            return isEmpty;
        }
    }

    public static boolean isValidSchemaString(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        String str = String.valueOf(value2);
        try {
            if (type2 instanceof XSSimpleType) {
                XSSimpleType typeValidator = (XSSimpleType)type2;
                XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                ValidatedInfo info = new ValidatedInfo();
                typeValidator.validate(str, (ValidationContext)ctx, info);
                Object val = info.actualValue;
                return val instanceof String;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean[] validateSchemaBoolean(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        boolean[] isError;
        block4: {
            isError = new boolean[]{};
            boolean[] result2 = new boolean[1];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof Boolean) {
                        result2[0] = (Boolean)val;
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static double[] validateSchemaDouble(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        double[] isError;
        block4: {
            isError = new double[]{};
            double[] result2 = new double[1];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof XSDouble) {
                        XSDouble xsVal = (XSDouble)val;
                        result2[0] = xsVal.getValue();
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static float[] validateSchemaFloat(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        float[] isError;
        block4: {
            isError = new float[]{};
            float[] result2 = new float[1];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof XSFloat) {
                        XSFloat xsVal = (XSFloat)val;
                        result2[0] = xsVal.getValue();
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static long[] validateSchemaLong(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        long[] isError;
        block4: {
            isError = new long[]{};
            long[] result2 = new long[1];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof XSDecimal) {
                        XSDecimal xsVal = (XSDecimal)val;
                        result2[0] = xsVal.getLong();
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static BigInteger[] validateSchemaBigInteger(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        BigInteger[] isError;
        block4: {
            isError = new BigInteger[]{};
            BigInteger[] result2 = new BigInteger[1];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof XSDecimal) {
                        XSDecimal xsVal = (XSDecimal)val;
                        result2[0] = xsVal.getBigInteger();
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static BigDecimal[] validateSchemaDecimal(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        BigDecimal[] isError;
        block4: {
            isError = new BigDecimal[]{};
            BigDecimal[] result2 = new BigDecimal[1];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof XSDecimal) {
                        XSDecimal xsVal = (XSDecimal)val;
                        result2[0] = xsVal.getBigDecimal();
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static byte[] validateSchemaHexBase64Binary(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        byte[] isEmpty = new byte[]{};
        String str = String.valueOf(value2);
        try {
            XSSimpleType typeValidator = (XSSimpleType)type2;
            XValidationContext ctx = new XValidationContext(inScopeNamespaces);
            ValidatedInfo info = new ValidatedInfo();
            typeValidator.validate(str, (ValidationContext)ctx, info);
            Object val = info.actualValue;
            ByteList xsVal = (ByteList)val;
            int len = xsVal.getLength();
            byte[] result2 = new byte[len];
            for (int i = 0; i < len; ++i) {
                result2[i] = xsVal.item(i);
            }
            return result2;
        }
        catch (Exception e) {
            return isEmpty;
        }
    }

    public static boolean isValidSchemaHexBase64Binary(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        String str = String.valueOf(value2);
        try {
            if (type2 instanceof XSSimpleType) {
                XSSimpleType typeValidator = (XSSimpleType)type2;
                XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                ValidatedInfo info = new ValidatedInfo();
                typeValidator.validate(str, (ValidationContext)ctx, info);
                Object val = info.actualValue;
                return val instanceof ByteList;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int[] validateSchemaDateTime(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        int[] isError;
        block4: {
            isError = new int[]{};
            int[] result2 = new int[10];
            String str = String.valueOf(value2);
            try {
                if (type2 instanceof XSSimpleType) {
                    XSSimpleType typeValidator = (XSSimpleType)type2;
                    XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                    ValidatedInfo info = new ValidatedInfo();
                    typeValidator.validate(str, (ValidationContext)ctx, info);
                    Object val = info.actualValue;
                    if (val instanceof XSDateTime) {
                        XSDateTime xsVal = (XSDateTime)val;
                        result2[0] = xsVal.getYears();
                        result2[1] = xsVal.getMonths();
                        result2[2] = xsVal.getDays();
                        result2[3] = xsVal.getHours();
                        result2[4] = xsVal.getMinutes();
                        double seconds2 = xsVal.getSeconds();
                        result2[5] = (int)Math.floor(seconds2);
                        result2[6] = (int)Math.floor(seconds2 % 1.0 * 1000.0);
                        result2[7] = xsVal.hasTimeZone() ? 1 : 0;
                        result2[8] = xsVal.getTimeZoneHours();
                        result2[9] = xsVal.getTimeZoneMinutes();
                        return result2;
                    }
                    break block4;
                }
                return isError;
            }
            catch (Exception e) {
                return isError;
            }
        }
        return isError;
    }

    public static QName validateSchemaQName(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        String str = String.valueOf(value2);
        try {
            XSSimpleType typeValidator = (XSSimpleType)type2;
            XValidationContext ctx = new XValidationContext(inScopeNamespaces);
            ValidatedInfo info = new ValidatedInfo();
            typeValidator.validate(str, (ValidationContext)ctx, info);
            Object val = info.actualValue;
            XSQName xsVal = (XSQName)val;
            return xsVal.getJAXPQName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidSchemaQName(XSTypeDefinition type2, char[] value2, Hashtable inScopeNamespaces) {
        String str = String.valueOf(value2);
        try {
            if (type2 instanceof XSSimpleType) {
                XSSimpleType typeValidator = (XSSimpleType)type2;
                XValidationContext ctx = new XValidationContext(inScopeNamespaces);
                ValidatedInfo info = new ValidatedInfo();
                typeValidator.validate(str, (ValidationContext)ctx, info);
                Object val = info.actualValue;
                return val instanceof XSQName;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

