/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.AbstractTranslet;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatInt;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.Translet;
import java.util.Vector;

public abstract class NodeCounter {
    protected int _value = Integer.MIN_VALUE;
    public final Translet _translet;
    private final NumberFormatFactoryRuleBased _formatFactory;
    private final NumberFormatInt _formater;
    protected String _format;
    protected String _lang;
    protected String _letterValue = "alphabetic";
    protected String _groupSep = ",";
    protected int _groupSize = 3;
    protected String _ordinal = "no";
    private boolean _separFirst = true;
    private boolean _separLast = false;
    private Vector _separToks = new Vector();
    private Vector _formatToks = new Vector();
    private int _nSepars = 0;
    private int _nFormats = 0;

    protected NodeCounter(Translet translet) {
        this._translet = translet;
        this._formatFactory = ((AbstractTranslet)this._translet).getRBNFFactory();
        this._formater = new NumberFormatInt(this._formatFactory);
        this.setTokens("1");
        this._format = "1";
    }

    public NodeCounter setValue(int value2) {
        this._value = value2;
        return this;
    }

    public NodeCounter setDefaultFormatting() {
        this.setFormatting("1", "en-US", "alphabetic", ",", "3", "no");
        return this;
    }

    public NodeCounter setFormatting(String format2, String lang2, String letterValue, String groupSep, String groupSize) {
        return this.setFormatting(format2, lang2, letterValue, groupSep, groupSize, null);
    }

    public NodeCounter setFormatting(String format2, String lang2, String letterValue, String groupSep, String groupSize, String ordinal) {
        if (format2 == null && format2.length() == 0) {
            this.setTokens("1");
        } else {
            this.setTokens(format2);
        }
        if (lang2 != null && lang2.length() != 0) {
            this._lang = lang2;
        }
        if (ordinal != null && ordinal.length() != 0) {
            this._ordinal = ordinal;
        }
        if (letterValue != null && letterValue.length() != 0) {
            this._letterValue = letterValue;
        }
        if (groupSep != null && groupSep.length() != 0 && groupSize != null && groupSize.length() != 0) {
            try {
                this._groupSize = Integer.parseInt(groupSize);
            }
            catch (Exception e) {
                this._groupSize = 3;
            }
            this._groupSep = groupSep;
        } else {
            this._groupSep = ",";
            this._groupSize = 3;
        }
        return this;
    }

    private final void setTokens(String format2) {
        if (format2.equals(this._format)) {
            return;
        }
        this._format = format2;
        int length2 = this._format.length();
        boolean isFirst = true;
        this._separFirst = true;
        this._separLast = false;
        this._nSepars = 0;
        this._nFormats = 0;
        this._separToks.clear();
        this._formatToks.clear();
        int j = 0;
        int i = 0;
        while (i < length2) {
            char c = format2.charAt(i);
            j = i;
            while (Character.isLetterOrDigit(c) && ++i != length2) {
                c = format2.charAt(i);
            }
            if (i > j) {
                if (isFirst) {
                    this._separToks.addElement(".");
                    this._separFirst = false;
                    isFirst = false;
                }
                this._formatToks.addElement(format2.substring(j, i));
            }
            if (i == length2) break;
            c = format2.charAt(i);
            j = i;
            while (!Character.isLetterOrDigit(c) && ++i != length2) {
                c = format2.charAt(i);
                isFirst = false;
            }
            if (i <= j) continue;
            this._separToks.addElement(format2.substring(j, i));
        }
        this._nSepars = this._separToks.size();
        this._nFormats = this._formatToks.size();
        if (this._nSepars > this._nFormats) {
            this._separLast = true;
        }
        if (this._separFirst) {
            --this._nSepars;
        }
        if (this._separLast) {
            --this._nSepars;
        }
        if (this._nSepars == 0) {
            this._separToks.insertElementAt(".", 1);
            ++this._nSepars;
        }
        if (this._nFormats == 0) {
            this._formatToks.add("1");
            ++this._nFormats;
        }
        if (this._separFirst) {
            ++this._nSepars;
        }
    }

    public abstract String getCounter();

    public String getCounter(String format2, String lang2, String letterValue, String groupSep, String groupSize, String ordinal) {
        this.setFormatting(format2, lang2, letterValue, groupSep, groupSize, ordinal);
        return this.getCounter();
    }

    public String getCounter(String format2, String lang2, String letterValue, String groupSep, String groupSize) {
        return this.getCounter(format2, lang2, letterValue, groupSep, groupSize, null);
    }

    public String formatNumbers(int value2) {
        return this.formatNumbers(new int[]{value2});
    }

    public String formatNumbers(Integer[] values2) {
        int l = values2.length;
        int[] v = new int[l];
        while (--l >= 0) {
            v[l] = values2[l];
        }
        return this.formatNumbers(v);
    }

    public String formatNumbers(Integer value2) {
        return this.formatNumbers(new int[]{value2});
    }

    public char[] stringToStream(String s) {
        int l = s.length();
        char[] c = new char[l];
        s.getChars(0, l, c, 0);
        return c;
    }

    public String formatNumbers(int[] values2) {
        int nValues = values2.length;
        boolean isEmpty = true;
        for (int i = 0; i < nValues; ++i) {
            if (values2[i] == Integer.MIN_VALUE) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            return "";
        }
        boolean isFirst = true;
        int t = 0;
        int n2 = 0;
        int s = 1;
        StringBuffer buffer = new StringBuffer();
        if (this._separFirst) {
            buffer.append((String)this._separToks.elementAt(0));
        }
        String token = null;
        String add2 = null;
        while (n2 < nValues) {
            int value2 = values2[n2];
            if (value2 != Integer.MIN_VALUE) {
                if (!isFirst) {
                    buffer.append((String)this._separToks.elementAt(s++));
                }
                token = (String)this._formatToks.elementAt(t++);
                add2 = this._formater.formatValue(value2, token, this._groupSize, this._groupSep, this._letterValue, this._lang, this._ordinal);
                buffer.append(add2);
                if (t == this._nFormats) {
                    --t;
                }
                if (s >= this._nSepars) {
                    --s;
                }
                isFirst = false;
            }
            ++n2;
        }
        if (this._separLast) {
            buffer.append((String)this._separToks.lastElement());
        }
        return buffer.toString();
    }
}

