/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class NumberFormatInt {
    private static final String DIGITS = "0123456789";
    private static final char CJK_IDEOGRAPH_FIRST = '\u4e00';
    private static final String KANJI_DIGITS = "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
    private static final char LATIN_CAPITAL_LETTER_A = 'A';
    private static final String ENGLISH_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char LATIN_SMALL_LETTER_A = 'a';
    private static final String ENGLISH_LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final char GREEK_CAPITAL_LETTER_ALPHA = '\u0391';
    private static final String GREEK_UPPER = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    private static final char GREEK_SMALL_LETTER_ALPHA = '\u03b1';
    private static final String GREEK_LOWER = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    private static final char CYRILLIC_CAPITAL_LETTER_A = '\u0410';
    private static final String RUSSIAN_UPPER = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    private static final char CYRILLIC_SMALL_LETTER_A = '\u0430';
    private static final String RUSSIAN_LOWER = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    private static final char HEBREW_LETTER_ALEF = '\u05d0';
    private static final String HEBREW = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    private static final char HIRAGANA_LETTER_A = '\u3042';
    private static final String HIRAGANA_A = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    private static final char KATAKANA_LETTER_A = '\u30a2';
    private static final String KATAKANA_A = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    private static final char HIRAGANA_LETTER_I = '\u3044';
    private static final String HIRAGANA_I = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    private static final char KATAKANA_LETTER_I = '\u30a4';
    private static final String KATAKANA_I = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    private static final String[] ROMAN_THOUSANDS = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static final String[] ROMAN_HUNDREDS = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static final String[] ROMAN_TENS = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static final String[] ROMAN_ONES = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    private static final Hashtable ordinalTable = new Hashtable();
    public static final String DEFAULT_FORMAT = "1";
    public static final String DEFAULT_LANG = "en-US";
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US", "");
    public static final String DEFAULT_LETTERVALUE = "alphabetic";
    public static final String DEFAULT_GROUPSEP = ",";
    public static final int DEFAULT_GROUPSIZE = 3;
    public static final String DEFAULT_ORDINAL = "no";
    private final NumberFormatFactoryRuleBased _factory;
    private final StringUtility _sUtil;
    private Locale[] m_Locales;
    private ArrayList m_LocaleNames;

    public static NumberFormatInt getInstance() {
        return new NumberFormatInt(NumberFormatFactoryRuleBased.getInstance());
    }

    public NumberFormatInt(NumberFormatFactoryRuleBased factory) {
        this._factory = factory;
        this._sUtil = factory != null ? new ICUStringUtility() : new StringUtility();
    }

    public final String formatValue(long value2, String token, int groupSize, String groupSeparator, String letterValue, String lang2, String ordinal) {
        if (value2 == 0L && value2 < 0L) {
            return "" + -value2;
        }
        if (ordinal.equals("yes")) {
            NumberFormatInt.initializeOrdinalHashtable();
        }
        StringBuffer buff = new StringBuffer();
        char firstCh = token.charAt(0);
        switch (firstCh) {
            case '0': 
            case '1': {
                buff.append(this.digitValue(value2, DIGITS, token, groupSize, groupSeparator, lang2, ordinal));
                break;
            }
            case '\u4e00': {
                buff.append(this.digitValue(value2, KANJI_DIGITS, token, groupSize, groupSeparator, lang2, ordinal));
                break;
            }
            case 'i': {
                buff.append(NumberFormatInt.romanValue(value2));
                break;
            }
            case 'I': {
                buff.append(NumberFormatInt.romanValue(value2).toUpperCase());
                break;
            }
            case 'N': 
            case 'W': 
            case 'n': 
            case 'w': {
                buff.append(this.spellValue(value2, token, groupSize, groupSeparator, lang2, ordinal));
                break;
            }
            case 'A': {
                NumberFormatInt.alphaValue(buff, value2, 0, ENGLISH_UPPER);
                break;
            }
            case 'a': {
                NumberFormatInt.alphaValue(buff, value2, 0, ENGLISH_LOWER);
                break;
            }
            case '\u0391': {
                NumberFormatInt.alphaValue(buff, value2, 0, GREEK_UPPER);
                break;
            }
            case '\u03b1': {
                NumberFormatInt.alphaValue(buff, value2, 0, GREEK_LOWER);
                break;
            }
            case '\u0410': {
                NumberFormatInt.alphaValue(buff, value2, 0, RUSSIAN_UPPER);
                break;
            }
            case '\u0430': {
                NumberFormatInt.alphaValue(buff, value2, 0, RUSSIAN_LOWER);
                break;
            }
            case '\u05d0': {
                NumberFormatInt.alphaValue(buff, value2, 0, HEBREW);
                break;
            }
            case '\u3042': {
                NumberFormatInt.alphaValue(buff, value2, 0, HIRAGANA_A);
                break;
            }
            case '\u30a2': {
                NumberFormatInt.alphaValue(buff, value2, 0, KATAKANA_A);
                break;
            }
            case '\u3044': {
                NumberFormatInt.alphaValue(buff, value2, 0, HIRAGANA_I);
                break;
            }
            case '\u30a4': {
                NumberFormatInt.alphaValue(buff, value2, 0, KATAKANA_I);
                break;
            }
            default: {
                if (lang2 == null || lang2.equals("en") || lang2.startsWith("en_")) {
                    if ('A' <= firstCh && firstCh <= 'Z') {
                        int base2 = firstCh - 65;
                        NumberFormatInt.alphaValue(buff, value2, base2, ENGLISH_UPPER);
                        break;
                    }
                    if ('a' <= firstCh && firstCh <= 'z') {
                        int base3 = firstCh - 97;
                        NumberFormatInt.alphaValue(buff, value2, base3, ENGLISH_LOWER);
                        break;
                    }
                }
                buff.append(this.digitValue(value2, DIGITS, DEFAULT_FORMAT, groupSize, groupSeparator, lang2, ordinal));
            }
        }
        return buff.toString();
    }

    private final String spellValue(long value2, String token, int groupSize, String groupSeparator, String lang2, String ordinal) {
        if (this._factory != null) {
            Locale locale = this.getLocale(lang2);
            String out = ((ICUStringUtility)this._sUtil).spellNumber(value2, token, this._factory, locale, ordinal);
            if (out != null) {
                return out;
            }
        } else {
            Locale locale = this.getLocale(lang2);
            String out = this._sUtil.spellNumber(value2, token, this._factory, locale, ordinal);
            if (out != null) {
                return out;
            }
        }
        return this.digitValue(value2, DIGITS, DEFAULT_FORMAT, groupSize, groupSeparator, lang2, ordinal);
    }

    private static final StringBuffer alphaValue(StringBuffer sb, long value2, int base2, String alphabet) {
        if (value2 <= 0L) {
            return sb.append("" + value2);
        }
        int range = alphabet.length() - base2;
        char last2 = alphabet.charAt(base2 + (int)((value2 - 1L) % (long)range));
        if (value2 > (long)range) {
            return NumberFormatInt.alphaValue(sb, (value2 - 1L) / (long)range, base2, alphabet).append(last2);
        }
        return sb.append("" + last2);
    }

    private final String digitValue(long value2, String digits, String token, int groupSize, String groupSeparator, String lang2, String ordinal) {
        int i;
        Locale locale;
        String out;
        if (this._factory != null && ordinal != null && ordinal.equals("yes") && (out = ((ICUStringUtility)this._sUtil).ordinalNumber(value2, this._factory, locale = this.getLocale(lang2))) != null) {
            return out;
        }
        StringBuffer buff = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        int base2 = digits.length();
        String s = "";
        for (long n2 = value2; n2 > 0L; n2 /= (long)base2) {
            s = digits.charAt((int)(n2 % (long)base2)) + s;
        }
        for (i = 0; i < token.length() - s.length(); ++i) {
            temp.append(digits.charAt(0));
        }
        temp.append(s);
        if (groupSize > 0) {
            for (i = 0; i < temp.length(); ++i) {
                if (i != 0 && (temp.length() - i) % groupSize == 0) {
                    buff.append(groupSeparator);
                }
                buff.append(temp.charAt(i));
            }
        } else {
            buff = temp;
        }
        return buff.toString();
    }

    private static String romanValue(long n2) {
        if (n2 <= 0L || n2 > 9999L) {
            return "" + n2;
        }
        return ROMAN_THOUSANDS[(int)n2 / 1000] + ROMAN_HUNDREDS[(int)n2 / 100 % 10] + ROMAN_TENS[(int)n2 / 10 % 10] + ROMAN_ONES[(int)n2 % 10];
    }

    private final Locale getLocale(String lang2) {
        Locale ret;
        if (lang2 == null || lang2.length() == 0) {
            ret = DEFAULT_LOCALE;
        } else {
            if (this.m_Locales == null) {
                Locale[] locs = this._factory != null ? this._factory.getAvailableLocales() : NumberFormat.getAvailableLocales();
                ArrayList<String> locNames = new ArrayList<String>();
                for (int i = 0; i < locs.length; ++i) {
                    locNames.add(locs[i].toString());
                }
                this.m_Locales = locs;
                this.m_LocaleNames = locNames;
            }
            ret = LocaleUtility.IETFToValidLocale(lang2, this.m_Locales, this.m_LocaleNames);
        }
        return ret;
    }

    private static String lowerCaseASingleWord(String strValue, String inWord, String outWord) {
        if (strValue.indexOf(inWord) < 0) {
            return strValue;
        }
        StringTokenizer st = new StringTokenizer(strValue);
        StringBuffer sb = new StringBuffer();
        boolean hasMore = st.hasMoreTokens();
        while (hasMore) {
            String str = st.nextToken();
            if (str.equals(inWord)) {
                sb.append(outWord);
            } else {
                sb.append(str);
            }
            if (!(hasMore = st.hasMoreTokens())) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public String applyPresentationModifier(String modifier, String value2, Locale locale) {
        if (modifier.equals("w") || modifier.equals("n")) {
            if (this._factory != null) {
                return ((ICUStringUtility)this._sUtil).toLowerCase(locale, value2);
            }
            return this._sUtil.toLowerCase(locale, value2);
        }
        if (modifier.equals("W") || modifier.equals("N")) {
            if (this._factory != null) {
                return ((ICUStringUtility)this._sUtil).toUpperCase(locale, value2);
            }
            return this._sUtil.toUpperCase(locale, value2);
        }
        if (modifier.equals("Ww") || modifier.equals("Nn")) {
            if (this._factory != null) {
                return ((ICUStringUtility)this._sUtil).toTitleCase(locale, value2);
            }
            return this._sUtil.toTitleCase(locale, value2);
        }
        return null;
    }

    private static void initializeOrdinalHashtable() {
        ordinalTable.put("one", "first");
        ordinalTable.put("two", "second");
        ordinalTable.put("three", "third");
        ordinalTable.put("four", "fourth");
        ordinalTable.put("five", "fifth");
        ordinalTable.put("six", "sixth");
        ordinalTable.put("seven", "seventh");
        ordinalTable.put("eight", "eighth");
        ordinalTable.put("nine", "ninth");
        ordinalTable.put("ten", "tenth");
        ordinalTable.put("eleven", "eleventh");
        ordinalTable.put("twelve", "twelfth");
        ordinalTable.put("thirteen", "thirteenth");
        ordinalTable.put("fourteen", "fourteenth");
        ordinalTable.put("fifteen", "fifteenth");
        ordinalTable.put("sixteen", "sixteenth");
        ordinalTable.put("seventeen", "seventeenth");
        ordinalTable.put("eighteen", "eighteenth");
        ordinalTable.put("nineteen", "nineteenth");
        ordinalTable.put("twenty", "twentieth");
        ordinalTable.put("thirty", "thirtieth");
        ordinalTable.put("forty", "fortieth");
        ordinalTable.put("fifty", "fiftieth");
        ordinalTable.put("sixty", "sixtieth");
        ordinalTable.put("seventy", "seventieth");
        ordinalTable.put("eighty", "eightieth");
        ordinalTable.put("ninety", "ninetieth");
        ordinalTable.put("hundred", "hundredth");
        ordinalTable.put("thousand", "thousandth");
        ordinalTable.put("million", "millionth");
    }

    private static class StringUtility {
        private StringUtility() {
        }

        private String spellNumber(long value2, String token, NumberFormatFactoryRuleBased factory, Locale locale, String ordinal) {
            String out = new NumberSpeller().spellNumber((int)value2);
            if (locale.equals(Locale.ENGLISH)) {
                out = out.replace('-', ' ');
                if (ordinal.equals("yes")) {
                    int index2 = out.lastIndexOf(" ");
                    if (index2 == -1) {
                        out = (String)ordinalTable.get(out);
                    } else {
                        String str = (String)ordinalTable.get(out.substring(index2 + 1));
                        out = out.substring(0, index2 + 1) + str;
                    }
                    if (token.endsWith("o")) {
                        token = token.substring(0, token.indexOf("o"));
                    }
                }
            }
            if (token.equals("w") || token.equals("n")) {
                return this.toLowerCase(locale, out);
            }
            if (token.equals("W") || token.equals("N")) {
                return this.toUpperCase(locale, out);
            }
            if (token.equals("Ww") || token.equals("Nn")) {
                String retValue = this.toTitleCase(locale, out);
                return NumberFormatInt.lowerCaseASingleWord(retValue, "And", "and");
            }
            return null;
        }

        private String ordinalNumber(long value2, NumberFormatFactoryRuleBased factory, Locale locale) {
            return null;
        }

        private String toUpperCase(Locale locale, String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            return str.toUpperCase(locale);
        }

        private String toLowerCase(Locale locale, String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            return str.toLowerCase(locale);
        }

        private String toTitleCase(Locale locale, String str) {
            return this.toTitleCase(str);
        }

        private final String toTitleCase(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            StringBuffer out = new StringBuffer(str);
            int len = out.length();
            char first = out.charAt(0);
            if (Character.isLetter(first) && !Character.isTitleCase(first)) {
                out.setCharAt(0, Character.toTitleCase(first));
            }
            char ch = first;
            char before2 = ' ';
            for (int i = 1; i < len; ++i) {
                ch = out.charAt(i);
                before2 = out.charAt(i - 1);
                if (!Character.isWhitespace(before2) || !Character.isLetter(ch) || Character.isTitleCase(ch)) continue;
                out.setCharAt(i, Character.toTitleCase(ch));
            }
            return out.toString();
        }
    }

    private static class NumberSpeller {
        private final String[] singles = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        private final String[] tens = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};

        private NumberSpeller() {
        }

        private String spellNumber(int value2) {
            String retValue;
            if (value2 < 100) {
                retValue = this.getLessThanHundered(value2);
            } else if (value2 < 1000) {
                retValue = this.getLessThanThousand(value2);
            } else {
                retValue = this.singles[value2 / 1000] + " thousand";
                int remainder = value2 % 1000;
                if (remainder != 0) {
                    retValue = retValue + " " + this.getLessThanThousand(remainder);
                }
            }
            return retValue;
        }

        private String getLessThanHundered(int value2) {
            if (value2 < 20) {
                return this.singles[value2];
            }
            return this.tens[value2 / 10] + " " + this.singles[value2 % 10];
        }

        private String getLessThanThousand(int value2) {
            String retValue = this.singles[value2 / 100] + " hundred";
            int remainder = value2 % 100;
            if (remainder != 0) {
                retValue = retValue + " and " + this.getLessThanHundered(remainder);
            }
            return retValue;
        }
    }

    private static class ICUStringUtility
    extends StringUtility {
        private ICUStringUtility() {
        }

        private final String spellNumber(long value2, String token, NumberFormatFactoryRuleBased factory, Locale locale, String ordinal) {
            RuleBasedNumberFormat format2 = factory.getFormatInstance(locale, 1);
            Long sValue = new Long(value2);
            String out = sValue.toString();
            try {
                out = format2.format((Object)sValue);
            }
            catch (Throwable e) {
                return null;
            }
            if (out.equals(sValue.toString())) {
                return null;
            }
            if (locale.equals(Locale.ENGLISH)) {
                out = out.replace('-', ' ');
                if (ordinal.equals("yes")) {
                    int index2 = out.lastIndexOf(" ");
                    if (index2 == -1) {
                        out = (String)ordinalTable.get(out);
                    } else {
                        String str = (String)ordinalTable.get(out.substring(index2 + 1));
                        out = out.substring(0, index2 + 1) + str;
                    }
                    if (token.endsWith("o")) {
                        token = token.substring(0, token.indexOf("o"));
                    }
                }
            }
            if (token.equals("w") || token.equals("n")) {
                return this.toLowerCase(locale, out);
            }
            if (token.equals("W") || token.equals("N")) {
                return this.toUpperCase(locale, out);
            }
            if (token.equals("Ww") || token.equals("Nn")) {
                return NumberFormatInt.lowerCaseASingleWord(this.toTitleCase(locale, out), "And", "and");
            }
            return null;
        }

        private final String ordinalNumber(long value2, NumberFormatFactoryRuleBased factory, Locale locale) {
            RuleBasedNumberFormat format2 = factory.getFormatInstance(locale, 2);
            Long sValue = new Long(value2);
            String out = sValue.toString();
            try {
                out = format2.format((Object)sValue);
                if (out.indexOf(44) >= 0) {
                    int length2 = out.length();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < length2; ++i) {
                        char c = out.charAt(i);
                        if (c == ',') continue;
                        sb.append(c);
                    }
                    out = sb.toString();
                }
            }
            catch (Throwable e) {
                return null;
            }
            if (out.equals(sValue.toString())) {
                return null;
            }
            return out;
        }

        private final String toUpperCase(Locale locale, String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            return UCharacter.toUpperCase((Locale)locale, (String)str);
        }

        private final String toLowerCase(Locale locale, String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            return UCharacter.toLowerCase((Locale)locale, (String)str);
        }

        private final String toTitleCase(Locale locale, String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            return UCharacter.toTitleCase((Locale)locale, (String)str, null);
        }
    }
}

