/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.output.ResultDocumentResolver;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.output.ResultTreeSequenceWriterStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class ResultDocumentManager {
    private final ResultDocumentResolver m_resultResolver;
    private final Result m_primary_result;
    private final ErrorHandler m_err_handler;
    private Map<String, Result> m_redirect_results;
    private Map<String, ResultTreeSequenceWriterStream> m_redirect_writers;
    private Map<String, Integer> m_redirect_depth;
    private Set<String> m_redirect_written;
    private Set<String> m_redirect_appends;
    private Set<String> m_referenced_hrefs;

    public ResultDocumentManager(ErrorHandler err, ResultDocumentResolver resultResolver, Result result2) {
        this.m_resultResolver = resultResolver;
        this.m_primary_result = result2;
        this.m_err_handler = err;
    }

    public void openRedirect(String baseURI, String href, boolean append) {
        Result result2 = this.getRedirectResult(baseURI, href, append);
        this.addRedirectResult(href, result2);
        if (append) {
            this.setRedirectAppends(href);
        }
    }

    public Result getRedirectResult(String baseURI, String href, boolean append) {
        this.checkURL(href);
        Result result2 = this.m_resultResolver.getResultDocument(baseURI, href, append);
        this.checkResult(result2, baseURI, href);
        return result2;
    }

    public Result lookupRedirectResult(String href) {
        Result result2 = null;
        if (this.m_redirect_results != null) {
            result2 = this.m_redirect_results.get(href);
        }
        return result2;
    }

    public ResultTreeSequenceWriterStream peekRedirectWriter(String href) {
        return this.m_redirect_writers != null ? this.m_redirect_writers.get(href) : null;
    }

    public ResultTreeSequenceWriterStream lookupRedirectWriter(String href) {
        ResultTreeSequenceWriterStream result2 = null;
        if (this.m_redirect_writers != null && (result2 = this.m_redirect_writers.get(href)) != null) {
            this.m_redirect_depth.put(href, this.m_redirect_depth.get(href) + 1);
        }
        return result2;
    }

    public void setRedirectWriter(String href, ResultTreeSequenceWriterStream writer) {
        if (this.m_redirect_writers == null) {
            this.m_redirect_writers = new HashMap<String, ResultTreeSequenceWriterStream>();
            this.m_redirect_depth = new HashMap<String, Integer>();
        }
        this.m_redirect_writers.put(href, writer);
        this.m_redirect_depth.put(href, 1);
    }

    public boolean releaseRedirectWriter(String href) {
        int newDepth = this.m_redirect_depth.get(href) - 1;
        if (newDepth == 0) {
            this.m_redirect_depth.remove(href);
            this.m_redirect_writers.remove(href);
            return true;
        }
        this.m_redirect_depth.put(href, this.m_redirect_depth.get(href) - 1);
        return false;
    }

    public void setRedirectWritten(String href) {
        if (this.m_redirect_written == null) {
            this.m_redirect_written = new HashSet<String>();
        }
        this.m_redirect_written.add(href);
    }

    public boolean isRedirectWritten(String href) {
        if (this.m_redirect_written != null) {
            return this.m_redirect_written.contains(href);
        }
        return false;
    }

    public void setRedirectAppends(String href) {
        if (this.m_redirect_appends == null) {
            this.m_redirect_appends = new HashSet<String>();
        }
        this.m_redirect_appends.add(href);
    }

    public boolean isRedirectAppends(String href) {
        if (this.m_redirect_appends != null) {
            return this.m_redirect_appends.contains(href);
        }
        return false;
    }

    public void closeRedirect(String href) {
        if (this.m_redirect_results != null) {
            this.m_redirect_results.remove(href);
        }
        if (this.m_redirect_written != null) {
            this.m_redirect_written.remove(href);
        }
        if (this.m_redirect_appends != null) {
            this.m_redirect_appends.remove(href);
        }
    }

    private void addRedirectResult(String href, Result result2) {
        if (this.m_redirect_results == null) {
            this.m_redirect_results = new HashMap<String, Result>();
        }
        this.m_redirect_results.put(href, result2);
    }

    public Result getResultDocument(String baseURI, String href, boolean isTentativePrimaryResult) {
        if (!href.equals("")) {
            this.checkURL(href);
        }
        Result result2 = null;
        if ("".equals(href) && this.m_primary_result != null) {
            result2 = this.m_primary_result;
        } else {
            result2 = this.m_resultResolver.getResultDocument(baseURI, href);
            this.checkResult(result2, baseURI, href);
        }
        if (!isTentativePrimaryResult) {
            this.addReference(href);
        }
        return result2;
    }

    public boolean hasPredefinedPrimaryResult() {
        return this.m_primary_result != null;
    }

    public boolean isReferenced(String href) {
        if (this.m_referenced_hrefs != null) {
            return this.m_referenced_hrefs.contains(href);
        }
        return false;
    }

    public boolean hadResultDocumentReferences() {
        return this.m_referenced_hrefs != null && this.m_referenced_hrefs.size() > 0;
    }

    public void addReference(String href) {
        if (this.m_referenced_hrefs == null) {
            this.m_referenced_hrefs = new HashSet<String>();
        }
        this.m_referenced_hrefs.add(href);
    }

    private void checkResult(Result result2, String baseURI, String href) {
        SAXResult sax;
        if (result2 != this.m_primary_result && result2 instanceof StreamResult) {
            StreamResult sr = (StreamResult)result2;
            if (sr.getOutputStream() == null && sr.getWriter() == null && (result2.getSystemId() == null || result2.getSystemId().length() == 0)) {
                String msg = XMLMessages.createXMLMessage("ER_RES_DOC_RESULTSTREAM_BAD", new Object[]{href, baseURI});
                this.m_err_handler.report(3, msg, null, null, true);
            }
        } else if (result2 instanceof DOMResult) {
            boolean bad = false;
            DOMResult dr = (DOMResult)result2;
            Node node2 = dr.getNode();
            if (node2 == null) {
                bad = true;
            } else {
                short type2 = node2.getNodeType();
                switch (type2) {
                    case 1: 
                    case 9: 
                    case 11: {
                        break;
                    }
                    default: {
                        bad = true;
                    }
                }
            }
            if (bad) {
                String msg = XMLMessages.createXMLMessage("ER_RES_DOC_RESULTDOM_BAD", new Object[]{href, baseURI});
                this.m_err_handler.report(3, msg, null, null, true);
            }
        } else if (result2 instanceof SAXResult && (sax = (SAXResult)result2).getHandler() == null) {
            String msg = XMLMessages.createXMLMessage("ER_RES_DOC_RESULTSAX_BAD", new Object[]{href, baseURI});
            this.m_err_handler.report(3, msg, null, null, true);
        }
    }

    private void checkURL(String href) {
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url != null && !ResultDocumentResolver.isCommonURL(href)) {
            String msg = XMLMessages.createXMLMessage("ER_RES_DOC_HREF_PROTOCOL_BAD", new Object[]{href});
            this.m_err_handler.report(3, msg, null, null, true);
        }
    }
}

