/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xml.types.TypeError;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.output.ResultTreeSequenceWriterStream;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.SchemaNamedXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIAttrNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIElementNSImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.traversal.NodeIterator;

public class RuntimeLibrary {
    public static final String VERSION = "Gustav-Mon-Jan-22-06:03:25-EST-2007";
    public static final char[] s_emptyCharStream = new char[0];
    private static final DecimalFormat DEC_NOTATION;
    private static final DecimalFormat DOUBLE_FORMATER;
    public static final int[] EMPTY_NAMESPACE_TABLE;
    public static final int EMPTY_ID = 13;
    static final short DERMETH = 3;
    private static final HashMap m_prefixes;

    public static String verboseVersionWithCopyright() {
        return "Xylem RuntimeLibrary version \"Gustav-Mon-Jan-22-06:03:25-EST-2007\" (C) Copyright IBM Corp. 2004, 2005, 2006";
    }

    public static String verboseVersion() {
        return "Xylem runtime version \"Gustav-Mon-Jan-22-06:03:25-EST-2007\"";
    }

    public static void checkVersion(String version) {
        if (!version.equals(VERSION)) {
            throw new Error("version '" + version + "' does not match RuntimeLibrary version '" + VERSION + "'");
        }
    }

    public static final int codePointCount(char[] c) {
        String s = new String(c);
        return s.codePointCount(0, s.length());
    }

    public static final boolean contains(char[] x, char[] y) {
        if (y.length == 0) {
            return true;
        }
        if (y.length > x.length) {
            return false;
        }
        int j = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[j]) {
                if (++j != y.length) continue;
                return true;
            }
            while (j != 0) {
                --j;
                --i;
            }
        }
        return false;
    }

    public static char[] doubleToCharArray10(double d) {
        return RuntimeLibrary.doubleToString10(d).toCharArray();
    }

    public static String doubleToString10(double d) {
        return BasisLibrary.realToString(d);
    }

    public static char[] floatToCharArray10(float f2) {
        return RuntimeLibrary.floatToString10(f2).toCharArray();
    }

    public static String floatToString10(float f2) {
        if (f2 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f2)) {
            return "NaN";
        }
        if (f2 == 0.0f) {
            return "0";
        }
        if ((double)StrictMath.abs(f2) < 1.0E-6 || StrictMath.abs(f2) >= 1000000.0f) {
            return DOUBLE_FORMATER.format(f2);
        }
        return RuntimeLibrary.removeTrailingZeros(Float.toString(f2));
    }

    public static char[] doubleToCharArray(double d) {
        return RuntimeLibrary.doubleToString(d).toCharArray();
    }

    public static String doubleToString(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        Double d2 = new Double(d);
        if (d == 0.0) {
            String str = d2.toString();
            return str.substring(0, str.indexOf("."));
        }
        if (StrictMath.abs(d) >= 1.0E-6 && StrictMath.abs(d) < 1000000.0) {
            return DEC_NOTATION.format(d);
        }
        if (StrictMath.abs(d) > 0.0 && StrictMath.abs(d) < 1.0E7) {
            return DOUBLE_FORMATER.format(d);
        }
        return Double.toString(d);
    }

    public static char[] floatToCharArray(float f2) {
        return RuntimeLibrary.floatToString(f2).toCharArray();
    }

    public static String floatToString(float f2) {
        if (f2 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f2)) {
            return "NaN";
        }
        Float f22 = new Float(f2);
        if (f2 == 0.0f) {
            String str = f22.toString();
            return str.substring(0, str.indexOf("."));
        }
        if ((double)StrictMath.abs(f2) >= 1.0E-6 && StrictMath.abs(f2) < 1000000.0f) {
            Double d = new Double(f22.toString());
            return DEC_NOTATION.format(d);
        }
        if (StrictMath.abs(f2) > 0.0f && StrictMath.abs(f2) < 1.0E7f) {
            Double d = new Double(f22.toString());
            return DOUBLE_FORMATER.format(d);
        }
        return f22.toString();
    }

    public static String removeTrailingZeros(String num) {
        int len = num.length();
        if (num.charAt(len - 1) != '0') {
            return num;
        }
        if (num.indexOf(46) >= 0) {
            while (num.charAt(len - 1) == '0') {
                --len;
            }
            if (num.charAt(len - 1) == '.') {
                --len;
            }
            return num.substring(0, len);
        }
        return num;
    }

    public static char[] decimalToCharArray(BigDecimal d) {
        return RuntimeLibrary.decimalToString(d).toCharArray();
    }

    public static String decimalToString(BigDecimal d) {
        return RuntimeLibrary.removeTrailingZeros(d.stripTrailingZeros().toPlainString());
    }

    public static char[] normalizeSpace(char[] x) {
        char[] result2;
        int i;
        int n2 = x.length;
        char[] result3 = new char[x.length];
        int j = 0;
        for (i = 0; i < n2 && RuntimeLibrary.isWhiteSpace(x[i]); ++i) {
        }
        while (true) {
            if (i < n2 && !RuntimeLibrary.isWhiteSpace(x[i])) {
                if (j == result3.length) {
                    result2 = new char[result3.length * 2];
                    System.arraycopy(result3, 0, result2, 0, result3.length);
                    result3 = result2;
                }
                result3[j++] = x[i++];
                continue;
            }
            if (i == n2) break;
            while (i < n2 && RuntimeLibrary.isWhiteSpace(x[i])) {
                ++i;
            }
            if (i >= n2) continue;
            if (j == result3.length) {
                result2 = new char[result3.length * 2];
                System.arraycopy(result3, 0, result2, 0, result3.length);
                result3 = result2;
            }
            result3[j++] = 32;
        }
        if (j == result3.length) {
            return result3;
        }
        result2 = new char[j];
        System.arraycopy(result3, 0, result2, 0, j);
        return result2;
    }

    private static final boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public static final boolean startsWith(char[] x, char[] y) {
        if (y.length == 0) {
            return true;
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) {
                if (i != y.length - 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void addToElement(Object x, Node e, boolean preserveTypeAnnotations) {
        RuntimeLibrary.addToElement((Cursor)x, e, e.getOwnerDocument(), preserveTypeAnnotations);
    }

    public static void addToElement(Cursor x, Node e, boolean preserveTypeAnnotations) {
        RuntimeLibrary.addToElement(x, e, e.getOwnerDocument(), preserveTypeAnnotations);
    }

    private static String render_xci_qname(QName name2) {
        return BasisLibrary2.qNameToString(name2);
    }

    public static void addToElement(Cursor src, Node target, Document doc2, boolean preserveTypeAnnotations) {
        if (src.isWrapped()) {
            src = src.unwrap();
        }
        if (Node.class == src.exportAsClass("expdom2")) {
            Node srcNode = (Node)src.exportAs(Node.class.getName(), false);
            short nodeType = src.itemKind();
            if (nodeType == 2) {
                String attrNamespace = src.itemName().getQName(1, null).getNamespaceURI();
                if (attrNamespace.equals("")) {
                    attrNamespace = null;
                }
                String attrName = RuntimeLibrary.render_xci_qname(src.itemName().getQName(1, null));
                ((Element)target).setAttributeNS(attrNamespace, attrName, src.itemTypedValue().getString(1));
                if (preserveTypeAnnotations) {
                    Attr newAttr = ((Element)target).getAttributeNodeNS(attrNamespace, attrName);
                    Attr oldAttr = (Attr)srcNode;
                    if (oldAttr instanceof AttributePSVI) {
                        ((PSVIAttrNSImpl)newAttr).setPSVI((AttributePSVI)((Object)oldAttr));
                    }
                }
            } else if (nodeType == 4) {
                String nsuri = srcNode.getNamespaceURI();
                String qualifiedName = srcNode.getNodeName();
                ((Element)target).setAttributeNS(nsuri, qualifiedName, src.itemTypedValue().getString(1));
            } else {
                Node newChild = target.appendChild(doc2.importNode(srcNode, !preserveTypeAnnotations));
                if (preserveTypeAnnotations) {
                    RuntimeLibrary.copySubtreeWithTypeAnnotations(srcNode, newChild, doc2);
                }
            }
            return;
        }
        short nodeKind = src.itemKind();
        switch (nodeKind) {
            case 3: {
                target.appendChild(doc2.createTextNode(src.itemTypedValue().getString(1)));
                break;
            }
            case 2: {
                QName attrName = src.itemName().getQName(1, null);
                String namespaceURI = attrName.getNamespaceURI();
                ((Element)target).setAttributeNS(namespaceURI.length() == 0 ? null : namespaceURI, RuntimeLibrary.render_xci_qname(attrName), src.itemTypedValue().getString(1));
                break;
            }
            case 1: 
            case 9: {
                QName elemName;
                String namespaceURI;
                Node e2 = nodeKind == 1 ? doc2.createElementNS((namespaceURI = (elemName = src.itemName().getQName(1, null)).getNamespaceURI()).length() == 0 ? null : namespaceURI, RuntimeLibrary.render_xci_qname(elemName)) : doc2.createDocumentFragment();
                Cursor children = src.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
                boolean ok2 = children.toChildren(null);
                if (ok2) {
                    do {
                        RuntimeLibrary.addToElement(children, e2, doc2, preserveTypeAnnotations);
                    } while (children.toNext());
                }
                target.appendChild(e2);
                break;
            }
            case 4: {
                VolatileCData prefix2 = src.itemName();
                String namespaceDeclAttr = prefix2 == null || prefix2.isEmptySequence() ? "xmlns" : "xmlns:" + prefix2.getQNameLocalPart(1);
                ((Element)target).setAttributeNS("http://www.w3.org/2000/xmlns/", namespaceDeclAttr, src.itemTypedValue().getString(1));
                break;
            }
            case 8: {
                target.appendChild(doc2.createComment(src.itemStringValue().getString(1)));
                break;
            }
            case 7: {
                target.appendChild(doc2.createProcessingInstruction(src.itemName().getQName(1, null).getLocalPart(), src.itemStringValue().getString(1)));
            }
        }
    }

    private static void copySubtreeWithTypeAnnotations(Node oldNode, Node newNode, Document newDoc) {
        if (newNode instanceof Element) {
            if (oldNode instanceof ElementPSVI && newNode instanceof PSVIElementNSImpl) {
                ((PSVIElementNSImpl)newNode).setPSVI((ElementPSVI)((Object)oldNode));
            }
            NamedNodeMap oldAttrs = oldNode.getAttributes();
            Element newElem = (Element)newNode;
            for (int i = 0; i < oldAttrs.getLength(); ++i) {
                Attr oldAttr = (Attr)oldAttrs.item(i);
                Attr newAttr = (Attr)newDoc.importNode(oldAttr, false);
                newElem.setAttributeNodeNS(newAttr);
                if (!(oldAttr instanceof AttributePSVI) || !(newAttr instanceof PSVIAttrNSImpl)) continue;
                ((PSVIAttrNSImpl)newAttr).setPSVI((AttributePSVI)((Object)oldAttr));
            }
        }
        NodeList oldChildren = oldNode.getChildNodes();
        for (int i = 0; i < oldChildren.getLength(); ++i) {
            Node oldChild = oldChildren.item(i);
            Node newChild = newDoc.importNode(oldChild, false);
            newNode.appendChild(newChild);
            RuntimeLibrary.copySubtreeWithTypeAnnotations(oldChild, newChild, newDoc);
        }
    }

    public static int compare(double x, double y) {
        if (Double.isNaN(x) && Double.isNaN(y)) {
            return 0;
        }
        if (Double.isNaN(y) || x > y) {
            return 1;
        }
        if (Double.isNaN(x) || x < y) {
            return -1;
        }
        return 0;
    }

    public static int compare(String x, String y) {
        int ret = x.compareToIgnoreCase(y);
        if (ret > 0) {
            return 1;
        }
        if (ret < 0) {
            return -1;
        }
        return 0;
    }

    private static String cursorToString(Cursor c) {
        if (c == null) {
            return "";
        }
        Chars chars = c.itemStringValueAsChars();
        return chars.isEmpty() ? "" : ((Object)chars).toString();
    }

    public static char[] cursorToCharArray(Cursor c) {
        if (c == null) {
            return s_emptyCharStream;
        }
        Chars chars = c.itemStringValueAsChars();
        return chars.isEmpty() ? s_emptyCharStream : chars.toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor c, Cursor separator) {
        if (c == null) {
            return s_emptyCharStream;
        }
        Chars result2 = c.sequenceConstructSimpleContent(separator.itemStringValueAsChars(), true, false);
        if (result2 instanceof Chars) {
            return result2.toCharArray();
        }
        return ((Object)result2).toString().toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor c, String sepString) {
        if (c == null) {
            return s_emptyCharStream;
        }
        CharSequence result2 = c.sequenceConstructSimpleContent(sepString, true, false);
        if (result2 instanceof Chars) {
            return ((Chars)result2).toCharArray();
        }
        return ((Object)result2).toString().toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor c, char[] sepString) {
        if (c == null) {
            return s_emptyCharStream;
        }
        Chars result2 = c.sequenceConstructSimpleContent(CharBufferChars.make(sepString), true, false);
        if (result2 instanceof Chars) {
            return result2.toCharArray();
        }
        return ((Object)result2).toString().toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor c) {
        if (c == null) {
            return s_emptyCharStream;
        }
        CharSequence result2 = c.sequenceConstructSimpleContent(" ", true, false);
        if (result2 instanceof Chars) {
            return ((Chars)result2).toCharArray();
        }
        return ((Object)result2).toString().toCharArray();
    }

    public static String cursorItemAtomizeToString(Cursor c, char[] sepString) {
        if (c == null) {
            return "";
        }
        return ((Object)c.sequenceConstructSimpleContent(CharBufferChars.make(sepString), true, false)).toString();
    }

    public static String cursorItemAtomizeToString(Cursor c, String sepString) {
        if (c == null) {
            return "";
        }
        return ((Object)c.sequenceConstructSimpleContent(sepString, true, false)).toString();
    }

    public static void cursorItemAtomize(Cursor c, String sepString, ResultTreeSequenceWriterStream rtsws) {
        if (c != null) {
            CharSequence result2 = c.sequenceConstructSimpleContent(sepString, true, false);
            if (result2 instanceof Chars) {
                rtsws.addText((Chars)result2);
            } else {
                rtsws.addText(((Object)result2).toString());
            }
        }
    }

    public static double cursorToDouble(Cursor c) {
        if (c == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(RuntimeLibrary.cursorToString(c));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static float cursorToFloat(Cursor c) {
        if (c == null) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(RuntimeLibrary.cursorToString(c));
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    public static BigDecimal cursorToDecimal(Cursor c) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(RuntimeLibrary.cursorToString(c));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException();
        }
        return bd;
    }

    public static int cursorToInt(Cursor c) {
        if (c == null) {
            return 0;
        }
        try {
            return Integer.parseInt(RuntimeLibrary.cursorToString(c));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static double stringToDouble(char[] c) {
        try {
            return Double.parseDouble(new String(c));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static float stringToFloat(char[] c) {
        try {
            return Float.parseFloat(new String(c));
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    public static int stringToInt(char[] c) {
        try {
            return Integer.parseInt(new String(c));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static BigDecimal stringToDecimal(char[] c) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(String.valueOf(c));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException();
        }
        return bd;
    }

    public static final Object convertJavaObject(CursorFactory fac, Object obj) {
        if (obj instanceof Double) {
            return obj;
        }
        if (obj instanceof Number) {
            return new Double(((Number)obj).doubleValue());
        }
        return obj;
    }

    public static XCollator getCollator(String language, String caseOrder) {
        CollatorDeclaration decl = CollatorFactory.getCollatorDeclaration(null, language, null, null, null, caseOrder, null);
        XCollator xcol = CollatorFactory.createCollatorFromDeclaration(decl);
        return xcol;
    }

    public static Collator getCollator(String lang2) {
        if (lang2 == null || lang2.length() == 0) {
            return Collator.getInstance();
        }
        Locale locale = new Locale(lang2.toLowerCase(), Locale.getDefault().getCountry());
        return Collator.getInstance(locale);
    }

    public static final int[] getNamespaceTable(Object nodeobj) {
        if (nodeobj instanceof Cursor) {
            return new int[0];
        }
        return null;
    }

    public static final float getCurrentItemAsFloat(Cursor cursor2) {
        return cursor2.itemTypedValue().getFloat(1);
    }

    public static final double getCurrentItemAsDouble(Cursor cursor2) {
        return cursor2.itemTypedValue().getDouble(1);
    }

    public static final BigDecimal getCurrentItemAsDecimal(Cursor cursor2) {
        return cursor2.itemTypedValue().getBigDecimal(1);
    }

    public static final long getCurrentItemAsLong(Cursor cursor2) {
        try {
            return cursor2.itemTypedValue().getLong(1);
        }
        catch (XCIDynamicErrorException e) {
            BasisLibrary2.runTimeError("ERR_INTEGER_TOO_LARGE");
            return 0L;
        }
    }

    public static final BigInteger getCurrentItemAsBigInteger(Cursor cursor2) {
        return cursor2.itemTypedValue().getBigInteger(1);
    }

    public static final int[] getCurrentItemAsDuration(Cursor cursor2) {
        int[] result2 = new int[7];
        try {
            Duration duration2 = cursor2.itemTypedValue().getDuration(1);
            result2[0] = duration2.getYears();
            result2[1] = duration2.getMonths();
            result2[2] = duration2.getDays();
            result2[3] = duration2.getHours();
            result2[4] = duration2.getMinutes();
            BigDecimal seconds2 = (BigDecimal)duration2.getField(DatatypeConstants.SECONDS);
            if (seconds2 == null) {
                result2[5] = 0;
                result2[6] = 0;
            } else {
                result2[5] = seconds2.intValue();
                result2[6] = seconds2.remainder(BigDecimal.ONE).movePointRight(3).intValue();
            }
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsYearMonthDuration(Cursor cursor2) {
        int[] result2 = new int[2];
        try {
            Duration duration2 = cursor2.itemTypedValue().getDuration(1);
            result2[0] = duration2.getYears();
            result2[1] = duration2.getMonths();
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsDayTimeDuration(Cursor cursor2) {
        int[] result2 = new int[5];
        try {
            Duration duration2 = cursor2.itemTypedValue().getDuration(1);
            result2[0] = duration2.getDays();
            result2[1] = duration2.getHours();
            result2[2] = duration2.getMinutes();
            BigDecimal seconds2 = (BigDecimal)duration2.getField(DatatypeConstants.SECONDS);
            if (seconds2 == null) {
                result2[3] = 0;
                result2[4] = 0;
            } else {
                result2[3] = seconds2.intValue();
                result2[4] = seconds2.remainder(BigDecimal.ONE).movePointRight(3).intValue();
            }
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsDateTime(Cursor cursor2) {
        int[] result2 = new int[10];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getYear();
            result2[1] = calendar.getMonth();
            result2[2] = calendar.getDay();
            result2[3] = calendar.getHour();
            result2[4] = calendar.getMinute();
            result2[5] = calendar.getSecond();
            int milliseconds = calendar.getMillisecond();
            result2[6] = milliseconds == Integer.MIN_VALUE ? 0 : milliseconds;
            result2[7] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[8] = calendar.getTimezone() / 60;
            result2[9] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsTime(Cursor cursor2) {
        int[] result2 = new int[7];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getHour();
            result2[1] = calendar.getMinute();
            result2[2] = calendar.getSecond();
            int milliseconds = calendar.getMillisecond();
            result2[3] = milliseconds == Integer.MIN_VALUE ? 0 : milliseconds;
            result2[4] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[5] = calendar.getTimezone() / 60;
            result2[6] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsDate(Cursor cursor2) {
        int[] result2 = new int[6];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getYear();
            result2[1] = calendar.getMonth();
            result2[2] = calendar.getDay();
            result2[3] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[4] = calendar.getTimezone() / 60;
            result2[5] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsYearMonth(Cursor cursor2) {
        int[] result2 = new int[5];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getYear();
            result2[1] = calendar.getMonth();
            result2[2] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[3] = calendar.getTimezone() / 60;
            result2[4] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsYear(Cursor cursor2) {
        int[] result2 = new int[4];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getYear();
            result2[1] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[2] = calendar.getTimezone() / 60;
            result2[3] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsMonthDay(Cursor cursor2) {
        int[] result2 = new int[5];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getMonth();
            result2[1] = calendar.getDay();
            result2[2] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[3] = calendar.getTimezone() / 60;
            result2[4] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsDay(Cursor cursor2) {
        int[] result2 = new int[4];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getDay();
            result2[1] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[2] = calendar.getTimezone() / 60;
            result2[3] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final int[] getCurrentItemAsMonth(Cursor cursor2) {
        int[] result2 = new int[4];
        try {
            XMLGregorianCalendar calendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            result2[0] = calendar.getMonth();
            result2[1] = calendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            result2[2] = calendar.getTimezone() / 60;
            result2[3] = calendar.getTimezone() % 60;
        }
        catch (ParseException pe) {
            throw new TypeError();
        }
        return result2;
    }

    public static final boolean getCurrentItemAsBoolean(Cursor cursor2) {
        return cursor2.itemTypedValue().getBoolean(1);
    }

    public static final byte[] getCurrentItemAsBase64Binary(Cursor cursor2) {
        Bytes bytes2 = cursor2.itemTypedValue().getBase64Binary(1);
        int size = (int)bytes2.byteLength();
        byte[] result2 = new byte[size];
        bytes2.writeBytesTo(0, result2, 0, true);
        return result2;
    }

    public static final byte[] getCurrentItemAsHexBinary(Cursor cursor2) {
        Bytes bytes2 = cursor2.itemTypedValue().getHexBinary(1);
        int size = (int)bytes2.byteLength();
        byte[] result2 = new byte[size];
        bytes2.writeBytesTo(0, result2, 0, true);
        return result2;
    }

    public static final QName getCurrentItemAsQName(Cursor cursor2) {
        return cursor2.itemTypedValue().getQName(1, cursor2.itemNamespaceContext());
    }

    public static final QName getCurrentItemAsNotation(Cursor cursor2) {
        return cursor2.itemTypedValue().getQName(1, cursor2.itemNamespaceContext());
    }

    public static final int getTypeConstant(Cursor cursor2) {
        XSTypeDefinition type2 = cursor2.itemXSType();
        if (type2 != null && 16 == type2.getTypeCategory()) {
            XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)type2;
            switch (simpleType.getVariety()) {
                case 3: {
                    return 60;
                }
                case 2: {
                    return 61;
                }
            }
            return RuntimeLibrary.convertType(type2);
        }
        return 45;
    }

    private static int convertType(XSTypeDefinition type2) {
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "boolean", (short)3)) {
            return 17;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "double", (short)3)) {
            return 3;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "float", (short)3)) {
            return 2;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "integer", (short)3)) {
            return 5;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "decimal", (short)3)) {
            return 4;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "dayTimeDuration", (short)3)) {
            return 8;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "yearMonthDuration", (short)3)) {
            return 7;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "duration", (short)3)) {
            return 6;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "dateTime", (short)3)) {
            return 9;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "time", (short)3)) {
            return 10;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "date", (short)3)) {
            return 11;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYearMonth", (short)3)) {
            return 12;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYear", (short)3)) {
            return 13;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonthDay", (short)3)) {
            return 14;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "gDay", (short)3)) {
            return 15;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonth", (short)3)) {
            return 16;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "hexBinary", (short)3)) {
            return 19;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "base64Binary", (short)3)) {
            return 18;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "anyURI", (short)3)) {
            return 20;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "QName", (short)3)) {
            return 21;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "NOTATION", (short)3)) {
            return 22;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "string", (short)3)) {
            return 1;
        }
        if (type2.derivedFrom("http://www.w3.org/2001/XMLSchema", "untypedAtomic", (short)3)) {
            return 0;
        }
        return 46;
    }

    public static Cursor getCurrentItemAsListOrUnion(Cursor cursor2) {
        CData data2 = cursor2.itemTypedValue().constant(false);
        Cursor unionCursor = cursor2.factory().sequence(data2, cursor2.profile());
        return unionCursor;
    }

    public static Cursor getVariableValue(DynamicContext context2, QName qname2) {
        Cursor cursor2 = context2.getVariableValue(qname2);
        if (cursor2 != null) {
            cursor2 = cursor2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
        }
        return cursor2;
    }

    public static boolean isVariableDefined(DynamicContext context2, QName qname2) {
        return context2.isVariableBound(qname2);
    }

    public static Cursor getCursor(Node n2) {
        if (n2 == null) {
            return null;
        }
        if (n2 instanceof Cursor) {
            Cursor cursor2 = ((Cursor)((Object)n2)).fork(true);
            cursor2.toSelf();
            return cursor2;
        }
        DOMSource src = new DOMSource(n2);
        SessionContext session = new SessionContext();
        return session.document(src, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
    }

    public static final Cursor getCursor(DocumentFragment node2) {
        if (node2 == null) {
            return null;
        }
        if (node2 instanceof Cursor) {
            return ((Cursor)((Object)node2)).fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE);
        }
        DOMSource src = new DOMSource(node2);
        SessionContext session = new SessionContext();
        return session.document(src, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
    }

    public static final Cursor getCursor(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        if (nodeList instanceof Cursor) {
            Cursor cursor2 = ((Cursor)((Object)nodeList)).fork(false);
            cursor2.toPosition(1L);
            return cursor2;
        }
        int length2 = nodeList.getLength();
        Cursor nodes2 = null;
        if (length2 > 0) {
            DOMSource src = new DOMSource(nodeList.item(0));
            SessionContext session = new SessionContext();
            nodes2 = session.document(src, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
            for (int i = 1; i < length2; ++i) {
                src = new DOMSource(nodeList.item(i));
                nodes2 = nodes2.sequenceConcat(session.document(src, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE)), XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE, false, false, true, true);
            }
        }
        return nodes2;
    }

    public static final Cursor getCursor(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return null;
        }
        Cursor nodes2 = null;
        Node aNode = nodeIterator.nextNode();
        DOMSource src = null;
        if (aNode != null) {
            src = new DOMSource(aNode);
            SessionContext session = new SessionContext();
            nodes2 = session.document(src, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
            aNode = nodeIterator.nextNode();
            while (aNode != null) {
                src = new DOMSource(aNode);
                nodes2 = nodes2.sequenceConcat(session.document(src, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE)), XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE, false, false, true, true);
                aNode = nodeIterator.nextNode();
            }
        }
        return nodes2;
    }

    public static final Cursor getCursor(Object arg2) {
        if (arg2 == null) {
            return null;
        }
        SessionContext session = new SessionContext();
        CursorFactory cursorFactory = session.getSimpleDataFactory();
        return cursorFactory.sequence(arg2);
    }

    private static QName qname_of_string(String qName) {
        QName qn2;
        String prefix2 = "";
        String localPart = "";
        try {
            int ind = qName.indexOf(":");
            if (ind == -1) {
                prefix2 = "";
                localPart = qName;
            } else {
                prefix2 = qName.substring(0, ind);
                localPart = qName.substring(ind + 1);
            }
            String tmp = (String)m_prefixes.get(prefix2);
            qn2 = new QName(tmp, localPart, prefix2);
        }
        catch (RuntimeException e) {
            if (!prefix2.equals("")) {
                throw e;
            }
            QName qn2 = new QName(localPart);
            return null;
        }
        return qn2;
    }

    public static XType resolve_TypeQNameF(char[] arg1) {
        QName qn = RuntimeLibrary.qname_of_string(new String(arg1));
        return new SchemaNamedXType(qn);
    }

    public static XType resolve_XNamedTypeQNameF(XSTypeDefinition xstype) {
        try {
            if (xstype != null) {
                String name2 = xstype.getName();
                if (null == name2 && xstype instanceof TypeInfo) {
                    TypeInfo t = (TypeInfo)((Object)xstype);
                    name2 = t.getTypeName();
                }
                QName qn = RuntimeLibrary.qname_of_string(name2);
                return new SchemaNamedXType(qn, (Object)xstype);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static char cursorToChar(Cursor c) {
        if (c == null) {
            return '\u0000';
        }
        VolatileCData cdata = c.itemTypedValue();
        if (c.itemIsAtomic()) {
            XSTypeDefinition type2 = c.itemXSType();
            if (type2 == TypeRegistry.XSDOUBLE || type2 == TypeRegistry.XSDECIMAL || type2 == TypeRegistry.XSINTEGER) {
                return (char)cdata.getDouble(1);
            }
            String valStr = cdata.isEmptySequence() ? "" : cdata.getString(1);
            return valStr.charAt(0);
        }
        String valStr = cdata.isEmptySequence() ? "" : cdata.getString(1);
        try {
            return (char)Double.parseDouble(valStr);
        }
        catch (NumberFormatException e) {
            return valStr.charAt(0);
        }
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setDigit('#');
        symbols.setGroupingSeparator(',');
        symbols.setMinusSign('-');
        symbols.setPatternSeparator(';');
        symbols.setPercent('%');
        symbols.setZeroDigit('0');
        DEC_NOTATION = new DecimalFormat("0.####################", symbols);
        DOUBLE_FORMATER = new DecimalFormat("0.0#################E0", symbols);
        EMPTY_NAMESPACE_TABLE = new int[0];
        m_prefixes = new HashMap();
        m_prefixes.put("xs", "http://www.w3.org/2001/XMLSchema");
        m_prefixes.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }
}

