/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;
import java.math.BigDecimal;

public class XDataTypeUtils {
    public static final BigDecimal dayTimeDurationToSeconds(XDayTimeDuration value2) {
        return XDataTypeUtils.dayTimeDurationToSeconds(value2.getDays(), value2.getHours(), value2.getMinutes(), value2.getSeconds());
    }

    public static final BigDecimal dayTimeDurationToSeconds(int days2, int hours2, int minutes2, double seconds2) {
        return new BigDecimal(days2).multiply(new BigDecimal(86400)).add(new BigDecimal(hours2).multiply(new BigDecimal(3600))).add(new BigDecimal(minutes2).multiply(new BigDecimal(60))).add(new BigDecimal(seconds2)).setScale(3, 4);
    }

    public static final double timeToSeconds(XTime value2) {
        return (double)(value2.getHour() * 3600 + value2.getMinute() * 60) + value2.getSecond();
    }

    public static final XDayTimeDuration secondsTodayTimeDuration(BigDecimal total) {
        return new XDayTimeDuration(total);
    }

    public static final XYearMonthDuration negate(XYearMonthDuration value2) {
        return new XYearMonthDuration(value2.getCValue().negate());
    }

    public static final XDayTimeDuration negate(XDayTimeDuration value2) {
        return new XDayTimeDuration(value2.getCValue().negate());
    }

    public static final int fQuotient(double a, double b) {
        return (int)Math.floor(a / b);
    }

    public static final int fQuotient(double a, int low, int high) {
        return XDataTypeUtils.fQuotient(a - (double)low, high - low);
    }

    public static final double modulo(double a, double b, int quotient) {
        return a - (double)quotient * b;
    }

    public static final double modulo(double a, int low, int high) {
        double tmp1 = a - (double)low;
        double tmp2 = high - low;
        return XDataTypeUtils.modulo(tmp1, tmp2, XDataTypeUtils.fQuotient(tmp1, tmp2)) + (double)low;
    }

    public static int maxDayInMonthFor(int year2, int month2) {
        if (month2 == 2) {
            return XDataTypeUtils.isLeapYear(year2) ? 29 : 28;
        }
        if (month2 == 4 || month2 == 6 || month2 == 9 || month2 == 11) {
            return 30;
        }
        return 31;
    }

    private static boolean isLeapYear(int year2) {
        return year2 % 400 == 0 || year2 % 100 != 0 && year2 % 4 == 0;
    }

    public static final int[] normalizeDate(int day2, int mon, int year2) {
        int[] value2 = new int[3];
        while (true) {
            int carry;
            int tmp = XDataTypeUtils.maxDayInMonthFor(year2, mon);
            if (day2 < 1) {
                day2 += XDataTypeUtils.maxDayInMonthFor(year2, mon - 1);
                carry = -1;
            } else {
                if (day2 <= tmp) break;
                day2 -= tmp;
                carry = 1;
            }
            tmp = mon + carry;
            mon = (int)XDataTypeUtils.modulo((double)tmp, 1, 13);
            year2 += XDataTypeUtils.fQuotient(tmp, 1, 13);
        }
        value2[0] = day2;
        value2[1] = mon;
        value2[2] = year2;
        return value2;
    }

    public static final int normalizeDay(int day2, int mon, int year2) {
        int tmp = XDataTypeUtils.maxDayInMonthFor(year2, mon);
        if (day2 < 1) {
            tmp = 1;
        } else if (day2 < tmp && day2 >= 1) {
            tmp = day2;
        }
        return tmp;
    }

    private static int leaps(int year2) {
        return (year2 - 1) / 4 - (year2 - 1) / 100 + (year2 - 1) / 400;
    }

    public static final int numberOfDays(int day2, int month2, int year2) {
        int[] days2 = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int total = (year2 - 1) * 365 + XDataTypeUtils.leaps(year2);
        total += days2[month2 - 1] + day2;
        return XDataTypeUtils.isLeapYear(year2) && month2 > 2 ? ++total : total;
    }
}

