/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;

public class XDate
extends XItemBase {
    private final XDayTimeDuration ZERO_DTD = new XDayTimeDuration(0, 0, 0, 0.0);
    private int m_year;
    private int m_month;
    private int m_day;
    private XDayTimeDuration m_timezone;

    public XDate(int year2, int month2, int day2) {
        this(year2, month2, day2, null);
    }

    public XDate(int year2, int month2, int day2, int tz_hour, int tz_minute) {
        this(year2, month2, day2, new XDayTimeDuration(0, tz_hour, tz_minute, 0.0));
    }

    public XDate(int year2, int month2, int day2, XDayTimeDuration timezone2) {
        this.m_year = year2;
        this.m_month = month2;
        this.m_day = day2;
        this.m_timezone = timezone2;
    }

    public XDateTime normalize() {
        if (this.m_timezone != null && !this.m_timezone.equals(this.ZERO_DTD)) {
            XDateTime dt = new XDateTime(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0.0, 0, 0);
            return dt.subtract(this.m_timezone);
        }
        return new XDateTime(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0.0);
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XDate add(XYearMonthDuration ymd) {
        int tmp = this.m_month + ymd.getMonths();
        int mDateTime = (int)XDataTypeUtils.modulo((double)tmp, 1, 13);
        int carry = XDataTypeUtils.fQuotient(tmp, 1, 13);
        int yDateTime = this.m_year + ymd.getYears() + carry;
        int dDateTime = this.m_day;
        dDateTime = XDataTypeUtils.normalizeDay(dDateTime, mDateTime, yDateTime);
        int[] date2 = new int[3];
        date2 = XDataTypeUtils.normalizeDate(dDateTime, mDateTime, yDateTime);
        return new XDate(date2[2], date2[1], date2[0], this.m_timezone);
    }

    public XDate add(XDayTimeDuration dtd) {
        int dDateTime = XDataTypeUtils.normalizeDay(this.m_day, this.m_month, this.m_year);
        dDateTime += dtd.getDays();
        if (dtd.getHours() < 0 || dtd.getMinutes() < 0 || dtd.getSeconds() < 0.0) {
            --dDateTime;
        }
        int[] date2 = new int[3];
        date2 = XDataTypeUtils.normalizeDate(dDateTime, this.m_month, this.m_year);
        return new XDate(date2[2], date2[1], date2[0], this.m_timezone);
    }

    public XDayTimeDuration subtract(XDate other2) {
        XDateTime dt1 = this.normalize();
        XDateTime dt2 = other2.normalize();
        return dt1.subtract(dt2);
    }

    public XDate subtract(XYearMonthDuration ymd) {
        return this.add(XDataTypeUtils.negate(ymd));
    }

    public XDate subtract(XDayTimeDuration dtd) {
        return this.add(XDataTypeUtils.negate(dtd));
    }
}

