/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.DateTimeBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;
import java.math.BigDecimal;

public class XDateTime
extends XItemBase {
    private final XDayTimeDuration ZERO_DTD = new XDayTimeDuration(0, 0, 0, 0.0);
    private int m_year;
    private int m_month;
    private int m_day;
    private int m_hour;
    private int m_minute;
    private double m_second;
    private XDayTimeDuration m_timezone;

    protected XDateTime(DateTimeBase value2) {
        this.m_year = value2.getYear();
        this.m_month = value2.getMonth();
        this.m_day = value2.getDay();
        this.m_hour = value2.getHours();
        this.m_minute = value2.getMinutes();
        this.m_second = (double)value2.getSeconds() + value2.getFraction();
    }

    public XDateTime(int year2, int month2, int day2, int hour, int minute, double second) {
        this(year2, month2, day2, hour, minute, second, null);
    }

    public XDateTime(int year2, int month2, int day2, int hour, int minute, double second, int tz_hour, int tz_minute) {
        this(year2, month2, day2, hour, minute, second, new XDayTimeDuration(0, tz_hour, tz_minute, 0.0));
    }

    public XDateTime(int year2, int month2, int day2, int hour, int minute, double second, XDayTimeDuration timezone2) {
        this.m_year = year2;
        this.m_month = month2;
        this.m_day = day2;
        this.m_hour = hour;
        this.m_minute = minute;
        this.m_second = second;
        this.m_timezone = timezone2;
    }

    public XDateTime normalize() {
        if (this.m_timezone != null && !this.m_timezone.equals(this.ZERO_DTD)) {
            XDateTime tmpDt = new XDateTime(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), 0, 0);
            return tmpDt.subtract(this.m_timezone);
        }
        return this;
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public double getSecond() {
        return this.m_second;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XDateTime add(XYearMonthDuration ymd) {
        int tmp = this.m_month + ymd.getMonths();
        int mDateTime = (int)XDataTypeUtils.modulo((double)tmp, 1, 13);
        int carry = XDataTypeUtils.fQuotient(tmp, 1, 13);
        int yDateTime = this.m_year + ymd.getYears() + carry;
        int dDateTime = XDataTypeUtils.normalizeDay(this.m_day, mDateTime, yDateTime);
        int[] date2 = new int[3];
        date2 = XDataTypeUtils.normalizeDate(dDateTime, mDateTime, yDateTime);
        return new XDateTime(date2[2], date2[1], date2[0], this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    public XDateTime add(XDayTimeDuration dtd) {
        double stmp = this.m_second + dtd.getSeconds();
        int carry = XDataTypeUtils.fQuotient(stmp, 60.0);
        double sDateTime = XDataTypeUtils.modulo(stmp, 60.0, carry);
        int tmp = this.m_minute + dtd.getMinutes() + carry;
        carry = XDataTypeUtils.fQuotient(tmp, 60.0);
        int mnDateTime = (int)XDataTypeUtils.modulo((double)tmp, 60.0, carry);
        tmp = this.m_hour + dtd.getHours() + carry;
        carry = XDataTypeUtils.fQuotient(tmp, 24.0);
        int hDateTime = (int)XDataTypeUtils.modulo((double)tmp, 24.0, carry);
        int dDateTime = XDataTypeUtils.normalizeDay(this.m_day, this.m_month, this.m_year);
        int[] date2 = new int[3];
        date2 = XDataTypeUtils.normalizeDate(dDateTime += dtd.getDays() + carry, this.m_month, this.m_year);
        return new XDateTime(date2[2], date2[1], date2[0], hDateTime, mnDateTime, sDateTime, this.m_timezone);
    }

    public XDateTime subtract(XYearMonthDuration ymd) {
        return this.add(XDataTypeUtils.negate(ymd));
    }

    public XDateTime subtract(XDayTimeDuration dtd) {
        return this.add(XDataTypeUtils.negate(dtd));
    }

    public XDayTimeDuration subtract(XDateTime other2) {
        XDateTime dt1 = this.normalize();
        XDateTime dt2 = other2.normalize();
        int days2 = XDataTypeUtils.numberOfDays(dt1.getDay(), dt1.getMonth(), dt1.getYear()) - XDataTypeUtils.numberOfDays(dt2.getDay(), dt2.getMonth(), dt2.getYear());
        XDayTimeDuration dtd1 = new XDayTimeDuration(days2, 0, 0, 0.0);
        double seconds2 = XDataTypeUtils.timeToSeconds(new XTime(dt1.getHour(), dt1.getMinute(), dt1.getSecond())) - XDataTypeUtils.timeToSeconds(new XTime(dt2.getHour(), dt2.getMinute(), dt2.getSecond()));
        if (days2 > 0 && seconds2 < 0.0) {
            return dtd1.subtract(XDataTypeUtils.secondsTodayTimeDuration(new BigDecimal(seconds2 * -1.0)));
        }
        return dtd1.add(XDataTypeUtils.secondsTodayTimeDuration(new BigDecimal(seconds2)));
    }
}

